/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXPANELCUTTINGIMAGEDATA_H_
#define WXPANELCUTTINGIMAGEDATA_H_

#include "vtkClipping3DDataViewer.h"

#include "figureCuttingCylinderModel.h"
#include "figureCuttingCubeModel.h"
#include "figureCuttingSphereModel.h"
#include "figureCuttingModel.h"

#include "wxVtk3DBaseView.h"

#include "vtkXYPlotActor.h"
#include "vtkCubeSource.h"
#include "vtkCylinderSource.h"
#include "vtkSphereSource.h"

#include "vtkPolyDataMapper.h"

class wxPanelCuttingImageData : public wxPanel
{
public:
	wxPanelCuttingImageData (wxWindow *parent);
	~wxPanelCuttingImageData ();
	void OnTransform(wxScrollEvent& event);
	void OnOpacityFig(wxScrollEvent& event);
	void OnTypeFig(wxCommandEvent& event);
	void OnExtract(wxCommandEvent& event);
	void SetVtkMPRBaseData( vtkMPRBaseData *vtkmprbasedata );
	void SetVtkClipping3DDataViewer( vtkClipping3DDataViewer *vtkclipping3Ddataviewer );
	void SetWxVtk3DBaseView( wxVtk3DBaseView * wxvtk3Dbaseview );

	void SetParamsOfTransformation( );
	void Configure();
	void Refresh();
	void RefreshView();
	void RemoveActors();


private:
	wxSlider						*_opacityFig;
	wxSlider						*_scaleX;
	wxSlider						*_scaleY;
	wxSlider						*_scaleZ;
	wxSlider						*_rotationX;
	wxSlider						*_rotationY;
	wxSlider						*_rotationZ;
	
	wxRadioButton					*_volIntern;
	wxRadioButton					*_volExtern;
	wxCheckBox						*_histogrammeAccumulated;
	wxSlider						*_isoValue;
	wxSlider						*_valueBeforeIsoValue;
	wxSlider						*_valueAfterIsoValue;
	wxChoice						*_typeFig;

	wxStaticText					*_infoToVo;
	wxStaticText					*_infoSuVo;
	wxStaticText					*_infoSuVoA;
	wxStaticText					*_infoPixLe;
	wxStaticText					*_infoPixHi;

	// Model
	figureCuttingCylinderModel		*_modelCylinder;
	figureCuttingCubeModel			*_modelCube;
	figureCuttingSphereModel		*_modelSphere;
	figureCuttingModel				*_actualCuttingModel;

	// view
	vtkCubeSource					*_vtkcube;
	vtkSphereSource					*_vtksphere;
	vtkCylinderSource				*_vtkcylinder;
	vtkPolyDataMapper				*_cubeMapper;
	vtkPolyDataMapper				*_sphereMapper;
	vtkPolyDataMapper				*_cylinderMapper;
	vtkActor						*_cubeActor;
	vtkActor						*_sphereActor;
	vtkActor						*_cylinderActor;
	vtkActor						*_actualActor;


	vtkMPRBaseData					*_vtkmprbasedata;
	wxVtk3DBaseView					*_wxvtk3Dbaseview;
	vtkImageData					*_imageData;
	vtkClipping3DDataViewer			*_vtkclipping3Ddataviewer;

	vtkImageData					*_histogrammeVector;
	vtkXYPlotActor					*_xyplot;
	wxVtkBaseView					*_wxvtkbaseView;
	vtkRenderer						*_renplotter;

	void	CreateModel();
	void	CreateInterface();
	void	Create3DViewObjects();
	void	RefreshOpacity();
	wxWindow *CreatePlotHistogrammeInterface();
	void	InitHistogramme();


protected:
};

#endif /*WXPANELCUTTINGIMAGEDATA_H_*/
