/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkObjectFactory.h"

#include "vtkActor.h"
#include "vtkCylinderSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkProperty.h"
#include "vtkCamera.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyDataReader.h"
#include "vtkImageReader.h"
#include "vtkImageViewer.h"
#include "vtkImageViewer2.h"
#include "vtkImageToStructuredPoints.h"
#include <vtkImageThreshold.h> 
#include "vtkImageWriter.h"


#include "vtkExtractVOI.h"
#include "vtkImageClip.h"
#include "vtkImageResample.h"
#include "vtkImageThreshold.h"
#include "vtkImageCast.h"
#include "vtkImageSeedConnectivity.h"
#include "vtkImageData.h"
#include "vtkMarchingCubes.h"
#include "vtkImageReslice.h"
#include "vtkTransform.h"
#include "vtkSphereSource.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkCommand.h"
#include "vtkCallbackCommand.h"
#include "vtkImageResample.h"
#include "vtkMath.h"
#include "vtkStripper.h"
#include <vtkSTLReader.h> 
#include "vtkMetaImageWriter.h"


#include "vtkTriangleFilter.h"
#include "vtkSTLWriter.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkClosePolyData.h"
#include "vtkAppendFilter.h"

#include "wxSTLWidget_03.h"

#include <wx/splitter.h>

#include <wx/filedlg.h>



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
wxSTLWidget_03::wxSTLWidget_03(wxWindow *parent)//, marInterface* mar)
: wxPanel( parent, -1) 
{
	_imagedata=NULL;
	cast2=NULL;
	cast3=NULL;
	cast4=NULL; // binary segmentation result
	_thresh=NULL;
	_thresh2=NULL;
	_cast=NULL;
	_connect=NULL;
	_connect2=NULL;
	_2_mapfinal=NULL;
	_2_stripfinal=NULL;
	_2_isoMapperMC6=NULL;
	_2_isoActorMC6=NULL;
	_2_isoMC6=NULL;	
	_loadSTLMapper=NULL;
	_loadActorSTL=NULL;
	sl_barrange_segmentation=NULL;	
	_imageviewer3D=NULL;	
	_wxMaracasMPR=NULL;	
	stlInterna=NULL;
	stlExterna=NULL;	
	stlSliderDeltaGauss=NULL;
	stlSliderMarchingCubes=NULL;	
	dsm1=NULL;
    actorInternal=NULL;
	stlSliderOpacityInternal=NULL;    
	dsm2=NULL; 
    actorExternal=NULL;
	stlSliderOpacityExternal=NULL;
	stlExtractor=NULL;   
	_sl_opacity_STL_file=NULL;
	arteryImageData=NULL;
	joiner=NULL;
	joinMarchingCubes=NULL;
    joinMapper=NULL; 
	joinActor=NULL;	
	_maxSize		= 2000;
	_minSize		= 300;
	
	_stlMarchingCubesLevel	= 128;
	_stlDeltaGaussLevel		= 100;

	/*_mar=new marInterface();	
	_mar->_parameters->setRescaleSlope( mar->_parameters->getRescaleSlope() );
	_mar->_parameters->setRescaleIntercept( mar->_parameters->getRescaleIntercept() );
	_mar->_parameters->setIntParam( marParameters::e_voxel_type, marParameters::VOX_TYPE_MINIMUM );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_x_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_x_dimension) );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_y_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_y_dimension) );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_z_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_z_dimension) );
	int voi[6];
	mar->_experiment->getVOI( voi );
	_mar->_experiment->setVOI( voi );
	_mar->SetDicom(mar->_dicom);
	_mar->initExperiment( );*/
	 

	wxBoxSizer		*sizer		= new wxBoxSizer(wxVERTICAL  );
	wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	wxPanel			*viewPanel	= CreateViewPanel(pnlSplitter);
	wxPanel			*controlPanel	= CreateControlPanel(pnlSplitter);

	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 150 );
	pnlSplitter	-> SplitVertically( viewPanel, controlPanel, 600 );

//	pnlSplitter	-> SplitVertically( new wxPanel(pnlSplitter,-1), new wxPanel(pnlSplitter,-1) , 600 );
//	pnlSplitter	-> SplitVertically( viewPanel, new wxPanel(pnlSplitter,-1) , 600 );

	this		-> SetSizer(sizer);
	


}
//-------------------------------------------------------------------
wxSTLWidget_03::~wxSTLWidget_03(){
	//ResetTree2_JF();
	//Reset_vtk_STLFile();

	if(_imagedata!=NULL){
		_imagedata->Delete();	
	}	
	if(cast2){cast2->Delete();}
	if(cast3){cast3->Delete();}
	if(cast4){cast4->Delete();}
	if(_thresh){_thresh->Delete();}
	if(_thresh2){_thresh2->Delete();}
	if(_cast){_cast->Delete();}
	if(_connect){_connect->Delete();}
	if(_connect2){_connect2->Delete();}
	if(_2_mapfinal){_2_mapfinal->Delete();}
	if(_2_stripfinal){_2_stripfinal->Delete();}
	if(_2_isoMapperMC6){_2_isoMapperMC6->Delete();}
	if(_2_isoActorMC6){_2_isoActorMC6->Delete();}
	if(_2_isoMC6){_2_isoMC6->Delete();}
	// Load STL file
	if(_loadSTLMapper){_loadSTLMapper->Delete();}
	if(_loadActorSTL){_loadActorSTL->Delete();}
	if(sl_barrange_segmentation){delete sl_barrange_segmentation;}
	if(_imageviewer3D){delete _imageviewer3D;}	
	if(_wxMaracasMPR){delete _wxMaracasMPR;}
	if(stlInterna){stlInterna->Delete();}
	if(stlExterna){stlExterna->Delete();}	
	if(dsm1){dsm1->Delete();}
    if(actorInternal){actorInternal->Delete();}
	if(dsm2){dsm2->Delete();} 
    if(actorExternal){actorExternal->Delete();}
	//if(stlExtractor){stlExtractor->Delete();}
	if(arteryImageData){arteryImageData->Delete();}
	if(joiner){delete joiner;}
	if(joinMarchingCubes){joinMarchingCubes->Delete();}
    if(joinMapper){joinMapper->Delete(); }
	if(joinActor){joinActor->Delete();}
}
//-------------------------------------------------------------------
wxPanel* wxSTLWidget_03::CreateViewPanel(wxWindow *parent)
{
 	wxPanel *panel		=	new wxPanel(parent,-1);
    wxBoxSizer *sizer	=	new wxBoxSizer(wxVERTICAL);


   // MPR
	//vtkImageData *imagedata;
	//imagedata = _mar->_experiment->getDynData( )->getVolume( )->castVtk();
	//imagedata->Update(); 	
	_wxMaracasMPR = new wxMaracasMPR( panel);//JCP 10-03-2009, new marImageData(imagedata), 1 );
	_wxMaracasMPR->ConfigureVTK();
	
	sizer->Add(	_wxMaracasMPR , 1, wxEXPAND, 0);
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}

void wxSTLWidget_03::setImage(vtkImageData* img){

	_wxMaracasMPR->setImageData(img, 1);
	_wxMaracasMPR->ConfigureVTK();


	this->ConfigureProcessing(img,0,0,0);
	this->ConfigureSTL();

	_wxMaracasMPR->Refresh();
	
	//this->Refresh();
}
//-------------------------------------------------------------------
wxWindow* wxSTLWidget_03::CreateSelectAPointPanel(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);


    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel,-1,_T(" Select a 3D Point...")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();


	return panel;
}
//-------------------------------------------------------------------
wxWindow* wxSTLWidget_03::CreateSegmentationPanel(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);


	_opacity_Vol		= new wxSlider( panel, -1, 40, 0, 100				 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_opacity_Vol	->SetSize(250,20);  
	/*SIL
	_sl_maxSize			= new wxSlider( panel, -1, 300 , 0, 2000 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  |  wxSL_AUTOTICKS | wxSL_LABELS );
	_sl_minSize			= new wxSlider( panel, -1, 200 , 0, 2000 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  |  wxSL_AUTOTICKS | wxSL_LABELS );
	
	_sl_minSizeSpin = new wxSlider(panel , -1,5,1,10,wxDefaultPosition , wxDefaultSize, wxSL_VERTICAL | wxSL_AUTOTICKS |wxSL_LEFT  );
	_sl_minSizeSpin->SetRange(1,8);
	_sl_minSizeSpin->SetValue(5);

	_sl_maxSizeSpin = new wxSlider(panel , -1,5,1,10,wxDefaultPosition , wxDefaultSize, wxSL_VERTICAL | wxSL_AUTOTICKS |wxSL_LEFT  );
	_sl_maxSizeSpin->SetRange(1,8);
	_sl_maxSizeSpin->SetValue(5);

	*/

	_sl_RangeSizeSpin = new wxSlider(panel , -1,5,1,10,wxDefaultPosition ,wxDefaultSize, wxSL_VERTICAL | wxSL_AUTOTICKS |wxSL_LEFT  );
	_sl_RangeSizeSpin->SetRange(1,8);
	_sl_RangeSizeSpin->SetValue(5);


	//SIL//
	sl_barrange_segmentation = new mBarRange(panel, 300,70);
	sl_barrange_segmentation -> setVisibleLabels ( true );
	sl_barrange_segmentation -> setIfWithActualDrawed( false );
	sl_barrange_segmentation -> setActiveStateTo ( true );
	sl_barrange_segmentation -> setRepresentedValues (0,  2000);
	sl_barrange_segmentation -> setDeviceBlitStart (10,10);
	sl_barrange_segmentation -> setDeviceEndMargin(10);
	parent->SetBackgroundColour(wxColour(255,255,255));
	sl_barrange_segmentation-> setBackgroundColor( wxColour(255,255,255 ));


	wxButton *btnExtract				= new wxButton(panel,-1,_T("Segmentation"));
	wxButton *btnSaveBinaryFile			= new wxButton(panel,-1,_T("Save Binary File"));

//SIL//	Connect(_sl_minSizeSpin->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED   , (wxObjectEventFunction) &wxSTLWidget_03::OnMinSpin ); 
//SIL//	Connect(_sl_maxSizeSpin->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED   , (wxObjectEventFunction) &wxSTLWidget_03::OnMaxSpin ); 
	Connect(_opacity_Vol->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_03::OnOpacity_Vol					); 
	Connect(btnExtract->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_03::OnBtnExtraction					); 
	Connect(btnSaveBinaryFile->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_03::OnBtnSaveBinaryFile				); 

	//SIL//
	Connect(_sl_RangeSizeSpin->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED   , (wxObjectEventFunction) &wxSTLWidget_03::OnRangeSpin ); 
	Connect(sl_barrange_segmentation->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxSTLWidget_03::OnStartChanged_range );
	Connect(sl_barrange_segmentation->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxSTLWidget_03::OnEndChanged_range );	
	Connect(sl_barrange_segmentation->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxSTLWidget_03::OnBarMoved_range );

    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));


	sizer->Add(new wxStaticText(panel,-1,_T("  - - -  Segmentation - - - ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  "))); 
	

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  "))); 

	/*sizer->Add(new wxStaticText(panel,-1,_T(" Threshold min")));
	sizer->Add(new wxStaticText(panel,-1,_T("  "))); 
	sizer->Add(_sl_minSizeSpin, 1, wxALL|wxEXPAND, 0);*/
	//sizer->Add(_sl_minSize, 1, wxALL|wxEXPAND, 0);

	sizer->Add(new wxStaticText(panel,-1,_T(" Threshold min-max")));
	sizer->Add(new wxStaticText(panel,-1,_T("  "))); 
	sizer->Add(_sl_RangeSizeSpin, 1, wxALL|wxEXPAND, 0);
	sizer->Add(sl_barrange_segmentation,3,wxALL|wxGROW,0 );
	
	//SIL//sizer->Add(new wxStaticText(panel,-1,_T(" Threshold max")));
	//SIL//sizer->Add(new wxStaticText(panel,-1,_T("  "))); 
	//SIL//	sizer->Add(_sl_maxSizeSpin, 1, wxALL|wxEXPAND, 0);
	//SIL//sizer->Add(_sl_maxSize, 1, wxALL|wxEXPAND, 0);
	
	sizer->Add(btnExtract);
	sizer->Add(new wxStaticText(panel,-1,_T(" ")));

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("Opacity - Result Volume")));
	sizer->Add(_opacity_Vol);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(btnSaveBinaryFile);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();

	return panel;
}
//-------------------------------------------------
wxWindow* wxSTLWidget_03::CreateSmoothingPanel(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);

	stlSliderDeltaGauss	= new wxSlider( panel, -1, (int)(_stlDeltaGaussLevel) , 0, 300 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	stlSliderMarchingCubes= new wxSlider( panel, -1, (int)(_stlMarchingCubesLevel) , 0, 256 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	stlSliderOpacityInternal = new wxSlider(panel, -1, 100,0,100, wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS);
	stlSliderOpacityExternal = new wxSlider(panel, -1, 100,0,100, wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS);
	wxButton *btnFileSTL = new wxButton(panel,-1,_T("Generate STL files"));

	Connect(btnFileSTL->GetId()				, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_03::OnBtnCreateFileSTL			);
	Connect(stlSliderDeltaGauss->GetId()	, wxEVT_SCROLL_THUMBRELEASE		, (wxObjectEventFunction) &wxSTLWidget_03::OnChangeSTLGaussLevel		);
	Connect(stlSliderMarchingCubes->GetId()	, wxEVT_SCROLL_THUMBRELEASE		, (wxObjectEventFunction) &wxSTLWidget_03::OnChangeSTLMarchingCubesLevel);
	Connect(stlSliderOpacityInternal->GetId(), wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &wxSTLWidget_03::OnOpacitySTLInternal			);
	Connect(stlSliderOpacityExternal->GetId(), wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &wxSTLWidget_03::OnOpacitySTLExternal			);


    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel,-1,_T("-- Smoothing --")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	
	sizer->Add(new wxStaticText(panel,-1,_T(" Delta Gauss")));
	sizer->Add(stlSliderDeltaGauss);

	sizer->Add(new wxStaticText(panel,-1,_T(" Marching Cubes Level")));
	sizer->Add(stlSliderMarchingCubes);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL Internal")));
	sizer->Add(stlSliderOpacityInternal);

	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL External")));
	sizer->Add(stlSliderOpacityExternal);

	sizer->Add(btnFileSTL);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));


	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();
	return panel;
}
//-------------------------------------------------
wxWindow* wxSTLWidget_03::CreateReadSTLFilePanel(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);

	wxButton *btnReadSTLFile			= new wxButton(panel,-1,_T("Read STL File"));
	wxButton *btnEraseReadSTLFile		= new wxButton(panel,-1,_T("Erase STL File"));
	_sl_opacity_STL_file				= new wxSlider( panel, -1, 100 , 0, 100 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );

	Connect(btnReadSTLFile->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_03::OnBtnSTLFileLoad 			); 
	Connect(btnEraseReadSTLFile->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_03::OnBtnSTLFileErase 			); 
	Connect(_sl_opacity_STL_file->GetId()	, wxEVT_SCROLL_THUMBRELEASE     , (wxObjectEventFunction) &wxSTLWidget_03::OnOpacitySTLFile				); 


    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel,-1,_T("-- Read STL File --")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));

	sizer->Add(btnReadSTLFile );
	sizer->Add(btnEraseReadSTLFile );
	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL File")));
	sizer->Add(_sl_opacity_STL_file);


	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();
	return panel;
}
//-------------------------------------------------------------------
wxPanel* wxSTLWidget_03::CreateControlPanel(wxWindow *parent)
{
	wxPanel *panel			= new wxPanel(parent,-1);

	wxNotebook *noteBook	= new wxNotebook(panel, -1);
	noteBook->AddPage(CreateSelectAPointPanel(noteBook),_T("0 ->") );
	noteBook->AddPage(CreateSegmentationPanel(noteBook),_T("1 ->") );
	noteBook->AddPage(CreateSmoothingPanel(noteBook)   ,_T("2 ->") );
	noteBook->AddPage(CreateReadSTLFilePanel(noteBook) ,_T("3 "  ) );
	noteBook->SetSelection(0);
	noteBook->SetSize(350,250);
    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);
	sizer->Add(noteBook);
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();

	return panel;
}
//------------------------------------------------------------------------
void wxSTLWidget_03::Refresh()
{
	if (_wxMaracasMPR!=NULL){
		_wxMaracasMPR->RefreshView();
	}
}

//------------------------------------------------------------------------


void wxSTLWidget_03::ConfigureProcessing(vtkImageData *img, int x, int y, int z)
{
    wxBusyCursor wait;

	_imagedata=img;


	double puntoactualprov[3];
	puntoactualprov[0] = x;
	puntoactualprov[1] = y;
	puntoactualprov[2] = z;

	double espprin[3];
	int extprin[6];				
	
	_imagedata->GetSpacing(espprin);
	_imagedata->GetExtent(extprin);


// MAZV 27 sep 2006
//	puntoactualprov[0]=puntoactualprov[0]*espprin[0];
//	puntoactualprov[1]=puntoactualprov[1]*espprin[1];
//	puntoactualprov[2]=puntoactualprov[2]*espprin[2];
	
    _imagedata->GetScalarRange( _range );

	// Update Controls
	//SIL//
	/*_sl_minSize->SetRange( (int)(_range[0]), (int)( _range[1]) );
	_sl_minSize->SetValue( (int)(_range[1]/4) );

	_sl_maxSize->SetRange( (int)(_range[0]) , (int)(_range[1]));
	_sl_maxSize->SetValue( (int)(_range[1]/2) );*/

	//SIL//
	minRangeValue = _range[0];
	maxRangeValue = _range[1];

	sl_barrange_segmentation ->setRepresentedValues(minRangeValue, maxRangeValue);
	sl_barrange_segmentation ->SetStart((int)(maxRangeValue/4));
	sl_barrange_segmentation ->SetEnd((int)(maxRangeValue/2));
	sl_barrange_segmentation -> RefreshForce();	
	lastResizeRef_Value = ( maxRangeValue - minRangeValue)/2;	

// MAZV 27 sep 2006
//	_highthreshold->SetRange(_range[0], _range[1]);
//	_highthreshold->SetValue( _range[1] );

//	_zslice->SetRange(extprin[4], extprin[5]);
//	_zslice->SetValue(extprin[5]/2);
    
	if(_thresh==NULL){
		_thresh = vtkImageThreshold::New();
		//_thresh->ReleaseDataFlagOff();
		_thresh->SetInValue(255);
		_thresh->SetOutputScalarTypeToUnsignedShort();
		_thresh->SetOutValue(0);
		//_thresh->ThresholdBetween(_sl_minSize->GetValue(), _range[1]);
		//SIL//
		_cast = vtkImageCast::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_cast->SetInput(_thresh->GetOutput());
#else
		_cast->SetInputData(_thresh->GetOutput());
#endif

		_cast->SetOutputScalarTypeToUnsignedChar();

		_connect = vtkImageSeedConnectivity::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_connect->SetInput(_cast->GetOutput());
#else
		_connect->SetInputData(_cast->GetOutput());
#endif
		_connect->SetInputConnectValue(255);
		_connect->SetOutputConnectedValue(255);
		_connect->SetOutputUnconnectedValue(0);

		cast3 = vtkImageCast::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		cast3->SetInput(_connect->GetOutput());
#else
		cast3->SetInputData(_connect->GetOutput());
#endif
		cast3->SetOutputScalarTypeToUnsignedShort();

		_thresh2 = vtkImageThreshold::New();
		//_thresh2->ReleaseDataFlagOff();
		_thresh2->SetInValue(255);
		_thresh2->SetOutputScalarTypeToUnsignedShort();
		_thresh2->SetOutValue(0);
		//SIL//_thresh2->ThresholdBetween(_sl_minSize->GetValue(), _sl_maxSize->GetValue());

		cast2 = vtkImageCast::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		cast2->SetInput(_thresh2->GetOutput());
#else
		cast2->SetInputData(_thresh2->GetOutput());
#endif
		cast2->SetOutputScalarTypeToUnsignedChar();
		_connect2 = vtkImageSeedConnectivity::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_connect2->SetInput(cast2->GetOutput());
#else
		_connect2->SetInputData(cast2->GetOutput());
#endif
		_connect2->SetInputConnectValue(255);
		_connect2->SetOutputConnectedValue(255);
		_connect2->SetOutputUnconnectedValue(0);

		cast4 = vtkImageCast::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		cast4->SetInput(_connect2->GetOutput());
#else
		cast4->SetInputData(_connect2->GetOutput());
#endif
		cast4->SetOutputScalarTypeToUnsignedShort();
	}
	_thresh->RemoveAllInputs();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_thresh->SetInput(_imagedata);	
#else
	_thresh->SetInputData(_imagedata);	
#endif
	_thresh->ThresholdBetween(sl_barrange_segmentation->GetStart(), sl_barrange_segmentation->GetEnd()); 	
	_thresh->Update();
	
	_cast->Update();  
	

	_connect->RemoveAllSeeds();
	_connect->AddSeed((int)(puntoactualprov[0]), (int)(puntoactualprov[1]), (int)(puntoactualprov[2]));
	//_connect->Update();	
	//cast3->Update();
//SIL//	
	_thresh2->RemoveAllInputs();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_thresh2->SetInput(_imagedata);	
#else
	_thresh2->SetInputData(_imagedata);	
#endif

	_thresh2->ThresholdBetween(sl_barrange_segmentation->GetStart(), sl_barrange_segmentation->GetEnd());
	_thresh2->Update();
	cast2->Update();
	_connect2->RemoveAllSeeds();
	_connect2->AddSeed( (int)(puntoactualprov[0]), (int)(puntoactualprov[1]), (int)(puntoactualprov[2]));
	//_connect2->Update();	
	//cast4->Update();
}

//------------------------------------------------------------------------



void wxSTLWidget_03::ConfigureVTK()
{
	wxBusyCursor wait;
//	vtkImageData	*imagedata		= _mar->_experiment->getDynData( )->getVolume( )->castVtk();
	//marImageData	*marimagedata;//		= _mar->_experiment->getDynData( )->GetMarImageData();
	
	//CONFIGURACION ADICIONAL
	this->ConfigureSTL();
	//this->ConfigureProcessing(marimagedata,0,0,0);
	
}

//------------------------------------------------------------------------

void wxSTLWidget_03::ResetTree2_JF()
{
	// Remove 

	try{

		

		// Delete 
	//	if (_2_prgov		) {	_2_prgov		-> Delete(); }
		if (_2_mapfinal		) {	_2_mapfinal		-> Delete(); }
		if (_2_stripfinal	) {	_2_stripfinal	-> Delete(); }
		if (_2_isoMapperMC6	) {	_2_isoMapperMC6	-> Delete(); }
		if (_2_isoActorMC6	) {	_2_isoActorMC6	-> Delete(); }
		if (_2_isoMC6		) {	_2_isoMC6		-> Delete(); }

		// Init
	//	_2_prgov		= NULL;
		_2_mapfinal		= NULL;
		_2_stripfinal	= NULL;
		_2_isoMapperMC6	= NULL;
		_2_isoActorMC6	= NULL;
		_2_isoMC6		= NULL;

		
		//vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();

		/*if (_2_isoActorMC6){
			ren->RemoveActor(_2_isoActorMC6);
		}
		if (_2_stripfinal){
			ren->RemoveActor(_2_stripfinal);
		}*/

		
	}catch(char* e){
		std::cout<<e<<std::endl;
	}
}






//------------------------------------------------------------------------
void wxSTLWidget_03::ExtractSurface(int x, int y, int z)
{
	
	double opacityvol		= ((double)_opacity_Vol->GetValue())/100;
//	vtkImageData *imagedata = _mar->_experiment->getDynData( )->getVolume( )->castVtk();

	double	puntoactualprov[3];
	double	espprin[3];
	int		extprin[6];				


	puntoactualprov[0]	=	x;
	puntoactualprov[1]	=	y;
	puntoactualprov[2]	=	z;
	
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_imagedata->UpdateInformation();
	_imagedata->SetUpdateExtent(_imagedata->GetWholeExtent());
	_imagedata->Update();
#else
	// ..
#endif

	_imagedata->GetSpacing(espprin);
	_imagedata->GetExtent(extprin);




	_connect->RemoveAllSeeds ();
	_connect->AddSeed( (int)(puntoactualprov[0] ), (int)(puntoactualprov[1]) ,(int)( puntoactualprov[2]) );
	_connect->Update();
	cast3->Update();



	_thresh->ThresholdBetween(3000, 3002 );
	_thresh2->ThresholdBetween(3000, 3001);
//	_thresh->Update();
//	_thresh2->Update();

	_thresh->ThresholdBetween(_minSize, _range[1] );
	_thresh->Update();

	_thresh2->ThresholdBetween(_minSize, _maxSize);
	_thresh2->Update();

	cast2->Update();
	_connect2->RemoveAllSeeds ();
	_connect2->AddSeed( (int)(puntoactualprov[0]) , (int)(puntoactualprov[1]) , (int)(puntoactualprov[2]) );
	_connect2->Update();
	cast4->Update();




	// Visualisation - result volume
   
    _2_isoMC6 = vtkMarchingCubes::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_2_isoMC6->SetInput(cast4->GetOutput());
#else
	_2_isoMC6->SetInputData(cast4->GetOutput());
#endif

    _2_isoMC6->SetValue(0, 128);
	_2_isoMC6->Update();

	_2_isoMapperMC6 = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
    _2_isoMapperMC6->SetInput(_2_isoMC6->GetOutput());
    _2_isoMapperMC6->ImmediateModeRenderingOn();
#else
    _2_isoMapperMC6->SetInputData(_2_isoMC6->GetOutput());
#endif


    _2_isoMapperMC6->ScalarVisibilityOff();

	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();

	if (_2_isoActorMC6!=NULL)
	{
		ren->RemoveActor(_2_isoActorMC6);
	}


	_2_isoActorMC6 = vtkActor::New();
    _2_isoActorMC6->SetMapper(_2_isoMapperMC6);
    _2_isoActorMC6->GetProperty()->SetColor(1.0, 1.0, 0.5);
    _2_isoActorMC6->GetProperty()->SetOpacity( opacityvol );
    
	// Interface Update

	ren->AddActor(_2_isoActorMC6);

}

//------------------------------------------------------------------------
void wxSTLWidget_03::OnOpacity_Vol(wxScrollEvent& event)
{
	if (_2_isoActorMC6!=NULL){
		double value = ((double)_opacity_Vol->GetValue())/100;
		_2_isoActorMC6->GetProperty( )->SetOpacity( value );
		Refresh();
	}
}
//------------------------------------------------------------------------

void wxSTLWidget_03::OnMinSpin  	(   	wxScrollEvent &   	 event  	 )   	
{
	/*wxSlider *sl_A=_sl_minSize;
	wxSlider *sl_B=_sl_minSizeSpin;
	int value = sl_A->GetValue();
	int delta=(int)pow( 4 , sl_B->GetValue() );
	int min=value - delta/2;
	int max=value + delta/2;
	if (min<0)
	{
		min=0;
		max=delta;
	}
	sl_A->SetRange(min,max);


	*/
}

//------------------------------------------------------------------------

void wxSTLWidget_03::OnMaxSpin  	(   	wxScrollEvent &   	 event  	 )   	
{
	/*wxSlider *sl_A=_sl_maxSize;
	wxSlider *sl_B=_sl_maxSizeSpin;
	int value = sl_A->GetValue();
	int delta = (int)pow( 4 , sl_B->GetValue() );
	int min=value - delta/2;
	int max=value + delta/2;
	if (min<0)
	{
		min=0;
		max=delta;
	}
	sl_A->SetRange(min,max);*/	
}

//------------------------------------------------------------------------

void wxSTLWidget_03::OnRangeSpin  	(   	wxScrollEvent &   	 event  	 )   	
{
	wxSlider *sl_B=_sl_RangeSizeSpin;

	int value = lastResizeRef_Value;
	int delta = (int)pow((double) 4 , (double)sl_B->GetValue() );
	int startResized = value - delta/2;
	int endResized = value + delta/2;

	if( startResized < minRangeValue )
		startResized = minRangeValue;

	if( endResized > maxRangeValue )
		endResized = maxRangeValue;

	sl_barrange_segmentation->setRepresentedValues(startResized,endResized);
	sl_barrange_segmentation -> RefreshForce();	
}

//------------------------------------------------------------------------
void wxSTLWidget_03:: OnStartChanged_range(wxCommandEvent& event)
{
	lastResizeRef_Value = sl_barrange_segmentation->GetStart();
}
//------------------------------------------------------------------------
void wxSTLWidget_03:: OnEndChanged_range(wxCommandEvent& event)
{
	lastResizeRef_Value = sl_barrange_segmentation->GetEnd();   
}
//------------------------------------------------------------------------
void wxSTLWidget_03:: OnBarMoved_range(wxCommandEvent& event)
{
	lastResizeRef_Value = (sl_barrange_segmentation->GetEnd() - sl_barrange_segmentation->GetStart())/2 ;
}
//------------------------------------------------------------------------

void wxSTLWidget_03::OnBtnSaveBinaryFile(wxCommandEvent& event)
{
	wxString dirSTL;// = _mar->_parameters->getStringParam( 
    //marParameters::e_installation_directory ); 
	dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;
	wxFileDialog dialog( this, _T("Choose a directory..."), ( !dirSTL.IsEmpty( ) )?
	dirSTL: wxGetHomeDir( ) );

	if( dialog.ShowModal( ) == wxID_OK ) 
	{
		vtkMetaImageWriter  *writer= vtkMetaImageWriter::New();
		writer->SetFileName( dialog.GetPath().mb_str(wxConvUTF8) );	
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		writer->SetInput(cast4->GetOutput());
#else
		writer->SetInputData(cast4->GetOutput());
#endif
		writer->Write();
		writer->Delete();
	}
}

//------------------------------------------------------------------------
void wxSTLWidget_03::OnBtnExtraction(wxCommandEvent& event)
{
	/*wxBusyCursor wait;
	_minSize = _sl_minSize->GetValue();
	_maxSize = _sl_maxSize->GetValue();

	double px=_wxMaracasMPR->GetVtkMPRBaseData()->GetX();
	double py=_wxMaracasMPR->GetVtkMPRBaseData()->GetY();
	double pz=_wxMaracasMPR->GetVtkMPRBaseData()->GetZ();
	ExtractSurface((int)(px),(int)(py),(int)(pz));
	generateSTLSurfaces(); //DHC: AFTER SEGMENTATION THE TREE, THE STL SURFACES ARE CALCULATED.

	Refresh();
*/
	//SIL//
	wxBusyCursor wait;
	_minSize = sl_barrange_segmentation->GetStart();
	_maxSize = sl_barrange_segmentation->GetEnd();

	double px=_wxMaracasMPR->GetVtkMPRBaseData()->GetX();
	double py=_wxMaracasMPR->GetVtkMPRBaseData()->GetY();
	double pz=_wxMaracasMPR->GetVtkMPRBaseData()->GetZ();
	ExtractSurface((int)(px),(int)(py),(int)(pz));
	generateSTLSurfaces(); //DHC: AFTER SEGMENTATION THE TREE, THE STL SURFACES ARE CALCULATED.

	Refresh();
}

//------------------------------------------------------------------------
void wxSTLWidget_03::OnOpacitySTLFile(wxScrollEvent& event)
{
	if (_loadActorSTL!=NULL)
	{
		double value = ((double)_sl_opacity_STL_file->GetValue())/100;
		_loadActorSTL->GetProperty( )->SetOpacity( value );
		Refresh();
	}
}
//------------------------------------------------------------------------
void wxSTLWidget_03::Reset_vtk_STLFile()
{
	// Remove
	try{
		vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
		if (_loadActorSTL){
			ren->RemoveActor(_loadActorSTL);
		}

		// Delete 
		if (_loadSTLMapper		) {	_loadSTLMapper		-> Delete(); }
		if (_loadActorSTL		) {	_loadActorSTL		-> Delete(); }

		// Init
		_loadSTLMapper		= NULL;
		_loadActorSTL		= NULL;
	}catch(char * e){
		std::cout<<e<<std::endl;
	}

}
//------------------------------------------------------------------------
void wxSTLWidget_03::OnBtnSTLFileErase(wxCommandEvent& event)
{
	Reset_vtk_STLFile();
	Refresh();
}
//------------------------------------------------------------------------
void wxSTLWidget_03::OnBtnSTLFileLoad(wxCommandEvent& event)
{
	wxString dirSTL;// = _mar->_parameters->getStringParam( 
    //marParameters::e_installation_directory ); 
	dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;
	wxFileDialog dialog( this, _T("Choose a directory..."), ( !dirSTL.IsEmpty( ) )?
	dirSTL: wxGetHomeDir( ) );

	if( dialog.ShowModal( ) == wxID_OK ) 
	{
		Reset_vtk_STLFile();
		vtkSTLReader *imgReader= vtkSTLReader::New();
		imgReader->SetFileName( dialog.GetPath().mb_str(wxConvUTF8) );	
		_loadSTLMapper = vtkPolyDataMapper::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_loadSTLMapper->SetInput(imgReader->GetOutput());
#else
		_loadSTLMapper->SetInputData(imgReader->GetOutput());
#endif
		_loadActorSTL = vtkActor::New();
		_loadActorSTL->SetMapper(_loadSTLMapper);
		_loadActorSTL->GetProperty()->SetColor( 1, 0, 0);
		_loadActorSTL->GetProperty()->SetOpacity( 0.5 );
		vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
		ren->AddActor(_loadActorSTL);
		imgReader->Delete();
	}
	//By default *always* update e_installation_directory:
	//_mar->_parameters->setStringParam( marParameters::e_installation_directory, dialog.GetPath( ) ); 
	//_mar->saveParameters( );
}



// ------------------------------------------------------------------------
// END JOIN FUNCTIONS - DHC
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// START STL FUNCTIONS - DHC
// ------------------------------------------------------------------------

void wxSTLWidget_03::ConfigureSTL()
{

	if(stlExterna == NULL){
		stlExterna = vtkPolyData::New();
		stlInterna = vtkPolyData::New();

		dsm1 = vtkPolyDataMapper ::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		dsm1->SetInput(stlInterna); 
#else
		dsm1->SetInputData(stlInterna); 
#endif
		dsm1->ScalarVisibilityOff();

		actorInternal = vtkActor::New();
		actorInternal->SetMapper (dsm1);
		actorInternal->GetProperty()->SetColor (0,1,0);

		dsm2 = vtkPolyDataMapper ::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		dsm2->SetInput(stlExterna);
#else
		dsm2->SetInputData(stlExterna);
#endif

		dsm2->ScalarVisibilityOff();

		actorExternal= vtkActor::New();
		actorExternal->SetMapper (dsm2);
		actorExternal->GetProperty()->SetRepresentationToWireframe();

	//    vtkRenderer *ren = _maracasSurfaceWidget->GetVtk3DSurfaceWidget()->GetRenderer();
		vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
		ren->AddActor(actorInternal);
		ren->AddActor(actorExternal);

		stlExtractor = new vtkSTLExtractor();  

	}

	
}

void wxSTLWidget_03::generateSTLSurfaces()
{
// EED 09Janvier2007
//	stlExtractor->setVolume(_2_prgov->GetVolumen());

	stlExtractor->setVolume(cast4->GetOutput());

	stlExtractor->setSigmaLevel(_stlDeltaGaussLevel);
	stlExtractor->setMarchingCubesLevel(_stlMarchingCubesLevel);
	stlExtractor->calculate();
	stlInterna->DeepCopy(stlExtractor->getInnerSurface());
	stlExterna->DeepCopy(stlExtractor->getOuterSurface());
}


void wxSTLWidget_03::OnOpacitySTLExternal(wxScrollEvent& event){
	double value = ((double)stlSliderOpacityExternal->GetValue())/100;
    actorExternal->GetProperty( )->SetOpacity( value );
	Refresh();
}


void wxSTLWidget_03::OnOpacitySTLInternal(wxScrollEvent& event){
	double value = ((double)stlSliderOpacityInternal->GetValue())/100;
    actorInternal->GetProperty( )->SetOpacity( value );
	Refresh();
}

void wxSTLWidget_03::OnBtnCreateFileSTL(wxCommandEvent& event)
{

	wxString dirSTL;// = _mar->_parameters->getStringParam( 
    //marParameters::e_installation_directory ); 
	dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;

	
//	wxDirDialog dialog( this, "Choose a directory...", ( !dirSTL.IsEmpty( ) )?dirSTL: wxGetHomeDir( ) );


//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFileDialog dialog( this, _T("Choose a directory..."), dirSTL , _T(""), _T("*.*"), wxSAVE );
#else
	wxFileDialog dialog( this, _T("Choose a directory..."), dirSTL , _T(""), _T("*.*"), wxFD_SAVE );
#endif


	if( dialog.ShowModal( ) == wxID_OK ) 
	{
	   
      	
		// ------------------------------------------------------------------------
		//  1.  GENERATE STL FILES
		// ------------------------------------------------------------------------
//		const char* fileprefix = "c:\\Creatis\\";
		std::string prefix ( dialog.GetPath().mb_str(wxConvUTF8) );
		std::string filename;

		// 1.1. Se hace un filtro triangular puesto que el stl writer solo recibe poligonos triangulares.

        vtkClosePolyData 				*cpd 	= vtkClosePolyData::New();
        vtkTriangleFilter 				*filtro = vtkTriangleFilter::New();
		vtkPolyDataConnectivityFilter 	*pdcf 	= vtkPolyDataConnectivityFilter::New();

		// 1.2 se escribe a disco el archivo stl de la superficie interna
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		filtro->SetInput(stlInterna);
        pdcf->SetInput( filtro->GetOutput() );
        cpd->SetInput( pdcf->GetOutput() );
        cpd->Update();
#else
		filtro->SetInputData(stlInterna);
        pdcf->SetInputData( filtro->GetOutput() );
        cpd->SetInputData( pdcf->GetOutput() );
#endif
        vtkSTLWriter *writerI = vtkSTLWriter::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        writerI->SetInput( cpd->GetOutput() );
#else
        writerI->SetInputData( cpd->GetOutput() );
#endif
//        prefix = fileprefix;
		filename=prefix+"_internal.stl";
        writerI->SetFileName(filename.c_str());
        writerI->SetFileTypeToASCII();
        writerI->Write();
        writerI->Delete();

		// 1.3 se escribe a disco el archivo stl de la superficie externa
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		filtro->SetInput(stlExterna);
#else
		filtro->SetInputData(stlExterna);
#endif
        cpd->Update();
        vtkSTLWriter *writerE = vtkSTLWriter::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        writerE->SetInput( cpd->GetOutput() );
#else
        writerE->SetInputData( cpd->GetOutput() );
#endif
//        prefix = fileprefix;
		filename=prefix+"_external.stl";
        writerE->SetFileName( filename.c_str() );
        writerE->SetFileTypeToASCII();
        writerE->Write();
        writerE->Delete();
   
        filtro->Delete();
        cpd->Delete();
        pdcf->Delete();
	}

	//By default *always* update e_installation_directory:
	//_mar->_parameters->setStringParam( marParameters::e_installation_directory, dialog.GetPath( ) ); 
	//_mar->saveParameters( );
}


void wxSTLWidget_03::OnChangeSTLGaussLevel(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_stlDeltaGaussLevel  = ((double)stlSliderDeltaGauss->GetValue())/100;
	generateSTLSurfaces();
	Refresh();
}


void wxSTLWidget_03::OnChangeSTLMarchingCubesLevel(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_stlMarchingCubesLevel = ((double)stlSliderMarchingCubes->GetValue());
 	generateSTLSurfaces();
	Refresh();
	
}


// ------------------------------------------------------------------------
// END STL FUNCTIONS - DHC
// ------------------------------------------------------------------------







