/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <creaWx.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <stdlib.h>
#include <iostream> // for std::cout

#include "wxVTKRenderWindowInteractorEditContour.h"

//---------------------------------------------------------------------------
vtkInteractorStyle3DMaracas::vtkInteractorStyle3DMaracas(){
}
//---------------------------------------------------------------------------
vtkInteractorStyle3DMaracas::~vtkInteractorStyle3DMaracas(){
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnRightButtonDown (){    
/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnRightButtonDown();
		}
*/
  this->FindPokedRenderer(this->Interactor->GetEventPosition()[0], 
                          this->Interactor->GetEventPosition()[1]);

  if (this->CurrentRenderer == NULL)
    {
    return;
    }

  if (this->Interactor->GetControlKey()) {
      this->StartDolly();
  }

}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnRightButtonUp () {
/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnRightButtonUp();
		}
*/

		
  switch (this->State) 
    {
    case VTKIS_DOLLY:
      this->EndDolly();
      break;
    }
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnMouseMove () {

//		this->vtkInteractorStyleTrackballCamera::OnMouseMove();

  /* int x = */ this->Interactor->GetEventPosition()[0]; // JPRx (unused)
  /* int y = */ this->Interactor->GetEventPosition()[1]; // JPRx (unused)


  vtkRenderWindowInteractor *rwi = this->Interactor;

  /* int lx = */  rwi->GetLastEventPosition()[0]; // JPRx (unused)
  /* int ly = */  rwi->GetLastEventPosition()[1]; // JPRx (unused)
  /* int dx = */  rwi->GetEventPosition()[0] ;    // JPRx (unused)
  /* int dy = */  rwi->GetEventPosition()[1] ;    // JPRx (unused)


  switch (this->State) 
    {
    case VTKIS_ROTATE:
 //     this->FindPokedRenderer(x, y);
      this->Rotate();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_PAN:
 //     this->FindPokedRenderer(x, y);
      this->Pan();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_DOLLY:
 //     this->FindPokedRenderer(x, y);
      this->Dolly();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;

    case VTKIS_SPIN:
 //     this->FindPokedRenderer(x, y);
      this->Spin();
 //     this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
      break;
    }



}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnLeftButtonDown (){
/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnMiddleButtonDown();
		} else {
			this->vtkInteractorStyleTrackballCamera::OnLeftButtonDown();
		}
*/


  this->FindPokedRenderer(this->Interactor->GetEventPosition()[0], 
                          this->Interactor->GetEventPosition()[1]);
  if (this->CurrentRenderer == NULL)
    {
    return;
    }

  if (this->Interactor->GetControlKey()) {
      this->StartPan();
  } else {
      this->StartRotate();
  }

 /* 
  if (this->Interactor->GetShiftKey()) 
    {
    if (this->Interactor->GetControlKey()) 
      {
      this->StartDolly();
      }
    else 
      {
      this->StartPan();
      }
    } 
  else 
    {
    if (this->Interactor->GetControlKey()) 
      {
      this->StartSpin();
      }
    else 
      {
      this->StartRotate();
      }
    }
*/


}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnLeftButtonUp () {
/*
		if (GetInteractor()->GetControlKey()==1 ){
			this->vtkInteractorStyleTrackballCamera::OnMiddleButtonUp();
		} else {
			this->vtkInteractorStyleTrackballCamera::OnLeftButtonUp();
		}
*/
  switch (this->State) 
    {

    case VTKIS_PAN:
      this->EndPan();
      break;

    case VTKIS_ROTATE:
      this->EndRotate();
      break;
    }
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnMiddleButtonDown () {
//		this->vtkInteractorStyleTrackballCamera::OnMiddleButtonDown();
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle3DMaracas::OnMiddleButtonUp () {
//		this->vtkInteractorStyleTrackballCamera::OnMiddleButtonUp();
}


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
vtkInteractorStyle2DMaracas::vtkInteractorStyle2DMaracas(){
	_obs=NULL;
}
//---------------------------------------------------------------------------
vtkInteractorStyle2DMaracas::~vtkInteractorStyle2DMaracas(){
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnRightButtonDown (){    
	if (GetInteractor()->GetControlKey()==1 ){
		this->vtkInteractorStyleImage::OnRightButtonDown();
	}
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnRightButtonUp () {
	if (GetInteractor()->GetControlKey()==1 ){
		this->vtkInteractorStyleImage::OnRightButtonUp();
	}
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnMouseMove () {
	this->vtkInteractorStyleImage::OnMouseMove();
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnLeftButtonDown (){
	if ((GetInteractor()->GetControlKey()==1) && (GetInteractor()->GetShiftKey()==0) ){
		this->vtkInteractorStyleImage::OnMiddleButtonDown();
	} else if ((GetInteractor()->GetControlKey()==0) && (GetInteractor()->GetShiftKey()==1) ){
		if (_obs){
			_obs->Execute( NULL , vtkCommand::LeftButtonPressEvent  , NULL ) ;
		}
	} else {
		this->vtkInteractorStyleImage::OnLeftButtonDown();
	}
}

//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnLeftButtonUp () {
	if ((GetInteractor()->GetControlKey()==1) && (GetInteractor()->GetShiftKey()==0) ){
		this->vtkInteractorStyleImage::OnMiddleButtonUp();
	} else if ((GetInteractor()->GetControlKey()==0) && (GetInteractor()->GetShiftKey()==1) ){
		if (_obs) {
			_obs->Execute( NULL , vtkCommand::LeftButtonReleaseEvent  , NULL );
		}
	} else {
		this->vtkInteractorStyleImage::OnLeftButtonUp();
	}
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnMiddleButtonDown () {
}
//---------------------------------------------------------------------------
void  vtkInteractorStyle2DMaracas::OnMiddleButtonUp () {
}

//---------------------------------------------------------------------------
void vtkInteractorStyle2DMaracas::SetObserver(vtkCommand* obs){
	this->_obs=obs;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

wxVTKRenderWindowInteractorEditContour::wxVTKRenderWindowInteractorEditContour(wxWindow *parent,wxWindowID id)
  :wxVTKRenderWindowInteractor(parent,id){
	this->_state=0;
}
//---------------------------------------------------------------------------
wxVTKRenderWindowInteractorEditContour::~wxVTKRenderWindowInteractorEditContour(){
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::OnButtonDown(wxMouseEvent &event){
	if (this->_state==1){
  	  wxVTKRenderWindowInteractor::OnButtonDown(event);
	}
	if (this->_state==2){
		if(event.LeftDown()==true){
			SetEventInformationFlipY(event.GetX(), event.GetY(), event.ControlDown(), event.ShiftDown(), '\0', 0, NULL);
			_obs->Execute( NULL , wxEVT_LEFT_DOWN  , NULL ) ;
		}
		if(event.RightDown()==true){
     	    wxVTKRenderWindowInteractor::OnButtonDown(event);
			SetEventInformationFlipY(event.GetX(), event.GetY(), event.ControlDown(), event.ShiftDown(), '\0', 0, NULL);
			_obs->Execute( NULL , wxEVT_RIGHT_DOWN  , NULL ) ;
		}
	}
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::OnButtonUp(wxMouseEvent &event){
	if (this->_state==1){
  	  wxVTKRenderWindowInteractor::OnButtonUp(event);
	}
	if (this->_state==2){
		if(event.LeftUp()==true){
			SetEventInformationFlipY(event.GetX(), event.GetY(), event.ControlDown(), event.ShiftDown(), '\0', 0, NULL);
			_obs->Execute( NULL , wxEVT_LEFT_UP  , NULL ) ;
		}
		if(event.RightUp()==true){
     	    wxVTKRenderWindowInteractor::OnButtonUp(event);
		}
	}
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::OnButtonDouble(wxMouseEvent &event){
	if (this->_state==1){
// EED 22 dec 2007 :  SIL que tengo que hacer aqui ..??  Esto creo que lo quito silvia y como se 
// remplaza
//  	  wxVTKRenderWindowInteractor::OnButtonDouble(event);
	}
	if (this->_state==2){
		if(event.LeftDClick()==true){
			SetEventInformationFlipY(event.GetX(), event.GetY(), event.ControlDown(), event.ShiftDown(), '\0', 0, NULL);
			_obs->Execute( NULL , wxEVT_LEFT_DCLICK  , NULL ) ;
		}
	}
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::OnMotion(wxMouseEvent &event){
	if (this->_state==1){
		wxVTKRenderWindowInteractor::OnMotion(event);
	}
	if (this->_state==2){
		wxVTKRenderWindowInteractor::OnMotion(event);
		if(event.Moving()==true){
			SetEventInformationFlipY(event.GetX(), event.GetY(), event.ControlDown(), event.ShiftDown(), '\0', 0, NULL);
			_obs->Execute( NULL , wxEVT_MOTION   , NULL ) ;
		}
	}
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::OnKeyDown(wxKeyEvent &event){
	wxVTKRenderWindowInteractor::OnKeyDown(event);
	if (( event.GetKeyCode()==WXK_BACK ) || ( event.GetKeyCode()==WXK_DELETE) ){
		_obs->Execute( NULL , WXK_CLEAR   , NULL ) ;
	}
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::SetState(int state){
	this->_state=state;
}
//---------------------------------------------------------------------------
int	 wxVTKRenderWindowInteractorEditContour::GetState(){
	return this->_state;
}
//---------------------------------------------------------------------------
void wxVTKRenderWindowInteractorEditContour::SetObserver(vtkCommand* obs){
	this->_obs=obs;
}

