/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _wxVTKRenderWindowInteractorEditContour_h_
#define _wxVTKRenderWindowInteractorEditContour_h_

#include <creawxVTKRenderWindowInteractor.h>

#include <vtkCommand.h> 
#include <vtkImageData.h> 
//#include <vtkRenderWindow.h> 
#include <vtkImageViewer2.h> 

#include <vtkInteractorStyleTrackballCamera.h> 
#include <vtkInteractorStyleImage.h> 



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------

class vtkInteractorStyle3DMaracas : public vtkInteractorStyleTrackballCamera    {
public:
	vtkInteractorStyle3DMaracas();
	~vtkInteractorStyle3DMaracas();

	virtual char const *GetClassName() const { return "vtkInteractorStyle3DMaracas";}
	static vtkInteractorStyle3DMaracas *New(){
					return new vtkInteractorStyle3DMaracas();
				}

	virtual void  OnMouseMove () ;
	virtual void  OnLeftButtonDown (); 
	virtual void  OnLeftButtonUp () ;
	virtual void  OnMiddleButtonDown (); 
	virtual void  OnMiddleButtonUp () ;
	virtual void  OnRightButtonDown () ;
	virtual void  OnRightButtonUp () ;

private:

};

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------


class vtkMaracasImageViewer2Callback : public vtkCommand
{
public:
  vtkMaracasImageViewer2Callback() {} ;
  ~vtkMaracasImageViewer2Callback() {} ;
  static vtkMaracasImageViewer2Callback *New() {
     return new vtkMaracasImageViewer2Callback(); 
  }

  virtual char const *GetClassName() const { return "vtkMaracasImageViewer2Callback";}
  
  void Execute(vtkObject *caller, 
               unsigned long event, 
               void *vtkNotUsed(callData))
    {
      if (this->IV->GetInput() == NULL)
        {
        return;
        }

      // Reset

      if (event == vtkCommand::ResetWindowLevelEvent)
        {


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        this->IV->GetInput()->UpdateInformation();
        this->IV->GetInput()->SetUpdateExtent
          (this->IV->GetInput()->GetWholeExtent());
        this->IV->GetInput()->Update();
#else
	//..
#endif

        double *range = this->IV->GetInput()->GetScalarRange();
        this->IV->SetColorWindow(range[1] - range[0]);
        this->IV->SetColorLevel(0.5 * (range[1] + range[0]));
        this->IV->Render();
        return;
        }

      // Start

      if (event == vtkCommand::StartWindowLevelEvent)
        {
        this->InitialWindow = this->IV->GetColorWindow();
        this->InitialLevel = this->IV->GetColorLevel();
        return;
        }
      
      // Adjust the window level here

      vtkInteractorStyleImage *isi = 
        static_cast<vtkInteractorStyleImage *>(caller);

      int *size = this->IV->GetRenderWindow()->GetSize();
      double window = this->InitialWindow;
      double level = this->InitialLevel;
      
      // Compute normalized delta

      double dx = 4.0 * 
        (isi->GetWindowLevelCurrentPosition()[0] - 
         isi->GetWindowLevelStartPosition()[0]) / size[0];
      double dy = 4.0 * 
        (isi->GetWindowLevelStartPosition()[1] - 
         isi->GetWindowLevelCurrentPosition()[1]) / size[1];
      
      // Scale by current values

      if (fabs(window) > 0.01)
        {
        dx = dx * window;
        }
      else
        {
        dx = dx * (window < 0 ? -0.01 : 0.01);
        }
      if (fabs(level) > 0.01)
        {
        dy = dy * level;
        }
      else
        {
        dy = dy * (level < 0 ? -0.01 : 0.01);
        }
      
      // Abs so that direction does not flip

      if (window < 0.0) 
        {
        dx = -1*dx;
        }
      if (level < 0.0) 
        {
        dy = -1*dy;
        }
      
      // Compute new window level

      double newWindow = dx + window;
      double newLevel;
      newLevel = level - dy;
      
      // Stay away from zero and really

      if (fabs(newWindow) < 0.01)
        {
        newWindow = 0.01*(newWindow < 0 ? -1 : 1);
        }
      if (fabs(newLevel) < 0.01)
        {
        newLevel = 0.01*(newLevel < 0 ? -1 : 1);
        }
      
      this->IV->SetColorWindow(newWindow);
      this->IV->SetColorLevel(newLevel);
      this->IV->Render();
    }
  
  vtkImageViewer2 *IV;
  double InitialWindow;
  double InitialLevel;
};

//class crea::wxVTKRenderWindowInteractor;

class vtkInteractorStyle2DMaracas : public vtkInteractorStyleImage{
public:
	vtkInteractorStyle2DMaracas();
	~vtkInteractorStyle2DMaracas();

	virtual char const *GetClassName() const { return "vtkInteractorStyle2DMaracas";}
	static vtkInteractorStyle2DMaracas *New(){
					return new vtkInteractorStyle2DMaracas();
				}

	virtual void  OnMouseMove () ;
	virtual void  OnLeftButtonDown (); 
	virtual void  OnLeftButtonUp () ;
	virtual void  OnMiddleButtonDown (); 
	virtual void  OnMiddleButtonUp () ;
	virtual void  OnRightButtonDown () ;
	virtual void  OnRightButtonUp () ;
	void  SetObserver( vtkCommand *obs );

private:
	vtkCommand *_obs;
};


//-----------------------------------------------------------------------------




class wxVTKRenderWindowInteractorEditContour : public crea::wxVTKRenderWindowInteractor {

public:

    wxVTKRenderWindowInteractorEditContour(wxWindow *parent,wxWindowID id); 
    virtual ~wxVTKRenderWindowInteractorEditContour(); 

    virtual void OnButtonDown(wxMouseEvent &event);
    virtual void OnButtonUp(wxMouseEvent &event);
    virtual void OnButtonDouble(wxMouseEvent &event);
    virtual void OnMotion(wxMouseEvent &event);
    virtual void OnKeyDown(wxKeyEvent &event);

    void SetState(int state);
    int  GetState();
    void SetObserver(vtkCommand *obs);

private:
    int        _state;
    vtkCommand *_obs;
};


#endif //_wxVTKRenderWindowInteractorEditContour_h_
