/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "wxVTKRenderWindowInteractorPlus.h"
#include "vtkInteractorStyleBaseView.h"

BEGIN_EVENT_TABLE( wxVTKRenderWindowInteractorPlus, wxVTKRenderWindowInteractor )
    EVT_LEFT_DCLICK( wxVTKRenderWindowInteractorPlus::OnLeftDClick )
    EVT_RIGHT_DCLICK( wxVTKRenderWindowInteractorPlus::OnRightDClick )
    EVT_MIDDLE_DCLICK( wxVTKRenderWindowInteractorPlus::OnMiddleDClick )
	EVT_MOUSEWHEEL( wxVTKRenderWindowInteractorPlus::OnMouseWheel )
END_EVENT_TABLE( );

//-------------------------------------------------------------------
wxVTKRenderWindowInteractorPlus::wxVTKRenderWindowInteractorPlus() 
: wxVTKRenderWindowInteractor()
{
}


//-------------------------------------------------------------------
wxVTKRenderWindowInteractorPlus::wxVTKRenderWindowInteractorPlus(wxWindow *parent, wxVtkBaseView *wxvtkbaseview)
: wxVTKRenderWindowInteractor(parent, -1)
{
	_wxvtkbaseview = wxvtkbaseview;
}

//-------------------------------------------------------------------
wxVTKRenderWindowInteractorPlus::~wxVTKRenderWindowInteractorPlus()
{
}

//---------------------------------------------------------------------------
wxVTKRenderWindowInteractorPlus * wxVTKRenderWindowInteractorPlus::New()
{
  // we don't make use of the objectfactory, because we're not registered
  return new wxVTKRenderWindowInteractorPlus;
}

//-------------------------------------------------------------------
void wxVTKRenderWindowInteractorPlus::OnLeftDClick( wxMouseEvent& event )
{
	/**
	 * JCP 14/05/09	 
	wxvtkbaseview->GetInteractorStyleBaseView()->OnLeftDClick();
	*/
	((vtkInteractorStyleBaseView*)_wxvtkbaseview->GetInteractorStyleBaseView())->OnLeftDClick();
}
//-------------------------------------------------------------------
void wxVTKRenderWindowInteractorPlus::OnRightDClick( wxMouseEvent& event )
{
	/**
		 * JCP 14/05/09		 
	_wxvtkbaseview->GetInteractorStyleBaseView()->OnRightDClick();
	*/
	((vtkInteractorStyleBaseView*)_wxvtkbaseview->GetInteractorStyleBaseView())->OnRightDClick();
}
//-------------------------------------------------------------------
void wxVTKRenderWindowInteractorPlus::OnMiddleDClick( wxMouseEvent& event )
{
	/**
		 * JCP 14/05/09
		 
	_wxvtkbaseview->GetInteractorStyleBaseView()->OnMiddleDClick();
	*/
	((vtkInteractorStyleBaseView*)_wxvtkbaseview->GetInteractorStyleBaseView())->OnMiddleDClick();
}
//-------------------------------------------------------------------
void wxVTKRenderWindowInteractorPlus::OnMouseWheel( wxMouseEvent& event )
{
	/**
		 * JCP 14/05/09
		 
	_wxvtkbaseview->GetInteractorStyleBaseView()->OnMouseWheel();
	*/
	
	if(event.GetWheelRotation() > 0)
    {
		//Send event to VTK
		//EED InvokeEvent(vtkCommand::MouseWheelForwardEvent, NULL);
		((vtkInteractorStyleBaseView*)_wxvtkbaseview->GetInteractorStyleBaseView())->OnMouseWheelForward();
    }
	else
    {
		//Send event to VTK
		//EED InvokeEvent(vtkCommand::MouseWheelBackwardEvent, NULL);
		((vtkInteractorStyleBaseView*)_wxvtkbaseview->GetInteractorStyleBaseView())->OnMouseWheelBackward();
    }
	
	
}


