/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxVtk2DBaseView.h"

#include "vtkInfoTextImage.h"
#include "vtkInteractorStyleBaseView2D.h"
#include "vtkInfoTextImageInteractor.h"
#include "vtkImageActor.h"


wxVtk2DBaseView::wxVtk2DBaseView(wxWindow *parent,bool TDxWindow)
:wxVtkBaseView(parent,TDxWindow)
{
   _imageViewer2XYZ   = NULL;
   _vtkIinfoTextImage = NULL;
}

//EED 5mai2009
//-------------------------------------------------------------------
wxVtk2DBaseView::~wxVtk2DBaseView()
{
	if (_vtkIinfoTextImage!=NULL)
	{
	   delete _vtkIinfoTextImage;
	}
	if (_imageViewer2XYZ!=NULL)
	{
	   delete _imageViewer2XYZ;
	}
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::TransformCoordinate_spacing_ViewToModel(double &X,double &Y, double &Z) // 	virtual
{
//EEDx5
	double spc[3];
//	GetVtkBaseData()->GetImageData()->GetSpacing(spc);
//JCP 04/08/10	W/O Image this->_imageViewer2XYZ->GetVtkImageViewer2()->GetInput()->GetSpacing(spc);
	vtkImageData* image = this->_imageViewer2XYZ->GetVtkImageViewer2()->GetInput();
	if(image)
	{
		image->GetSpacing(spc);
	}else{
		spc[0] = 1;
		spc[1] = 1;
		spc[2] = 1;
	}
	X = X / spc[0];
	Y = Y / spc[1];
	Z = Z / spc[2];
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::TransformCoordinate_spacing_ModelToView(double &X,double &Y, double &Z) // 	virtual
{
//EEDx5
	double spc[3];
//	GetVtkBaseData()->GetImageData()->GetSpacing(spc);
//JCP 04/08/10	W/O Image this->_imageViewer2XYZ->GetVtkImageViewer2()->GetInput()->GetSpacing(spc);
	vtkImageData* image = this->_imageViewer2XYZ->GetVtkImageViewer2()->GetInput();
	if(image){
		image->GetSpacing(spc);
	}else{
		spc[0] = 1;
		spc[1] = 1;
		spc[2] = 1;
	}
//
	X=X*spc[0];
	Y=Y*spc[1];
	Z=Z*spc[2];
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::ResetView()
{
	double spx = 0,spy = 0,spz = 0;
	int x1 = 1,x2 = 1,y1 = 1,y2 = 1,z1 = 1,z2 = 1;
	wxVtkBaseView::Configure();
	crea::wxVTKRenderWindowInteractor *iren = GetWxVTKRenderWindowInteractor();
	vtkImageData *imageData	= GetVtkBaseData()->GetImageData();
	if(imageData)
	{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		imageData->UpdateInformation();
		imageData->SetUpdateExtent( imageData->GetWholeExtent());
		imageData->Update();
		_imageViewer2XYZ->GetVtkImageViewer2()->SetInput(imageData );
#else
		_imageViewer2XYZ->GetVtkImageViewer2()->SetInputData(imageData );
#endif
		imageData->GetSpacing (spx,spy,spz);
		imageData->GetExtent (x1,x2,y1,y2,z1,z2);
	}
	_imageViewer2XYZ -> SetExtentDimension(x1,x2,y1,y2,z1,z2);
 	_imageViewer2XYZ -> GetVtkImageViewer2()->SetupInteractor ( iren );

//EED 24oct2010
    _imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel()->Modified();

//EED2120-06-23	_imageViewer2XYZ->GetVtkImageViewer2()->Render();

	//////////////
	//RaC 04-2010 Look for the description of new changes in vtkInteractorStyleBaseView2D constructor.
	//
	// Previous version
	// SetInteractorStyleImage( vtkInteractorStyleBaseView2D::New() );
	//
	// Actual version
	vtkInteractorStyleBaseView2D *style2D = vtkInteractorStyleBaseView2D::New();

	manualInteractorWindowLevel *_manualinteractorwindowlevel= new manualInteractorWindowLevel();
	style2D->SetInteractorWindowLevel( _manualinteractorwindowlevel );

	vtkInteractorScrollZ *_vtkInteractorScrollZ = new vtkInteractorScrollZ();
	style2D->SetInteractorScrollZ(_vtkInteractorScrollZ);

	vtkInteractorZoomCamera *_vtkInteractorZoomCamera = new vtkInteractorZoomCamera();
	style2D->SetInteractorZoomCamera(_vtkInteractorZoomCamera);

	SetInteractorStyleImage( style2D );
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetImageToVtkViewer(vtkImageData *imageData)
{
	int ext[6];
	if (_imageViewer2XYZ!=NULL)
	{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		imageData->Update();
		imageData->GetWholeExtent(ext);
		_imageViewer2XYZ->SetExtentDimension( ext[0],ext[1],ext[2],ext[3],ext[4],ext[5] );
		_imageViewer2XYZ->GetVtkImageViewer2()->SetInput( imageData );
#else
		imageData->GetExtent(ext);
		_imageViewer2XYZ->SetExtentDimension( ext[0],ext[1],ext[2],ext[3],ext[4],ext[5] );
		_imageViewer2XYZ->GetVtkImageViewer2()->SetInputData( imageData );
#endif
	} // if _imageViewer2XYZ

	GetRenderer()->GetActiveCamera()->SetClippingRange(0.01, 1000000);

}

//-------------------------------------------------------------------
void wxVtk2DBaseView::Configure(bool okimage)
{
	double spx,spy,spz;
	int x1,x2,y1,y2,z1,z2;
	wxVtkBaseView::Configure();

// EED 17 Oct 2007
	if (_imageViewer2XYZ==NULL)
	{
		_imageViewer2XYZ = new vtkImageViewer2_XYZ();
		crea::wxVTKRenderWindowInteractor *iren = GetWxVTKRenderWindowInteractor();
		_imageViewer2XYZ -> GetVtkImageViewer2()->SetupInteractor ( iren );

		//////////////
		//RaC 04-2010 Look for the description of new changes in vtkInteractorStyleBaseView2D constructor.
		//
		// Previous version
		// SetInteractorStyleImage( vtkInteractorStyleBaseView2D::New() );
		//
		// Actual version
		vtkInteractorStyleBaseView2D *style2D = vtkInteractorStyleBaseView2D::New();

		manualInteractorWindowLevel *_manualinteractorwindowlevel= new manualInteractorWindowLevel();
		style2D->SetInteractorWindowLevel( _manualinteractorwindowlevel );

		vtkInteractorScrollZ *_vtkInteractorScrollZ = new vtkInteractorScrollZ();
		style2D->SetInteractorScrollZ(_vtkInteractorScrollZ);

		vtkInteractorZoomCamera *_vtkInteractorZoomCamera = new vtkInteractorZoomCamera();
		style2D->SetInteractorZoomCamera(_vtkInteractorZoomCamera);

		SetInteractorStyleImage( style2D );

		// RaC
		//////////////
	}

	vtkImageData *imageData	= GetVtkBaseData()->GetMarImageData()->GetImageData();
	if (imageData!=NULL)
	{

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		imageData->UpdateInformation();
		imageData->SetUpdateExtent( imageData->GetWholeExtent());
		imageData->Update();
#else
		//...
#endif

		if (okimage==true){
			imageData->GetSpacing (spx,spy,spz);
			imageData->GetExtent (x1,x2,y1,y2,z1,z2);
			SetImageToVtkViewer(imageData);
			_imageViewer2XYZ->SetExtentDimension(x1,x2,y1,y2,z1,z2);
			
/*EED Borrame,  now is syncroniced in vtkBaseData for all windows			
			double range[2];
			imageData->GetScalarRange(range);
			if (range[1]<20000){
				 _imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow( (range[1]-range[0])/2 );
				 _imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel( (range[1]+range[0])/4 );
			} else {
				 _imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow( 1000 );
				 _imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel( 500 );
			}
*/ 
			
// EED 31 Janvier 2007
//vtkImageActor *vtkimageactor = _imageViewer2XYZ->GetVtkImageViewer2()->GetImageActor ();
//vtkimageactor->InterpolateOff ();
//vtkLookupTable * _collookup = vtkLookupTable::New( );
//_collookup->SetNumberOfColors( 256 );
//_collookup->SetTableRange( 0 , 255 );
//_collookup->Build( );
//_collookup->SetTableValue( 0  , 1 , 0 , 0 , 1 );
//_collookup->SetTableValue(128 , 0 , 0 , 1 , 1 );
//_collookup->SetTableValue(255 , 0 , 1 , 0 , 1 );
//_imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel ()->SetLookupTable(_collookup );

// EED 17 Oct 2007
//			SetInteractorStyleImage( vtkInteractorStyleBaseView2D::New() );

			vtkImageViewer2 *IV2		=	_imageViewer2XYZ->GetVtkImageViewer2();
	  		vtkCamera		*camera		=	IV2->GetRenderer()->GetActiveCamera();

//EED 17Avril2009
//EED 21 mars 2012	FLIP problem  ..PLOP..
			
			// XY
			camera->SetViewUp		( spx*0			, -spy*1		, spz*0		);
			camera->SetPosition		( spx*(x1+x2)/2	, spy*(y1+y2)/2	, -spz*10000	);
			camera->SetFocalPoint	( spx*(x1+x2)/2	, spy*(y1+y2)/2	, spz*0		);
/*
			camera->SetViewUp		( spx*0			, spy*1			, spz*0		);
			camera->SetPosition		( spx*(x1+x2)/2	, spy*(y1+y2)/2	, spz*10000	);
			camera->SetFocalPoint	( spx*(x1+x2)/2	, spy*(y1+y2)/2	, spz*0		);
*/

			
			camera->SetClippingRange( 0.01			, 1000000 );
			camera->ComputeViewPlaneNormal();
		
			double cameraparallelScale=spx*(x2-x1)/3.0;	
			camera->SetParallelScale( cameraparallelScale );
			GetVtkBaseData()->SetCameraParallelScale( cameraparallelScale );

			// text information over the graphic window
			if(_vtkIinfoTextImage == NULL){
				_vtkIinfoTextImage					= new vtkInfoTextImage();
				_vtkIinfoTextImageInteractor		= new vtkInfoTextImageInteractor();
				((vtkInteractorStyleBaseView*)this->GetInteractorStyleBaseView())->AddInteractorStyleMaracas(_vtkIinfoTextImageInteractor);
			}
			_vtkIinfoTextImage->SetWxVtk2DBaseView(this);
			_vtkIinfoTextImage->SetMarImageData( GetVtkBaseData()->GetMarImageData() );
			_vtkIinfoTextImageInteractor->SetModelVtkInfoTextImage(_vtkIinfoTextImage);
			_vtkIinfoTextImage->Configure();

		} // okimage
	} // imageData
    
}

//-------------------------------------------------------------------

int wxVtk2DBaseView::GetActualSlice()  // virtual
{
   return (int)(GetVtkBaseData()->GetZ());
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetActualSlice(int slice)  // Virtual
{
   GetVtkBaseData()->SetZ(slice);
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::UpdateColorWindowLevel()
{
	//EED 24oct2010
	//EED 02nov2012
	
	vtkImageMapToWindowLevelColors* imagemaptowindowlevel = _imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel();
	imagemaptowindowlevel->SetWindow( GetVtkBaseData()->GetColorWindow() );
	imagemaptowindowlevel->SetLevel( GetVtkBaseData()->GetColorLevel() );
	_imageViewer2XYZ->GetVtkImageViewer2()->GetWindowLevel()->Modified();
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::UpdateCameraParallelScale()
{
	vtkCamera *camera =_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->GetActiveCamera();
	camera->SetParallelScale( GetVtkBaseData()->GetCameraParallelScale() );
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::Refresh()
{
	int z = (int)(GetVtkBaseData()->GetZ());
	_imageViewer2XYZ->SetZSlice( z );
//EED 2016/02/19
	vtkImageActor *imageactor = _imageViewer2XYZ->GetVtkImageViewer2()->GetImageActor();
	imageactor->SetInterpolate( GetVtkBaseData()->GetInterpolate() );
	//EED 01nov2012
	UpdateColorWindowLevel();	
	UpdateCameraParallelScale();	
	wxVtkBaseView::Refresh();
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetInteractorStyleImage(vtkInteractorStyleBaseView *interactorstylebaseview)
{
	SetInteractorStyleBaseView(interactorstylebaseview);
	crea::wxVTKRenderWindowInteractor *iren = GetWxVTKRenderWindowInteractor();
	interactorstylebaseview->SetInteractor ( iren );
	iren->SetInteractorStyle(interactorstylebaseview);
	interactorstylebaseview->SetwxVtkBaseView(this);
	vtkMaracasImageViewer2Callback * cbk = vtkMaracasImageViewer2Callback::New();
	cbk->IV = _imageViewer2XYZ->GetVtkImageViewer2();
	interactorstylebaseview->AddObserver( vtkCommand::WindowLevelEvent, cbk );
	interactorstylebaseview->AddObserver( vtkCommand::StartWindowLevelEvent, cbk );
	interactorstylebaseview->AddObserver( vtkCommand::ResetWindowLevelEvent, cbk );
	cbk->Delete();
}

//---------------------------------------------------------------------------
vtkRenderer* wxVtk2DBaseView::GetRenderer()	// virtual
{
   return _imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer();
}

//---------------------------------------------------------------------------
vtkRenderWindow* wxVtk2DBaseView::GetRenWin()		// virtual
{
   return _imageViewer2XYZ->GetVtkImageViewer2()->GetRenderWindow();
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::GetSpacing(double spc[3])  // virtual
{
   vtkImageData *imageData	= GetVtkBaseData()->GetImageData();
   if(imageData)
   {
	imageData->GetSpacing(spc);
   }else{
	 spc[0] = 0;
	 spc[1] = 0;
	 spc[2] = 0;
   }
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::setColorTransferFunction(vtkColorTransferFunction* colortable)
{
	if(_imageViewer2XYZ!=NULL)
	{
		_imageViewer2XYZ->setColorTransferFunction(colortable);
		this->Refresh();
	}
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetColorWindow(double level)
{
//	_imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow(level);
	GetVtkBaseData()->SetColorWindow(level);	
	this->Refresh();
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetColorLevel(double level)
{
//	_imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel(level);
	GetVtkBaseData()->SetColorLevel(level);
	this->Refresh();
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::SetInterpolate(bool iterpolate)
{
	GetVtkBaseData()->SetInterpolate( iterpolate );
	this->Refresh();
}

//-------------------------------------------------------------------
int wxVtk2DBaseView::GetDirection() // virtual
{
    return 2;
}

//-------------------------------------------------------------------
void wxVtk2DBaseView::GetNormal(double normal[3] ) // virtual
{
	if (GetDirection()==0 ) 
	{
		normal[0]=1;
		normal[1]=0;
		normal[2]=0;
	} // if
	if (GetDirection()==1 ) 
	{
		normal[0]=0;
		normal[1]=1;
		normal[2]=0;
	} // if
	if (GetDirection()==2 ) 
	{
		normal[0]=0;
		normal[1]=0;
		normal[2]=1;
	} // if
}


//-------------------------------------------------------------------
void wxVtk2DBaseView::SetOpacityText(double opacity)
{
	if (_vtkIinfoTextImage!=NULL)
	{
		_vtkIinfoTextImage->SetOpacity( opacity );
	}
}


