/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxVtk3DBaseView.h"

#include "vtkInteractorStyleBaseView3D.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
wxVtk3DBaseView::wxVtk3DBaseView(wxWindow *parent, vtkBaseData* vtkbasedata,bool TDxWindow)
:wxVtkBaseView( parent , TDxWindow)
{
	SetVtkBaseData( vtkbasedata );
	_configure	= false;
	_aRenderer	= NULL;
	_renWin		= NULL;
	_aCamera	= NULL;
}
//-------------------------------------------------------------------
wxVtk3DBaseView::~wxVtk3DBaseView()
{
	if (_aCamera!=NULL)		{ _aCamera		-> Delete(); _aCamera=NULL;}
	if (_aRenderer!=NULL)	{ _aRenderer	-> Delete(); _aRenderer=NULL;}
	if (_renWin!=NULL)		
	{ 
		if(_renWin->GetReferenceCount()==0)
		{
			_renWin->Delete(); 
			_renWin=NULL;
		}
	}
}
//-------------------------------------------------------------------
vtkCamera* wxVtk3DBaseView::GetCamera()
{
	return _aCamera;
}
//-------------------------------------------------------------------
vtkRenderer* wxVtk3DBaseView::GetRenderer()  // virtual
{
	return _aRenderer;
}
//-------------------------------------------------------------------
vtkRenderWindow* wxVtk3DBaseView::GetRenWin()  // virtual
{
	return _renWin;
}
//-------------------------------------------------------------------
void wxVtk3DBaseView::Refresh()
{
//	_renWin->Render();
	vtkRenderWindowInteractor *vri = GetWxVTKRenderWindowInteractor();
	vri->vtkRenderWindowInteractor::Render();
}

//-------------------------------------------------------------------
// EED 27/05/2013
void wxVtk3DBaseView::ResetCamera(int* ext, double* spc)
{
    GetRenderer()->ResetCameraClippingRange();
	if(ext == NULL)
	{
		GetRenderer()->ResetCamera ();
		GetCamera()->Dolly(1.2);
	}else{	
		/*double x = (spc[0])*(origin[0]+(((double)ext[1]-(double)ext[0])/2.0));
		double y = (spc[1])*(origin[1]+(double)ext[3]);
		double z = (spc[2])*(origin[2]+(((double)ext[5]-(double)ext[4])/2.0));*/
		/*double x0=(spc[0])*((double)ext[0]+origin[0]);
		double x1=(spc[0])*((double)ext[1]+origin[0]);
		double y0=(spc[1])*((double)ext[2]+origin[1]);
		double y1=(spc[1])*((double)ext[3]+origin[1]);
		double z0=(spc[2])*((double)ext[4]+origin[2]);
		double z1=(spc[2])*((double)ext[5]+origin[2]);*/
		double x0=(spc[0])*((double)ext[0]);
		double x1=(spc[0])*((double)ext[1]);
		double y0=(spc[1])*((double)ext[2]);
		double y1=(spc[1])*((double)ext[3]);
		double z0=(spc[2])*((double)ext[4]);
		double z1=(spc[2])*((double)ext[5]);
		GetRenderer()->ResetCamera(x0,x1,y0,y1,z0,z1);
		//_wxvtk3Dbaseview->GetCamera()->SetPosition(x,y,z);
		GetCamera()->Dolly(1.5);	
	}// if ext
}

//-------------------------------------------------------------------
void wxVtk3DBaseView::SetStereo(int type)
{
	//EED 02/06/2012  
	if (_renWin!=NULL)
	{
		if (type==0)
		{
			_renWin->SetStereoRender(0); // OFF
		} else {
			_renWin->SetStereoRender(1); // ON
			_renWin->SetStereoCapableWindow(1);
			_renWin->SetAnaglyphColorMask(4,3);
			_renWin->SetAnaglyphColorSaturation(0.65);
		
			// VTK_STEREO_CRYSTAL_EYES 1
			// VTK_STEREO_RED_BLUE     2
			// VTK_STEREO_INTERLACED   3
			// VTK_STEREO_LEFT         4
			// VTK_STEREO_RIGHT        5
			// VTK_STEREO_DRESDEN      6
			// VTK_STEREO_ANAGLYPH     7
            // VTK_STEREO_CHECKERBOARD 8
            // VTK_STEREO_SPLITVIEWPORT_HORIZONTAL 9
            // VTK_STEREO_FAKE 10
			// VTK_STEREO_EMULATE 11
            
			_renWin->SetStereoType(type);

		} // if type
	} // _renWin
}


//-------------------------------------------------------------------
void wxVtk3DBaseView::Configure()
{
	if (_configure==false)
	{
		_configure=true;
		//wxVtkBaseView::Configure();
		_aRenderer	= vtkRenderer::New();
		_renWin		= vtkRenderWindow::New();
        
        
        printf("EED wxVtk3DBaseView::Configure >>>>> vtkRenderWindow IsDirect       %d\n", _renWin->IsDirect() );
        
        /* EED 2022-07-26  Segmentation fault with VTK9.2 Macos
        int supportopengl=_renWin->SupportsOpenGL();
        printf("EED wxVtk3DBaseView::Configure >>>>> vtkRenderWindow SupportsOpenGL %d\n", supportopengl );
        if (supportopengl==0)
        {
#if defined(_WIN32)
            printf("   OpenGL 3 not detected.\n    Try to install opengl drivers or use de opengl-mesa version.\n    Copy from <ProgramsFiles>\\CreaTools\\crea_TPdlls-4.0.0\\bin\\opengl-mesa\n    the file: opengl32.dll\n to    <ProgramsFiles>\\CreaTools\\CreaTools-3.0.0\\bin \n");
#else
            printf("   OpenGL 3 not detected.\n    Try to install opengl drivers or use de opengl-mesa version.\n");
#endif
            exit(0);
        }
        */

        
        
		_renWin->AddRenderer(_aRenderer);

		_aRenderer->GradientBackgroundOn();
		_aRenderer->SetBackground( 0.33 , 0.33 , 0.33 );
		_aRenderer->SetBackground2( 0.66 , 0.66 , 0.66 );

//		_aRenderer->GradientBackgroundOff();
//		_aRenderer->SetBackground(0,0,0 );
		
		SetStereo(0);
		
		GetWxVTKRenderWindowInteractor()->SetRenderWindow(_renWin);

		vtkInteractorStyleBaseView3D *interactorStyleBaseView3D = vtkInteractorStyleBaseView3D::New(); 

		SetInteractorStyleBaseView( interactorStyleBaseView3D );
		interactorStyleBaseView3D->SetInteractor (  GetWxVTKRenderWindowInteractor() );
		GetWxVTKRenderWindowInteractor()->SetInteractorStyle( interactorStyleBaseView3D );
		interactorStyleBaseView3D->SetwxVtkBaseView(this);	

		// It is convenient to create an initial view of the data. The
		// FocalPoint and Position form a vector direction. Later on
		// (ResetCamera() method) this vector is used to position the camera
		// to look at the data in this direction.
		_aCamera = vtkCamera::New();

//EED 17Avril2009	
/*
		_aCamera->SetViewUp (0, 0, -1);
		_aCamera->SetPosition (0, 1, 0);
 */
		_aCamera->SetViewUp (0, 1, 0);
		_aCamera->SetPosition (0, 0, 1);
		
		_aCamera->SetFocalPoint (0, 0, 0);
		_aCamera->ComputeViewPlaneNormal();

//EED 27/05/2013
		GetRenderer()->SetActiveCamera(GetCamera());
		
//EED 21 mars 2012  FLIP probleme  ..PLOP..
//EED 13 may 2013  FLIP probleme  ..PLOP..
		GetCamera()->Roll(180);
		GetCamera()->Yaw(180+30);
		GetCamera()->Pitch(-22);
				
		//https://stackoverflow.com/questions/47528086/problems-with-rendering-transparent-objects-in-vtk
		//https://itk.org/Wiki/VTK/Depth_Peeling

// EED 2022-08-24
//		_aRenderer->SetUseDepthPeeling(1);
//		_aRenderer->SetOcclusionRatio(0.1);
// //        _aRenderer->SetMaximumNumberOfPeels(100);
//		_aRenderer->SetMaximumNumberOfPeels(4);
        
		_renWin->SetMultiSamples(0);
		_renWin->SetAlphaBitPlanes(1);
        
//EED 2021-11-3
// The Depth Peeling method have a bug in MacOs
// In vtkDualDepthPeelingPass::Peel()   TranslucentWrittenPixels are incoherent  TOO BIG  some times. Why ??
// So the comparition in vtkDualDepthPeelingPass::PeelingDone()  is not coherent.
//   while (!this->PeelingDone())
//        {
//          this->Peel();
//        }
// Or CurrentPeel >= MaximumNumberOfPeels || TranslucentWrittenPixels <= OcclusionThreshold not coherent. Why ??

 //EED 2021-07-25
//        _aRenderer->UseDepthPeelingOff();

        
/*
_renWin -> StereoRenderOn ();
_renWin -> StereoCapableWindowOn ();
_renWin -> SetStereoTypeToSplitViewportHorizontal();
*/
        
        
	} // if _configure
    
}

//-------------------------------------------------------------------
//EED 27 sep 2006
void wxVtk3DBaseView::GetSpacing(double spc[3])
{
	spc[0]=1;
	spc[1]=1;
	spc[2]=1;
}

