/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



//#include "vtkInteractorStyleBaseView.h"

#include "wxVtkBaseView.h"
#include "wxVtk2DBaseView.h"
#include "wxVTKRenderWindowInteractorPlus.h"



wxVtkBaseView::wxVtkBaseView()
{
	_parent				= NULL;
	_iren				= NULL;
	_interactorStyle	= NULL;
}

//-------------------------------------------------------------------

wxVtkBaseView::wxVtkBaseView(wxWindow *parent,bool TDxWindow)
{
	_parent				= parent;
	_iren				= (crea::wxVTKRenderWindowInteractor*)new wxVTKRenderWindowInteractorPlus(_parent,this);
//EED 2021-10-12
#ifdef VTK_USE_TDX
    if (TDxWindow==true)
    {
        _iren->SetUseTDx(true);
    } // if TDX
#endif

    
    
//	_iren->UseCaptureMouseOn();
//	_iren				= new wxVTKRenderWindowInteractor(_parent,-1);
	_interactorStyle	= NULL;
}

//-------------------------------------------------------------------
wxVtkBaseView::~wxVtkBaseView()
{
 	_iren -> Delete();
	//_iren=NULL;
}
//-------------------------------------------------------------------

// EED 2022-08-04	throw
//crea::wxVTKRenderWindowInteractor* wxVtkBaseView::GetWxVTKRenderWindowInteractor() throw (char*)
crea::wxVTKRenderWindowInteractor* wxVtkBaseView::GetWxVTKRenderWindowInteractor() 
{
	try {
		if(_iren==NULL)
		{
			throw "wxVtkBaseView::GetWxVTKRenderWindowInteractor() _iren cwxVTKRenderWindowInteractorPlus =NULL";
		}
	   return _iren;
	} catch (...) {
	  throw ;
	}
   
}
//-------------------------------------------------------------------
void wxVtkBaseView::Configure()  // virtual 
{
}
//-------------------------------------------------------------------
void wxVtkBaseView::Refresh()  // virtual 
{
// EED 10 Oct 2007
	#if defined(WIN32)
		_iren->Refresh(true);
// EED 27 sept 2016
  	   vtkRenderWindowInteractor *vri = GetWxVTKRenderWindowInteractor();
	   vri->vtkRenderWindowInteractor::Render();
	#else
//EED 01Avril2009
//		_iren->Render();	
	vtkRenderWindowInteractor *vri = GetWxVTKRenderWindowInteractor();
	vri->vtkRenderWindowInteractor::Render();
		//_iren->Refresh();
	#endif
}
//-------------------------------------------------------------------
void wxVtkBaseView::RefreshView()  // virtual 
{
// EED 10 Oct 2007
	#if defined(WIN32)
		GetRenWin()->Render();
	#else
		//GetRenWin()->Render();
	#endif
}
//---------------------------------------------------------------------------
vtkRenderer* wxVtkBaseView::GetRenderer()	// virtual 
{
	return NULL;
}
//---------------------------------------------------------------------------
vtkRenderWindow* wxVtkBaseView::GetRenWin()		// virtual
{
	return _iren->GetRenderWindow();
}

//----------------------------------------------------------------------------

void wxVtkBaseView::TransCoordScreenToWorld(double &X, double &Y, double &Z, int type)
{
	GetRenderer()->SetDisplayPoint((int)X, (int)Y, (int)Z);
	GetRenderer()->DisplayToWorld();
	double fP[4];
	GetRenderer()->GetWorldPoint( fP );
    if ( fP[3] ){
		fP[0] /= fP[3];
		fP[1] /= fP[3];
		fP[2] /= fP[3];
	}

	if (type!=0)
	{
		X=fP[0];
	}
	if (type!=1)
	{
		Y=fP[1];
	}
	if (type!=2)
	{
		Z=fP[2];
	} 
}
//----------------------------------------------------------------------------
					
void wxVtkBaseView::TransFromCoordScreenToWorld(double &X, double &Y, double &Z, bool keepNormalDirection, int type) //virtual //keepNormalDirection=false, type=2
{
	double xx = X;
	double yy = Y;
	double zz = Z;

	//RaC 03-2010
	TransCoordScreenToWorld(xx,yy,zz,type);

	X = xx;
	Y = yy;
	Z = zz;

// EEDx5
	//JCP 13/05/2009
	vtkInteractorStyleBaseView* interactorstyle = (vtkInteractorStyleBaseView*)this->GetInteractorStyleBaseView();
    wxVtk2DBaseView* baseview = (wxVtk2DBaseView*)interactorstyle->GetWxVtk2DBaseView();

	double fP[3];
	fP[0] = X;
	fP[1] = Y;
	fP[2] = Z;

	baseview->TransformCoordinate_spacing_ViewToModel( fP[0] , fP[1] , fP[2] );
	//JCP 13/05/2009

	if (type!=0)
	{
		X=fP[0];
	}
	if (type!=1)
	{
		Y=fP[1];
	}
	if (type!=2)
	{
		Z=fP[2];
	}

}

//---------------------------------------------------------------------------
/* JCP 14/05/09
vtkInteractorStyleBaseView*	wxVtkBaseView::GetInteractorStyleBaseView()
{
	return _interactorStyle;
}
*/
vtkInteractorStyleImage*	wxVtkBaseView::GetInteractorStyleBaseView()
{
	return _interactorStyle;
}

//---------------------------------------------------------------------------

void wxVtkBaseView::SetInteractorStyleBaseView( vtkInteractorStyleImage*	interactorStyle)
{
	_interactorStyle = interactorStyle;
}

//---------------------------------------------------------------------------

void wxVtkBaseView::GetSpacing(double spc[3])  // virtual
{
	spc[0] = 1;
	spc[1] = 1;
	spc[2] = 1;
}

void wxVtkBaseView::GetNormal(double normal[3])  // virtual
{
	normal[0] = 0;
	normal[1] = 0;
	normal[2] = 0;
}

//---------------------------------------------------------------------------
int  wxVtkBaseView::GetDirection()   // virtual 
{
	return -1;
}

//-------------------------------------------------------------------
vtkBaseData *wxVtkBaseView::GetVtkBaseData()
{
   return _vtkbasedata;
}

//-------------------------------------------------------------------
void wxVtkBaseView::SetVtkBaseData(vtkBaseData *vtkbasedata)
{
   _vtkbasedata=vtkbasedata;
}



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------



