/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <creaWx.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <stdlib.h>
#include <iostream> // for std::cout


#include "wxVtkClipping3DView.h"

#include "wxVtkClipping3DViewCntrlPanel.h"
#include "wxVtkClipping3DViewVolCntrlPanel.h"

wxVtkClipping3DView::wxVtkClipping3DView(wxVtk3DBaseView* wxvtk3Dbaseview)
{

	_wxvtk3Dbaseview				=	wxvtk3Dbaseview;
	_vtkclipping3Ddataviewer		=	NULL;
	_wxvtkclipping3DviewCntrlPanel	=	NULL;

	_boxWidgetVolume				=	NULL;
	_boxWidgetS1					=	NULL;
}

//-------------------------------------------------------------------
wxVtkClipping3DView::~wxVtkClipping3DView()
{
	if (_boxWidgetVolume!=NULL)				 { _boxWidgetVolume	-> Delete();			}
	if (_boxWidgetS1!=NULL)					 { _boxWidgetS1		-> Delete();			}
	if (_vtkclipping3Ddataviewer!=NULL)		 { delete _vtkclipping3Ddataviewer;			}
	if (_wxvtkclipping3DviewCntrlPanel!=NULL){ delete _wxvtkclipping3DviewCntrlPanel;	}
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::SetVisibleBoxSurface(bool visible)
{
	if (visible==true)
	{
		_boxWidgetS1->On();
	} else {
		_boxWidgetS1->Off();
	}
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::VisibleVolumeBoxActor(bool visible)
{
	if (visible!=_vtkclipping3Ddataviewer->GetVisibleVolumeBox() )
	{
        VisibleVolumeActor(!visible);
        _vtkclipping3Ddataviewer->BoxActorChanged(visible);
        _vtkclipping3Ddataviewer->SetVisibleVolumeBox(visible);
        _vtkclipping3Ddataviewer->SetVisibleVolume(!visible);
	}
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::Refresh()
{
	_vtkclipping3Ddataviewer->Refresh();
	if (_wxvtkclipping3DviewCntrlPanel!=NULL)
	{
		_wxvtkclipping3DviewCntrlPanel->Refresh();
	}
}

//-------------------------------------------------------------------
wxPanel* wxVtkClipping3DView::CreateSurfControlPanel(wxWindow *parent)
{
	_wxvtkclipping3DviewCntrlPanel = new wxVtkClipping3DViewCntrlPanel(parent,this);
	return _wxvtkclipping3DviewCntrlPanel;
}

//RaC 03-2010 Divide in two panels
//-------------------------------------------------------------------
wxPanel* wxVtkClipping3DView::CreateVolControlPanel(wxWindow *parent)
{
	_wxvtkclipping3DviewVolCntrlPanel = new wxVtkClipping3DViewVolCntrlPanel(parent,this);
	return _wxvtkclipping3DviewVolCntrlPanel;
}

//-------------------------------------------------------------------
vtkClipping3DDataViewer* wxVtkClipping3DView::GetVtkClipping3DDataViewer()
{
	return _vtkclipping3Ddataviewer;
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::VisibleActor(int idTissue, bool visTissue){
	if (visTissue!=_vtkclipping3Ddataviewer->GetVisibleTissue(idTissue)){
		if (visTissue==false){
			_wxvtk3Dbaseview->GetRenderer()->RemoveActor( _vtkclipping3Ddataviewer->GetTissueActor(idTissue)  );
		} else {
			_wxvtk3Dbaseview->GetRenderer()->AddActor( _vtkclipping3Ddataviewer->GetTissueActor(idTissue)  );
//			_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(idTissue) );
//			_actor->VisibilityOn();
		}
		_vtkclipping3Ddataviewer->SetVisibleTissue(idTissue,visTissue);
	}
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::SetRepSurfaceWireFrame(int idTissue , bool representationType )
{
	vtkActor *tmpActor;
	tmpActor = GetVtkClipping3DDataViewer()->GetTissueActor(idTissue);

	if (representationType==false){
		tmpActor->GetProperty()->SetRepresentationToWireframe();
	} else {
		tmpActor->GetProperty()->SetRepresentationToSurface();
	}

	_vtkclipping3Ddataviewer->SetRepresentationType(idTissue,representationType);
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::VisibleVolumeActor( bool visVolume){
	if (visVolume!=_vtkclipping3Ddataviewer->GetVisibleVolume() ){
		if (visVolume==false){
//EED 31/03/2008
//			_wxvtk3Dbaseview->GetRenderer()->RemoveActor( _vtkclipping3Ddataviewer->GetVolumeActor()  );
			_wxvtk3Dbaseview->GetRenderer()->RemoveVolume( _vtkclipping3Ddataviewer->GetVolumeActor()  );
		} else {
//EED 31/03/2008
//			_wxvtk3Dbaseview->GetRenderer()->AddActor( _vtkclipping3Ddataviewer->GetVolumeActor() );
			_wxvtk3Dbaseview->GetRenderer()->AddVolume( _vtkclipping3Ddataviewer->GetVolumeActor() );
		}
		_vtkclipping3Ddataviewer->SetVisibleVolume(visVolume);
	}
	else if(visVolume==false  && _vtkclipping3Ddataviewer->GetVisibleVolumeBox() == true)
	{
	    _vtkclipping3Ddataviewer->BoxActorChanged(false);
        _vtkclipping3Ddataviewer->SetVisibleVolumeBox(false);
	}

}

//-------------------------------------------------------------------
// EED 2022-08-04	throw
//wxVtk3DBaseView* wxVtkClipping3DView::GetWxvtk3Dbaseview()throw(char*)
wxVtk3DBaseView* wxVtkClipping3DView::GetWxvtk3Dbaseview()
{
	try {
		if(_wxvtk3Dbaseview==NULL){
			throw "wxVtk3DBaseView* wxVtkClipping3DView::GetWxvtk3Dbaseview() _wxvtk3Dbaseview=NULL";
		}
		return _wxvtk3Dbaseview;
	} catch (...) {
	  throw ;
	}
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::Configure()
{
	_wxvtk3Dbaseview->Configure();

	// Actors are added to the renderer.

	_boxWidgetS1 = vtkBoxWidget::New();
	_boxWidgetS1->SetInteractor( _wxvtk3Dbaseview->GetWxVTKRenderWindowInteractor() );
	_boxWidgetS1->SetPlaceFactor(1.25);

	vtkStripper *stripper=_vtkclipping3Ddataviewer->GetTissueStripper(0);
	vtkPolyData *polydata= stripper->GetOutput();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_boxWidgetS1->SetInput( polydata );
#else
	stripper->Update();
	_boxWidgetS1->SetInputData( polydata );
#endif

//EED 2016-08-19	
	//_boxWidgetS1->PlaceWidget();
	int ext[6];
	this->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData()->GetExtent(ext);
	_boxWidgetS1->PlaceWidget(ext[0],ext[1],ext[2],ext[3],ext[4],ext[5]);

	int i;
  	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++)
	{
		_boxWidgetS1->AddObserver( vtkCommand::InteractionEvent, _vtkclipping3Ddataviewer->GetObserverS(i) );
	}

//	_wxvtk3Dbaseview->GetRenderer()->AddActor( _vtkclipping3Ddataviewer->GetTissueActor(0) );
//	_wxvtk3Dbaseview->GetRenderer()->AddActor( _vtkclipping3Ddataviewer->GetTissueActor(3));

	VisibleActor(0, false );
	VisibleActor(1, false );
	VisibleActor(2, false );
	VisibleActor(3, false );

	_boxWidgetS1->HandlesOn ();

//EED 29Mars2009
//	_boxWidgetS1->On();
	_boxWidgetS1->Off();

	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(0) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(1) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(2) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(3) );

// EED 9 fev 2007
// box Volume
	_boxWidgetVolume = vtkBoxWidget::New();
	_boxWidgetVolume->SetInteractor( _wxvtk3Dbaseview->GetWxVTKRenderWindowInteractor() );
	_boxWidgetVolume->SetPlaceFactor(1.25);

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_boxWidgetVolume->SetInput( this->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData() );
#else
	_boxWidgetVolume->SetInputData( this->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData() );
#endif

	_boxWidgetVolume->PlaceWidget();
	_boxWidgetVolume->AddObserver( vtkCommand::InteractionEvent, _vtkclipping3Ddataviewer->GetObserverV() );
	_boxWidgetVolume->HandlesOn ();

//EED 29Mars2009
//	_boxWidgetVolume->On();
	_boxWidgetVolume->Off();

//	vtkPlanes *vtkplanes=this->GetVtkClipping3DDataViewer()->GetVolumePlanes();
//	_boxWidgetVolume->GetPlanes( vtkplanes );

//EED 27/05/2013
//  _wxvtk3Dbaseview->GetRenderer()->ResetCamera ();
//  _wxvtk3Dbaseview->GetCamera()->Dolly(1.2);

  // An initial camera view is created.  The Dolly() method moves
  // the camera towards the FocalPoint, thereby enlarging the image.
        _wxvtk3Dbaseview->ResetCamera();


  // Set a background color for the renderer and set the size of the
  // render window (expressed in pixels).
  _wxvtk3Dbaseview->GetRenderer()->SetBackground( 0.36 , 0.36 , 0.36 );
  _wxvtk3Dbaseview->GetRenWin()->SetSize(400, 400);

  // Note that when camera movement occurs (as it does in the Dolly()
  // method), the clipping planes often need adjusting. Clipping planes
  // consist of two planes: near and far along the view direction. The
  // near plane clips out objects in front of the plane; the far plane
  // clips out objects behind the plane. This way only what is drawn
  // between the planes is actually rendered.
//EEDUPS  _wxvtk3Dbaseview->GetRenderer()->ResetCameraClippingRange();

	_vtkclipping3Ddataviewer->SetRenderer(this->GetWxvtk3Dbaseview()->GetRenderer());
	_vtkclipping3Ddataviewer->SetInteractor(this->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor());
}

//-------------------------------------------------------------------
void wxVtkClipping3DView::SetVtkClipping3DDataViewer(vtkClipping3DDataViewer *vtkclipping3Ddataviewer)
{
	_vtkclipping3Ddataviewer = vtkclipping3Ddataviewer;
}

void wxVtkClipping3DView::SetRayCasting(bool active)
{
    _vtkclipping3Ddataviewer->SetRayCasting(active);
    _vtkclipping3Ddataviewer->updateVolume();
}

void wxVtkClipping3DView::SetMIPActive(bool active)
{
    _vtkclipping3Ddataviewer->SetMIPActive(active);
    _vtkclipping3Ddataviewer->updateVolume();
}

void wxVtkClipping3DView::SetInterpolation(bool active)
{
    _vtkclipping3Ddataviewer->SetInterpolation(active);
    _vtkclipping3Ddataviewer->updateVolume();
}

void wxVtkClipping3DView::SetShade(bool active)
{
    _vtkclipping3Ddataviewer->SetShade(active);
    _vtkclipping3Ddataviewer->updateVolume();
}

void wxVtkClipping3DView::UpdateVolumeBox(vector<double> gf, vector<double> vf, vtkColorTransferFunction* ctfun)
{
    _vtkclipping3Ddataviewer->UpdateVolumeBox(gf, vf, ctfun);
}



