/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include <creaWx.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <stdlib.h>
#include <iostream> // for std::cout


#include "wxVtkClipping3DViewCntrlPanel.h"
#include "wx/colordlg.h"
#include "vtkTriangleFilter.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkClosePolyData.h"
#include "vtkSTLWriter.h"
#include "HistogramDialog.h"
#include "marDicomBase.h"

wxVtkClipping3DViewCntrlPanel::wxVtkClipping3DViewCntrlPanel(wxWindow *parent, wxVtkClipping3DView *wxvtkclipping3Dview )
: wxPanel(parent, -1)
{
	wxPanel *panel	= this;
	_wxvtkclipping3Dview	= wxvtkclipping3Dview;

//EEDx2.6
//	wxStaticText	*text1			= new wxStaticText(panel, -1,_T("          "));
//	wxStaticText	*text2			= new wxStaticText(panel, -1,_T("  "));

					_surfA			= new wxRadioButton(panel,-1,_T("A"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP);
					_surfB			= new wxRadioButton(panel,-1,_T("B"));
					_surfC			= new wxRadioButton(panel,-1,_T("C"));
					_surfD			= new wxRadioButton(panel,-1,_T("D"));

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//wxCheckBox		*ckVolum		= new wxCheckBox(panel,-1,_T("Vol"));
	wxCheckBox		*ckBoxSurface	= new wxCheckBox(panel,-1,_T("Surface Box"));

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//wxCheckBox		*ckBoxVolume	= new wxCheckBox(panel,-1,_T("Volume Box"));

					_color			= new wxButton(panel,-1,_T(""));
					_visible		= new wxCheckBox(panel,-1,_T("Vis"));
//EED					_opacity		= new wxSlider(panel,-1,50,0,100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
					_opacity		= new wxSlider(panel,-1,50,0,100, wxDefaultPosition, wxSize(300,110), wxSL_HORIZONTAL | wxSL_LABELS);

	wxStaticText	*isoValueTitle	= new wxStaticText(panel,-1,_T("isoValue"));
//EED					_isoValue		= new wxSlider(panel,-1,2000,110,2000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  |  wxSL_AUTOTICKS | wxSL_LABELS);
					_isoValue		= new wxSlider(panel,-1,2000,110,2000, wxDefaultPosition, wxSize(300,110), wxSL_HORIZONTAL  |  wxSL_AUTOTICKS | wxSL_LABELS);

					_wireFrameRep	= new wxRadioButton(panel,-1,_T("WireFrame"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP);
					_surfaceRep		= new wxRadioButton(panel,-1,_T("Surface"));

	double range[2];
	vtkImageData *vtkimagedata = wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	vtkimagedata->GetScalarRange( range );
//EED 2020-11-25	_isoValue->SetRange( (int)(range[1]*0.1) , (int)(range[1]) );
	_isoValue->SetRange( (int)(range[0]) , (int)(range[1]) );
	_isoValue->SetValue( (int)(wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetIsovalue(0)) );

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	_isoValue->SetTickFreq(25,0);
#else
	// ..
#endif

	_isoValueSpin	= new wxSlider(panel , -1,5,1,10,wxDefaultPosition , wxDefaultSize, wxSL_VERTICAL | wxSL_AUTOTICKS |wxSL_LEFT  );
	_isoValueSpin->SetRange(1,8);
	_isoValueSpin->SetValue(5);
	Connect(_isoValueSpin->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED 	 , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnIsoValueSpin );

	wxButton *btnSTL				= new wxButton(panel,-1,_T("Create STL File"));
	wxButton *btnSaveRaw			= new wxButton(panel,-1,_T("Save Raw Volume"));

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//wxButton *btnVolumeFunctions	= new wxButton(panel,-1,_T("Read Volume Functions"));


	Connect(btnSTL->GetId()				, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnBtnCreateFileSTL 	);
	Connect(btnSaveRaw->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnBtnSaveRawVolume 	);

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//Connect(btnVolumeFunctions->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnBtnVolumeFunctions 	);


	wxButton *btnMeshVTKLoad	= new wxButton(panel,-1,_T("Load Mesh"));
	Connect(btnMeshVTKLoad->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnBtnMeshVTKLoad 	);


/*
	int maxX = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionX();
	int maxY = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionY();
	int maxZ = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionZ();
	wxCheckBox		*ckBoxX			= new wxCheckBox(panel,-1,"X");
					_positionX		= new wxSlider(panel,-1,maxX/2,0,maxX, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	wxCheckBox		*ckBoxY			= new wxCheckBox(panel,-1,"Y");
					_positionY		= new wxSlider(panel,-1,maxY/2,0,maxY, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	wxCheckBox		*ckBoxZ			= new wxCheckBox(panel,-1,"Z");
					_positionZ		= new wxSlider(panel,-1,maxZ/2,0,maxZ, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
*/

//	ckVolum->Enable(false);
	ckBoxSurface->SetValue(false);


	//ckBoxVolume->SetValue(false);


	_color->SetSize(40,20);
	_opacity->SetSize(370,20);
//	ckBoxX->SetValue(true);
//	ckBoxY->SetValue(true);
//	ckBoxZ->SetValue(true);
	_surfA->SetValue(true);
	_wireFrameRep->SetValue(false);
	_surfaceRep->SetValue(true);
	_visible->SetValue(false);
//	_positionX->SetSize(400,20);
//	_positionY->SetSize(400,20);
//	_positionZ->SetSize(400,20);

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//Connect(ckVolum->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnVisibleVolume				);
	//Connect(ckBoxVolume->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnVisibleBoxVolume			);

	Connect(_surfA->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnSurface					);
	Connect(_surfB->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnSurface					);
	Connect(_surfC->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnSurface					);
	Connect(_surfD->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnSurface					);
	Connect(ckBoxSurface->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnVisibleBoxSurface			);

	Connect(_wireFrameRep->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnRepresentationSurfaceWireFrame	);
	Connect(_surfaceRep->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnRepresentationSurfaceWireFrame	);

	Connect(_color->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED		  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnColor						);
	Connect(_visible->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnVisibleSurface			);
	Connect(_opacity->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED		  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnOpacity					);

//EED 27Dic2007
//	Connect(_isoValue->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED		  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnIsoValue					);
	Connect(_isoValue->GetId()		, wxEVT_SCROLL_THUMBRELEASE		  , (wxObjectEventFunction) &wxVtkClipping3DViewCntrlPanel::OnIsoValue						);

/*
	Connect(ckBoxX->GetId()     , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisX	);
	Connect(_positionX->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionX		);
	Connect(ckBoxY->GetId()     , wxEVT_COMMAND_CHECKBOX_CLICKED 	  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisY	);
	Connect(_positionY->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionY		);
	Connect(ckBoxZ->GetId()     , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisZ	);
	Connect(_positionZ->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		  , (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionZ		);
*/

	wxFlexGridSizer *sizer	 = new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerH0 = new wxFlexGridSizer(20);
	wxFlexGridSizer *sizerH1 = new wxFlexGridSizer(20);
	wxFlexGridSizer *sizerH2 = new wxFlexGridSizer(10);
	wxFlexGridSizer *sizerH3 = new wxFlexGridSizer(10);
	//wxFlexGridSizer *sizerH4 = new wxFlexGridSizer(10); // JPRx
	//wxFlexGridSizer *sizerH5 = new wxFlexGridSizer(10); // JPRx
	//wxFlexGridSizer *sizerH6 = new wxFlexGridSizer(10); // JPRx

	//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
	//sizerH0->Add( ckVolum									, 1, wxALL|wxEXPAND, 0);
	//sizerH0->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	//sizerH0->Add( ckBoxVolume								, 1, wxALL|wxEXPAND, 0);
	//sizerH0->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	//sizerH0->Add( btnVolumeFunctions						, 1, wxALL|wxEXPAND, 0);
	//sizerH0->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH0->Add( btnMeshVTKLoad							, 1, wxALL|wxEXPAND, 0);


	sizerH1->Add( _surfA									, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("  "))		, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( _surfB									, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("  "))		, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( _surfC									, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("  "))		, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( _surfD									, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( ckBoxSurface								, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( btnSTL									, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH1->Add( btnSaveRaw								, 1, wxALL|wxEXPAND, 0);


//	sizerH2->Add( new wxStaticText(panel, -1,_T("          ")			, 1, wxALL|wxEXPAND, 0);
	sizerH2->Add( _color				, 1, wxALL|wxEXPAND, 0);
	sizerH2->Add( new wxStaticText(panel, -1,_T("          "))			, 1, wxALL|wxEXPAND, 0);
	sizerH2->Add( _visible				, 1, wxALL|wxEXPAND, 0);
	sizerH2->Add( new wxStaticText(panel, -1,_T("          "))			, 1, wxALL|wxEXPAND, 0);


	sizerH2->Add( _wireFrameRep				, 1,wxSHAPED | wxALIGN_CENTER_VERTICAL , 0);
	sizerH2->Add( new wxStaticText(panel, -1,_T("   "))					, 1, wxALL|wxEXPAND, 0);
	sizerH2->Add( _surfaceRep				, 1,wxSHAPED | wxALIGN_CENTER_VERTICAL , 0);
	sizerH2->Add( new wxStaticText(panel, -1,_T("          "))			, 1, wxALL|wxEXPAND, 0);



	sizerH3->Add( isoValueTitle			, 1, wxALL|wxEXPAND, 0);
	sizerH3->Add( _isoValueSpin			, 1, wxALL|wxEXPAND, 0);
	sizerH3->Add( _isoValue				, 1, wxALL|wxEXPAND, 0);

	sizerH3->Add( new wxStaticText(panel, -1,_T("      "))			, 1, wxALL|wxEXPAND, 0);
	sizerH3->Add( new wxStaticText(panel, -1,_T("Opacity:"))			, 1, wxALL|wxEXPAND, 0);
	sizerH3->Add( _opacity				, 1, wxALL|wxEXPAND, 0);


/*
	sizerH4->Add( ckBoxX		, 1, wxALL|wxEXPAND, 0);
	sizerH4->Add( text2			, 1, wxALL|wxEXPAND, 0);
	sizerH4->Add( _positionX		, 1, wxALL|wxEXPAND, 0);

	sizerH5->Add( ckBoxY		, 1, wxALL|wxEXPAND, 0);
	sizerH5->Add( text2			, 1, wxALL|wxEXPAND, 0);
	sizerH5->Add( _positionY		, 1, wxALL|wxEXPAND, 0);

	sizerH6->Add( ckBoxZ		, 1, wxALL|wxEXPAND, 0);
	sizerH6->Add( text2			, 1, wxALL|wxEXPAND, 0);
	sizerH6->Add( _positionZ		, 1, wxALL|wxEXPAND, 0);
*/
	sizer->Add( sizerH0 , 1, wxALL|wxEXPAND, 2);
	sizer->Add( sizerH1 , 1, wxALL|wxEXPAND, 2);
	sizer->Add( sizerH2 , 1, wxALL|wxEXPAND, 2);
	sizer->Add( sizerH3 , 1, wxALL|wxEXPAND, 2);
//	sizer->Add( sizerH4 , 1, wxALL|wxEXPAND, 2);
//	sizer->Add( sizerH5 , 1, wxALL|wxEXPAND, 2);
//	sizer->Add( sizerH6 , 1, wxALL|wxEXPAND, 2);

	panel->SetSize(300,60);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->Layout();

	panel->SetEventHandler((wxEvtHandler*)this);

}
//-------------------------------------------------------------------
wxVtkClipping3DViewCntrlPanel::~wxVtkClipping3DViewCntrlPanel()
{
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::Refresh()
{
//	wxPanel::Refresh();
/*
	_positionX->SetValue( _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetX( ) );
	_positionY->SetValue( _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetY( ) );
	_positionZ->SetValue( _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetZ( ) );
*/
}
//-------------------------------------------------------------------
int wxVtkClipping3DViewCntrlPanel::GetIdTissue()
{
	int idTissue=-1;
	if (_surfA->GetValue()==true)
	{
		idTissue=0;
	}
	if (_surfB->GetValue()==true)
	{
		idTissue=1;
	}
	if (_surfC->GetValue()==true)
	{
		idTissue=2;
	}
	if (_surfD->GetValue()==true)
	{
		idTissue=3;
	}

	return idTissue;
}
/*
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleAxisX(wxCommandEvent& event)
{
	_wxvtkclipping3Dview->VisibleImageActor(0, event.IsChecked() );
	_wxvtkclipping3Dview->Refresh();
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleAxisY(wxCommandEvent& event)
{
	_wxvtkclipping3Dview->VisibleImageActor(1, event.IsChecked() );
	_wxvtkclipping3Dview->Refresh();
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleAxisZ(wxCommandEvent& event)
{
	_wxvtkclipping3Dview->VisibleImageActor(2, event.IsChecked() );
	_wxvtkclipping3Dview->Refresh();
}
*/

//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnSurface(wxCommandEvent& event)
{
	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
		// Color
		vtkActor *tmpActor;
		tmpActor = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTissueActor(idTissue);
		double rgb[3];
		tmpActor->GetProperty()->GetColor( rgb );
		wxColour colour( (int)(rgb[0]*255) , (int)(rgb[1]*255) , (int)(rgb[2]*255) );
		_color->SetBackgroundColour(colour);

		// Visible
		_visible->SetValue(_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVisibleTissue(idTissue));

		// Opacity
		_opacity->SetValue( (int)(tmpActor->GetProperty()->GetOpacity()*100) );

		// Representation Type  WireFrame / Surface
		_surfaceRep->SetValue(_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetRepresentationType(idTissue));
		_wireFrameRep->SetValue(!_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetRepresentationType(idTissue));

		// isoValue
		int isoValue= (int)(_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetIsovalue(idTissue));
		_isoValue->SetValue(isoValue);
	}
}


//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnRepresentationSurfaceWireFrame(wxCommandEvent& event)
{
	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
		_wxvtkclipping3Dview->SetRepSurfaceWireFrame(idTissue , _surfaceRep->GetValue() );

		_wxvtkclipping3Dview->Refresh();

		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

	} // if idTissue
}

//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleVolume(wxCommandEvent& event)
{
	_wxvtkclipping3Dview->VisibleVolumeActor( event.IsChecked()  );
	_wxvtkclipping3Dview->Refresh();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
	_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleBoxSurface(wxCommandEvent& event)
{
	_wxvtkclipping3Dview->SetVisibleBoxSurface(event.IsChecked() );
	_wxvtkclipping3Dview->Refresh();
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleBoxVolume(wxCommandEvent& event)
{
printf("EED ERROR JPReyes wxVtkClipping3DViewCntrlPanel::OnVisibleBoxVolume  calling 	_wxvtkclipping3Dview->SetVisibleBoxVolume that not exists ...");
//EED01July2011	_wxvtkclipping3Dview->SetVisibleBoxVolume(event.IsChecked() );
	//this->BoundingBoxChanged(event.IsChecked());
	_wxvtkclipping3Dview->Refresh();
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnColor(wxCommandEvent& event)
{
	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
// EED 17 Janvier 2007
		wxColourDialog dlgColour(this);
//		dlgColour.ShowModal();
		if( dlgColour.ShowModal( ) == wxID_OK )
		{
			vtkActor *tmpActor;
			tmpActor    = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTissueActor(idTissue);
			float   r   = dlgColour.GetColourData().GetColour().Red()/255.0;
			float   g   = dlgColour.GetColourData().GetColour().Green()/255.0;
			float   b   = dlgColour.GetColourData().GetColour().Blue()/255.0;
			tmpActor->GetProperty()->SetColor( r , g , b );
			_color->SetBackgroundColour(dlgColour.GetColourData().GetColour());
			_wxvtkclipping3Dview->Refresh();
			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	 		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
	 		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
		} // if ShowModal
	} // if idTissue
}

//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnVisibleSurface(wxCommandEvent& event)
{
	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
		_wxvtkclipping3Dview->VisibleActor(idTissue, _visible->GetValue());
		_wxvtkclipping3Dview->Refresh();
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
	} // if idTissue
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnOpacity(wxScrollEvent& event)
{
	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
		vtkActor *tmpActor;
		tmpActor = _wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTissueActor(idTissue);
		float opacity=_opacity->GetValue();
		tmpActor->GetProperty()->SetOpacity( opacity/100 );
		_wxvtkclipping3Dview->Refresh();
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
	} // if idTissue
}

//----------------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnIsoValueSpin(wxScrollEvent& event)
{
	int value = _isoValue->GetValue();
	int delta= (int)pow( (double)4 ,(double) _isoValueSpin->GetValue() );
	int min=value - delta/2;
	int max=value + delta/2;
	if (min<0)
	{
		min=0;
		max=delta;
	}
	_isoValue->SetRange(min,max);
}


//------------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnIsoValue(wxScrollEvent& event)
{
	wxBusyCursor wait;

	int idTissue=GetIdTissue();
	if (idTissue!=-1)
	{
		int isoValue=_isoValue->GetValue();
		_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->SetIsovalue(idTissue,isoValue);
//		wxString tmpStr;
//		tmpStr.Printf("%d",isoValue);

		_wxvtkclipping3Dview->Refresh();

		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

	} // if idTissue

}
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnBtnCreateFileSTL(wxCommandEvent& event)
{

	int idTissue=GetIdTissue();
	if (idTissue==-1)
	{
		idTissue=0;
	}


	wxString dirSTL = wxGetHomeDir( ) ;
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFileDialog dialog( this, _T("Choose a directory..."), dirSTL , _T(""), _T("*.*"), wxSAVE );
#else
	wxFileDialog dialog( this, _T("Choose a directory..."), dirSTL , _T(""), _T("*.*"), wxFD_SAVE );
#endif

	if( dialog.ShowModal( ) == wxID_OK )
	{


		// ------------------------------------------------------------------------
		//  1.  GENERATE STL FILES
		// ------------------------------------------------------------------------
//		const char* fileprefix = "c:\\Creatis\\";
		std::string prefix = (const char*) (dialog.GetPath().mb_str() );
		std::string filename;

		// 1.1. Se hace un filtro triangular puesto que el stl writer solo recibe poligonos triangulares.

        vtkTriangleFilter *filtro = vtkTriangleFilter::New();


		vtkPolyDataConnectivityFilter *pdcf = vtkPolyDataConnectivityFilter::New();
        vtkClosePolyData *cpd = vtkClosePolyData::New();


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		filtro->SetInput( this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTissueClipper(idTissue)->GetOutput() );
        pdcf->SetInput( filtro->GetOutput() );
        cpd->SetInput( pdcf->GetOutput() );
#else
		filtro->SetInputConnection( this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTissueClipper(idTissue)->GetOutputPort() );
        pdcf->SetInputConnection( filtro->GetOutputPort() );
        cpd->SetInputConnection( pdcf->GetOutputPort() );
#endif

		// 1.2 Write the stl file
        cpd->Update();
        vtkSTLWriter *writer = vtkSTLWriter::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        writer->SetInput( cpd->GetOutput() );
#else
        writer->SetInputConnection( cpd->GetOutputPort() );
#endif

        writer->SetFileName(filename.c_str());
        writer->SetFileTypeToASCII();
        writer->Write();
        writer->Delete();

        filtro->Delete();
        cpd->Delete();
        pdcf->Delete();
	}

}

//EED 30 Janvier 2007
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnBtnSaveRawVolume(wxCommandEvent& event)
{
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFileDialog dialog(this, _T("Choose a file"), _T(""), _T(""), _T("*.maracas"), wxSAVE );
#else
	wxFileDialog dialog(this, _T("Choose a file"), _T(""), _T(""), _T("*.maracas"), wxFD_SAVE );
#endif
	if (dialog.ShowModal() == wxID_OK)
	{
		std::string directory = (const char*) (dialog.GetDirectory().mb_str() );
		std::string filename  = (const char*) (dialog.GetFilename().mb_str() );
		float rescalaSlope           =  1;
		float rescalaIntercept       =  0;
		vtkMPRBaseData *vtkmprbasedata = this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData();
		vtkImageData *vtkimagedata	 = vtkmprbasedata->GetImageData();
		int dim[3];
		vtkimagedata->GetDimensions(dim);
		int voi[6];
		voi[0]=0;
		voi[1]=dim[0];
		voi[2]=0;
		voi[3]=dim[1];
		voi[4]=0;
		voi[5]=dim[2];
//EED 10 oct 2007 MaracasVisu pour bbMaracasvisu
		marRAW2Files marraw2;
		marraw2.saveVolume(directory,filename,vtkimagedata,voi,rescalaSlope,rescalaIntercept);
	}
}

//EED 22 Fevrier 2007
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnBtnVolumeFunctions(wxCommandEvent& event)
{

	int /*i=0,*/ xi,yi,r,g,b;  // JPRx
	vtkColorTransferFunction* ctfun	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetColorTransferenceFunction();
	vtkPiecewiseFunction* tfun   	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTransferencefunction();
	std::vector<double>* gtf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreyValuesTransferenceFVector();
	std::vector<double>* itf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetIntensityValuesTransferenceFVector();
	std::vector<double>* greyctf	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreyValueColorsOfColorTransferenceFVector();
	std::vector<double>* rctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetRedColorsOfColorTransferenceFVector();
	std::vector<double>* gctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreenColorsOfColorTransferenceFVector();
	std::vector<double>* bctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetBlueColorsOfColorTransferenceFVector();
	vtkImageData *imagedata	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData();

	//use for update in the refresh
	/*
	vtkVolumeRayCastMapper* volumeMapper = this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVolumeMapper();
	vtkVolume* newvol	=this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVolumeActor();
	*/

	/*
	MMLR BORRAME
	wxFileDialog dialog(this, _T("Choose a file"), _T("c:/Maracas_configuration"),_T(""), _T("*.MarVolConf"), wxOPEN);
	if (dialog.ShowModal() == wxID_OK)
	{
		_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions( (char *)dialog.GetPath().c_str() );


	}
	*/

	HistogramDialog* hDlg=new HistogramDialog(NULL,_T("Histogram Dialog"),imagedata,1);
	//
	// put in a method
	//
	int tfSize=gtf->size();
		if(tfSize>0)
		{
			int i=0;
			hDlg->erasePointsTransferenceFunction();
			while(i<tfSize)
			{
				double g=(*gtf)[i];
				double in=(*itf)[i];
				hDlg->addPointToTransferenceFunction(g,in*100);
				i++;
			}

		}

	int ctfSize=rctf->size();
	if(ctfSize>0)
	{
		int i=0;
			while(i<ctfSize)
			{
				double gr=(*greyctf)[i];
				double r=(*rctf)[i];
				double g=(*gctf)[i];
				double b=(*bctf)[i];
				hDlg->addColorPoint(gr,(int)(r*255),(int)(g*255),(int)(b*255));
				i++;
			}
	}
	//setting variables if the user wants to do refresh
	hDlg->setCTF(ctfun);
	hDlg->setTF(tfun);
	//hDlg->setClipping3DView(_wxvtkclipping3Dview);
	/*
	hDlg->setVolume(newvol);
	hDlg->setVolumeMapper(volumeMapper);
	*/
	//
	// when the user had changed the transference Function
	//
	if(hDlg->ShowModal()== wxID_OK )
	{
			// -- vtkPiecewiseFunction --
			tfun->RemoveAllPoints();
			gtf->clear();
			itf->clear();

			int nTFPoints=hDlg->getSizeTransferenceFunction();
			int i=0;
			while(i<nTFPoints)
			{
				hDlg->getTransferenceFunctionPoint(i,xi,yi);
				tfun->AddPoint( xi , yi/100.0 );
				gtf->push_back(xi);
				itf->push_back(yi/100.0);
				i++;
			}
			// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();
			//clean colors
			rctf->clear();
			gctf->clear();
			bctf->clear();
			greyctf->clear();

			int nCTFpoints=hDlg->getSizeBarColor();
			i=0;
			while(i<nCTFpoints)
			{
				hDlg->getDataBarColorPoint(i,xi,r,g,b);
				ctfun->AddRGBPoint(xi,r/255.0,g/255.0,b/255.0 );
				rctf->push_back(r/255.0);
				gctf->push_back(g/255.0);
				bctf->push_back(b/255.0);
				greyctf->push_back(xi);
				i++;
			}
			//---------------------------------
			// Refreshing and sending the event
			//---------------------------------
			//_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions();
			_wxvtkclipping3Dview->Refresh();
			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif



			/*
			volumeMapper->Update();
			newvol->Update();
			*/
	} else	{
		if(hDlg->getRefreshed())
		{
			int i=0,size;
			//--Transference Function----
			tfun->RemoveAllPoints();
			i=0;
			size=gtf->size();
			for(i=0;i<size;i++)
			{
				double grey1=(*gtf)[i];
				double  in2=(*itf)[i];
				tfun->AddPoint( grey1 , in2 );
			}

			// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();

			i=0;
			size=greyctf->size();
			for(i=0;i<size;i++)
			{
				double grey2	= (*greyctf)[i];
				double red 	= (*rctf)[i];
				double green 	= (*gctf)[i];
				double blue 	= (*bctf)[i];
				ctfun->AddRGBPoint(grey2,red,green,blue);
			}

			//---------------------------------
			// Refreshing and sending the event
			//---------------------------------
			//_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions();
			_wxvtkclipping3Dview->Refresh();
			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

			/*
			volumeMapper->Update();
			newvol->Update();
			*/
		 }

	}
	//destroy the dialog
	hDlg->Destroy();
}

//EED 23 Mai 2007
//-------------------------------------------------------------------
void wxVtkClipping3DViewCntrlPanel::OnBtnMeshVTKLoad(wxCommandEvent& event)
{
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFileDialog dialog(this, _T("Choose a file"), _T("c:/Maracas_configuration"),_T(""), _T("*.vtk"), wxOPEN);
	if (dialog.ShowModal() == wxID_OK)
	{
		_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadMeshVTK( (char *)dialog.GetPath().c_str() );
		_wxvtkclipping3Dview->Refresh();
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
	} // if
#else
	wxFileDialog dialog(this, _T("Choose a file"), _T("c:/Maracas_configuration"),_T(""), _T("*.vtk"), wxFD_OPEN);
	if (dialog.ShowModal() == wxID_OK)
	{
		_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadMeshVTK( dialog.GetPath().char_str() );
		_wxvtkclipping3Dview->Refresh();
		wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
		_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);

	} // if
#endif

}

