/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WXVTKCLIPPING3DVIEWCNTRLPANEL_H_
#define WXVTKCLIPPING3DVIEWCNTRLPANEL_H_

#include "wxVtkClipping3DView.h"
#include "volumerendererdata.h"
#include "wx/wx.h"

class wxVtkClipping3DViewCntrlPanel: public wxPanel
	//, VolumeRendererData
{
public:
	wxVtkClipping3DViewCntrlPanel(wxWindow *parent, wxVtkClipping3DView *_wxvtkclipping3Dview);
	~wxVtkClipping3DViewCntrlPanel();
			void	OnSurface(wxCommandEvent& event);
			void	OnRepresentationSurfaceWireFrame(wxCommandEvent& event);
			void	OnVisibleVolume(wxCommandEvent& event);
			void	OnVisibleBoxSurface(wxCommandEvent& event);
			void	OnVisibleBoxVolume(wxCommandEvent& event);
			void	OnColor(wxCommandEvent& event);
			void	OnVisibleSurface(wxCommandEvent& event);
			void	OnOpacity(wxScrollEvent& event);
			void	OnIsoValue(wxScrollEvent& event);
			void	OnIsoValueSpin(wxScrollEvent& event);
	virtual void	Refresh();
			void	OnBtnCreateFileSTL(wxCommandEvent& event);
			void	OnBtnSaveRawVolume(wxCommandEvent& event);
			void	OnBtnVolumeFunctions(wxCommandEvent& event);
			void	OnBtnMeshVTKLoad(wxCommandEvent& event);


private:
	wxVtkClipping3DView	*_wxvtkclipping3Dview;
	wxSlider			*_opacity;
	wxSlider			*_isoValue;
	wxSlider			*_isoValueSpin;
	wxRadioButton		*_surfA;
	wxRadioButton		*_surfB;
	wxRadioButton		*_surfC;
	wxRadioButton		*_surfD;
	wxCheckBox			*_visible;
	wxButton			*_color;

	wxRadioButton		*_wireFrameRep;
	wxRadioButton		*_surfaceRep;

	int				GetIdTissue();
protected:

};

#endif /*WXVTKCLIPPING3DVIEWCNTRLPANEL_H_*/
