/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//-------------------------------------------------------------------
//RaC 03-2010 Divides in two panels thje last tab Surface/Volume
//-------------------------------------------------------------------

#include <creaWx.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <stdlib.h>
#include <iostream> // for std::cout

#include "wxVtkClipping3DViewVolCntrlPanel.h"
#include "wx/colordlg.h"
#include "vtkTriangleFilter.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkClosePolyData.h"
#include "vtkSTLWriter.h"
#include "HistogramDialog.h"
#include "marDicomBase.h"

wxVtkClipping3DViewVolCntrlPanel::wxVtkClipping3DViewVolCntrlPanel(wxWindow *parent, wxVtkClipping3DView *wxvtkclipping3Dview )
: wxPanel(parent, -1)
{
	wxPanel *panel	= this;
	_wxvtkclipping3Dview	= wxvtkclipping3Dview;


	ckVolum		= new wxCheckBox(panel,-1,_T("Volume"));
	ckBoxVolume	= new wxCheckBox(panel,-1,_T("Volume Box"));

	ckBoxVolume->Disable();

	rbRayCasting   = new wxRadioButton(panel, -1, _T("Ray Casting"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP);
    rbMIP   = new wxRadioButton(panel, -1, _T("MIP"));

    ckInterpolation = new wxCheckBox(panel, -1, _T("Interpolation"));
    ckShade = new wxCheckBox(panel, -1, _T("Shade"));

    rbRayCasting->Disable();

    rbMIP->Disable();
    ckInterpolation->Disable();
    ckShade->Disable();


	wxButton *btnVolumeFunctions	= new wxButton(panel,-1,_T("Read Volume Functions"));

	Connect(btnVolumeFunctions->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnBtnVolumeFunctions 	);

	ckBoxVolume->SetValue(false);

	Connect(ckVolum->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnVisibleVolume				);
	Connect(ckBoxVolume->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnVisibleBoxVolume			);

	Connect(rbRayCasting->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnRayCastingActive			);
	Connect(rbMIP->GetId()      	, wxEVT_COMMAND_RADIOBUTTON_SELECTED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnMIPActive		        	);

    Connect(ckInterpolation->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnInterpolationActive		);
	Connect(ckShade->GetId()      	, wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxVtkClipping3DViewVolCntrlPanel::OnShadeActive        		);



	wxFlexGridSizer *sizer	 = new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerH0 = new wxFlexGridSizer(20);
	wxFlexGridSizer *sizerH1 = new wxFlexGridSizer(20);
	wxFlexGridSizer *sizerH2 = new wxFlexGridSizer(20);

	sizerH0->Add( ckVolum									, 1, wxALL|wxEXPAND, 0);
	sizerH0->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH0->Add( ckBoxVolume								, 1, wxALL|wxEXPAND, 0);
	sizerH0->Add( new wxStaticText(panel, -1,_T("          "))	, 1, wxALL|wxEXPAND, 0);
	sizerH0->Add( btnVolumeFunctions						, 1, wxALL|wxEXPAND, 0);

    sizerH1->Add(rbRayCasting, 1, wxALL|wxEXPAND, 0 );
    sizerH1->Add(rbMIP, 1, wxALL|wxEXPAND, 0 );

    sizerH2->Add(ckInterpolation, 1, wxALL|wxEXPAND, 0 );
    sizerH2->Add(ckShade, 1, wxALL|wxEXPAND, 0 );

	sizer->Add( sizerH0 , 1, wxALL|wxEXPAND, 2);
    sizer->Add( sizerH1 , 1, wxALL|wxEXPAND, 2);
    sizer->Add( sizerH2 , 1, wxALL|wxEXPAND, 2);

	panel->SetSize(300,60);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->Layout();

	panel->SetEventHandler((wxEvtHandler*)this);

	rbRayCasting->SetValue(true);

//	_volumerendererdata = VolumeRendererData::New();
//	_volumerendererdata->SetImageData(_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData());

}
//-------------------------------------------------------------------
wxVtkClipping3DViewVolCntrlPanel::~wxVtkClipping3DViewVolCntrlPanel()
{
}
//-------------------------------------------------------------------
void wxVtkClipping3DViewVolCntrlPanel::Refresh()
{
}

//-------------------------------------------------------------------
void wxVtkClipping3DViewVolCntrlPanel::OnVisibleVolume(wxCommandEvent& event)
{



    if(event.IsChecked())
    {
        ckBoxVolume->Enable();
    }
    else{
        ckBoxVolume->Disable();
    }

  //  _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetRenderer()->RemoveAllViewProps();



        _wxvtkclipping3Dview->VisibleVolumeActor( event.IsChecked()  );
        if(event.IsChecked())
        {
            rbRayCasting->Enable();
            rbMIP->Enable();
            ckInterpolation->Enable();
            ckShade->Enable();
        }
        else
        {
            rbRayCasting->Disable();
            rbMIP->Disable();
            ckInterpolation->Disable();
            ckShade->Disable();
            if(ckBoxVolume->IsChecked())
            {
               ckBoxVolume->SetValue(false);
            }
        }

	_wxvtkclipping3Dview->Refresh();


	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
	_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkClipping3DViewVolCntrlPanel::OnVisibleBoxVolume(wxCommandEvent& event)
{

  //cout<<"JPRG::wxVtkClipping3DViewVolCntrlPanel::OnVisibleVolume::event_value::"<<event.IsChecked()<<endl;


    if(event.IsChecked())
    {
           // rbRayCasting->Disable();
           // rbMIP->Disable();
            ckInterpolation->Disable();
            ckShade->Disable();
    }
    else
    {
            //rbRayCasting->Enable();
            //rbMIP->Enable();
            ckInterpolation->Enable();
            ckShade->Enable();

    }

    _wxvtkclipping3Dview->VisibleVolumeBoxActor(event.IsChecked());

    _wxvtkclipping3Dview->Refresh();
    wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif

}

//EED 22 Fevrier 2007
//-------------------------------------------------------------------
void wxVtkClipping3DViewVolCntrlPanel::OnBtnVolumeFunctions(wxCommandEvent& event)
{

	int /*i=0,*/ xi,yi,r,g,b;  // JPRx
	vtkColorTransferFunction* ctfun	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetColorTransferenceFunction();
	vtkPiecewiseFunction* tfun   	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetTransferencefunction();
	std::vector<double>* gtf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreyValuesTransferenceFVector();
	std::vector<double>* itf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetIntensityValuesTransferenceFVector();
	std::vector<double>* greyctf	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreyValueColorsOfColorTransferenceFVector();
	std::vector<double>* rctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetRedColorsOfColorTransferenceFVector();
	std::vector<double>* gctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetGreenColorsOfColorTransferenceFVector();
	std::vector<double>* bctf		= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetBlueColorsOfColorTransferenceFVector();
	vtkImageData *imagedata	= this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVtkMPRBaseData()->GetImageData();

	//use for update in the refresh
	/*
	vtkVolumeRayCastMapper* volumeMapper = this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVolumeMapper();
	vtkVolume* newvol	=this->_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->GetVolumeActor();
	*/

	/*
	MMLR BORRAME
	wxFileDialog dialog(this, _T("Choose a file"), _T("c:/Maracas_configuration"),_T(""), _T("*.MarVolConf"), wxOPEN);
	if (dialog.ShowModal() == wxID_OK)
	{
		_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions( (char *)dialog.GetPath().c_str() );


	}
	*/

	HistogramDialog* hDlg=new HistogramDialog(NULL,_T("Histogram Dialog"),imagedata,1);
	//
	// put in a method
	//
	int tfSize=gtf->size();
		if(tfSize>0)
		{
			int i=0;
			hDlg->erasePointsTransferenceFunction();
			while(i<tfSize)
			{
				double g=(*gtf)[i];
				double in=(*itf)[i];
				hDlg->addPointToTransferenceFunction(g,in*100);
				i++;
			}

		}

	int ctfSize=rctf->size();
	if(ctfSize>0)
	{
		int i=0;
			while(i<ctfSize)
			{
				double gr=(*greyctf)[i];
				double r=(*rctf)[i];
				double g=(*gctf)[i];
				double b=(*bctf)[i];
				hDlg->addColorPoint(gr,(int)(r*255),(int)(g*255),(int)(b*255));
				i++;
			}
	}
	//setting variables if the user wants to do refresh
	hDlg->setCTF(ctfun);
	hDlg->setTF(tfun);
	//hDlg->setClipping3DView(_wxvtkclipping3Dview);
	/*
	hDlg->setVolume(newvol);
	hDlg->setVolumeMapper(volumeMapper);
	*/
	//
	// when the user had changed the transference Function
	//
	if(hDlg->ShowModal()== wxID_OK )
	{
			// -- vtkPiecewiseFunction --
			tfun->RemoveAllPoints();
			gtf->clear();
			itf->clear();

			int nTFPoints=hDlg->getSizeTransferenceFunction();
			int i=0;
			while(i<nTFPoints)
			{
				hDlg->getTransferenceFunctionPoint(i,xi,yi);
				tfun->AddPoint( xi , yi/100.0 );
				gtf->push_back(xi);
				itf->push_back(yi/100.0);
				i++;
			}
			// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();
			//clean colors
			rctf->clear();
			gctf->clear();
			bctf->clear();
			greyctf->clear();

			int nCTFpoints=hDlg->getSizeBarColor();
			i=0;
			while(i<nCTFpoints)
			{
				hDlg->getDataBarColorPoint(i,xi,r,g,b);
				ctfun->AddRGBPoint(xi,r/255.0,g/255.0,b/255.0 );
				rctf->push_back(r/255.0);
				gctf->push_back(g/255.0);
				bctf->push_back(b/255.0);
				greyctf->push_back(xi);
				i++;
			}
			//---------------------------------
			// Refreshing and sending the event
			//---------------------------------
			//_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions();

			//test


         //   _volumerendererdata->OpacityChanged(*gtf, *itf);
            _wxvtkclipping3Dview->UpdateVolumeBox(*gtf, *itf, ctfun);

//test end

			_wxvtkclipping3Dview->Refresh();
			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
			/*
			volumeMapper->Update();
			newvol->Update();
			*/
	} else	{
		if(hDlg->getRefreshed())
		{
			int i=0,size;
			//--Transference Function----
			tfun->RemoveAllPoints();
			i=0;
			size=gtf->size();
			for(i=0;i<size;i++)
			{
				double grey1=(*gtf)[i];
				double  in2=(*itf)[i];
				tfun->AddPoint( grey1 , in2 );
			}

			// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();

			i=0;
			size=greyctf->size();
			for(i=0;i<size;i++)
			{
				double grey2=(*greyctf)[i];
				double red =(*rctf)[i];
				double green =(*gctf)[i];
				double blue = (*bctf)[i];
				ctfun->AddRGBPoint(grey2,red,green,blue);
			}

			//---------------------------------
			// Refreshing and sending the event
			//---------------------------------
			//_wxvtkclipping3Dview->GetVtkClipping3DDataViewer()->ReadVolumeFunctions();

			wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
			_wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
	     	_wxvtkclipping3Dview->Refresh();

			/*
			volumeMapper->Update();
			newvol->Update();
			*/
		 }

	}
	//destroy the dialog

	hDlg->Destroy();
}

void wxVtkClipping3DViewVolCntrlPanel::OnRayCastingActive(wxCommandEvent& event)
{
    //If Ray Casting is active, others options are disabled. Only RayCasting is true
    _wxvtkclipping3Dview->SetRayCasting(true);
    _wxvtkclipping3Dview->SetMIPActive(false);
    wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
    _wxvtkclipping3Dview->Refresh();
}

void wxVtkClipping3DViewVolCntrlPanel::OnMIPActive(wxCommandEvent& event)
{
    //If MIP is active, others options are disabled. Only MIP is true
    _wxvtkclipping3Dview->SetMIPActive(true);
    _wxvtkclipping3Dview->SetRayCasting(false);
    wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
    _wxvtkclipping3Dview->Refresh();
}


void wxVtkClipping3DViewVolCntrlPanel::OnInterpolationActive(wxCommandEvent& event)
{
    _wxvtkclipping3Dview->SetInterpolation(event.IsChecked());
    wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
    _wxvtkclipping3Dview->Refresh();
}

void wxVtkClipping3DViewVolCntrlPanel::OnShadeActive(wxCommandEvent& event)
{
    _wxvtkclipping3Dview->SetShade(event.IsChecked());
    wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
    _wxvtkclipping3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
    _wxvtkclipping3Dview->Refresh();
}

