/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxVtkMPR2DView.h"

#include "vtkInteractorStyleBaseView.h"

#include "vtkCellArray.h"
#include "vtkImageActor.h"

#ifdef WIN32
#include <mathdefs.h>
using namespace gtm;
#endif

wxVtkMPR2DView::wxVtkMPR2DView( wxWindow *parent, int direction, bool TDxWindow)
 :wxVtk2DBaseView(parent, TDxWindow)
{
	_backX			= -99999;
	_backY			= -99999;
	_backZ			= -99999;
	_direction		= direction;
	_ptsA			= NULL;
	_lineAActor		= NULL;
	_lineAMapper	= NULL;
	_pdA			= NULL;
	_ptsB			= NULL;
	_lineBActor		= NULL;
	_lineBMapper	= NULL;
	_pdB			= NULL;
	_interactorstylemprview = NULL;
}

//-------------------------------------------------------------------
wxVtkMPR2DView::~wxVtkMPR2DView()
{
	if (_ptsA!=NULL) 	    { _ptsA->Delete(); 			}
	if (_lineAActor!=NULL) 	{ _lineAActor->Delete(); 	}
	if (_lineAMapper!=NULL) { _lineAMapper->Delete(); 	}
	if (_pdA!=NULL) 	    { _pdA->Delete(); 			}
	if (_ptsB!=NULL) 	    { _ptsB->Delete(); 			}
	if (_lineBActor!=NULL) 	{ _lineBActor->Delete(); 	}
	if (_lineBMapper!=NULL) { _lineBMapper->Delete(); 	}
	if (_pdB!=NULL) 	    { _pdB->Delete(); 			}
}
//-------------------------------------------------------------------
vtkMPRBaseData *wxVtkMPR2DView::GetVtkmprbasedata()
{
	return (vtkMPRBaseData*)GetVtkBaseData();
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::Configure()
{
	wxVtk2DBaseView::Configure();
	int x1,x2,y1,y2,z1,z2;
	GetVtkmprbasedata()	-> GetDimensionExtention(&x1,&x2,&y1,&y2,&z1,&z2);
	double spc[3];
	vtkImageData* img =  GetVtkmprbasedata()->GetImageData();
	if(_interactorstylemprview==NULL)
	{
		_interactorstylemprview = new vtkInteractorStyleMPRView();
		((vtkInteractorStyleBaseView*)GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _interactorstylemprview );
	}

	if(img!=NULL)
	{
		double* origin = img->GetOrigin();
		img->GetExtent(x1,x2,y1,y2,z1,z2);
		img->GetSpacing(spc);
		x1 += origin[0];
		x2 += origin[0];
		y1 += origin[1];
		y2 += origin[1];
		z1 += origin[2];
		z2 += origin[2];
		x1 = (int)(x1*spc[0]);
		y1 = (int)(y1*spc[1]);
		z1 = (int)(z1*spc[2]);
		x2 = (int)(x2*spc[0]);
		y2 = (int)(y2*spc[1]);
		z2 = (int)(z2*spc[2]);
		_visibleAxis = true;
	}

	// Axe A
	if(_lineAActor==NULL){
		_lineAActor = vtkActor::New();
		_lineAActor->GetProperty()->SetDiffuseColor(1,0,0);
		_lineAActor->GetProperty()->SetLineWidth(0.5);

		_ptsA = vtkPoints::New();
		_ptsA->SetNumberOfPoints(2);
		_ptsA->SetPoint(0, -1000	, -1000	, -1000 );
		_ptsA->SetPoint(1,  1000	,  1000	,  1000	);
		_pdA = vtkPolyData::New();
		_lineAMapper = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_lineAMapper->SetInput(_pdA);
		_lineAMapper->ImmediateModeRenderingOn();
#else
		_lineAMapper->SetInputData(_pdA);
#endif

		_lineAActor->SetMapper(_lineAMapper);
	}

	vtkCellArray *linesA = vtkCellArray::New();
	linesA->InsertNextCell(2);
	linesA->InsertCellPoint(0);
	linesA->InsertCellPoint(1);
	_pdA->SetPoints( _ptsA );
	_pdA->SetLines( linesA );
	linesA->Delete();  //do not delete lines ??
//		_lineAActor->GetProperty()->BackfaceCullingOn();


// Axe B
	if(_lineBActor==NULL)
	{
		_lineBActor						=	vtkActor::New();
		_lineBActor->GetProperty()->SetDiffuseColor(1,0,0);
		_lineBActor->GetProperty()->SetLineWidth(0.5);
		_lineBMapper					=	vtkPolyDataMapper::New();
		_lineBActor->SetMapper(_lineBMapper);
		_ptsB = vtkPoints::New();
		_ptsB->SetNumberOfPoints(2);
		_ptsB->SetPoint(0, -1000	, -1000	, -1000 );
		_ptsB->SetPoint(1,  1000	,  1000	,  1000	);
//		_lineBActor->GetProperty()->BackfaceCullingOn();
	}

	vtkCellArray *linesB;
	linesB = vtkCellArray::New();
	linesB->InsertNextCell(2);
	linesB->InsertCellPoint(0);
	linesB->InsertCellPoint(1);
	_pdB = vtkPolyData::New();
	_pdB->SetPoints( _ptsB );
	_pdB->SetLines( linesB );
	linesB->Delete();  //do not delete lines ??

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_lineBMapper->SetInput(_pdB);
	_lineBMapper->ImmediateModeRenderingOn();
#else
	_lineBMapper->SetInputData(_pdB);
#endif

	if(_imageViewer2XYZ)
	{
		_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineAActor );
		_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineBActor );
		vtkCamera *camera =_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->GetActiveCamera();

	//EED 17Avril2009
    //EED 21 mars 2012  FLIP problem  ..PLOP..

		if (_direction==0) 
		{  // YZ
			camera->SetViewUp		(   0	,    0		,     1		);
			camera->SetPosition		( 10000,(y1+y2)/2	, (z1+z2)/2	);
			camera->SetFocalPoint	(   0	, (y1+y2)/2	, (z1+z2)/2	);
			camera->SetParallelScale( (z2-z1)/3.0 );
		}
		if (_direction==1) 
		{ // XZ
			camera->SetViewUp		(	0		,	0	,	1		);
			camera->SetPosition		((x1+x2)/2	, -10000	, (z1+z2)/2	);
			camera->SetFocalPoint	((x1+x2)/2	,   0	, (z1+z2)/2	);
			camera->SetParallelScale( (x2-x1)/3.0 );
		}
		if (_direction==2) 
		{  // XY
			camera->SetViewUp		(	0		,	-1		,	0	);
			camera->SetPosition		((x1+x2)/2	, (y1+y2)/2	, -10000);
			camera->SetFocalPoint	((x1+x2)/2	, (y1+y2)/2	,	0	);
			camera->SetParallelScale( (x2-x1)/3.0 );
		}

/*
		if (_direction==0) {	// YZ
			camera->SetViewUp		(   0	,     1		,     0		);
			camera->SetPosition		(  10000,(y1+y2)/2	, (z1+z2)/2	);
			camera->SetFocalPoint	(   0	, (y1+y2)/2	, (z1+z2)/2	);
			camera->SetParallelScale( (z2-z1)/3.0 );
		}

		if (_direction==1) {	// XZ
			camera->SetViewUp		(	0		,	0	,	-1		);
			camera->SetPosition		((x1+x2)/2	, 10000	, (z1+z2)/2	);
			camera->SetFocalPoint	((x1+x2)/2	,   0	, (z1+z2)/2	);
			camera->SetParallelScale( (x2-x1)/3.0 );
		}

		if (_direction==2) {	// XY
			camera->SetViewUp		(	0		,	1		,	0	);
			camera->SetPosition		((x1+x2)/2	, (y1+y2)/2	,  10000);
			camera->SetFocalPoint	((x1+x2)/2	, (y1+y2)/2	,	0	);
			camera->SetParallelScale( (x2-x1)/3.0 );
		}
*/

	//	_imageViewer2XYZ->GetVtkImageViewer2()->SetColorWindow (160);
	//	_imageViewer2XYZ->GetVtkImageViewer2()->SetColorLevel (800);
	}
}

void wxVtkMPR2DView::SetVisibleAxis(bool ok)
{
	if (ok != _visibleAxis)
	{
		_visibleAxis = ok;
		if (_visibleAxis==true)
		{
			_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineAActor );
			_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineBActor );
		}
		if (_visibleAxis==false)
		{
			_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->RemoveActor( _lineAActor );
			_imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->RemoveActor( _lineBActor );
		} // if visible
	} // ok
}


//-------------------------------------------------------------------
void wxVtkMPR2DView::ResetBackXYZ()
{
	_backX = -9999;
	_backY = -9999;
	_backZ = -9999;
}


//-------------------------------------------------------------------
void wxVtkMPR2DView::Refresh()
{
	//wxVtk2DBaseView::Refresh();
	int x1 = 0,x2 = 0,y1 = 0,y2 = 0,z1 = 0,z2 = 0;
//EED 02/08/2013
//	int x = 0, y = 0, z = 0;
	double 	x  = 0, y  = 0, z  = 0;
	int 	xx = 0, yy = 0, zz = 0;
	double *spc     = 0;
	double *origin  = 0;
	double xx1,yy1,zz1,xx2,yy2,zz2;
	bool   fixAxis2D;
	double opacityAxis;
	vtkImageData* img = GetVtkmprbasedata()->GetImageData();
	if(img!=NULL)
 	{
		origin = img->GetOrigin();
		img->GetExtent(x1,x2,y1,y2,z1,z2);
		spc = img->GetSpacing();
		x1 += origin[0];
		x2 += origin[0];
		y1 += origin[1];
		y2 += origin[1];
		z1 += origin[2];
		z2 += origin[2];
		xx1 = x1*spc[0];
		yy1 = y1*spc[1];
		zz1 = z1*spc[2];
		xx2 = x2*spc[0];
		yy2 = y2*spc[1];
		zz2 = z2*spc[2];
		x1 	= (int)(x1*spc[0]);
		y1 	= (int)(y1*spc[1]);
		z1	= (int)(z1*spc[2]);
		x2	= (int)(x2*spc[0]);
		y2	= (int)(y2*spc[1]);
		z2	= (int)(z2*spc[2]);
		xx 	= (int)(GetVtkmprbasedata()->GetX());
		yy 	= (int)(GetVtkmprbasedata()->GetY());
		zz 	= (int)(GetVtkmprbasedata()->GetZ());
		x 	=  xx*spc[0];
		y 	=  yy*spc[1];
		z 	=  zz*spc[2];
		fixAxis2D		= GetVtkmprbasedata()->GetFixAxis2D();
		opacityAxis		= GetVtkmprbasedata()->GetOpacityAxis();
		if ((xx!=_backX) || (yy!=_backY) || (zz!=_backZ)  || (fixAxis2D!=_backFixAxis2D) || (opacityAxis!=_backOpacityAxis)) 
		{
			double position[3];
			double focalpoint[3];
			GetRenderer()->GetActiveCamera()->GetPosition(position);
			GetRenderer()->GetActiveCamera()->GetFocalPoint(focalpoint);
			if (_direction==0) {	// YZ
				if(_imageViewer2XYZ)
				{
					_imageViewer2XYZ->SetXSlice( (int)(GetVtkmprbasedata()->GetX()) );
				}
//EED 21 mars 2012  FLIP probleme  ..PLOP..
				//_ptsA->SetPoint(0, x2, y1  , z );
				//_ptsA->SetPoint(1, x2, y2  , z );
				//_ptsB->SetPoint(0, x2, y   , z1);
				//_ptsB->SetPoint(1, x2, y   , z2);
				_ptsA->SetPoint(0, xx2+1, yy1  , z  );
				_ptsA->SetPoint(1, xx2+1, yy2  , z  );
				_ptsB->SetPoint(0, xx2+1, y    , zz1);
				_ptsB->SetPoint(1, xx2+1, y    , zz2);
				position[1]		= y;	
				position[2]		= z;	
				focalpoint[1]	= y;	
				focalpoint[2]	= z;	
			}
			if (_direction==1) {	// XZ
				if(_imageViewer2XYZ)
				{
					_imageViewer2XYZ->SetYSlice( (int)(GetVtkmprbasedata()->GetY()) );
				}
//EED 21 mars 2012  FLIP probleme  ..PLOP..
			    //_ptsA->SetPoint(0, x1 , y2 , z );
				//_ptsA->SetPoint(1, x2 , y2 , z );
				//_ptsB->SetPoint(0, x  , y2 , z1);
				//_ptsB->SetPoint(1, x  , y2 , z2);
			    _ptsA->SetPoint(0, xx1 , y1-1 , z  );
				_ptsA->SetPoint(1, xx2 , y1-1 , z  );
				_ptsB->SetPoint(0, x   , y1-1 , zz1);
				_ptsB->SetPoint(1, x   , y1-1 , zz2);
				position[0]		= x;	
				position[2]		= z;	
				focalpoint[0]	= x;	
				focalpoint[2]	= z;	
			}
			if (_direction==2) {	// XY
				if(_imageViewer2XYZ)
				{
					_imageViewer2XYZ->SetZSlice( (int)(GetVtkmprbasedata()->GetZ()) );
				}
			//	_ptsA->SetPoint(0, x1 , y , -z2 );
			//	_ptsA->SetPoint(1, x2 , y , -z2 );
			//	_ptsB->SetPoint(0, x  , y1, -z2 );
			//	_ptsB->SetPoint(1, x  , y2, -z2 );

				
//EED 21 mars 2012  FLIP probleme  ..PLOP..
				//_ptsA->SetPoint(0, x1 , y , z2 );
				//_ptsA->SetPoint(1, x2 , y , z2 );
				//_ptsB->SetPoint(0, x  , y1, z2 );
				//_ptsB->SetPoint(1, x  , y2, z2 );

				_ptsA->SetPoint(0, xx1 , y  , z1-1 );
				_ptsA->SetPoint(1, xx2 , y  , z1-1 );
				_ptsB->SetPoint(0, x   , yy1, z1-1 );
				_ptsB->SetPoint(1, x   , yy2, z1-1 );
				
				position[0]		= x;	
				position[1]		= y;	
				focalpoint[0]	= x;	
				focalpoint[1]	= y;					
			} // if back
			
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
				// ..
#else
				_ptsA->Modified();
				_ptsB->Modified();
#endif

			if (fixAxis2D == true)
			{
				GetRenderer()->GetActiveCamera()->SetPosition(position);
				GetRenderer()->GetActiveCamera()->SetFocalPoint(focalpoint);
			} // if GetFixAxis2D
			_lineAActor->GetProperty()->SetOpacity( opacityAxis );
			_lineBActor->GetProperty()->SetOpacity( opacityAxis );
			SetOpacityText( opacityAxis );
			_backX			= xx;
			_backY			= yy;
			_backZ			= zz;
			_backFixAxis2D	= fixAxis2D;
			_backOpacityAxis= opacityAxis;
		} // if image

//EED 2016/02/19
	vtkImageActor *imageactor = _imageViewer2XYZ->GetVtkImageViewer2()->GetImageActor();
	imageactor->SetInterpolate( GetVtkBaseData()->GetInterpolate() );
//EED 01nov2012
		UpdateColorWindowLevel();
//EED 05juin2019
		UpdateCameraParallelScale();
		wxVtkBaseView::Refresh();
	}
}

//-------------------------------------------------------------------
int wxVtkMPR2DView::GetActualSlice()   // virtual
{
	int result;
	if (_direction==0)
	{
		result = (int)(GetVtkmprbasedata()->GetX());
	}
	if (_direction==1)
	{
		result = (int)(GetVtkmprbasedata()->GetY());
	}
	if (_direction==2)
	{
		result = (int)(GetVtkmprbasedata()->GetZ());
	}
	return result;
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::SetActualSlice(int slice)   // virtual
{
	if (_direction==0)
	{
		GetVtkmprbasedata()->SetX(slice);
	}
	if (_direction==1)
	{
		GetVtkmprbasedata()->SetY(slice);
	}
	if (_direction==2)
	{
		GetVtkmprbasedata()->SetZ(slice);
	}
}
//-------------------------------------------------------------------
bool wxVtkMPR2DView::IfMouseTouchX(double x, double y, double z)
{
	double delta=5;
	bool result=false;
	if (_direction==0)
	{
	}
	if (_direction==1)
	{
		if (( x<GetVtkmprbasedata()->GetX()+delta ) && ( x>GetVtkmprbasedata()->GetX()-delta ))
		{
			result = true;
		}
	}
	if (_direction==2)
	{
		if (( x<GetVtkmprbasedata()->GetX()+delta ) && ( x>GetVtkmprbasedata()->GetX()-delta ))
		{
			result = true;
		}
	}
	return result;
}
//-------------------------------------------------------------------
bool wxVtkMPR2DView::IfMouseTouchY(double x, double y, double z)
{
	double delta=5;
	bool result=false;
	if (_direction==0)
	{
		if (( y<GetVtkmprbasedata()->GetY()+delta ) && ( y>GetVtkmprbasedata()->GetY()-delta ))
		{
			result = true;
		}
	}
	if (_direction==1)
	{
	}
	if (_direction==2)
	{
		if (( y<GetVtkmprbasedata()->GetY()+delta ) && ( y>GetVtkmprbasedata()->GetY()-delta ))
		{
			result = true;
		}
	}
	return result;
}
//-------------------------------------------------------------------
bool wxVtkMPR2DView::IfMouseTouchZ(double x, double y, double z)
{
	double delta=5;
	bool result=false;
	if (_direction==0)
	{
		if (( z<GetVtkmprbasedata()->GetZ()+delta ) && ( z>GetVtkmprbasedata()->GetZ()-delta ))
		{
			result = true;
		}
	}
	if (_direction==1)
	{
		if (( z<GetVtkmprbasedata()->GetZ()+delta ) && ( z>GetVtkmprbasedata()->GetZ()-delta ))
		{
			result = true;
		}
	}
	if (_direction==2)
	{
	}
	return result;
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::MoveX(double x, double y, double z)
{
	if (_direction==0)
	{
	}
	if (_direction==1)
	{
		GetVtkmprbasedata()->SetX(x);
	}
	if (_direction==2)
	{
		GetVtkmprbasedata()->SetX(x);
	}
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::MoveY(double x, double y, double z)
{
	if (_direction==0)
	{
		GetVtkmprbasedata()->SetY(y);
	}
	if (_direction==1)
	{
	}
	if (_direction==2)
	{
		GetVtkmprbasedata()->SetY(y);
	}
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::MoveZ(double x, double y, double z)
{
	if (_direction==0)
	{
		GetVtkmprbasedata()->SetZ(z);
	}
	if (_direction==1)
	{
		GetVtkmprbasedata()->SetZ(z);
	}
	if (_direction==2)
	{
	}
}
//-------------------------------------------------------------------
void wxVtkMPR2DView::ChangeAxisColor(double x, double y, double z)
{
	double c1r=1,c1g=1,c1b=0;
	double c2r=1,c2g=0,c2b=0;

	if (_direction==0)
	{
		if (IfMouseTouchY(x,y,z)==true)
		{
			_lineBActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineBActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
		if (IfMouseTouchZ(x,y,z)==true)
		{
			_lineAActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineAActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
	}

	if (_direction==1)
	{
		if (IfMouseTouchX(x,y,z)==true)
		{
			_lineBActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineBActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
		if (IfMouseTouchZ(x,y,z)==true)
		{
			_lineAActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineAActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
	}

	if (_direction==2)
	{
		if (IfMouseTouchX(x,y,z)==true)
		{
			_lineBActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineBActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
		if (IfMouseTouchY(x,y,z)==true)
		{
			_lineAActor->GetProperty()->SetDiffuseColor(c1r,c1g,c1b);
		} else {
			_lineAActor->GetProperty()->SetDiffuseColor(c2r,c2g,c2b);
		}
	}
	Refresh();
}


//EED 5 juin 2009
//void wxVtkMPR2DView::TransfromCoordViewWorld(double &X, double &Y, double &Z, int type) // virtual
void wxVtkMPR2DView::TransFromCoordScreenToWorld(double &X, double &Y, double &Z, bool keepNormalDirection, int type) //virtual //keepNormalDirection=false, type=2
{

	wxVtkBaseView::TransFromCoordScreenToWorld(X,Y,Z,keepNormalDirection,_direction);

	if ((_direction==0) && (keepNormalDirection==true) )
	{
		X = ((vtkMPRBaseData*)GetVtkBaseData())->GetX();
	}

	if ((_direction==1) && (keepNormalDirection==true) )
	{
		Y = ((vtkMPRBaseData*)GetVtkBaseData())->GetY();
	}

	if ((_direction==2) && (keepNormalDirection==true) )
	{
		Z = ((vtkMPRBaseData*)GetVtkBaseData())->GetZ();
	}

}

//-------------------------------------------------------------------
int wxVtkMPR2DView::GetDirection() // virtual
{
    return _direction;
}


//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
//void boxVolumeObserver::Execute(vtkObject *wdg, unsigned long eventId, void* calldata) {  // virtual
//	if (eventId==vtkCommand::StartInteractionEvent){
//		_renWin->SetDesiredUpdateRate(10);
//	}
//	if (eventId==vtkCommand::InteractionEvent){
//		_renWin->SetDesiredUpdateRate(0.001);
//	}
//	if (eventId==vtkCommand::EndInteractionEvent){
//		vtkPlanes *planes = vtkPlanes::New();
//		vtkBoxWidget *boxwidget = reinterpret_cast<vtkBoxWidget*>(wdg);
//		boxwidget->GetPlanes(planes);
//		_volumeMapper->SetClippingPlanes(planes);
//		planes -> Delete();
//	}
//}

//-------------------------------------------------------------------
//void boxVolumeObserver::SetRenWin( vtkRenderWindow *renWin ){
//	_renWin = renWin;
//}
//-------------------------------------------------------------------
//void boxVolumeObserver::SetVolumeMapper(vtkVolumeRayCastMapper *volumeMapper){
//	_volumeMapper = volumeMapper;
//}
