/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxVtkMPR3DView.h"

#include "vtkDataSetMapper.h"
#include "vtkPlaneSource.h"
#include "vtkProbeFilter.h"
#include "vtkStructuredPoints.h"
#include "vtkMetaImageWriter.h"
#include "vtkImageChangeInformation.h"
#include "vtkPointData.h"
#include "vtkWindowLevelLookupTable.h"
#include "vtkPlane.h"
#include "vtkCutter.h"
#include "vtkTransform.h"
#include "vtkmyPWCallback_3DPointWidget.h"
#include "vtkProperty.h"
#include "vtkCellPicker.h"
#include "vtkInteractorStyleBaseView.h"
#include <vtkImageReslice.h>
#include "vtkTexture.h"



//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
class vtkWindowLevelImagePlaneWidgetCallback : public vtkCommand
{
	 public:
	   static vtkWindowLevelImagePlaneWidgetCallback *New()
	   { 
		   return new vtkWindowLevelImagePlaneWidgetCallback;
	   }
	
	   void Execute( vtkObject *caller, unsigned long ev, void *callData )
		{
			bool needRefresh=false;
			double slicePosition;
			vtkImagePlaneWidget* ipw =dynamic_cast< vtkImagePlaneWidget* >( caller );
		    if ( ev == vtkCommand::WindowLevelEvent)
			{
				double info[2];
				ipw->GetWindowLevel(info);
				_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetColorWindow(info[0]);
				_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetColorLevel(info[1]);
				needRefresh=true;
			} // if ev
		   
		   if ( ev == vtkCommand::InteractionEvent)
		   {
			   needRefresh=true;
			   if (ipw->GetCursorDataStatus())
			   {
				   double xyzv[4];
				   ipw->GetCursorData(xyzv);
				   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetX(xyzv[0]);
				   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetY(xyzv[1]);
				   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetZ(xyzv[2]);
			   } else {
				   vtkImageData *image = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
				   double spc[3];
				   if(image)
				   {
					   image->GetSpacing(spc);
				   }
				   double normal[3];
				   slicePosition = ipw->GetSlicePosition();
				   ipw->GetNormal(normal);
				   // FreePlaneX
				   if ((normal[0]==1)&&(normal[1]==0)&&(normal[2]==0))
				   {
					   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetX( slicePosition/spc[0] );
				   }
				   // FreePlaneY
				   if ((normal[0]==0)&&(normal[1]==1)&&(normal[2]==0))
				   {
					   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetY( slicePosition/spc[1] );
				   }
				   // FreePlaneZ
				   if ((normal[0]==0)&&(normal[1]==0)&&(normal[2]==1))
				   {
					   _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetZ( slicePosition/spc[2] );
				   }
			   }// ipw->GetCursorDataStatus
		   }// ev
		   if (needRefresh)	
		   {
			   vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*)_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetInteractorStyleBaseView();
			   isbv->SetParent_refresh_waiting();
			   isbv->EvaluateToRefresh();
		   }
	   } // Execute
		vtkWindowLevelImagePlaneWidgetCallback(){}
		wxVtkMPR3DView *_wxvtkmpr3Dview;
};

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
wxVtkMPR3DView::wxVtkMPR3DView( wxVtk3DBaseView *wxvtk3Dbaseview )
{
	_wxvtk3Dbaseview			=	wxvtk3Dbaseview;
	_vtkmpr3Ddataviewer			=	NULL;
	_wxvtkmpr3DviewCntrlPanel	=	NULL;
	//_myCallback				=	NULL;
	_pointWidget				=	NULL;
	_planeWidget				=	NULL;
	_vtkplane					=	NULL;
	_probe						=	NULL;
	_contourMapper				=	NULL;
	_planeWidgetX				=	NULL;
	_planeWidgetY				=	NULL;
	_planeWidgetZ				=	NULL;
	//EED Fev 3 2010
	//Free Planes
}

//-------------------------------------------------------------------
wxVtkMPR3DView::~wxVtkMPR3DView()
{
	VisiblePointWidget( false );
//	VisiblePlaneWidget( false );
	if(_pointWidget!=NULL)
	{
		_pointWidget->Delete();
	}
	if(_planeWidget!=NULL)
	{
		_planeWidget->Delete();
	}
	if(_vtkplane!=NULL)
	{
		_vtkplane->Delete();
		_probe->Delete();
		_contourMapper->Delete();
		_contourPlaneActor->Delete();
	}
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::RemoveActor(vtkActor* actor)
{
	_wxvtk3Dbaseview->GetRenderer()->RemoveActor(actor);
}
//-------------------------------------------------------------------
void wxVtkMPR3DView::Configure()
{
	vtkImageData *imageData = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	_wxvtk3Dbaseview->Configure();
	_wxvtkmpr3DviewCntrlPanel->UpdateControlPanel();
	// Actors are added to the renderer.
	vtkActor* _outlineActor = _vtkmpr3Ddataviewer->GetOutlineActor();
	_wxvtk3Dbaseview->GetRenderer()->AddActor( _outlineActor );

	vtkmyPWCallback_3DPointWidget *_myCallback = vtkmyPWCallback_3DPointWidget::New();
	_myCallback->SetWxVtkMPR3DView(this);
	if(imageData){
		if(_pointWidget==NULL)
		{
			_pointWidget = vtkPointWidget::New();
		}
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_pointWidget->SetInput( imageData );
#else
		_pointWidget->SetInputData( imageData );
#endif
		_myCallback->SetVtkPointWidget(_pointWidget);
		_pointWidget->SetInteractor( GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor() );
		_pointWidget->AllOff();
		_pointWidget->PlaceWidget();
		_pointWidget->AddObserver(vtkCommand::InteractionEvent,_myCallback);
		if(_planeWidget==NULL)
		{
			_planeWidget = vtkPlaneWidget::New();
		}
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_planeWidget->SetInput( imageData );
#else
		_planeWidget->SetInputData( imageData );
#endif

		_myCallback->SetVtkPlaneWidget(_planeWidget);
		_planeWidget->NormalToXAxisOn();
		_planeWidget->SetResolution(50);
		_planeWidget->SetRepresentationToOutline();
		int dim[3];
		imageData->GetDimensions(dim);
		int px=(dim[0]/2);
		int py=(dim[1]/2);
		int pz=(dim[2]/2);
		int dd=20;
		_planeWidget->PlaceWidget( px-dd , px+dd , py-dd , py+dd , pz-dd , pz+dd );
		if(_vtkplane==NULL)
		{
			_vtkplane 		= vtkPolyData::New();
			_probe 			= vtkProbeFilter::New();
			_contourMapper 	= vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			_probe->SetInput(_vtkplane);
			_contourMapper->SetInput( _probe->GetPolyDataOutput() );
#else
			_myCallback->SetVtkPolyData(_vtkplane);
			_myCallback->SetVtkProbeFilter(_probe);
			_planeWidget->GetPolyData(_vtkplane);
			_probe->SetInputData(_vtkplane);
			_probe->SetSourceData(imageData);
//			_probe->Update();
			_contourMapper->SetInputData( _probe->GetPolyDataOutput() );
#endif

			_contourPlaneActor = vtkActor::New();
			_contourPlaneActor->SetMapper(_contourMapper);
			_contourPlaneActor->VisibilityOff();
			_planeWidget->SetInteractor( GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor() );
			_planeWidget->AddObserver(vtkCommand::InteractionEvent,_myCallback);
			_planeWidget->Off();
			_wxvtk3Dbaseview->GetRenderer()->AddActor( _contourPlaneActor );
		}
		_planeWidget->GetPolyData(_vtkplane);

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_probe->SetSource( imageData );
#else
		_probe->SetSourceData( imageData );
#endif
		_contourMapper->SetScalarRange( imageData->GetScalarRange() );
	ConfigureFreePlanes();
	}

//	_pointWidget->SetPosition( x,y,z );

//EED01 29Mars2009
// MACOS probleme vtk-window out of wx-window
//	_pointWidget->On();

// PlaneWidget


// An initial camera view is created.  The Dolly() method moves
	// the camera towards the FocalPoint, thereby enlarging the image.
//	_wxvtk3Dbaseview->GetRenderer()->SetActiveCamera(_wxvtk3Dbaseview->GetCamera());

	// Note that when camera movement occurs (as it does in the Dolly()
	// method), the clipping planes often need adjusting. Clipping planes
	// consist of two planes: near and far along the view direction. The
	// near plane clips out objects in front of the plane; the far plane
	// clips out objects behind the plane. This way only what is drawn
	// between the planes is actually rendered.

//EED 27/05/2013
//	_wxvtk3Dbaseview->GetRenderer()->ResetCameraClippingRange();

//EED 27/05/2013
//      this->ResetCamera();
	_wxvtk3Dbaseview->ResetCamera();

	// Set a background color for the renderer and set the size of the
	// render window (expressed in pixels).
	_wxvtk3Dbaseview->GetRenderer()->SetBackground( 0.36 , 0.36 , 0.36 );
//EED 23oct2010	_wxvtk3Dbaseview->GetRenWin()->SetSize(400, 400);
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::ConfigureFreePlanes()
{
	// The shared picker enables us to use 3 planes at one time
	// and gets the picking order right
	vtkCellPicker* picker = vtkCellPicker::New();
	picker->SetTolerance(0.005);
	// The 3 image plane widgets
	_planeWidgetX = GetPlaneWidget('x', 1, 0, 0, picker);
	_planeWidgetY = GetPlaneWidget('y', 1, 1, 0, picker);
	_planeWidgetZ = GetPlaneWidget('z', 0, 0, 1, picker);
	_planeWidgetY->SetLookupTable(_planeWidgetX->GetLookupTable());
	_planeWidgetZ->SetLookupTable(_planeWidgetX->GetLookupTable());
	picker->UnRegister(NULL);

	// ColorWindow ColorLevel Callback
	vtkWindowLevelImagePlaneWidgetCallback *wlipwc	= vtkWindowLevelImagePlaneWidgetCallback::New();
	wlipwc->_wxvtkmpr3Dview							= this;
	_planeWidgetX->AddObserver(vtkCommand::WindowLevelEvent, wlipwc );
	_planeWidgetY->AddObserver(vtkCommand::WindowLevelEvent, wlipwc );
	_planeWidgetZ->AddObserver(vtkCommand::WindowLevelEvent, wlipwc );
	
	// Cursor Callback
	_planeWidgetX->AddObserver(vtkCommand::InteractionEvent, wlipwc );
	_planeWidgetY->AddObserver(vtkCommand::InteractionEvent, wlipwc );
	_planeWidgetZ->AddObserver(vtkCommand::InteractionEvent, wlipwc );	
}


//-------------------------------------------------------------------
void wxVtkMPR3DView::SetImage()
{
	vtkImageData *imageData					= GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	// Orthogonal planes B&W
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_planeWidgetX->SetInput( imageData );
	_planeWidgetY->SetInput( imageData );
	_planeWidgetZ->SetInput( imageData );
	// -- Plane widget
	_probe->SetSource( imageData );
#else


//	double colorWindow 	= _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetColorWindow();
//	double colorLevel 	= _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetColorLevel();

	double spc[3];
	vtkImageData *image = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	if(image)
	{
		image->GetSpacing(spc);
	}else{
		spc[0] = 0;
		spc[1] = 0;
		spc[2] = 0;
	}
	double x = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX();
	double y = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY();
	double z = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ();


/*
	if (mchange==NULL)
	{
		mchange = vtkImageChangeInformation::New();
		mchange->SetInputData( imageData );
		mchange->Modified();    //important
		mchange->Update();    //important
		_planeWidgetX->SetInputData( mchange->GetOutput() );
		_planeWidgetY->SetInputData( mchange->GetOutput() );
		_planeWidgetZ->SetInputData( mchange->GetOutput() );
	} else {
		mchange->SetInputData( imageData );
		mchange->Modified();    //important
		mchange->Update();    //important
	}
	
*/




	_planeWidgetX->SetInputData( imageData );
	_planeWidgetY->SetInputData( imageData );
	_planeWidgetZ->SetInputData( imageData );
//EED 2021-06-23	
//	_planeWidgetX->SetWindowLevel(colorLevel,colorWindow,1);
//	_planeWidgetY->SetWindowLevel(colorLevel,colorWindow,1);
//	_planeWidgetY->SetWindowLevel(colorLevel,colorWindow,1);
	_planeWidgetX->SetSlicePosition( x*spc[0] );
	_planeWidgetY->SetSlicePosition( y*spc[1] );
	_planeWidgetZ->SetSlicePosition( z*spc[2] );

	_planeWidgetX->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
	_planeWidgetY->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
	_planeWidgetZ->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );


	// -- Plane widget
	_probe->SetSourceData( imageData );
#endif
	_vtkmpr3Ddataviewer->SetImage();
}

//-------------------------------------------------------------------
vtkImagePlaneWidget* wxVtkMPR3DView::GetPlaneWidget(unsigned char activationkey, double r, double g, double b, vtkCellPicker* picker)
{
	vtkProperty* prop1					= NULL;
	vtkImagePlaneWidget* planeWidget	= vtkImagePlaneWidget::New();
	planeWidget->SetInteractor( GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor() );
	planeWidget->EnabledOff();
	vtkImageData *image					= GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	int xMin = 0, xMax = 0, yMin = 0, yMax = 0, zMin = 0, zMax = 0;
	double xSpacing = 0, ySpacing = 0, zSpacing = 0;
	if(image)
	{

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		planeWidget->SetInput( image );
#else
		planeWidget->SetInputData( image );
#endif
		image->GetExtent(xMin, xMax, yMin, yMax, zMin, zMax);
		image->GetSpacing(xSpacing, ySpacing, zSpacing);
	}

	if (activationkey=='x')
	{
		planeWidget->SetPlaneOrientationToXAxes();
		planeWidget->SetSlicePosition((xMax+xMin)/2.*xSpacing);
	}

	if (activationkey=='y')
	{
		planeWidget->SetPlaneOrientationToYAxes();
		planeWidget->SetSlicePosition((yMax+yMin)/2.*ySpacing);
	}

	if (activationkey=='z')
	{
		planeWidget->SetPlaneOrientationToZAxes();
		planeWidget->SetSlicePosition((zMax+zMin)/2.*zSpacing);
	}

	planeWidget->DisplayTextOn();
	planeWidget->SetPicker(picker);
	planeWidget->SetKeyPressActivationValue(activationkey);
	prop1 = planeWidget->GetPlaneProperty();
	prop1->SetColor(r, g, b);
	return planeWidget;
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::SetFreePlanesOrtho()
{
	_planeWidgetX->SetPlaneOrientationToXAxes();
	_planeWidgetY->SetPlaneOrientationToYAxes();
	_planeWidgetZ->SetPlaneOrientationToZAxes();
	vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*)GetWxvtk3Dbaseview()->GetInteractorStyleBaseView();
	isbv->SetParent_refresh_waiting();
	isbv->EvaluateToRefresh();
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::FreePlaneVisible(int plane, bool ok)
{
	if(_planeWidgetX)
	{
    	if (ok==true)
        {
//EED 21/07/2013
//			1. Make backup of actors
// 			2. Putting out all the actors
//			3. Add vtkImagageActor in first place
//			4. Putting again the originals actors
//			5. Refresh

			// step 1, step 2
        	vtkActorCollection *tmpCollection    = vtkActorCollection::New();
	 		vtkActorCollection *collectionActors =  _wxvtk3Dbaseview->GetRenderer()->GetActors();
        	int i,size=collectionActors->GetNumberOfItems();
			for (i=0; i<size; i++)
			{
				tmpCollection->AddItem ( (vtkActor*)collectionActors->GetItemAsObject(0)  );           		
			        _wxvtk3Dbaseview->GetRenderer()->RemoveActor( (vtkProp*)tmpCollection->GetItemAsObject(i) );
			} // for

			// step 3
 	      		if ((plane==1) && (ok==true)) _planeWidgetX->EnabledOn();
	      		if ((plane==2) && (ok==true)) _planeWidgetY->EnabledOn();
	      		if ((plane==3) && (ok==true)) _planeWidgetZ->EnabledOn();

			// step 4
			 for (i=0; i<size; i++)
			{
			        _wxvtk3Dbaseview->GetRenderer()->AddActor( (vtkProp*)tmpCollection->GetItemAsObject(i) );
			} // for
			tmpCollection->Delete();

			// step 5 Refresh
			_wxvtk3Dbaseview->GetRenderer()->GetRenderWindow()->Render();
        } // if ok
		if ((plane==1) && (ok==false)) _planeWidgetX->EnabledOff();
		if ((plane==2) && (ok==false)) _planeWidgetY->EnabledOff();
		if ((plane==3) && (ok==false)) _planeWidgetZ->EnabledOff();
	} // if  _planeWidgetX
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::FreePlaneInteraction(bool ok)
{
	if(_planeWidgetX)
	{
		if (ok==true)
		{
			_planeWidgetX->InteractionOn();
			_planeWidgetY->InteractionOn();
			_planeWidgetZ->InteractionOn();
		} else {
			_planeWidgetX->InteractionOff();
			_planeWidgetY->InteractionOff();
			_planeWidgetZ->InteractionOff();
		}
	} // if _planeWidgetXVisiblePointWidget
}



//-------------------------------------------------------------------
void wxVtkMPR3DView::setColorTransferFunction(vtkColorTransferFunction* colortable)
{
	GetVtkMPR3DDataViewer ()->setColorTransferFunction(colortable);
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::Refresh()   // virtual
{
	_vtkmpr3Ddataviewer->Refresh();
	if (_wxvtkmpr3DviewCntrlPanel!=NULL)
	{
		_wxvtkmpr3DviewCntrlPanel->Refresh();
	}
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::RefreshView()   // virtual
{
	double spc[3];
	vtkImageData *image = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
	if(image)
	{
		image->GetSpacing(spc);
	}else{
		spc[0] = 0;
		spc[1] = 0;
		spc[2] = 0;
	}
//	GetVtkMPR3DDataViewer()->Configure();

	//double nx=1,ny=0,nz=0; // JPRx
	Refresh();
	double x = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX();
	double y = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY();
	double z = GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ();

	double normal[3];
	// FreePlaneX
	_planeWidgetX->GetNormal(normal);
	if ((normal[0]==1)&&(normal[1]==0)&&(normal[2]==0))
	{
		_planeWidgetX->SetSlicePosition( x*spc[0] );
//EED 2016/02/19
		_planeWidgetX->GetReslice()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
		_planeWidgetX->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
	}
	// FreePlaneY
	_planeWidgetY->GetNormal(normal);
	if ((normal[0]==0)&&(normal[1]==1)&&(normal[2]==0))
	{
		_planeWidgetY->SetSlicePosition( y*spc[1] );
//EED 2016/02/19
		_planeWidgetY->GetReslice()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
		_planeWidgetY->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
	}
	// FreePlaneZ
	_planeWidgetZ->GetNormal(normal);
	if ((normal[0]==0)&&(normal[1]==0)&&(normal[2]==1))
	{
		_planeWidgetZ->SetSlicePosition( z*spc[2] );
//EED 2016/02/19
		_planeWidgetZ->GetReslice()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
		_planeWidgetZ->GetTexture()->SetInterpolate( _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetInterpolate() );
	}
    
	SetWindowColorLevel(_vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetColorWindow() , _vtkmpr3Ddataviewer->GetVtkMPRBaseData()->GetColorLevel() );
    
	x = x*spc[0];
	y = y*spc[1];
	z = z*spc[2];
	if(_pointWidget)
	{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_pointWidget->SetInput( image );
#else
		_pointWidget->SetInputData( image );
#endif
		_pointWidget->PlaceWidget();

		_pointWidget->SetPosition( x,y,z );
		double in[3];
		double normal[3];
		vtkTransform *transform = GetVtkMPR3DDataViewer ()->GetVtkMPRBaseData()->GetTransformOrientation();
		in[0]=1;		in[1]=0;			in[2]=0;
		transform->TransformPoint(in,normal);
		_planeWidget->SetNormal( normal[0],normal[1],normal[2] );
		_planeWidget->SetCenter( x,y,z );
		_planeWidget->UpdatePlacement();
		_planeWidget->GetPolyData(_vtkplane);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		// ..
#else
		_probe->Update();
#endif
	} //_pointWidget

	if (_wxvtkmpr3DviewCntrlPanel!=NULL)
	{
		_wxvtkmpr3DviewCntrlPanel->UpdateControlPanel(false);
	} // if _wxvtkmpr3DviewCntrlPanel
}

//-------------------------------------------------------------------
wxPanel* wxVtkMPR3DView::CreateControlPanel(wxWindow *parent, bool align)
{
	_wxvtkmpr3DviewCntrlPanel = new wxVtkMPR3DViewCntrlPanel(parent,this, align);
	return _wxvtkmpr3DviewCntrlPanel;
}
//-------------------------------------------------------------------
vtkMPR3DDataViewer* wxVtkMPR3DView::GetVtkMPR3DDataViewer()
{
	return _vtkmpr3Ddataviewer;
}
//-------------------------------------------------------------------
// EED 2022-08-04	throw
//wxVtk3DBaseView* wxVtkMPR3DView::GetWxvtk3Dbaseview() throw (char*)
wxVtk3DBaseView* wxVtkMPR3DView::GetWxvtk3Dbaseview() 
{
	try {
		if(_wxvtk3Dbaseview==NULL)
		{
			throw "wxVtk3DBaseView* wxVtkMPR3DView::GetWxvtk3Dbaseview() _wxvtk3Dbaseview=NULL";
		}
		return _wxvtk3Dbaseview;
	} catch (...) {
	  throw ;
	}
}
//-------------------------------------------------------------------

//-------------------------------------------------------------------
void wxVtkMPR3DView::VisibleImageActor(int idPosition, bool visible)
{
	/*if(visible == false)
		printf("CPR: wxVtkMPR3DView::VisibleImageActor-> visibleActor == false \n");
	else
	{
		printf("CPR: wxVtkMPR3DView::VisibleImageActor-> visibleActor == true\n");
		printf("CPR: wxVtkMPR3DView::VisibleImageActor-> idPosition == %d\n", idPosition);
	}
	*/
	if (visible!=_vtkmpr3Ddataviewer->GetVisiblePosition(idPosition)){
		if (visible==false)
		{
			_wxvtk3Dbaseview->GetRenderer()->RemoveActor( _vtkmpr3Ddataviewer->GetImageActor(idPosition)  );
		} else {
//EED 21/07/2013
//			1. Make backup of actors
// 			2. Putting out all the actors
//			3. Add vtkImagageActor in first place
//			4. Putting again the originals actors
//			5. Refresh

//EED 4 nov 2015  (For Estelle)
// This works in ViewerNV with nTymeView=6
// Because the others modules (5) generate also more actors with an OutLineFilter -> Actor
//showOutlineActor(false);
			// step 1, step 2
			vtkActorCollection *tmpCollection    = vtkActorCollection::New();
	 		vtkActorCollection *collectionActors =  _wxvtk3Dbaseview->GetRenderer()->GetActors();
        		int i,size=collectionActors->GetNumberOfItems();
			for (i=0; i<size; i++)
			{
				tmpCollection->AddItem ( (vtkActor*)collectionActors->GetItemAsObject(0)  );           		
			        _wxvtk3Dbaseview->GetRenderer()->RemoveActor( (vtkProp*)tmpCollection->GetItemAsObject(i) );
			} // for
			// step 3
			_wxvtk3Dbaseview->GetRenderer()->AddActor( _vtkmpr3Ddataviewer->GetImageActor(idPosition)  );
			// step 4
			 for (i=0; i<size; i++)
			{
			        _wxvtk3Dbaseview->GetRenderer()->AddActor( (vtkProp*)tmpCollection->GetItemAsObject(i) );
			} // for
			tmpCollection->Delete();
			// step 5 Refresh
			_wxvtk3Dbaseview->GetRenderer()->GetRenderWindow()->Render();
		} // if visible
		_vtkmpr3Ddataviewer->SetVisiblePosition(idPosition,visible);
	} // if visible 
}


//-------------------------------------------------------------------
void wxVtkMPR3DView::VisiblePointWidget( bool visible )
{
	if(_pointWidget){
		if (visible==true)
		{
			_pointWidget->On();
		} else {
			_pointWidget->Off();
		} // visible
	} // _pointWidget
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::VisiblePlaneWidget( bool visible )
{
	if(_planeWidget){
		if (visible==true)
		{
			_planeWidget->On();
			_contourPlaneActor->VisibilityOn();
		} else {
			_planeWidget->Off();
			_contourPlaneActor->VisibilityOff();			
		} // if visible
		_wxvtk3Dbaseview->GetRenderer()->GetRenderWindow()->Render();
	} // _planeWidget
}

//CPR: Method added 30 Nov 2009
void wxVtkMPR3DView::showOutlineBoxActor(bool value)
{
	vtkActor* _outlineActor = _vtkmpr3Ddataviewer->GetOutlineActor();
	if(value == true)
	{
		_wxvtk3Dbaseview->GetRenderer()->AddActor( _outlineActor );
	} else {
		_wxvtk3Dbaseview->GetRenderer()->RemoveActor( _outlineActor );
	} // value
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::showOutlinePlaneActor(bool value)
{
	vtkProperty *prop1=NULL;
	if(value == true)
	{
		prop1 = _planeWidgetX ->GetPlaneProperty();
		prop1->SetOpacity(1);
		prop1 = _planeWidgetY ->GetPlaneProperty();
		prop1->SetOpacity(1);
		prop1 = _planeWidgetZ ->GetPlaneProperty();
		prop1->SetOpacity(1);		
	} else {
		prop1 = _planeWidgetX ->GetPlaneProperty();
		prop1->SetOpacity(0);
		prop1 = _planeWidgetY ->GetPlaneProperty();
		prop1->SetOpacity(0);
		prop1 = _planeWidgetZ ->GetPlaneProperty();
		prop1->SetOpacity(0);
	} // value
}


//-------------------------------------------------------------------
void wxVtkMPR3DView::SetVtkMPR3DDataViewer(vtkMPR3DDataViewer *vtkmpr3Ddataviewer)
{
	_vtkmpr3Ddataviewer = vtkmpr3Ddataviewer;
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::InitOrientationPointWidget()
{
	this->_planeWidget->SetNormal(1,0,0);
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::SetWindowColorLevel(double colorWindow , double colorLevel)
{
	_planeWidgetX->SetWindowLevel(colorWindow,colorLevel);
	_planeWidgetY->SetWindowLevel(colorWindow,colorLevel);
	_planeWidgetZ->SetWindowLevel(colorWindow,colorLevel);
}


//-------------------------------------------------------------------
// EED 25 Janvier 2007 testLoic
void wxVtkMPR3DView::TestLoic1()
{

	int sizeIma	= 128;
  double dimIma = sizeIma*2;

	vtkImageData *vtkimagedata =  this->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();

	double spc[3];
	vtkimagedata->GetSpacing(spc);

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	vtkimagedata->Update();
#else
	// ..
#endif


	 double p[3], n[3];
     this->_planeWidget->GetOrigin(p);
     this->_planeWidget->GetNormal(n);



    vtkPlaneSource* pSource = vtkPlaneSource::New( );
    pSource->SetResolution( sizeIma - 1, sizeIma - 1 );
    pSource->SetOrigin( p[ 0 ], p[ 1 ], p[ 2 ] );
    pSource->SetPoint1( p[ 0 ] + dimIma - 1.0, p[ 1 ], p[ 2 ] );
    pSource->SetPoint2( p[ 0 ], p[ 1 ]+ dimIma - 1.0 , p[ 2 ] );
    pSource->Update( );
    pSource->SetCenter( p[ 0 ], p[ 1 ], p[ 2 ] );
    pSource->SetNormal( n[ 0 ], n[ 1 ], n[ 2 ] );
    pSource->Update( );

    vtkProbeFilter* slices = vtkProbeFilter::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
    slices->SetInput( ( vtkDataSet* )pSource->GetOutput( ) );
    slices->SetSource( vtkimagedata );
    slices->Update( );
    pSource->Delete( );
#else
    slices->SetInputData( ( vtkDataSet* )pSource->GetOutput( ) );
    slices->SetSourceData( vtkimagedata );
#endif

	vtkStructuredPoints   *stPoints = vtkStructuredPoints::New();
	stPoints -> GetPointData( )->SetScalars(  slices->GetOutput()->GetPointData()->GetScalars()  );
	stPoints -> SetDimensions( sizeIma, sizeIma, 1 );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	stPoints -> SetScalarType( vtkimagedata->GetScalarType() );
	stPoints -> SetScalarTypeToShort();
	stPoints -> Update();
#else
	vtkInformation* info=stPoints->GetInformation();
	vtkDataObject::SetPointDataActiveScalarInfo(info, VTK_SHORT, 1);
#endif



	vtkImageChangeInformation  *change = vtkImageChangeInformation ::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	change	  -> SetInput( stPoints );
#else
	change	  -> SetInputData( stPoints );
#endif
	change	  -> Update();    //important

	double _range[2];
	vtkimagedata->GetScalarRange(_range);
   vtkWindowLevelLookupTable *_bwlookup = vtkWindowLevelLookupTable::New( );
   _bwlookup->SetHueRange( 0 , 1 );
   _bwlookup->SetNumberOfColors( (int)(_range[1] - _range[0] + 1) );
   _bwlookup->SetTableRange( _range[0] , _range[1] );
   _bwlookup->SetSaturationRange( 0 , 0 );
   _bwlookup->SetValueRange( 0 , 1 );
   _bwlookup->SetAlphaRange( 1 , 1 );
   _bwlookup->Build( );

   vtkLookupTable * _collookup = vtkLookupTable::New( );
   _collookup->SetNumberOfColors( 256 );
   _collookup->SetTableRange( 0 , 255 );
   _collookup->Build( );
   _collookup->SetTableValue( 0  , 1 , 0 , 0 , 1 );
   _collookup->SetTableValue(128 , 0 , 0 , 1 , 1 );
   _collookup->SetTableValue(255 , 0 , 1 , 0 , 1 );


	vtkMetaImageWriter *writer = vtkMetaImageWriter::New( );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	writer->SetInput( stPoints );
#else
	writer->SetInputData( stPoints );
#endif
	writer->SetFileName( "C:/Users/Images/temp_EED/image.mhd" );
	writer->SetFileDimensionality( 2 );
	writer->Write( );



	vtkDataSetMapper *_3DSliceMapper = vtkDataSetMapper::New( );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_3DSliceMapper->SetInput(change->GetOutput( ) );
	_3DSliceMapper->ImmediateModeRenderingOn( );
#else
	_3DSliceMapper->SetInputData(change->GetOutput( ) );
#endif

	_3DSliceMapper->SetLookupTable( _bwlookup );
	_3DSliceMapper->SetScalarRange( _range );

	vtkActor *_3DSliceActor = vtkActor::New( );
	_3DSliceActor->SetMapper( _3DSliceMapper );

 // The usual rendering stuff.
  vtkCamera *camera = vtkCamera::New();
      camera->SetPosition(1,1,1);
      camera->SetFocalPoint(0,0,0);

  vtkRenderer *renderer = vtkRenderer::New();
  vtkRenderWindow *renWin = vtkRenderWindow::New();
    renWin->AddRenderer(renderer);

  vtkRenderWindowInteractor *iren = vtkRenderWindowInteractor::New();
    iren->SetRenderWindow(renWin);

  renderer->AddActor( _3DSliceActor );
      renderer->SetActiveCamera(camera);
      renderer->ResetCamera();
      renderer->SetBackground(1,1,1);

  renWin->SetSize(300,300);

  // interact with data
  renWin->Render();
  iren->Start();





}

//-------------------------------------------------------------------
// EED 25 Janvier 2007 testLoic
void wxVtkMPR3DView::TestLoic2()
{
/*
 vtkVectorNorm *vecMagnitude = vtkVectorNorm::New();
                vecMagnitude->SetInput(VtkMainGrid);
                vecMagnitude->NormalizeOff();
                vecMagnitude->Update();
*/

        vtkPlane *slicePlane = vtkPlane::New();
				this->_planeWidget->GetPlane( slicePlane );

        vtkCutter* sliceCutter = vtkCutter::New();
		vtkImageData *vtkimagedata =  this->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
                sliceCutter->SetInput( vtkimagedata );
#else
                sliceCutter->SetInputData( vtkimagedata );
#endif
                sliceCutter->SetCutFunction( slicePlane );

//EED
//        vtkLookupTable *lut = BuildHueWeightBaseMap();

        vtkPolyDataMapper *slice = vtkPolyDataMapper::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		slice->SetInput( sliceCutter->GetOutput() );
#else
		slice->SetInputData( sliceCutter->GetOutput() );
#endif
        double range[2];
// EED
//                slice->Update();
				  vtkimagedata->GetScalarRange(range);
//                vecMagnitude->GetOutput()->GetScalarRange( range );
//                range[1] *= 0.7; // reduce the upper range by 30%
//                slice->SetScalarRange( range );
//                slice->SetLookupTable( lut );

//       vtkActor *sliceActor = vtkActor::New();
//                sliceActor->SetMapper( slice );

        vtkPolyDataMapper *contourMapper = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
                contourMapper->SetInput( sliceCutter->GetOutput() );
#else
                contourMapper->SetInputData( sliceCutter->GetOutput() );
#endif

                contourMapper->SetScalarRange( range );
  //              contourMapper->SetLookupTable( lut );

        vtkActor *contourActor = vtkActor::New();
                contourActor->SetMapper( contourMapper );

 // The usual rendering stuff.
  vtkCamera *camera = vtkCamera::New();
      camera->SetPosition(1,1,1);
      camera->SetFocalPoint(0,0,0);

  vtkRenderer *renderer = vtkRenderer::New();
  vtkRenderWindow *renWin = vtkRenderWindow::New();
    renWin->AddRenderer(renderer);

  vtkRenderWindowInteractor *iren = vtkRenderWindowInteractor::New();
    iren->SetRenderWindow(renWin);

  renderer->AddActor( contourActor );
//  renderer->AddActor(cubeActor);
      renderer->SetActiveCamera(camera);
      renderer->ResetCamera();
      renderer->SetBackground(1,1,1);

  renWin->SetSize(300,300);

  // interact with data
  renWin->Render();
  iren->Start();
}

//-------------------------------------------------------------------
void wxVtkMPR3DView::SetBackGroundType(int type)
{
	if (_wxvtk3Dbaseview!=NULL)
	{
		if (type==0)
		{
			_wxvtk3Dbaseview->GetRenderer()->GradientBackgroundOn();
			_wxvtk3Dbaseview->GetRenderer()->SetBackground( 0.33 , 0.33 , 0.33 );
			_wxvtk3Dbaseview->GetRenderer()->SetBackground2( 0.66 , 0.66 , 0.66 );
		} // if type
		else if (type==1)
		{
			_wxvtk3Dbaseview->GetRenderer()->GradientBackgroundOff();
			_wxvtk3Dbaseview->GetRenderer()->SetBackground( 0 , 0 , 0 );
		} // if type
		else if (type==2)
		{
			_wxvtk3Dbaseview->GetRenderer()->GradientBackgroundOff();
			_wxvtk3Dbaseview->GetRenderer()->SetBackground( 1 , 1 , 1 );
		} // if type
		_wxvtk3Dbaseview->Refresh();
	}// if _wxvtk3Dbaseview
	
}


