/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxVtkMPR3DViewCntrlPanel.h"

#include "HistogramDialog.h"
#include <wx/combobox.h>

wxVtkMPR3DViewCntrlPanel::wxVtkMPR3DViewCntrlPanel(wxWindow *parent, wxVtkMPR3DView *wxvtkmpr3Dview, bool align )
: wxPanel(parent, -1)
{
	wxPanel *panel	= this;
	_wxvtkmpr3Dview	= wxvtkmpr3Dview;

	/*int maxX = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionX();
	int maxY = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionY();
	int maxZ = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetMaxPositionZ();*/

	//int maxX = 1;
	//int maxY = 1;
	//int maxZ = 1;

	//CPR: Modified 30 Nov 2009
	/*
	wxCheckBox		*ckBoxX			= new wxCheckBox(panel,-1,_T("X           "));
					_positionX		= new wxSlider(panel,-1,maxX/2,0,maxX, wxDefaultPosition,  wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	wxCheckBox		*ckBoxY			= new wxCheckBox(panel,-1,_T("Y           "));
					_positionY		= new wxSlider(panel,-1,maxY/2,0,maxY, wxDefaultPosition,  wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	wxCheckBox		*ckBoxZ			= new wxCheckBox(panel,-1,_T("Z           "));
					_positionZ		= new wxSlider(panel,-1,maxZ/2,0,maxZ, wxDefaultPosition,  wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	wxButton		*btnColorTable  = new wxButton (panel, -1, _T("Edit Color Table") );
	*/

	_ckBoxX						= new wxCheckBox(panel,-1,_T("X   "));
	_positionX					= new wxSlider(panel,-1,0,0,1, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	_ckBoxY						= new wxCheckBox(panel,-1,_T("Y   "));
	_positionY					= new wxSlider(panel,-1,0,0,1, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
	_ckBoxZ						= new wxCheckBox(panel,-1,_T("Z   "));
	_positionZ					= new wxSlider(panel,-1,0,0,1, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);

	_ckBoxXYZ					= new wxCheckBox(panel,-1,_T("3D Axis  "));
	_ckBoxFixAxis2D				= new wxCheckBox(panel,-1,_T("2D Fix Axis"));
	_opacityAxis				= new wxSlider(panel,-1,100,0,100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);

	_ckBoxPlane					= new wxCheckBox(panel,-1,_T("Plane"));
////EED 05Nov2012	_ckBox_BW_Color_Plane		= new wxCheckBox(panel,-1,_T("GL/Color"));
	wxButton *btnColorTable		= new wxButton (panel, -1, _T("Color table") );
	wxButton *btnFreePlanesOrtho= new wxButton (panel, -1, _T("Orthogonal planes GL") );

	_ckFreePlaneX= new wxCheckBox(panel,-1,_T("X "));
	_ckFreePlaneY= new wxCheckBox(panel,-1,_T("Y "));
	_ckFreePlaneZ= new wxCheckBox(panel,-1,_T("Z "));
	_ckFreePlaneInteraction= new wxCheckBox(panel,-1,_T("Interaction planes GL"));
	
	//EED: If-else statements added 30 Nov 2009
	_ckFreePlaneX->SetValue(false);
	_ckFreePlaneY->SetValue(false);
	_ckFreePlaneZ->SetValue(false);
	_ckFreePlaneInteraction->SetValue(true);
	
	_ckBoxX->SetValue(false);
	_ckBoxY->SetValue(false);
	_ckBoxZ->SetValue(false);
	_ckBoxXYZ->SetValue(false);
////EED 05Nov2012	_ckBox_BW_Color_Plane->SetValue(true);
	_ckBoxPlane->SetValue(false);
	_ckBoxInterpolate= new wxCheckBox(panel,-1,_T("Interpolate"));
	_ckBoxInterpolate->SetValue(true);


	_ckBoxOutlineBox	= new wxCheckBox(panel,-1,_T("Outline Box"));
	_ckBoxOutlineBox->SetValue(true);
	_ckBoxOutlinePlane	= new wxCheckBox(panel,-1,_T("Outline Plane"));
	_ckBoxOutlinePlane->SetValue(true);


	
//	_ckBoxBackGroundBlack= new wxCheckBox(panel,-1,_T("Background Black"));;
//	_ckBoxBackGroundBlack->SetValue(false);
// EED Borrame	
//	_ckBoxBackGroundBlack= new wxCheckBox(panel,-1,_T("Background Black"));;
//	_ckBoxBackGroundBlack->SetValue(false);

	wxPanel *panelH7 = new wxPanel(panel);

	_rdBackGroundGradient	= new wxRadioButton( panelH7, -1, _T("Background Gradient"),wxDefaultPosition, wxDefaultSize, wxRB_GROUP);
	_rdBackGroundBlack		= new wxRadioButton( panelH7, -1, _T("Background Black"),wxDefaultPosition, wxDefaultSize, 0);
	_rdBackGroundWhite 		= new wxRadioButton( panelH7, -1, _T("Background White"),wxDefaultPosition, wxDefaultSize, 0);

	_rdBackGroundGradient->SetValue(false);
	_rdBackGroundBlack->SetValue(false);
	_rdBackGroundWhite->SetValue(false);

	_positionX->SetSize(400,20);
	_positionY->SetSize(400,20);
	_positionZ->SetSize(400,20);

	// Stereo
	_cbStereo = new wxComboBox(panel, -1, _T(""), wxDefaultPosition, wxDefaultSize, 0, NULL,wxCB_READONLY );	
	_cbStereo->Append(_T(" * NO STEREO"));
	_cbStereo->Append(_T("   STEREO CRYSTAL EYES"));
	_cbStereo->Append(_T("   STEREO RED BLUE"));
	_cbStereo->Append(_T("   STEREO INTERLACED"));
	_cbStereo->Append(_T("   STEREO LEFT"));
	_cbStereo->Append(_T("   STEREO RIGHT"));
	_cbStereo->Append(_T("   STEREO DRESDEN"));
	_cbStereo->Append(_T(" * STEREO ANAGLYPH"));
	_cbStereo->Append(_T("   STEREO CHECKERBOARD"));
    _cbStereo->Append(_T(" * STEREO SPLITVIEWPORT_HORIZONTAL"));
    _cbStereo->Append(_T("   STEREO FAKE"));
    _cbStereo->Append(_T("   STEREO EMULATE"));
	_cbStereo->Select(0);

	Connect(_ckBoxX->GetId()				, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisX 	);
	Connect(_positionX->GetId()				, wxEVT_COMMAND_SLIDER_UPDATED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionX 		);
	Connect(_ckBoxY->GetId()				, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisY 	);
	Connect(_positionY->GetId()				, wxEVT_COMMAND_SLIDER_UPDATED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionY 		);
	Connect(_ckBoxZ->GetId()				, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisZ 	);
	Connect(_positionZ->GetId()				, wxEVT_COMMAND_SLIDER_UPDATED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnPositionZ 		);
	
	Connect(btnColorTable->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnEditColorTable 	);
	Connect(_ckBoxXYZ->GetId()				, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleAxisXYZ	);
	Connect(_ckBoxPlane->GetId()			, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisiblePlane 	);
	Connect(_ckFreePlaneX->GetId()          , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneX);
	Connect(_ckFreePlaneY->GetId()          , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneY);
	Connect(_ckFreePlaneZ->GetId()          , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneZ);
	Connect(btnFreePlanesOrtho->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnFreePlanesOrtho	);
	Connect(_ckFreePlaneInteraction->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneInteraction );
	Connect(_cbStereo->GetId()				, wxEVT_COMMAND_COMBOBOX_SELECTED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnSetStereo 		);
	Connect(_ckBoxOutlineBox->GetId()			, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnOutlineBox 			);
	Connect(_ckBoxOutlinePlane->GetId()			, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnOutlinePlane 			);

// EED Borrame
//	Connect(_ckBoxBackGroundBlack->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnBackGroundBlack 	);
	Connect(_rdBackGroundGradient->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnBackGroundBlack 	);
	Connect(_rdBackGroundBlack->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnBackGroundBlack 	);
	Connect(_rdBackGroundWhite->GetId()	, wxEVT_COMMAND_RADIOBUTTON_SELECTED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnBackGroundBlack 	);


	Connect(_ckBoxInterpolate->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnInterpolate 		);
	Connect(_ckBoxFixAxis2D->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnFixAxis2D 		);
	Connect(_opacityAxis->GetId()			, wxEVT_COMMAND_SLIDER_UPDATED,   (wxObjectEventFunction) &wxVtkMPR3DViewCntrlPanel::OnOpacityAxis 		);
	
	wxFlexGridSizer *sizer;
	
	//	wxBoxSizer *sizer	 = new wxBoxSizer(wxVERTICAL);
	//	wxBoxSizer *sizerH4 = new wxBoxSizer(wxHORIZONTAL);
	
	//CPR: If-else statements added 30 Nov 2009
	wxFlexGridSizer *sizerV1;
	wxFlexGridSizer *sizerH4;
	wxFlexGridSizer *sizerH4a;
	wxFlexGridSizer *sizerH5;
	wxFlexGridSizer *sizerH6;
	wxFlexGridSizer *sizerH7;

	if(align)
	{
		sizer	= new wxFlexGridSizer(4);
		sizerH4 = new wxFlexGridSizer(3);

		sizerH4a = new wxFlexGridSizer(3);
		
		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T("GL"))		,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T("Color   ")),1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( _positionX 								,1,	wxGROW                 				, 0);
		sizerH4->Add( _ckFreePlaneX								,1, wxALL|wxEXPAND					 	, 0);
		sizerH4->Add( _ckBoxX     								,0,	wxALIGN_CENTER_VERTICAL|wxSHAPED	, 0);
		sizerH4->Add( _positionY 								,1,	wxGROW								, 0);
		sizerH4->Add( _ckFreePlaneY								,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( _ckBoxY     								,0,	wxALIGN_CENTER_VERTICAL|wxSHAPED	, 0);
		sizerH4->Add( _positionZ 								,1,	wxGROW								, 0);
		sizerH4->Add( _ckFreePlaneZ								,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( _ckBoxZ     								,0,	wxALIGN_CENTER_VERTICAL|wxSHAPED	, 0);

//EED 2016/02/19		
		sizerH4->Add( _ckBoxInterpolate							,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
//		sizerH4->Add( _ckBoxXYZ									,1, wxALL|wxEXPAND						, 0);
//		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
//		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);

//		sizerH4a->Add( new wxStaticText(panel, -1,_T("Axis 2D:")),1, wxALL|wxEXPAND						, 0);
		sizerH4a->Add( _ckBoxXYZ								,1, wxALL|wxEXPAND						, 0);
		sizerH4a->Add( _ckBoxFixAxis2D							,1, wxALL|wxEXPAND						, 0);
		sizerH4a->Add( _opacityAxis								,1, wxALL|wxEXPAND						, 0);

		sizerH4->Add( sizerH4a									,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
		sizerH4->Add( new wxStaticText(panel, -1,_T(" "))		,1, wxALL|wxEXPAND						, 0);
		
			
		
		sizerH5 = new wxFlexGridSizer(1);
		sizerH5->Add( new wxStaticText(panel, -1,_T("      "))	, 1, wxALL|wxEXPAND						, 0);
		sizerH5->Add( _ckBoxPlane								, 1, wxALL|wxEXPAND						, 0);		
		sizerH5->Add( new wxStaticText(panel, -1,_T("      "))	, 1, wxALL|wxEXPAND						, 0);
////EED 05Nov2012		sizerH5->Add( _ckBox_BW_Color_Plane		, 1, wxALL|wxEXPAND						, 0);
		sizerH5->Add( _ckFreePlaneInteraction 					, 1, wxALL|wxEXPAND						, 0);
		sizerH5->Add( btnFreePlanesOrtho      					, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED	, 0);
		sizerH5->Add( new wxStaticText(panel, -1,_T(" "))		, 1, wxALL|wxEXPAND						, 0);
		sizerH5->Add( btnColorTable                         	, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED	, 0);
		sizerH5->Add( new wxStaticText(panel, -1,_T(" "))		, 1, wxALL|wxEXPAND						, 0);
		sizerH5->Add( _cbStereo									, 1, wxALL|wxEXPAND						, 0);
		
		sizerH6 = new wxFlexGridSizer(1);
		sizerH6->Add( _ckBoxOutlineBox							, 1, wxALL|wxEXPAND						, 0);
		sizerH6->Add( _ckBoxOutlinePlane						, 1, wxALL|wxEXPAND						, 0);



		sizerH7 = new wxFlexGridSizer(1);
		panelH7->SetSizer(sizerH7);
		sizerH7->Add( _rdBackGroundGradient						, 1, wxALL|wxEXPAND						, 0);
		sizerH7->Add( _rdBackGroundBlack						, 1, wxALL|wxEXPAND						, 0);
		sizerH7->Add( _rdBackGroundWhite						, 1, wxALL|wxEXPAND						, 0);


		sizerH6->Add( new wxStaticText(panel, -1,_T(" "))		, 1, wxALL|wxEXPAND						, 0);
		sizerH6->Add( panelH7									, 1, wxALL|wxEXPAND						, 0);

		sizer->Add( sizerH4,  1, wxALL|wxGROW,	2);
		sizer->Add( sizerH5,  1, wxALL|wxEXPAND,2);
		sizer->Add( sizerH6,  1, wxALL|wxEXPAND,2);
			
	}	else	{
		sizer	 = new wxFlexGridSizer(1);

		sizerH4 = new wxFlexGridSizer(10);
		sizerH5 = new wxFlexGridSizer(10);
		sizerH6 = new wxFlexGridSizer(10);

		sizerH4->Add( _positionX	, 1, wxGROW                          , 0 );
		sizerH4->Add( _ckBoxX		, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED, 0 );
		sizerH4->Add( _positionY	, 1, wxGROW                          , 0 );
		sizerH4->Add( _ckBoxY		, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED, 0 );
		sizerH4->Add( _positionZ	, 1, wxGROW                          , 0 );
		sizerH4->Add( _ckBoxZ		, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED, 0 );
		sizerH4->Add( btnColorTable	, 0, wxALIGN_CENTER_VERTICAL|wxSHAPED, 0 );

		sizerH5->Add( _ckBoxXYZ									, 1, wxALL|wxEXPAND, 0);
		sizerH5->Add( _ckBoxPlane								, 1, wxALL|wxEXPAND, 0);
////EED 05Nov2012		sizerH5->Add( _ckBox_BW_Color_Plane						, 1, wxALL|wxEXPAND, 0);
		sizerH5->Add( new wxStaticText(panel, -1,_T("      "))	, 1, wxALL|wxEXPAND, 0);

		sizerH6 = new wxFlexGridSizer(10);
		sizerH6->Add( _ckFreePlaneX                            , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( new wxStaticText(panel, -1,_T(" "))      , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( _ckFreePlaneY                            , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( new wxStaticText(panel, -1,_T(" "))      , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( _ckFreePlaneZ                            , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( new wxStaticText(panel, -1,_T("  "))     , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( _ckFreePlaneInteraction                  , 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( new wxStaticText(panel, -1,_T(" "))	, 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( btnFreePlanesOrtho	, 0	, wxALIGN_CENTER_VERTICAL|wxSHAPED, 0 );
		sizerH6->Add( new wxStaticText(panel, -1,_T(" "))	, 1, wxALL|wxEXPAND, 0);
		sizerH6->Add( _cbStereo, 1, wxALL|wxEXPAND, 0);
		
		sizer->Add( sizerH4,  1, wxALL|wxGROW,	2);
		sizer->Add( sizerH5,  1, wxALL|wxEXPAND,2);
		sizer->Add( sizerH6,  1, wxALL|wxEXPAND,2);
	}

	

	
	//EED 28 sep 2006
	//	wxFlexGridSizer *sizerH6 = new wxFlexGridSizer(10);
	//	wxFlexGridSizer *sizerH7 = new wxFlexGridSizer(10);

	//	sizerH4->Add( ckBoxX		, 1, wxALL|wxEXPAND, 0);
	//	sizerH4->Add( new wxStaticText(panel, -1,"  ")			, 1, wxALL|wxEXPAND, 0);
	//	sizerH4->Add( _positionX	, 1, wxALL|wxEXPAND, 0);

	//	sizerH5->Add( ckBoxY		, 1, wxALL|wxEXPAND, 0);
	//	sizerH5->Add( new wxStaticText(panel, -1,"  ")			, 1, wxALL|wxEXPAND, 0);
	//	sizerH5->Add( _positionY	, 1, wxALL|wxEXPAND, 0);

	//	sizerH6->Add( ckBoxZ		, 1, wxALL|wxEXPAND, 0);
	//	sizerH6->Add( new wxStaticText(panel, -1,"  ")			, 1, wxALL|wxEXPAND, 0);
	//	sizerH6->Add( _positionZ	, 1, wxALL|wxEXPAND, 0);

	//	sizerH7->Add( _ckBoxXYZ		, 1, wxALL|wxEXPAND, 0);
	//	sizerH7->Add( _ckBoxPlane	, 1, wxALL|wxEXPAND, 0);

	//	sizer->Add( sizerH4			, 1, wxALL|wxEXPAND, 2);
	//	sizer->Add( sizerH5			, 1, wxALL|wxEXPAND, 2);
	//	sizer->Add( sizerH6			, 1, wxALL|wxEXPAND, 2);
	//	sizer->Add( sizerH7			, 1, wxALL|wxEXPAND, 2);

		
	//	sizerH5->Add( ckBoxX				,  1, wxALL|wxEXPAND, 0);
	//	sizerH5->Add( ckBoxY				,  1, wxALL|wxEXPAND, 0);
	//	sizerH5->Add( ckBoxZ				,  1, wxALL|wxEXPAND, 0);


		panelH7->SetAutoLayout(true);
		panelH7->Layout();


	panel->ClearBackground();
//	panel->SetSize(400,50);
	sizer->FitInside(panel);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->Layout();

	panel->SetEventHandler((wxEvtHandler*)this);
	
	//this->UpdateControlPanel();
		
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::UpdateControlPanel(bool firsttime)
{
	vtkMPRBaseData* basedata = _wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData();
	if(basedata != NULL){

		vtkImageData* img = basedata->GetImageData();
		int x0,x1,y0,y1,z0,z1;

		if(img)
		{
			img->GetExtent(x0,x1,y0,y1,z0,z1);
			_positionX->SetRange(x0,x1);
			_positionY->SetRange(y0,y1);
			_positionZ->SetRange(z0,z1);

			if (firsttime==true)
			{
				_positionX->SetValue((x0+x1)/2);
				_positionY->SetValue((y0+y1)/2);
				_positionZ->SetValue((z0+z1)/2);
			} // if firsttime

//EED 12April2012  This make a floting window in MacOs and Linux with for windows			
//			_positionX->Update();
//			_positionY->Update();
//			_positionZ->Update();
//			this->Update();
		}//img
		
	}//basedata 
	
}

//-------------------------------------------------------------------
wxVtkMPR3DViewCntrlPanel::~wxVtkMPR3DViewCntrlPanel()
{
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::Refresh()
{
//	wxPanel::Refresh();
	_positionX->SetValue( (int)(_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX( )) );
	_positionY->SetValue( (int)(_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY( )) );
	_positionZ->SetValue( (int)(_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ( )) );
}

/*
//-------------------------------------------------------------------
int wxVtkMPR3DViewCntrlPanel::GetIdTissue()
{
	int idTissue=-1;
	if (_surfA->GetValue()==true)
	{
		idTissue=0;
	}
	if (_surfB->GetValue()==true)
	{
		idTissue=1;
	}
	if (_surfC->GetValue()==true)
	{
		idTissue=2;
	}
	if (_surfD->GetValue()==true)
	{
		idTissue=3;
	}

	return idTissue;
}
*/

//-------------------------------------------------------------------
//void wxVtkMPR3DViewCntrlPanel::On_BW_Color_Plane(wxCommandEvent& event)
//{
//	printf ("EED wxVtkMPR3DViewCntrlPanel::On_BW_Color_Plane  ...... NOT Implemented\n ");
//}


//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnEditColorTable(wxCommandEvent& event)
{
	
	vtkImageData *imagedata	= this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetImageData();

	if ( imagedata->GetScalarType()!=VTK_UNSIGNED_SHORT )
	{
		wxMessageDialog windowMessage1(NULL,_T("This option is just available for UNSIGNED SHORT images."), _T("Alert !"), wxOK);
		windowMessage1.ShowModal();
		return;
	}
	
	vtkColorTransferFunction *ctfun			= this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetvtkColorTransferFunction(); 
	std::vector<double> *ctfunVectorPoint	= this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetctFunVectorPoint();
	std::vector<double> *ctfunVectorRed		= this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetctFunVectorRed();
	std::vector<double> *ctfunVectorGreen	= this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetctFunVectorGreen();
	std::vector<double> *ctfunVectorBlue	=   this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetctFunVectorBlue();

	//void *p=this->_wxvtkmpr3Dview->GetVtkMPR3DDataViewer(); // JPRx


	int i=0,xi,r,g,b;
	
	HistogramDialog* hDlg=new HistogramDialog(NULL,_T("Color table"),imagedata,2);
	
		
	hDlg->erasePointsTransferenceFunction();		
	int ctfSize=ctfunVectorRed->size();
	if(ctfSize>0)
	{
// MACHETE  OJO Eduardo
		int i=0;
			while(i<ctfSize)
			{
				double gr	= (*ctfunVectorPoint)[i];
				double r	= (*ctfunVectorRed)[i];
				double g	= (*ctfunVectorGreen)[i];
				double b	= (*ctfunVectorBlue)[i];			

				hDlg->addColorPoint(gr,(int)(r*255),(int)(g*255),(int)(b*255));

				i++;
			}
	}

	//
	// when the user had changed the transference Function
	//
	
	//setting variables if the user wants to do refresh
	
	hDlg->setCTF(ctfun);
	//hDlg->setMPR3Dview(_wxvtkmpr3Dview);
	
	if(hDlg->ShowModal()== wxID_OK )
	{	
		
		// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();
			//clean colors
			ctfunVectorPoint->clear();
			ctfunVectorRed->clear();
			ctfunVectorGreen->clear();
			ctfunVectorBlue->clear();

			int nCTFpoints=hDlg->getSizeBarColor();
// Machete .. Ojo Eduardo
			i=0;	
			while(i<nCTFpoints)
			{
				hDlg->getDataBarColorPoint(i,xi,r,g,b);
				/*
				if (i==0)
				{
					hDlg->getDataBarColorPoint(1,xi,r,g,b);
				} 
				if (i==nCTFpoints)
				{
					hDlg->getDataBarColorPoint(i-1,xi,r,g,b);
				} 
				*/
				ctfun->AddRGBPoint(xi,r/255.0,g/255.0,b/255.0 );
				ctfunVectorPoint->push_back(xi);
				ctfunVectorRed->push_back(r/255.0);
				ctfunVectorGreen->push_back(g/255.0);
				ctfunVectorBlue->push_back(b/255.0);
				i++;
				
			}
			
	}
	
	else
	{
		
		if(hDlg->getRefreshed())
		{
			// -- vtkColorTransferFunction  --
			ctfun->RemoveAllPoints ();
			
			int i=0;
			int size=ctfunVectorPoint->size();
			
			for(i=0;i<size;i++)
			{
				double grey2=(*ctfunVectorPoint)[i];
				double red =(*ctfunVectorRed)[i];
				double green =(*ctfunVectorGreen)[i];
				double blue = (*ctfunVectorBlue)[i];
				ctfun->AddRGBPoint(grey2,red,green,blue);
			}
		 }	
		 
	}

 hDlg->Destroy();
}


//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneX(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->FreePlaneVisible( 1, event.IsChecked() );
	_wxvtkmpr3Dview->FreePlaneInteraction( _ckFreePlaneInteraction->GetValue() );
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneY(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->FreePlaneVisible(  2, event.IsChecked() );
	_wxvtkmpr3Dview->FreePlaneInteraction( _ckFreePlaneInteraction->GetValue() );
}


//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneZ(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->FreePlaneVisible(  3, event.IsChecked() );
	_wxvtkmpr3Dview->FreePlaneInteraction( _ckFreePlaneInteraction->GetValue() );
}


//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleFreePlaneInteraction(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->FreePlaneInteraction(  event.IsChecked() );
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnFreePlanesOrtho(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->SetFreePlanesOrtho();
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnSetStereo(wxCommandEvent& event)
{
	this->_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->SetStereo( _cbStereo->GetSelection()  );
}



//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleAxisX(wxCommandEvent& event)
{	
	_wxvtkmpr3Dview->VisibleImageActor(0, event.IsChecked() );
	_wxvtkmpr3Dview->Refresh();
	
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh

	try{
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 		_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 		_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
	}catch(char* e){
		std::cout<<e<<std::endl;
	}
}
//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleAxisY(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->VisibleImageActor(1, event.IsChecked() );
	_wxvtkmpr3Dview->Refresh();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}
//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleAxisZ(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->VisibleImageActor(2, event.IsChecked() );
	_wxvtkmpr3Dview->Refresh();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisibleAxisXYZ(wxCommandEvent& event)
{

	_wxvtkmpr3Dview->VisiblePointWidget(event.IsChecked());
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnVisiblePlane(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->VisiblePlaneWidget(event.IsChecked());
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnPositionX(wxScrollEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetX( _positionX->GetValue() );
	_wxvtkmpr3Dview->RefreshView();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}
//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnPositionY(wxScrollEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetY( _positionY->GetValue() );
	_wxvtkmpr3Dview->RefreshView();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}
//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnPositionZ(wxScrollEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetZ( _positionZ->GetValue() );
	_wxvtkmpr3Dview->RefreshView();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}



//-------------------------------------------------------------------
bool wxVtkMPR3DViewCntrlPanel::GetVisibleX()
{
	return _ckBoxX->GetValue();
}

//-------------------------------------------------------------------
bool wxVtkMPR3DViewCntrlPanel::GetVisibleY()
{
	return _ckBoxY->GetValue();
}

//-------------------------------------------------------------------
bool wxVtkMPR3DViewCntrlPanel::GetVisibleZ()
{
	return _ckBoxZ->GetValue();
}

//-------------------------------------------------------------------
bool wxVtkMPR3DViewCntrlPanel::GetVisibleXYZ()
{
	return _ckBoxXYZ->GetValue();
}

//-------------------------------------------------------------------
////EED 05Nov2012
//bool wxVtkMPR3DViewCntrlPanel::Get_BW_Color_Plane()
//{
//	return _ckBox_BW_Color_Plane;
//}

//-------------------------------------------------------------------
bool wxVtkMPR3DViewCntrlPanel::GetVisiblePlane()
{
	return _ckBoxPlane->GetValue();
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::SetVisibleX(bool value)
{
	_ckBoxX->SetValue(value);
	
	_wxvtkmpr3Dview->VisibleImageActor(0, value );
	_wxvtkmpr3Dview->Refresh();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::SetVisibleY(bool value)
{
	_ckBoxY->SetValue(value);
	
	_wxvtkmpr3Dview->VisibleImageActor(1, value );
	_wxvtkmpr3Dview->Refresh();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::SetVisibleZ(bool value)
{
	_ckBoxZ->SetValue(value);

	_wxvtkmpr3Dview->VisibleImageActor(2, value );
	_wxvtkmpr3Dview->Refresh();

	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::SetVisibleXYZ(bool value)
{
	_ckBoxXYZ->SetValue(value);
	_wxvtkmpr3Dview->VisiblePointWidget(value);

}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::SetVisiblePlane(bool value)
{
	_ckBoxPlane->SetValue(value);
	_wxvtkmpr3Dview->VisiblePlaneWidget(value);
}


//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnOutlineBox(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->showOutlineBoxActor( _ckBoxOutlineBox->GetValue() );
	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->Refresh();
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnOutlinePlane(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->showOutlinePlaneActor( _ckBoxOutlinePlane->GetValue() );
	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->Refresh();
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnBackGroundBlack(wxCommandEvent& event)
{
//EED Borrame
//	if (_ckBoxBackGroundBlack->GetValue()==true)
//	{
//		_wxvtkmpr3Dview->SetBackGroundType(0);
//	} else {
//		_wxvtkmpr3Dview->SetBackGroundType(1);
//	}
	
	if (_rdBackGroundGradient->GetValue()==true) {
		_wxvtkmpr3Dview->SetBackGroundType(0);
	} else if (_rdBackGroundBlack->GetValue()==true) {
		_wxvtkmpr3Dview->SetBackGroundType(1);
	} else if (_rdBackGroundWhite->GetValue()==true) {
		_wxvtkmpr3Dview->SetBackGroundType(2);
	}
	
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnInterpolate(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetInterpolate(	_ckBoxInterpolate->GetValue() );
	_wxvtkmpr3Dview->Refresh();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh	
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnFixAxis2D(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetFixAxis2D(	_ckBoxFixAxis2D->GetValue() );
	_wxvtkmpr3Dview->Refresh();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif
}

//-------------------------------------------------------------------
void wxVtkMPR3DViewCntrlPanel::OnOpacityAxis(wxCommandEvent& event)
{
	_wxvtkmpr3Dview->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->SetOpacityAxis(	_opacityAxis->GetValue()/100.0 );
	_wxvtkmpr3Dview->Refresh();
	wxCommandEvent newevent1(wxEVT_COMMAND_MENU_SELECTED,12121); // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessEvent(newevent1);
#else
 	_wxvtkmpr3Dview->GetWxvtk3Dbaseview()->GetWxVTKRenderWindowInteractor()->GetParent()->ProcessWindowEvent(newevent1);
#endif	
}


