/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxWidgetMesure2D.h"


/*
BEGIN_EVENT_TABLE( wxWidgetMesure2D , wxSplitterWindow )
	EVT_MENU( 12121, wxWidgetMesure2D::OnRefreshView )
END_EVENT_TABLE( );
*/
//-------------------------------------------------------------------

wxWidgetMesure2D::wxWidgetMesure2D( wxWindow *parent )
: wxSplitterWindow( parent , -1)
{
// EED 27 oct 2007
	this->SplitHorizontally( new wxPanel(this,-1) ,  new wxPanel(this,-1), 2 );
	this->SetMinimumPaneSize(50);
}
//-------------------------------------------------------------------
wxWidgetMesure2D::~wxWidgetMesure2D()
{
}
//-------------------------------------------------------------------
wxWindow *wxWidgetMesure2D::CreateWin1a(wxWindow *parent) // virtual
{
	wxPanel *panel = new wxPanel(parent,-1);

	_cb_messuretool	 = new wxCheckBox(panel,-1,_T("Active messure tool     ")); 
	_cb_mt_visible	 = new wxCheckBox(panel,-1,_T("Visibles    ")); 
	_cb_closeContour = new wxCheckBox(panel,-1,_T("Close/Open    ")); 
	_cb_visibleText	 = new wxCheckBox(panel,-1,_T("Information    ")); 

	_cb_mt_visible->SetValue(true);
	_cb_closeContour->SetValue(true);
	_cb_visibleText->SetValue(true);

	wxFlexGridSizer *sizer = new wxFlexGridSizer(4);

	sizer->Add(_cb_messuretool);
	sizer->Add(_cb_mt_visible);
	sizer->Add(_cb_closeContour);
	sizer->Add(_cb_visibleText);

	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->SetSize(400,30);
	panel->Layout();
//EEDxx2.4
//	panel->FitInside();

	Connect(_cb_messuretool->GetId()  , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D::OnActiveMessureTool	);
	Connect(_cb_mt_visible->GetId()	  , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D::OnVisibleMessureTool	);
	Connect(_cb_closeContour->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D::OnCloseContour		);
	Connect(_cb_visibleText->GetId()  , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D::OnVisibleInformation	);

	return panel;
}

//-------------------------------------------------------------------
void wxWidgetMesure2D::ConfigureA(wxVtk2DBaseView *wxvtk2Dbaseview) // virtual
{
	_wxvtk2Dbaseview = wxvtk2Dbaseview;

	// Contorno 1
	_manContourControl_1	= new manualContourControler();
	_mContourModel_1		= new manualContourModel();
	_mViewContour_1			= new manualViewContour();
	_mViewContour_1->SetModel( _mContourModel_1 );
	_mViewContour_1->SetWxVtkBaseView( _wxvtk2Dbaseview );
	_mViewContour_1->SetRange( 1 );

// EED 3 oct 2006
//	double spc[3];
//	_wxvtk2Dbaseview->GetSpacing( spc );
//	_mViewContour_1->SetSpacing( spc );



	_manContourControl_1->SetZ( 1000 );
	_manContourControl_1->SetModelView( _mContourModel_1 , _mViewContour_1 );
	((vtkInteractorStyleBaseView*)_wxvtk2Dbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_1 );
	_manContourControl_1->CreateNewManualContour();
	_manContourControl_1->SetActive( false );
	_mViewContour_1->RefreshContour();

//EED 27 Oct 2007
	
//	this->ReplaceWindow( this->GetWindow1() ,  CreateWin1a(this) );
//	this->ReplaceWindow( this->GetWindow2() ,  _wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor() );
//	CreateWin1a(this->GetWindow1() );

	wxBoxSizer *sizerA = new wxBoxSizer(wxHORIZONTAL);	
	sizerA->Add(  CreateWin1a( this->GetWindow1()) ,1, wxGROW );
	this->GetWindow1()->SetSizer(sizerA);
	this->SetAutoLayout(true);
	this->Layout();

	wxBoxSizer *sizerB = new wxBoxSizer(wxHORIZONTAL);	
	sizerB->Add(  _wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor()  ,1, wxGROW );
	this->GetWindow2()->SetSizer(sizerB);
	this->SetAutoLayout(true);
	this->Layout();


//	this->SplitHorizontally( CreateWin1a(this) , _wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor() , 2 );


//EEDxx2.4 
//	this->FitInside();
}


//-------------------------------------------------------------------
void wxWidgetMesure2D::ActiveMessureTool(bool ok)
{
	((vtkInteractorStyleBaseView*)_wxvtk2Dbaseview->GetInteractorStyleBaseView())->SetActiveAllInteractors(!ok);
	_manContourControl_1->SetActive( ok );
}

//-------------------------------------------------------------------
void wxWidgetMesure2D::OnActiveMessureTool(wxCommandEvent& event)
{
	ActiveMessureTool( _cb_messuretool->GetValue() );
	if ( _cb_messuretool->GetValue() == true )
	{
		_cb_mt_visible->SetValue(true);
		_mViewContour_1->SetVisible( _cb_mt_visible->GetValue() );
		_cb_closeContour->Enable(true);
		_cb_visibleText->Enable(true);
	} else{
		_cb_closeContour->Enable(false);
		_cb_visibleText->Enable(false);
	}
	_wxvtk2Dbaseview->Refresh();
	_wxvtk2Dbaseview->RefreshView();
}

//-------------------------------------------------------------------
void wxWidgetMesure2D::OnVisibleMessureTool(wxCommandEvent& event)
{
	_cb_messuretool->SetValue( _cb_mt_visible->GetValue() );
	if (_cb_messuretool->GetValue()==true)
	{
		_cb_closeContour->Enable(true);
		_cb_visibleText->Enable(true);
	}
	ActiveMessureTool( _cb_messuretool->GetValue() );	
	_mViewContour_1->SetVisible( _cb_mt_visible->GetValue() );
	_mViewContour_1->Refresh();
	_wxvtk2Dbaseview->Refresh();
	_wxvtk2Dbaseview->RefreshView();
}

//-------------------------------------------------------------------
void wxWidgetMesure2D::OnCloseContour(wxCommandEvent& event)
{
	_mContourModel_1->SetCloseContour( _cb_closeContour->GetValue() );
	_mViewContour_1->Refresh();
	_wxvtk2Dbaseview->Refresh();
	_wxvtk2Dbaseview->RefreshView();

}
//-------------------------------------------------------------------
void wxWidgetMesure2D::OnVisibleInformation(wxCommandEvent& event)
{
	_mViewContour_1->SetShowText( _cb_visibleText->GetValue() );
	_mViewContour_1->Refresh();
	_wxvtk2Dbaseview->Refresh();
	_wxvtk2Dbaseview->RefreshView();
}
//-------------------------------------------------------------------
manualContourModel*	wxWidgetMesure2D::GetManualContourModel()
{
	return _mContourModel_1;
}
