/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxWidgetMesure2D_Plane.h"

#include "vtkPlane2DView.h"

wxWidgetMesure2D_Plane::wxWidgetMesure2D_Plane(wxWindow *parent)
: wxWidgetMesure2D(parent)
{
	// Circle 1
	_ptsCircle1		= NULL;
	_circle1Actor	= NULL;
	_circle1Mapper	= NULL;
    _pdCircle1		= NULL;
	// Circle 2
	_ptsCircle2		= NULL;
	_circle2Actor	= NULL;
	_circle2Mapper	= NULL;
    _pdCircle2		= NULL;
	// line reference 1
	_ptsLineRef1	= NULL;
	_lineRef1Actor	= NULL;
	_lineRef1Mapper	= NULL;
    _pdLineRef1		= NULL;
	// line reference 2
	_ptsLineRef2	= NULL;
	_lineRef2Actor	= NULL;
	_lineRef2Mapper = NULL;
    _pdLineRef2		= NULL;

}

//-------------------------------------------------------------------

wxWidgetMesure2D_Plane::~wxWidgetMesure2D_Plane()
{
	// Circle 1
    if (	_ptsCircle1		!= NULL){	_ptsCircle1			-> Delete(); }
    if (	_circle1Actor	!= NULL){	_circle1Actor		-> Delete(); }
    if (	_circle1Mapper	!= NULL){	_circle1Mapper		-> Delete(); }
    if (    _pdCircle1		!= NULL){	_pdCircle1			-> Delete(); }
	// Circle 2
    if (	_ptsCircle2		!= NULL){	_ptsCircle2			-> Delete(); }
    if (	_circle2Actor	!= NULL){	_circle2Actor		-> Delete(); }
    if (	_circle2Mapper	!= NULL){	_circle2Mapper		-> Delete(); }
    if (    _pdCircle2		!= NULL){	_pdCircle2			-> Delete(); }
	// line reference 1
    if (	_ptsLineRef1	!= NULL){	_ptsLineRef1		-> Delete(); }
    if (	_lineRef1Actor	!= NULL){	_lineRef1Actor		-> Delete(); }
    if (	_lineRef1Mapper	!= NULL){	_lineRef1Mapper		-> Delete(); }
     if (   _pdLineRef1		!= NULL){	_pdLineRef1			-> Delete(); }
	// line reference 2
    if (	_ptsLineRef2	!= NULL){	_ptsLineRef2		-> Delete(); }
    if (	_lineRef2Actor	!= NULL){	_lineRef2Actor		-> Delete(); }
    if (	_lineRef2Mapper != NULL){	_lineRef2Mapper		-> Delete(); }
    if (    _pdLineRef2		!= NULL){	_pdLineRef2			-> Delete(); }
}

//-------------------------------------------------------------------

wxWindow *wxWidgetMesure2D_Plane::CreateWin1a(wxWindow *parent) // virtual
{
	wxPanel *panel = new wxPanel(parent,-1);

	_cb_circle		= new wxCheckBox(panel,-1,_T("Circle        ")); 
	_cb_line		= new wxCheckBox(panel,-1,_T("Rotation Axe ")); 


	wxBoxSizer *sizerA = new wxBoxSizer(wxHORIZONTAL);
	sizerA->Add(_cb_circle);
	sizerA->Add(_cb_line);


	wxFlexGridSizer *sizer = new wxFlexGridSizer(1);
	sizer->Add( sizerA );
	sizer->Add( wxWidgetMesure2D::CreateWin1a(panel) );

	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->SetSize(400,30);
	panel->Layout();
//EEDxx2.4
//	panel->FitInside();

	Connect(_cb_line->GetId()        , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D_Plane::OnActiveLine			);
	Connect(_cb_circle->GetId()      , wxEVT_COMMAND_CHECKBOX_CLICKED	  , (wxObjectEventFunction) &wxWidgetMesure2D_Plane::OnActiveCirlcle		);

	return panel;
}


//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::OnActiveCirlcle(wxCommandEvent& event)
{
	SetVisibleCircle( _cb_circle->GetValue() );
	_wxvtk2Dbaseview->RefreshView();
}

//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::SetVisibleCircle( bool ok )
{
	double opacity;
	if (ok==true)
	{
		opacity=1;
	} else {
		opacity=0;
	} 
	_lineRef1Actor->GetProperty()->SetOpacity( opacity );
	_lineRef2Actor->GetProperty()->SetOpacity( opacity );
	_circle1Actor->GetProperty()->SetOpacity( opacity );
	_circle2Actor->GetProperty()->SetOpacity( opacity );
}
//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::OnActiveLine(wxCommandEvent& event)
{
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)_wxvtk2Dbaseview;
	vtkplane2Dview->SetVisibleLine( _cb_line->GetValue() );
	_wxvtk2Dbaseview->RefreshView();
}


//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::ConfigureA(wxVtk2DBaseView *wxvtk2Dbaseview) // virtual
{
	wxWidgetMesure2D::ConfigureA(wxvtk2Dbaseview);
	CircleLine();
	ConfigureCircleLine();
	SetVisibleCircle(false);	
}


//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::ConfigureCircleLine()
{
	double ang;

	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)_wxvtk2Dbaseview;
	int sizeIma = vtkplane2Dview->GetImgSize();

	double i,maxPts=20;
	double k=(360/(maxPts-1)) * (3.1416/180);
	double x,y,r1=5,r2=10,r3=15;
	for (i=0;i<maxPts;i++)
	{
		x=cos( k*i ) ;
		y=sin( k*i ) ;
		_ptsCircle1->SetPoint( (int)i , (sizeIma/2) + x*r1	, (sizeIma/2) + y*r1	, 1 );
		_ptsCircle2->SetPoint( (int)i , (sizeIma/2) + x*r2	, (sizeIma/2) + y*r2	, 1 );
	}

	//
	ang=(45) * (3.1416/180);
	x=cos( ang ) ;
	y=sin( ang ) ;
	_ptsLineRef1->SetPoint( 0 , (sizeIma/2) + x*r3	, (sizeIma/2) + y*r3	, 1 );
	
	ang=(45+180) * (3.1416/180);
	x=cos( ang ) ;
	y=sin( ang ) ;
	_ptsLineRef1->SetPoint( 1 , (sizeIma/2) + x*r3	, (sizeIma/2) + y*r3	, 1 );

	//
	ang=(135) * (3.1416/180);
	x=cos( ang ) ;
	y=sin( ang ) ;
	_ptsLineRef2->SetPoint( 0 , (sizeIma/2) + x*r3	, (sizeIma/2) + y*r3	, 1 );
	
	ang=(135+180) * (3.1416/180);
	x=cos( ang ) ;
	y=sin( ang ) ;
	_ptsLineRef2->SetPoint( 1 , (sizeIma/2) + x*r3	, (sizeIma/2) + y*r3	, 1 );
}



//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane::CircleLine()
{
	int i,maxPts=20;
	vtkCellArray *lines;

	vtkImageViewer2_XYZ *imageViewer2XYZ = _wxvtk2Dbaseview->_imageViewer2XYZ;
	

// Circle 1 Horizontal
	_ptsCircle1 = vtkPoints::New();
	_ptsCircle1->SetNumberOfPoints(maxPts);
	lines = vtkCellArray::New();
	lines->InsertNextCell(maxPts);
	for (i=0;i<maxPts;i++)
	{
		lines->InsertCellPoint(i);
		_ptsCircle1->SetPoint(i, 0	, 0	, 0 );
	}
	lines->InsertCellPoint(0);
	_ptsCircle1->SetPoint(0, -1000	, -1000	, -1000 );
	_ptsCircle1->SetPoint(1,  1000	,  1000	,  1000	);

	_pdCircle1 = vtkPolyData::New();
    _pdCircle1->SetPoints( _ptsCircle1 );
    _pdCircle1->SetLines( lines );
	lines->Delete();  //do not delete lines ??
	_circle1Actor					=	vtkActor::New();
    _circle1Mapper					=	vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_circle1Mapper->SetInput(_pdCircle1);
	_circle1Mapper->ImmediateModeRenderingOn();
#else
	_circle1Mapper->SetInputData(_pdCircle1);
#endif
	_circle1Actor->SetMapper(_circle1Mapper);
	_circle1Actor->GetProperty()->BackfaceCullingOn();
	_circle1Actor->GetProperty()->SetDiffuseColor(0,0,1);
	_circle1Actor->GetProperty()->SetLineWidth(2);
    imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _circle1Actor );

// Circle 2 Horizontal
	_ptsCircle2 = vtkPoints::New();
	_ptsCircle2->SetNumberOfPoints(maxPts);
	lines = vtkCellArray::New();
	lines->InsertNextCell(maxPts);
	for (i=0;i<maxPts;i++)
	{
		lines->InsertCellPoint(i);
		_ptsCircle2->SetPoint(i, 0	, 0	, 0 );
	}
	_ptsCircle2->SetPoint(0, -1000	, -1000	, -1000 );
	_ptsCircle2->SetPoint(1,  1000	,  1000	,  1000	);

	_pdCircle2 = vtkPolyData::New();
    _pdCircle2->SetPoints( _ptsCircle2 );
    _pdCircle2->SetLines( lines );
	lines->Delete();  //do not delete lines ??
	_circle2Actor					=	vtkActor::New();
    _circle2Mapper					=	vtkPolyDataMapper::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_circle2Mapper->SetInput(_pdCircle2);
	_circle2Mapper->ImmediateModeRenderingOn();
#else
	_circle2Mapper->SetInputData(_pdCircle2);
#endif
	_circle2Actor->SetMapper(_circle2Mapper);
	_circle2Actor->GetProperty()->BackfaceCullingOn();
	_circle2Actor->GetProperty()->SetDiffuseColor(0,0,1);
	_circle2Actor->GetProperty()->SetLineWidth(2);
    imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _circle2Actor );

// Line Referance 1
	_ptsLineRef1 = vtkPoints::New();
	_ptsLineRef1->SetNumberOfPoints(2);
	_ptsLineRef1->SetPoint(0, -1000	, -1000	, -1000 );
	_ptsLineRef1->SetPoint(1,  1000	,  1000	,  1000	);
	lines = vtkCellArray::New();
	lines->InsertNextCell(2);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(1);

	_pdLineRef1 = vtkPolyData::New();
    _pdLineRef1->SetPoints( _ptsLineRef1 );
    _pdLineRef1->SetLines( lines );
	lines->Delete();  //do not delete lines ??
	_lineRef1Actor					=	vtkActor::New();
    _lineRef1Mapper					=	vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_lineRef1Mapper->SetInput(_pdLineRef1);
	_lineRef1Mapper->ImmediateModeRenderingOn();
#else
	_lineRef1Mapper->SetInputData(_pdLineRef1);
#endif

	_lineRef1Actor->SetMapper(_lineRef1Mapper);
	_lineRef1Actor->GetProperty()->BackfaceCullingOn();
	_lineRef1Actor->GetProperty()->SetDiffuseColor(0,0,1);
	_lineRef1Actor->GetProperty()->SetLineWidth(2);
    imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineRef1Actor );

// Line Referance 2
	_ptsLineRef2 = vtkPoints::New();
	_ptsLineRef2->SetNumberOfPoints(2);
	_ptsLineRef2->SetPoint(0, -1000	, -1000	, -1000 );
	_ptsLineRef2->SetPoint(1,  1000	,  1000	,  1000	);
	lines = vtkCellArray::New();
	lines->InsertNextCell(2);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(1);

	_pdLineRef2 = vtkPolyData::New();
    _pdLineRef2->SetPoints( _ptsLineRef2 );
    _pdLineRef2->SetLines( lines );
	lines->Delete();  //do not delete lines ??
	_lineRef2Actor					=	vtkActor::New();
    _lineRef2Mapper					=	vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_lineRef2Mapper->SetInput(_pdLineRef2);
	_lineRef2Mapper->ImmediateModeRenderingOn();
#else
	_lineRef2Mapper->SetInputData(_pdLineRef2);
#endif

	_lineRef2Actor->SetMapper(_lineRef2Mapper);
	_lineRef2Actor->GetProperty()->BackfaceCullingOn();
	_lineRef2Actor->GetProperty()->SetDiffuseColor(0,0,1);
	_lineRef2Actor->GetProperty()->SetLineWidth(2);
    imageViewer2XYZ->GetVtkImageViewer2()->GetRenderer()->AddActor( _lineRef2Actor );


}

