/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxWidgetMesure2D_Plane_in_MPR.h"

wxWidgetMesure2D_Plane_in_MPR::wxWidgetMesure2D_Plane_in_MPR(wxWindow *parent)
:wxWidgetMesure2D_Plane(parent)
{
	_vtkplane2Dview=NULL;
}

//-------------------------------------------------------------------

wxWidgetMesure2D_Plane_in_MPR::~wxWidgetMesure2D_Plane_in_MPR()
{
}
//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane_in_MPR::OnActiveLink(wxCommandEvent& event)
{
	if (_vtkplane2Dview!=NULL)
	{
		_vtkplane2Dview->SetActive( _cb_link->GetValue() );
		_vtkplane2Dview->Refresh();
		_vtkplane2Dview->RefreshView();
	}
}


//-------------------------------------------------------------------
void wxWidgetMesure2D_Plane_in_MPR::SetActiveLink(bool ok)
{
	_cb_link->SetValue(ok);
	if (_vtkplane2Dview!=NULL)
	{
		_vtkplane2Dview->SetActive( _cb_link->GetValue() );
	}
}
//-------------------------------------------------------------------

void wxWidgetMesure2D_Plane_in_MPR::SetVtkPlane2DView(vtkPlane2DView *vtkplane2Dview)
{
	_vtkplane2Dview = vtkplane2Dview;
}

//-------------------------------------------------------------------

wxWindow *wxWidgetMesure2D_Plane_in_MPR::CreateWin1a(wxWindow *parent) // virtual
{
	wxPanel *panel = new wxPanel(parent,-1);

	_cb_link		= new wxCheckBox(panel,-1,_T("LINK                    ")); 
	_cb_link->SetValue(true);

	wxFlexGridSizer *sizer = new wxFlexGridSizer(1);

	sizer->Add(_cb_link);

	sizer->Add( wxWidgetMesure2D_Plane::CreateWin1a(panel) );

	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->SetSize(400,30);
	panel->Layout();

//EEDxx2.4
//	panel->FitInside();

	Connect(_cb_link->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxWidgetMesure2D_Plane_in_MPR::OnActiveLink );

	return panel;
}

