/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasMPR.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:51 $
  Version:   $Revision: 1.5 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasMPR.h"


wxMaracasMPR::wxMaracasMPR( wxWindow* parent,
                            marImageData* marimagedata )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
	_MPR=NULL;
	wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
	_MPR = new wxMPRWidget( this, marimagedata);
	szTop->Add( _MPR, 1  , wxGROW |  wxALL , 0 );
	this->SetAutoLayout( true );
	this->SetSizer( szTop );
	szTop->Fit( this );
//	szTop->SetSizeHints( this );
}
//----------------------------------------------------------------------------
wxMaracasMPR::~wxMaracasMPR( )
{
	if (_MPR!=NULL) { delete _MPR; }
}
//----------------------------------------------------------------------------
void wxMaracasMPR::ConfigureVTK( )
{
	if (_MPR!=NULL ) {_MPR->ConfigureVTK(); }
}
//----------------------------------------------------------------------------
vtkMPRBaseData  *wxMaracasMPR::GetVtkMPRBaseData()
{
	return _MPR->GetVtkMPRBaseData();
}
//----------------------------------------------------------------------------
vtkPlane2DView *wxMaracasMPR::GetVtkPlane2DView()
{
	return _MPR->GetVtkPlane2DView();
}

//----------------------------------------------------------------------------
// EED 2022-08-04	throw
//wxVtkMPR3DView  *wxMaracasMPR::GetWxvtkmpr3Dview_BB() throw(char*)
wxVtkMPR3DView  *wxMaracasMPR::GetWxvtkmpr3Dview_BB()
{ 
	try {
		if(_MPR == NULL){ 
		    throw "wxVtkMPR3DView  *wxMaracasMPR::GetWxvtkmpr3Dview_BB() _MPR =NULL";
		}
		if(_MPR->GetWxvtkmpr3Dview_BB() ==NULL){
			throw "wxVtkMPR3DView  *wxMaracasMPR::GetWxvtkmpr3Dview_BB() _MPR->GetWxvtkmpr3Dview_BB()=NULL";
		}
		return _MPR->GetWxvtkmpr3Dview_BB();
	} catch (...) {
	  throw ;
	}
}

//----------------------------------------------------------------------------
void wxMaracasMPR::RefreshView()
{ 
	_MPR->RefreshView();
}

void wxMaracasMPR::setImageData(vtkImageData *img, double voxelsize)
{
	_MPR->setImageData( img) ;

}

// EOF - wxMaracasMPR.cxx




