/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "PlaneDirectionManager.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

PlaneDirectionManager::PlaneDirectionManager(int radio, double colour[3] , int opacity){	
	_radio = radio;
	_colour = colour;
	_opacity = opacity;
}


PlaneDirectionManager::~PlaneDirectionManager(){
	RemoveAllActorsFromIndex();
}

void PlaneDirectionManager::SetRenderer(vtkRenderer* render){
    _render = render;
}
void PlaneDirectionManager::SetVectors( std::vector<double> lstPointsx, std::vector<double> lstPointsy, std::vector<double> lstPointsz){	

	_lstPointsx = lstPointsx;
	_lstPointsy = lstPointsy;
	_lstPointsz = lstPointsz;
}

// EED 2022-08-04	throw
//void PlaneDirectionManager::UpdateDirections() throw (std::exception)
void PlaneDirectionManager::UpdateDirections() 
{
	try {
		UpdateVectors();
		UpdateActors();
		AddActors();
	} catch (...) {
	  throw ;
	}
}

void PlaneDirectionManager::AddActors(){
	int i;
    for(i = 0; i < (int)_vectdata.size();i++){
		_render->AddViewProp (_vectdata[i]->GetActor());		
	}
}

// EED 2022-08-04	throw
//void PlaneDirectionManager::RemoveAllActorsFromIndex(int n)throw (std::exception)
void PlaneDirectionManager::RemoveAllActorsFromIndex(int n)
{
	try{
		/*due to incompleate set of points to create the plane
		*/				
		if(_render==NULL){
			throw std::exception();
		}
		for(int i = _vectdata.size()-1; i >= n;i--){
			_render->RemoveViewProp(_vectdata[i]->GetActor());
			delete _vectdata[i];
			_vectdata.pop_back();
		}	
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void PlaneDirectionManager::UpdateVectors()throw (std::exception)
void PlaneDirectionManager::UpdateVectors()
{
	try{
		PlaneDirectionManagerData* temp;
		bool deletelast = false;
		int currentdata = 0;
		int i;
		for(i = 0; i < (int)_lstPointsx.size();i++){
			if(i % 3 == 0){	
				if((int)_vectdata.size()>currentdata){
					temp = _vectdata[currentdata];
				}else{
					temp = new PlaneDirectionManagerData(_radio, _colour, _opacity);
					_vectdata.push_back(temp);
				}
				temp->setPoint0(_lstPointsx[i],_lstPointsy[i],_lstPointsz[i]);
				deletelast = true;
			}else if(i % 3 == 1){
		        temp->setPoint1(_lstPointsx[i],_lstPointsy[i],_lstPointsz[i]);			
			}else if(i % 3 == 2){
				temp->setPoint2(_lstPointsx[i],_lstPointsy[i],_lstPointsz[i]);						
				currentdata++;
				deletelast = false;
			}
		}
		RemoveAllActorsFromIndex(currentdata);
	} catch (...) {
	  throw ;
	}
}

void PlaneDirectionManager::UpdateActors()
{
	int i;
    for(i = 0; i < (int)_vectdata.size();i++)
	{
		_vectdata[i]->UpdateActor();
	}
}

void PlaneDirectionManager::addRemoveActor(int index, bool addremove)
{
	if(index < (int)_vectdata.size()){
		if(addremove){
			_render->AddViewProp (_vectdata[index]->GetActor());
		}else{
			_render->RemoveViewProp (_vectdata[index]->GetActor());
		}	
	}	
}

void PlaneDirectionManager::changeColor(int index,double r,double g,double b)
{
    GetPlaneDirectionManagerData(index)->ChangeColour(r,g,b);
}

PlaneDirectionManagerData* PlaneDirectionManager::GetPlaneDirectionManagerData(int id) 
{
	return _vectdata[id];
}

void PlaneDirectionManager::WriteInformation(std::string  filename, double* spc){
	FILE *ff;	
	ff = fopen( filename.c_str() , "w+" );
	if(spc ==NULL){
		spc = new double[3];
		spc[0] = 1;
		spc[1] = 1;
		spc[2] = 1;
	}
	if (ff!=NULL)
	{	    
		int i;
		for(i = 0; i < (int)_vectdata.size();i++){

			double* p0 = _vectdata[i]->getPoint0();
			double* p1 = _vectdata[i]->getPoint1();
			double* p2 = _vectdata[i]->getPoint2();
			double* dir = _vectdata[i]->GetDirection();

			double p0x = p0[0]/spc[0];
			double p0y = p0[1]/spc[1];
			double p0z = p0[2]/spc[2];

			double p1x = p1[0]/spc[0];
			double p1y = p1[1]/spc[1];
			double p1z = p1[2]/spc[2];

			double p2x = p2[0]/spc[0];
			double p2y = p2[1]/spc[1];
			double p2z = p2[2]/spc[2];

			double dirx = dir[0]/spc[0];
			double diry = dir[1]/spc[1];
			double dirz = dir[2]/spc[2];

			fprintf(ff,"Dir%d\n",i);
            fprintf(ff,"\tP0[%f, %f, %f]\tP1[%f, %f, %f]\tP2[%f, %f, %f]\tDir[%f, %f, %f] \n",
							p0x,p0y,p0z,	p1x,p1y,p1z,	p2x,p2y,p2z,	dirx,diry,dirz);
		}			
		fclose(ff);
	} else {   // else ff
		printf("PlaneDirectionManager::WriteInformation  ...Error... creating file");
	} //ff	
}

void  PlaneDirectionManager::SetArrowSize(int arrowsize){
    _radio = arrowsize;
}
