/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef PlaneDirectionManager_H_
#define PlaneDirectionManager_H_

#include <math.h>
#include <iostream>
#include "PlaneDirectionManagerData.h"
#include <vector>
#include <vtkRenderer.h>

class PlaneDirectionManager  
{
public:
	PlaneDirectionManager(int radio, double colour[3], int opacity);	
	~PlaneDirectionManager();		
	void SetRenderer(vtkRenderer* render);
	void SetVectors( std::vector<double> lstPointsx, std::vector<double> lstPointsy, std::vector<double> lstPointsz);
// EED 2022-08-04	throw
//	void UpdateDirections() throw (std::exception);
	void UpdateDirections();
	std::vector<PlaneDirectionManagerData*> GetPlanesData()
	{
		return _vectdata;
	}
	void addRemoveActor(int index, bool addremove);
	void changeColor(int index,double r,double g,double b);
	PlaneDirectionManagerData* GetPlaneDirectionManagerData(int id);
	void WriteInformation(std::string  filename, double* spc=NULL);
	void SetArrowSize(int arrowsize);
private:
	std::vector<double> _lstPointsx;
	std::vector<double> _lstPointsy;
	std::vector<double> _lstPointsz;
	std::vector<PlaneDirectionManagerData*> _vectdata;
// EED 2022-08-04	throw
//	void RemoveAllActorsFromIndex(int n=0)throw (std::exception);
	void RemoveAllActorsFromIndex(int n=0);
// EED 2022-08-04	throw
//	void UpdateVectors()throw (std::exception);
	void UpdateVectors();
	void UpdateActors();
	void AddActors();
	vtkRenderer		*_render;
	int 			_radio;
	double			*_colour;
	int 			_opacity;
};

#endif /*PlaneDirectionManager_H_*/
