/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "PlaneDirectionManagerData.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

PlaneDirectionManagerData::PlaneDirectionManagerData(int radio, double colour[3], int opacity)
:PlanesOperations(){	
	_vtkarrow		= vtkArrowSource::New();	
	_arrowMapper	= vtkPolyDataMapper::New();
	_arrowActor		= vtkActor::New();

	_vtkarrow->SetTipResolution(30);
	_vtkarrow->SetShaftResolution( 30  );	

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_arrowMapper->SetInput( _vtkarrow->GetOutput() );	
#else
	_arrowMapper->SetInputData( _vtkarrow->GetOutput() );	
#endif

	_arrowActor->SetMapper(_arrowMapper);	

	_radio 			= radio;
	_colour 		= colour;
	_opacity 		= opacity;

	p0 				= new double[3];
	p0[0] 			= 0;
	p0[1] 			= 0;
	p0[2] 			= 0;
	p1 				= new double[3];
	p1[0] 			= 0;
	p1[1] 			= 0;
	p1[2] 			= 0;
	p2 				= new double[3];
	p2[0] 			= 1;
	p2[1] 			= 1;
	p2[2] 			= 1;
	_dir 			= new double[3];
	_dir[0] 		= 0;
	_dir[1] 		= 0;
	_dir[2] 		= 0;
}


PlaneDirectionManagerData::~PlaneDirectionManagerData(){

	_vtkarrow->Delete();
	_arrowMapper->Delete();
	_arrowActor->Delete();
	delete p0;
	delete p1;
	delete p2;
	delete _dir;
}

vtkProp3D* PlaneDirectionManagerData::GetActor(){	
	return _arrowActor;
}

void PlaneDirectionManagerData::UpdateActor(){	

	_arrowActor->GetProperty()->SetColor( _colour[0] , _colour[1] , _colour[2] );
	_arrowActor->GetProperty()->SetOpacity( _opacity );
	
	
	double* vect1= getNormal(makeVector(p0, p1));
	double* vect2= getNormal(makeVector(p0, p2));	
	_dir = getNormal(getCrossProduct(vect1, vect2));
	double *newvectnorm = getNormal(getCrossProduct(_dir, vect2));
	double *midp = GetMidPoint();

	vtkMatrix4x4* _matrix = vtkMatrix4x4::New();  
	_matrix->Identity();	
	_matrix->SetElement(0,0,_dir[0]*_radio);
	_matrix->SetElement(1,0,_dir[1]*_radio);
	_matrix->SetElement(2,0,_dir[2]*_radio);
	_matrix->SetElement(0,1,vect2[0]*_radio);
	_matrix->SetElement(1,1,vect2[1]*_radio);
	_matrix->SetElement(2,1,vect2[2]*_radio);
	_matrix->SetElement(0,2,newvectnorm[0]*_radio);
	_matrix->SetElement(1,2,newvectnorm[1]*_radio);
	_matrix->SetElement(2,2,newvectnorm[2]*_radio);		
	_matrix->SetElement(0,3,midp[0]);
	_matrix->SetElement(1,3,midp[1]);
	_matrix->SetElement(2,3,midp[2]);
	_arrowActor->SetUserMatrix(_matrix);	

}

void PlaneDirectionManagerData::ChangeColour(double r,double g,double b){
	_colour[0] = r;
	_colour[1] = g;
	_colour[2] = b;
	if(_arrowActor!=NULL){
		_arrowActor->GetProperty()->SetColor( r,g,b );
	}	
}

double* PlaneDirectionManagerData::GetMidPoint(){
	if(p0 != NULL && p1 != NULL && p2 != NULL){
		double* ret = new double[3];
		ret[0] = (p0[0] + p1[0] +p2[0])/3;
		ret[1] = (p0[1] + p1[1] +p2[1])/3;
		ret[2] = (p0[2] + p1[2] +p2[2])/3;
		return ret;
	}
	return NULL;
}
