/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "PlanesOperations.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

using namespace std;

PlanesOperations::PlanesOperations()
{	
}


PlanesOperations::~PlanesOperations()
{

}


double* PlanesOperations::getCrossProduct(double* vect0,double* vect1)
{
	double* vectCross;
	vectCross = new double[3];
	vectCross[0] = vect0[1]*vect1[2]-(vect0[2]*vect1[1]);
	vectCross[1] = -(vect0[0]*vect1[2]-(vect0[2]*vect1[0]));
	vectCross[2] = vect0[0]*vect1[1]-(vect0[1]*vect1[0]);

	return vectCross;
}
/**
**	Returns the magnitud of the given vector
**/
double PlanesOperations::getMagnitud(double* vect)
{
	double mag;

	mag = sqrt(pow(vect[0],2) + pow(vect[1],2) + pow(vect[2],2));

	//std::cout<<"mag "<<mag <<std::endl;

	return mag;
}
/**
**	returns the unitary vector of the given vector
**	u = 1/|vect| . vect
**/
double* PlanesOperations::getNormal(double* vect)
{

	double* vectnorm;
	double mag = getMagnitud(vect);

	vectnorm = new double[3];
	
	if(mag!=0){
		vectnorm[0] = vect[0]/mag;
		vectnorm[1] = vect[1]/mag;
		vectnorm[2] = vect[2]/mag;
	}else{
		vectnorm[0] = 0;
		vectnorm[1] = 0;
		vectnorm[2] = 0;
	}
	return vectnorm;
}

double* PlanesOperations::makeVector(double *podouble0, double *podouble1)
{
	double *vect;
	vect = new double[3];

	vect[0]= podouble1[0]-podouble0[0];
	vect[1]= podouble1[1]-podouble0[1];
	vect[2]= podouble1[2]-podouble0[2];

	return vect;
}

void PlanesOperations::getCrossProduct(double* vect0,double* vect1, double* vectres){
    vectres[0] = vect0[1]*vect1[2]-(vect0[2]*vect1[1]);
    vectres[1] = -(vect0[0]*vect1[2]-(vect0[2]*vect1[0]));
    vectres[2] = vect0[0]*vect1[1]-(vect0[1]*vect1[0]);
}

void PlanesOperations::getNormal(double* vect, double* vectnorm){

    double mag = getMagnitud(vect);

    if(mag!=0){
            vectnorm[0] = vect[0]/mag;
            vectnorm[1] = vect[1]/mag;
            vectnorm[2] = vect[2]/mag;
    }else{
            vectnorm[0] = 0;
            vectnorm[1] = 0;
            vectnorm[2] = 0;
    }
}

void PlanesOperations::makeVector(double* podouble0, double* podouble1, double* vectres){
    vectres[0] = podouble1[0] - podouble0[0];
    vectres[1] = podouble1[1] - podouble0[1];
    vectres[2] = podouble1[2] - podouble0[2];
}

double PlanesOperations::getDotProduct(double* vect0,double* vect1){
	return vect0[0]*vect1[0] + vect0[1]*vect1[1] + vect0[2]*vect1[2];
}

void PlanesOperations::addVectors(double* vect0, double* vect1, double*vectres){

    vectres[0]= vect0[0] + vect1[0];
    vectres[1]= vect0[1] + vect1[1];
    vectres[2]= vect0[2] + vect1[2];
}

void PlanesOperations::scalarVector(double* vect0, double scalar, double*vectres){

    vectres[0]= vect0[0]*scalar;
    vectres[1]= vect0[1]*scalar;
    vectres[2]= vect0[2]*scalar;
}

vector<double> PlanesOperations::getCrossProduct(vector<double> vect0,vector<double> vect1){
  
	vector<double> vectCross;
	
	for(unsigned i = 0; i < vect0.size(); i++){
	  
	  unsigned ii = (i + 1 == vect0.size())? 0: i + 1;
	  unsigned iii = (ii + 1 == vect0.size())? 0: ii + 1;
	  
	  vectCross.push_back( vect0[ii]*vect1[iii]- vect0[iii]*vect1[ii] );
	  
	}
	return vectCross;
  
}
double  PlanesOperations::getDotProduct(vector<double> vect0,vector<double> vect1){
  
  double sum = 0;
  
  for(unsigned i = 0; i < vect0.size(); i++) sum += vect0[i]*vect1[i];
  
  return sum;
}
vector<double> PlanesOperations::getNormal(vector<double> vect){
	vector<double> vectnorm;
	double mag = getMagnitud(vect);	
	
	for(unsigned i = 0; i < vect.size(); i++){
	  
	  if(mag != 0){
	    vectnorm.push_back(vect[i]/mag);
	  }else{
	    vectnorm.push_back(0);
	  }
	}
	return vectnorm;
}
double  PlanesOperations::getMagnitud(vector<double> vect){
  double mag = 0;
  
  for(unsigned i = 0; i < vect.size(); i++) mag += pow(vect[i], 2);
  
  mag = sqrt(mag);

  //std::cout<<"mag "<<mag <<std::endl;

  return mag;
}
vector<double> PlanesOperations::makeVector(vector<double> podouble0, vector<double> podouble1){
  
  vector<double> vector;
  
  for(unsigned i = 0; i < podouble0.size(); i++){    
    vector.push_back(podouble1[i] - podouble0[i]);    
  }
  return vector;
}

/**
*    Adds to vectors, the result is in vectres;
*@param double* vect0, the first vector
*@param double* vect1, the second vector
*@param double* vectres, the resulting vector
*/
vector<double> PlanesOperations::addVectors(vector<double> vect0, vector<double> vect1){
    vector<double> vectres;
    for(unsigned i = 0; i < vect0.size(); i++){
        vectres.push_back(vect0[i] + vect1[i]);
    }
    return vectres;
}

/**
*    multiply a vector with a given scalar
*@param double* vect0, the vector
*@param double scalar, the scalar value
*@param double* vectres, the resulting vector
*/
vector<double> PlanesOperations::scalarVector(vector<double> vect0, double scalar){
    vector<double> vectres;
    for(unsigned i = 0; i < vect0.size(); i++){
        vectres.push_back(vect0[i]*scalar);
    }
    return vectres;
}

