/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  */

#ifndef __axisExtractor_h
#define __axisExtractor_h



#include <list>
#include <stack>
#include <time.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <string.h>



#include <vtkPolyDataSource.h>
#include <vtkImageThreshold.h>
#include <vtkImageCast.h>
#include <vtkImageSeedConnectivity.h>
#include <vtkImageData.h>
#include <vtkMarchingCubes.h>
#include <vtkDoubleArray.h>
#include <vtkPointData.h>
#include <vtkExtractVOI.h>
#include <vtkPoints.h>
#include <vtkCellArray.h>
#include <vtkImageResample.h>





class  axisExtractor : public vtkPolyDataSource
{
public:
	static axisExtractor *New();
	void PrintSelf(ostream& os, vtkIndent indent);

	virtual void SetInput(vtkImageData *input);
	vtkImageData *GetInput();

	void SetMaxPropRadio(double value);
	double GetMaxPropRadio();

	void SetHumbral(double value);
	double GetHumbral();

	void SetMaxPropMasa(double value);
	double GetMaxPropMasa();

	void SetMinPropMasa(double value);
	double GetMinPropMasa();

	void SetPoint(double puntoactualprov[3] );

	vtkImageData *GetVolumen();

  
  
protected:  
	axisExtractor();
	
	~axisExtractor() {};

	void Execute();
 
  

private:
	axisExtractor(const axisExtractor&);  // Not implemented.

	void operator=(const axisExtractor&);  // Not implemented.
  
	void searc(int i, int j, int k );

	void find_components( );

	unsigned short maximo();

	void blanquear();

	void blanquear2();

	
	
	void corte(double punto1[3], double punto2[3], double punto3[3], double centro[3],  double radio );

	void avanzar();

	
	void redondear(vtkImageData *data );

	
	
	void copiar(vtkImageData *data, vtkImageData *data2 );

	double distancia(double a[3], double b[3] );	
	
	int envolumen(int a[3], vtkImageData *datae );

	void realtoreal(double a[3], double b[3] );


	void realtoreal2(double a[3], double b[3] );

	void realtoindex(double a[3], int b[3] );



	void indextoreal(int a[3], double b[3] );


	void indextoreal(double a[3], double b[3] );

	



	vtkImageData *dataprov;
	vtkImageData *datatotal;
	
	unsigned char label;
	unsigned char label2;

	unsigned long vector[50][4] ;
	unsigned long vectorb[50][4] ;

	vtkExtractVOI *extrac;
	vtkImageThreshold *thresh;
	vtkImageCast *cast;
	vtkImageSeedConnectivity *connect;

	vtkImageResample *resample;
	
	int iter;

	vtkPoints *points;

	vtkCellArray *lineas; 

	double humbral;
	double maxpropradio;
	double maxpropmasa;
	double minpropmasa; 

	int buenos;

	std::stack< double  >						m_Stack0;
	std::stack< double  >						m_Stack1;
	std::stack< double  >						m_Stack2;
	std::stack< double  >						m_Stack3;
	std::stack< double  >						m_Stack4;
	std::stack< double  >						m_Stack5;
	std::stack< int  >						m_Stack;

	int flagg;
	
};

#endif


