/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  */

#ifndef __axisExtractor02_h
#define __axisExtractor02_h


#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkPolyData.h"
#include "vtkImageToStructuredPoints.h"
#include "vtkImageEuclideanDistance.h"
#include "vtkExtractVOI.h"
#include "vtkImageThreshold.h"
#include "vtkImageCast.h"
#include "vtkImageSeedConnectivity.h"
#include "vtkImageData.h"
#include "vtkImageReslice.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkImageResample.h"
#include "vtkMath.h"
#include "vtkPolyDataSource.h"
#include "vtkImageConstantPad.h"


#include <stack>
#include <deque>
#include <stdio.h>




class  axisExtractor02 : public vtkPolyDataSource
{
public:
	static axisExtractor02 *New();
	void PrintSelf(ostream& os, vtkIndent indent);

	virtual void SetInput(vtkImageData *input);
	vtkImageData *GetInput();
	vtkPolyData  *GetOutput();

	void SetParam(double value);
	double GetParam();

	void SetParam2(double value);
	double GetParam2();

	void SetParam3(double value);
	double GetParam3();


	void SetMaxant(int value);
	int GetMaxant();

	void SetMinant(int value);
	int GetMinant();

	void SetPoint(double value[3]);
	
	vtkImageData *GetVolumen();

	void distanciaejes(vtkPolyData *eje1,  vtkPolyData *eje2);

	void blanquear(vtkImageData *data );

	void copiar(vtkImageData *data, vtkImageData *data2 );

	

	




	
  
  
protected:  
	axisExtractor02();
	
	~axisExtractor02() {};

	void Execute();
 
  

private:
	axisExtractor02(const axisExtractor02&);  // Not implemented.

	void operator=(const axisExtractor02&);  // Not implemented.

	void realtoreal(double a[3], double b[3] );

	void realtoreal2(double a[3], double b[3] );

	void realtoindex(double a[3], int b[3] );

	void indextoreal(int a[3], double b[3] );

	void indextoreal(double a[3], double b[3] );

	double distanciaejepunto(double point[3], double point2[3], double point3[3]);

	double proporcioejepunto(double point[3], double point2[3], double point3[3]);

	void searc(int i, int j, int k, vtkImageData *data, vtkImageData *data2, unsigned char label, unsigned long vector[50][4] );

	void searcb(int i, int j, int k, vtkImageData *data, vtkImageData *data2, unsigned char label, unsigned long vector[50][4] );

	unsigned char find_components(vtkImageData *data, vtkImageData *data2, unsigned char label, unsigned long vector[50][4] );

	unsigned char find_componentsb(vtkImageData *data, vtkImageData *data2, unsigned char label, unsigned long vector[50][4] );

	int proporcion(vtkImageData *data );

	bool border(vtkImageData *data, int p1[3] );

	void optim(vtkImageData *data, vtkImageData *data2 );

	void costominimo(vtkImageData *data,  vtkImageData *data2 );

	void costominimo2(vtkImageData *data,  vtkImageData *data3, int p1[3], int p2[3], int p3[3]);

	void invertir(vtkImageData *data );

	void redondear(vtkImageData *data );

	void redondear2(vtkImageData *data );

	void redondear3(vtkImageData *data );

	double distancia(double a[3], double b[3] );

	double distancia(int a[3], int b[3] );

	void blanquear3(vtkImageData *data );

	void blanquear2(vtkImageData *data );

	void cilindro(vtkImageData *data, double vector[3] );

	void modelo(vtkImageData *data, unsigned char cantidad,  unsigned long vector[50][4], int candit[10][3], double radioactual, double minis[10]);

	void comparacion(vtkImageData *data, vtkImageData *data2, unsigned long minis[4]);

	void copiar2(vtkImageData *data, vtkImageData *data2 );

	double angulo(double a[3], double b[3] );

	double angulo(double i1, double j1, double k1, double i2, double j2, double k2 );

	int envolumen(int a[3], vtkImageData *datae );

	int mincandit(int candit[10][3], int cantidad, double puntoanterior[3]);

	int maxareacandit(unsigned long vector[50][4], int cantidad);

	unsigned long totalarea(unsigned long vector[50][4], unsigned long vectorb[50][4], int cantidad, int cantidadb);

	unsigned long conecarea(unsigned long vector[50][4], int cantidad);

	int bruled(int candit[10][3], int cantidad, vtkImageData *data4);

	double correction(int candit[10][3], int cantidad, vtkImageData *data, int indicecorregido[3], double puntocorregido[3], int indiceanterior[3], double radioanterior, int indicepre[3], double radiopre);

	double correction2(int candit[10][3], int cantidad, vtkImageData *data, int indicecorregido[3], double puntocorregido[3], int indiceanterior[3], double radioanterior);

	void avanzar();

	void todo();

	void paso();

	void rama();

	void segmento();

	

	int extprin0[6];
	double espprin[3];
	int extprin[6];
	

		
	
	vtkImageEuclideanDistance *distance;
	vtkExtractVOI *extrac;
	vtkImageSeedConnectivity *connect;
	vtkImageResample *resample;
	

	vtkImageData *data1;
	vtkImageData *data2;
	vtkImageData *data3;
	vtkImageData *data4;
	vtkImageData *data6;
	
		

	int flagg;
	int flagg2;

	vtkPoints *points;
	vtkCellArray *lineas; 
	int buenos;

/*	std::stack< double  >						m_Stack0;
	std::stack< double  >						m_Stack1;
	std::stack< double  >						m_Stack2;
	std::stack< double  >						m_Stack3;
	std::stack< double  >						m_Stack4;
	std::stack< double  >						m_Stack5;
	std::stack< double  >						m_Stack6;
	std::stack< double  >						m_Stack7;
	std::stack< double  >						m_Stack8;
	std::stack< int  >						m_Stack;
	std::stack< double  >						m_Stackr;
	std::stack< double  >						m_Stackra;
	std::stack< double  >						m_Stackrp;*/


	std::deque< double  >						m_Stack0;
	std::deque< double  >						m_Stack1;
	std::deque< double  >						m_Stack2;
	std::deque< double  >						m_Stack3;
	std::deque< double  >						m_Stack4;
	std::deque< double  >						m_Stack5;
	std::deque< double  >						m_Stack6;
	std::deque< double  >						m_Stack7;
	std::deque< double  >						m_Stack8;
	std::deque< int  >						m_Stack;
	std::deque< double  >						m_Stackr;
	std::deque< double  >						m_Stackra;
	std::deque< double  >						m_Stackrp;



	double puntoanteriorr[3];



	unsigned short max;
	unsigned long cantt;
	double sum;
	double sumc;
	double sums;
	double sumk;
	double kurt;
	double slew;
	double des;
	double prom;
	unsigned short min;

	double kurt1;
	double slew1;


	unsigned short max2;
	unsigned long cant;
	double sumi;
	double sumii;
	double kurt2;
	double slew2;
	double des2;
	double inerciaii;
	double centi;
	unsigned short min2;

	unsigned short max3;
	unsigned long cant2;
	double sumi2;
	double sumii2;
	double kurt3;
	double slew3;
	double des3;
	double inerciaii2;
	double centi2;
	unsigned short min3;

	float tmin, tmax;

	unsigned int hist[2000];

	int maxant;
	int minant;
	double totalMean ;
	double variance, maxVariance, zerothCumuMoment, firstCumuMoment ;
	double variance2, maxVariance2, zerothCumuMoment2, firstCumuMoment2 ;
	double variance3, maxVariance3, zerothCumuMoment3, firstCumuMoment3 ;
	double firstCumuMomentb, firstCumuMomentb2, firstCumuMomentb3 ;

	double kurtt;
	double slewt;
	
	int thresholdPoint, thresholdPoint1, thresholdPoint2;

	double    w[3];
	double    V[3][3];
	int ejemin;

	double    w2[3];
	double    V2[3][3];
	int ejemin2;

	double    wi[3];
	double    Vi[3][3];
	int ejemini;

	double centx, centy, centz;
	double centx2, centy2, centz2;

	double centix, centiy, centiz;

	double    A[3][3];
	double    A2[3][3];
	double    Ai[3][3];

	double    wp[3];
	double    Vp[3][3];
	int ejeminp;

	double    w2p[3];
	double    V2p[3][3];
	int ejemin2p;

	double centxp, centyp, centzp;
	double centx2p, centy2p, centz2p;

	double centixp, centiyp, centizp;
	
	double costo, costop;

	double    Ap[3][3];
	double    A2p[3][3];

	int candit[10][3];

	double minis[10];

	double inerciar, inerciarp, inerciari, inerciary, inerciarz, inerciariy, inerciariz, inerciarpy, inerciarpz;

	double inercia2r, inercia2rp;

	double mejor[3];

	
	

	int visited[10][3];

	double visitedrad[10];

	int frama;
	int fseg;
	double mejordst;

	double mejorrad;

	int mejorcant;

	

	double param;
	double param2;
	double param3;
	double param4;

	FILE *stream;


	
	
	


	
};

#endif


