/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  */

#ifndef __carotidaBifurcacion_h
#define __carotidaBifurcacion_h

#include "vtkPolyDataSource.h"
#include "vtkImageThreshold.h"
#include "vtkImageCast.h"
#include "vtkImageSeedConnectivity.h"
#include "vtkImageData.h"
#include "vtkMarchingCubes.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkExtractVOI.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"


class vtkPolyData;

class  carotidaBifurcacion : public vtkPolyDataSource
{
public:
	static carotidaBifurcacion *New();
	void PrintSelf(ostream& os, vtkIndent indent);

	virtual void SetInput(vtkPolyData *input);
	vtkPolyData *GetInput();

	virtual void SetInput2(vtkImageData *input);
	vtkImageData *GetInput2();

	void SetMaxPropRadio(double value);
	double GetMaxPropRadio();

	void SetHumbral(double value);
	double GetHumbral();

	void SetMaxPropMasa(double value);
	double GetMaxPropMasa();

	void SetMinPropMasa(double value);
	double GetMinPropMasa();
  
  
protected:  
	carotidaBifurcacion();
	
	~carotidaBifurcacion() {};

	void Execute();
 
  

private:
	carotidaBifurcacion(const carotidaBifurcacion&);  // Not implemented.

	void operator=(const carotidaBifurcacion&);  // Not implemented.
  
	void searc(int i, int j, int k );

	void find_components( );

	unsigned short maximo();

	void blanquear();

	double angulo(double i1, double j1, double k1, double i2, double j2, double k2 );

	void direcciones(vtkPolyData *points, int iter, double radio, double puntocortea[3], double puntocortes[3] );

	void corte(double punto1[3], double punto2[3], double punto3[3], double centro[3],  double radio );

	void avanzar(vtkIdType iter);

	int proporcion(vtkImageData *data );

	void redondear(vtkImageData *data );

	void limpiar(vtkPoints *profile, vtkPoints *profile2, vtkPoints *profile3, vtkPoints *profile4 );

	int igual(double puntoactual[3], double puntoactualdis[3], double puntoantguar[3], double puntoantguardis[3] );



	vtkImageData *dataprov;
	unsigned char label;
	unsigned long vector[50][4] ;
	vtkExtractVOI *extrac;
	vtkImageThreshold *thresh;
	vtkImageCast *cast;
	vtkImageSeedConnectivity *connect;
	vtkIdType iter;

	vtkPoints *points;

	vtkCellArray *lineas; 

	
	vtkDoubleArray *salidas;

	double humbral;
	double maxpropradio;
	double maxpropmasa;
	double minpropmasa;


	vtkPoints *points2;

	vtkPoints *points3;
	vtkPoints *points4;

 

	int buenos2;
	
};

#endif


