/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: curve.hxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef KGFO__CURVE__HXX
#define KGFO__CURVE__HXX

#include <vector>
#include "marTypes.h"

/*! \brief Parametrized n-dimensional curve.
 *
 *  This class realizes a parametric curve model, given some control points.
 */
class MAR_KERNEL_EXPORT kCurve
{
    public:

    kCurve( size_t dim = 3, size_t sdim = 0 );
    ~kCurve( );

    kCurve& operator=( const kCurve& r );

    uint32_t getDimension( ) const
    {
      return( _dimension );
    }

    uint32_t getStateDimension( ) const
    {
      return( _stateDim );
    }

    uint32_t getClosestControlPoint( double* p );

    void getPoint( double* p, double s );
    void getState( double* st, double s );
    void getTangent( double* tg, double s );
    void getNormal( double* n, double s );
    void getBinormal( double* b, double s );

    void addControlPoint( double* cp, double* sp );
    void getControlPoint( int i, double* cp, double* sp );
    void setControlPoint( int i, double* cp, double* sp );
    uint32_t getNumberOfControlPoints( )
    {
      return( _controlPoints.size( ) );
    }

    double length( double step = 0.01 );

    double projectOverControlPoints( double* pr, double* pt );
    double projectOverCurve( double* pr, double* pt );

    void evaluate( double* p, int i, double t );
    void evalState( double* s, int i, double t );

    void derivative1( double* d, int i, double t );
    void derivative2( double* d, int i, double t );

    void reset( );

    public:

    static int MAX_DIMENSION;
    static int MAX_STATE_DIMENSION;

    protected:
    
    std::vector< double* > _controlPoints;
    std::vector< double* > _controlState;
    uint32_t _dimension;
    uint32_t _stateDim;

    private:

    void loadCatmullControlMatrix( int i );
    void loadCatmullStateMatrix( int i );
    void calculeSplineArguments( double s, int& i, double& t );

    std::vector< double > _controlT;
    std::vector< double > _controlL;

    double* _mC;
    double* _mS;

};

#endif // KGFO__CURVE__HXX

// eof - curve.hxx
