/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: gslobj.hxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __GSL__OBJ__HXX__
#define __GSL__OBJ__HXX__

#include <iostream>
#include <gsl/gsl_math.h>
#include <gsl/gsl_matrix.h>

/*======================================================================================*/
/*=================================gslobj_vector========================================*/
/*======================================================================================*/
class gslobj_vector {

    public:
/*==Constructeurs========================================*/
    gslobj_vector( size_t s = 3 );
    gslobj_vector( const gslobj_vector& v );
    gslobj_vector( double* v, size_t s );
    gslobj_vector( gsl_vector* v );
/*==Destructeur========================================*/
	~gslobj_vector( ) { if( _copy ) gsl_vector_free( _gsl ); }

/*==Operateurs========================================*/
    
	/* Affectation */
	gslobj_vector& operator=( const gslobj_vector& o );
    gslobj_vector& operator=( double o );
    gslobj_vector& operator=( double* o );
    gslobj_vector& operator=( gsl_vector* o );

	/* Affichage */
    friend std::ostream& operator<<( std::ostream& os, const gslobj_vector& v );

    operator double*( ) const { return( _gsl->data ); }
    operator gsl_vector*( ) const { return( _gsl ); }

	double& operator()( size_t i ) { return( _gsl->data[ i ] ); }
    const double& operator()( size_t i ) const
    {
      return( _gsl->data[ i ] );
    }

	/* Comparaison */
    bool operator==( const gslobj_vector& o ) const;
    bool operator!=( const gslobj_vector& o ) const
    {
      return( !( ( *this ) == o ) );
    }

	/* Ajout */
    gslobj_vector operator+( const gslobj_vector& o );
    gslobj_vector operator+( double o );
    gslobj_vector operator+( double* o );
    gslobj_vector operator+( gsl_vector* o );
    gslobj_vector& operator+=( const gslobj_vector& o );
    gslobj_vector& operator+=( double o );
    gslobj_vector& operator+=( double* o );
    gslobj_vector& operator+=( gsl_vector* o );

	/* Suppression */
    gslobj_vector operator-( const gslobj_vector& o );
    gslobj_vector operator-( double o );
    gslobj_vector operator-( double* o );
    gslobj_vector operator-( gsl_vector* o );
    gslobj_vector& operator-=( const gslobj_vector& o );
    gslobj_vector& operator-=( double o );
    gslobj_vector& operator-=( double* o );
    gslobj_vector& operator-=( gsl_vector* o );

	/* Multiplication (produit scalaire) */
    gslobj_vector operator*( double o );
    gslobj_vector& operator*=( double o );

	/* Division (produit scalaire) */
    gslobj_vector operator/( double o );
    gslobj_vector& operator/=( double o );


/*==Methodes========================================*/

/*==PS========================================*/
//    /* Redimenssionnement */
//	void resize( size_t s );
//
//	/* cree un vecteur unitaire pour une base */
//    int basis( size_t i )
//    {
//      *this = ( double )0;
//      ( *this )( i ) = 1;
//      return( i );
//    }
/*==PS========================================*/
	
	/* Renvoie la taille du vecteur */
    size_t size( ) const { return( _gsl->size ); }

/*==PS========================================*/    
//	/* Affecte  */
//    void setValue( size_t i, double val ) { _gsl->data[ i ] = val; }
//
//	/* Permutation d'elements */
//    int swap( size_t i, size_t j )
//    {
//      return( gsl_vector_swap_elements( _gsl, i, j ) );
//    }
//
//	/* le vecteur est "retourn�" */
//    int reverse( ) { return( gsl_vector_reverse( _gsl ) ); }
/*==PS========================================*/

	/* produit scalaire */
    double dot( const gslobj_vector& o );
    double dot( double* o );
    double dot( gsl_vector* o );
	
	/* produit vectoriel : le resultat est renvoye */
    gslobj_vector cross( const gslobj_vector& o );
    gslobj_vector cross( double* o );
    gslobj_vector cross( gsl_vector* o );
	/* produit vectoriel : le resultat est stock� dans this*/
    int scross( const gslobj_vector& o );
    int scross( double* o );
    int scross( gsl_vector* o );


	/* norme */

/*==PS========================================*/
//    double norm1( ); /* somme des valeurs absolues de chaque 
//					 composantes du vecteur (norme discrete)*/
/*==PS========================================*/

    double norm2( ); /* norme "normale" */

	/* normalisation */
    gslobj_vector normalize( ); /* resultat renvoy� */
    int snormalize( ); /* resultat stock� dans this */ 

    private:

    gsl_vector* _gsl;
    bool _copy;
    gsl_vector_view _view;
};



/*======================================================================================*/
/*=================================gslobj_matrix========================================*/
/*======================================================================================*/
class gslobj_matrix {

    friend std::ostream& operator<<( std::ostream& os, const gslobj_matrix& m );

    public:

    gslobj_matrix( size_t r = 3, size_t c = 3 );
    gslobj_matrix( const gslobj_matrix& m );
    gslobj_matrix( double* m, size_t r, size_t c );
    gslobj_matrix( double* m[], size_t r, size_t c );
    gslobj_matrix( gsl_matrix* m );

/*==PS========================================*/
//    void resize( size_t r, size_t c );
/*==PS========================================*/

    ~gslobj_matrix( ) { if( _copy ) gsl_matrix_free( _gsl ); }

    gslobj_matrix& operator=( const gslobj_matrix& o );
    gslobj_matrix& operator=( double o );
    gslobj_matrix& operator=( double* o );
    gslobj_matrix& operator=( double* o[] );
    gslobj_matrix& operator=( gsl_matrix* o );

    operator gsl_matrix*( ) const { return( _gsl ); }
    operator double*( ) const { return( _gsl->data ); }
		
    size_t size1( ) const { return( _gsl->size1 ); }
    size_t size2( ) const { return( _gsl->size2 ); }
    size_t rows( ) const { return( _gsl->size1 ); }
    size_t columns( ) const { return( _gsl->size2 ); }
    double& operator()( size_t i, size_t j );
    const double& operator()( size_t i, size_t j ) const;

/*==PS========================================*/
//    void setValue( size_t i, size_t j, double val );
/*==PS========================================*/

    bool operator==( const gslobj_matrix& o ) const;
    bool operator!=( const gslobj_matrix& o ) const 
    {
      return( !( ( *this ) == o ) );
    }

    gslobj_matrix operator+( const gslobj_matrix& o );
    gslobj_matrix operator+( double o );
    gslobj_matrix operator+( double* o );
    gslobj_matrix operator+( double* o[] );
    gslobj_matrix operator+( gsl_matrix* o );
    gslobj_matrix& operator+=( const gslobj_matrix& o );
    gslobj_matrix& operator+=( double o );
    gslobj_matrix& operator+=( double* o );
    gslobj_matrix& operator+=( double* o[] );
    gslobj_matrix& operator+=( gsl_matrix* o );

    gslobj_matrix operator-( const gslobj_matrix& o );
    gslobj_matrix operator-( double o );
    gslobj_matrix operator-( double* o );
    gslobj_matrix operator-( double* o[] );
    gslobj_matrix operator-( gsl_matrix* o );
    gslobj_matrix& operator-=( const gslobj_matrix& o );
    gslobj_matrix& operator-=( double o );
    gslobj_matrix& operator-=( double* o );
    gslobj_matrix& operator-=( double* o[] );
    gslobj_matrix& operator-=( gsl_matrix* o );

    gslobj_matrix operator*( const gslobj_matrix& o );
    gslobj_matrix operator*( double o );
    gslobj_matrix operator*( double* o );
    gslobj_matrix operator*( double* o[] );
    gslobj_matrix operator*( gsl_matrix* o );
    gslobj_vector operator*( const gslobj_vector& o );
    gslobj_matrix& operator*=( const gslobj_matrix& o );
    gslobj_matrix& operator*=( double o );
    gslobj_matrix& operator*=( double* o );
    gslobj_matrix& operator*=( double* o[] );
    gslobj_matrix& operator*=( gsl_matrix* o );

/*==PS========================================*/
//    gslobj_matrix transpose( );
//    gslobj_matrix invertLU( );
//    double determinant( );

//    bool isSquare( ) { return( _gsl->size1 == _gsl->size2 ); }
//    void identity( );
/*==PS========================================*/

    private:

    gsl_matrix* _gsl;
    bool _copy;
    gsl_matrix_view _view;
};

#endif // __GSL__OBJ__HXX__
