/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkImageData.h"
/**
* Clase para segmentar una imagen usando fast marching
*
* La imagen de velocidad se obtiene aplicando una transformacion sigmoide a cada voxel.
* Dicha transformacion esta regida por los par�metros alfa (pendiente) y beta(centro de pivotaje)
*/

class itkFM3D
{
public:
	itkFM3D();
	virtual ~itkFM3D();
	void AddSeed(int x, int y, int z);
	void SetAlpha(double alpha);
	void SetBeta(double beta);
	void SetStopTime(double stopTime);
	void CurvatureAnisotropicFiltertOn();
	void CurvatureAnisotropicFilterOff();
	vtkImageData* segment(vtkImageData *volume);
	double GetEstimatedOtsuTreshold();
	
protected:

	 FILE *logger;

private:
	double alpha;
	double beta;
	double stopTime;
	int usefilter;
	int x;
	int y;
	int z;
	double estimatedOtsuThreshold;
};
