/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marAxis.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __MAR__KERNEL__AXIS__HXX__
#define __MAR__KERNEL__AXIS__HXX__

#include <vtkPolyData.h>
#include <vtkProbeFilter.h>
#include <vector>

//In an ideal future we should get rid of gslobj to get rid of gsl...
// PS -> //#include "gslobj.hxx" //PS

#include "curve.hxx"
#include "volume.hxx"
#include "marContour.h"
#include "marObject.h"
#include "ExtractionAxe.h"
#include <marAxisContours.h>
#include <marIsocontour.h>

class vtkPoints;
class vtkCellArray;

/**
 * \brief class describing an axe in Maracas
 * \todo marAxis ...miss some stuff...
 */
class MAR_KERNEL_EXPORT marAxis : public marObject, public kCurve
{
public:

/** An enum.
*
* More detailed enum description.
*/
  
  enum AxisStateVectorIndexes
{
    INDX_X = 0,       /*!< X coordinate of an axis point. */  
    INDX_Y,           /*!< Y coordinate of an axis point. */ 
    INDX_Z,           /*!< Z coordinate of an axis point. */  
    INDX_V1X,         /*!< X coordinate of the first eigen vector. */
    INDX_V1Y,         /*!< Y coordinate of the first eigen vector. */
    INDX_V1Z,         /*!< Z coordinate of the first eigen vector. */
    INDX_V2X,         /*!< X coordinate of the second eigen vector. */
    INDX_V2Y,         /*!< Y coordinate of the second eigen vector. */
    INDX_V2Z,         /*!< Z coordinate of the second eigen vector. */
    INDX_V3X,         /*!< X coordinate of the third eigen vector. */
    INDX_V3Y,         /*!< Y coordinate of the third eigen vector. */
    INDX_V3Z,         /*!< Z coordinate of the third eigen vector. */
    INDX_LAMBDA1,     /*!< Value of the first eigen value. */  
    INDX_LAMBDA2,     /*!< Value of the second eigen value. */  
    INDX_LAMBDA3,     /*!< Value of the third eigen value. */  
    INDX_MASSE,       /*!< Weight of the optimal sphere. */  
    INDX_RAYON,       /*!< Radius of the optimal sphere. */  
    INDX_INERTIE,     /*!< Inertia of the optimal sphere. */  
    INDX_PTAGEMASSE,  /*!< X coordinate of an axis point. */  
    INDX_PTAGERAYON,  /*!< X coordinate of an axis point. */  
    INDX_SIGNALVALUE, /*!< X coordinate of an axis point. */  
    INDX_count        /*!< Allow counting of this enum. */  
    };

public:

/**
* Cstor
*/
  marAxis( marParameters* p = NULL );

/**
* Destructor
*/
  ~marAxis( ) { reset( ); };

/**
* Return description as a std::string
*/
  std::string& getDescription( ) { return( _description ); };

/**
* Set description as a std::string
*/
  void setDescription( std::string& d ) { _description = d; };

/**
* Add a point to the axis
* \warning no check is done
  */
  void addAxisPoint( double* p );
  void changeAxisResolution( );
  void calculateSignal( kVolume* vol );
    

  int getActualQuant( )						{ return _actualQuant;				}

  float getSignal( uint slice )				{ return( _signal[ slice ] );		};

  double* getSplinePoint( uint i )			{ return ( _points[ i ] );			};

  int getHealthySlice( )					{ return( _healthySlice );			};
  int getHealthySliceStart( )				{ return( _healthySliceStart );		};
  int getHealthySliceEnd( )					{ return( _healthySliceEnd );		};

  void setActualQuant(int act)				{ _actualQuant=act;					};

  void setHealthySlice( int hsS, int hs, int hsE );

  void setStartQuant( int sq );
  void setFinishQuant( int fq );


  int   getStartQuant( )					{ return _startQuant;				};
  int   getFinishQuant( )					{ return _finishQuant;				};


  void start( );
  void next( )								{ _actualQuant++; };
  void stop( )								{ _actualQuant = _finishQuant + 1; };
  bool isFinished( ) { return( _actualQuant >= _startQuant && _actualQuant <= _finishQuant ); }

  void doSpline ( );

  void cut( int slice, bool up );

// EED Ojo eduardo esto toca borrarlo
  void sliceVolumeAxis( kVolume* vol, bool forceCnt = true );

  double* getNormal( unsigned int slice );

  int getNumberOfContours( );
  int getNumberOfSplinePoints( );

// EED Ojo Eduardo esto toca redefinirlo o partilo en dos o algo..
//  vtkPolyData* setContour( int i, int x = -1, int y = -1,  std::vector< double* >* points =  NULL, marContour* c = NULL );

// EED borrame
/*
  marContour* getContour( int i ) { return( _contours[ i ] ); };
  kVolume* getSlice( int i ) { return( _slices[ i ] ); };
  vtkProbeFilter* get3DSlice( int i ) { return( _3Dslices[ i ] ); };
  vtkImageData* getSliceImage( int i ) { return(_quantificationImages[ i ]);  };
*/

  bool              if3DcontourExist(int i);
  void				Save3Dcontour(FILE *ff,int i);
  void				SaveExisting3DContours(FILE *ff);
	
  marContour*		getContour(		int i , kVolume* vol );		// DATA-MODEL-2D  
  kVolume*			getSlice(		int i , kVolume* vol );		// DATA-MODEL-Voxel XxYx1
  vtkProbeFilter*	get3DSlice(		int i , kVolume* vol );		// VISUALISATION-VTK 3D
  vtkPoints*		get3Dcontour(	int i , kVolume* vol );		// VISUALISATION-VTK 3D
  vtkImageData*		getSliceImage(	int i , kVolume* vol );		// VISUALISATION-VTK 2D
  vtkPolyData*		get2Dcontour(	int i , kVolume* vol );		// VISUALISATION-VTK 2D
  vtkPoints*		get2DDiameterMin(	int i , kVolume* vol );		// VISUALISATION-VTK 3D
  vtkPoints*		get2DDiameterMax(	int i , kVolume* vol );		// VISUALISATION-VTK 3D

  void				replaceContour2D(int i,int size,double *vx,double *vy);
  void				EraseContour(int i);

  void				createEmptyVectors();
  void				clearAllVectors(); 
  void				eraseContourVectorsContent();
  

  void				set_points_disc   ( PPPOINTAXE p ) { _points_disc = p; };

  double			getTotalLength();
  double			getSubAxisLength();
  double			getReferenceArea(kVolume* vol);
  double			getReferenceAverDiam(kVolume* vol);
  double			getAverageArea(int pIni, int pEnd, kVolume* vol);

/**
*  General methods
*/
  void				reset( );
  void				copyFrom( const marObject& from );

/**
* Persistence methods
*/
  bool				save( std::ofstream& os );
  bool				load( std::ifstream& is );

  vtkPolyData		*Draw( );
  vtkPolyData		*GetAxisData();
  void				Delete( );
  double*			getPoints(int i) { return _points[i]; };	

	void AddPointToList(double x, double y, double z, int signal);



private:

  double _totalAxisLenght;
  double _subAxisLenght;
  double _referenceArea;
  double _referenceAverDiam;

  std::string						_description;				//  Axis description
  std::vector< double* >			_points;					//  Axis spline points
  std::vector< marContour* >		_contours;					//  DATA-MODEL-2D			Axis Contours
  std::vector< kVolume* >			_slices;					//  DATA-MODEL-Voxel XxYx1	Axis perpendicular Slice
  std::vector< vtkProbeFilter* >	_3Dslices;					//  VISUALISATION_VTK 3D	Axis perpendicular Slice
  std::vector< vtkPoints* >			_3Dcontour;					//  VISUALISATION_VTK 3D	Axis perpendicular Contour
  std::vector< vtkImageData* >		_quantificationImages;		//  VISUALISATION_VTK 2D    Axis perpendicular Coup
  std::vector< vtkPolyData* >		_2Dcontours;				//  VISUALISATION_VTK 2D	Axis perpendicular Contour
  std::vector< vtkPoints* >			_2DDiameterMin;				//  VISUALISATION_VTK 2D	Line diameter Minimum
  std::vector< vtkPoints* >			_2DDiameterMax;				//  VISUALISATION_VTK 2D	Line diameter Maximum
  std::vector< int >				_signal;					//  Axis intensity signal
  int _healthySlice;                     //  Healthy slice, if -1 then is unselected
  int _healthySliceStart;
  int _healthySliceEnd;
  int _startQuant;
  int _finishQuant;
  int _actualQuant;
  PPPOINTAXE _points_disc;
    
  vtkPolyData* _allData;

  // Properties from marObject
  //marParameters* _parameters;

  // Properties from kCurve
  // std::vector< double* > _controlPoints; //  Axis calculated points

  void		calculateTotalAxisLenght();	
  void		calculateSubAxisLength();
  void		calculateReferenceArea(kVolume* vol );
  void 		calculateReferenceAverDiam(kVolume* vol );
  void		createContour(		int i	, kVolume* vol );
  void		createSlice(		int i	, kVolume* vol );
  void		create3DSlice(		int i	, kVolume* vol );
  void		create3Dcontour(	int i	, kVolume* vol );
  void		createSliceImage(	int i	, kVolume* vol );
  void		create2Dcontour(	int i	, kVolume* vol );
  void		create2DDiameterMin(int i	, kVolume* vol );
  void		create2DDiameterMax(int i	, kVolume* vol );
  double	getAxisLenght(		int pIni, int pEnd);
  

protected:

  std::vector <marAxisContours* > quantContours;
  std::vector <marPoint *> vesselPoints;
  std::vector <marIsocontour *> lumenContour;
  bool calibration;
  

//  std::vector <marIsocontour* > pointContours;
  

};

#endif // __MAR__KERNEL__AXIS__HXX__
