/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marAxisCT.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __MAR__KERNEL__AXISCT__HXX__
#define __MAR__KERNEL__AXISCT__HXX__



#include <marAxis.h>
#include <marAxisContours.h>
#include <marPoint.h>
#include <marIsocontour.h>
#include <vector>
#include <list>

class MAR_KERNEL_EXPORT marAxisCT : public marAxis
{

public:

		
	marAxisCT(  );
	marContour*		getContour( int point , kVolume* vol, int index );		// DATA-MODEL-2D  
	vtkPoints*		get3Dcontour(	int point , kVolume* vol, int index );		// VISUALISATION-VTK 3D
	vtkPolyData*	get2Dcontour(	int point , kVolume* vol, int index );		// VISUALISATION-VTK 2D
	vtkPoints*		get2DDiameterMin(	int point , kVolume* vol, int index );		// VISUALISATION-VTK 3D
	vtkPoints*		get2DDiameterMax(	int point , kVolume* vol, int index );		// VISUALISATION-VTK 3D
	int				getSignal(int point, int index, kVolume* vol);
	void			updateLumenPercentage(int point, kVolume* vol);
	void			updateCalcPercentage(int point, kVolume* vol);

	void			replaceContour2D(int point,int size,double *vx,double *vy, int type);

	marContourVO*   searchContour(int type, int point);
	int			getNumberOfContours(int point, kVolume* vol);
	int			getContourType(int point, int index, kVolume* vol  );
	void		createEmptyContours();
	void		eraseContours();
	void		eraseContoursPartial(int start);
	
	void			histogram(int point, kVolume* vol);
	void		setCalibration(bool calib);
	bool		getCalibration();
	
	int			getStartIndex();
	void		setStartIndex(int start);

	int			getPointSize();
	marPoint*	getPoint(int i);
	void		markUpLumen(int point, kVolume* vol);
	void		generateFile(int point,kVolume* vol);

	void		cleanContours(int type, int point);
	double		performXOR(int type, int point, std::vector<marIsocontour *> manual, kVolume* vol);
	double		performAND(int type, int point, std::vector<marIsocontour *> manual, kVolume* vol);
	double		performUnion(int type, int point, std::vector<marIsocontour *> manual, kVolume* vol);
	marIsocontour*	loadMarIsocontour(int size, double *vx, double *vy);


private:

	void			createContours(		int point	, kVolume* vol );
	void			create3Dcontours(	int point	, kVolume* vol );
	void			create2Dcontours(	int point	, kVolume* vol );
	void			create2DDiametersMin(int point	, kVolume* vol );
	void			create2DDiametersMax(int point	, kVolume* vol );
	void			createSignals (int point, kVolume* vol);
	void			generatePoints(int point, kVolume* vol, std::vector<marIsocontour*> *list);
	int				getMaximumGrad(std::vector <marPoint *> list, int iniPos, int limit, double threshold);
	int				getMinimumGrad(std::vector <marPoint *> list, int iniPos, int limit, double threshold);
	double			interpolate(double x, double y, vtkImageData* imagedata);
	void			generateVector(int dir,int *coordBase,double originX,double originY,double *x,double *y);
	bool			detectNeighbor(marIsocontour* contour,int dir, int type);
	marIsocontour*	addPointToContour(marIsocontour* cont ,bool inside,int type,marPoint* point);
	void			unifyDividedStructure(std::vector<marIsocontour*> *contList);
	double			getStatistics(marIsocontour* contour, double x, double y, vtkImageData* imagedata);
	double			getCalcStatistics(marIsocontour* contour, double x, double y, vtkImageData* imagedata,int i);
	int				round(double num);
	int				getMaxIntensity(int point);
	bool			pointInPolygon(marIsocontour *c, double x, double y);
	marIsocontour*	parsePolyDataToMarIsocontour(marContourVO* contourVO);

	marIsocontour*  filterContour(marIsocontour* contExt, marIsocontour* contInt, double radio);
	
	double			obtainContourArea(marIsocontour*contour);
	void			adjustWall(int point, kVolume* vol);
	void			adjustCalcification(int point, kVolume* vol);
	void			adjustContour(int point, kVolume* vol);
	int				maxValue(std::vector <double> list);
	int				getDiameter(marContourVO* contourVO, double x, double y, int limInfX, int limInfY, int limSupX, int limSupY);
	
	int				searchData(std::vector<double> vec, double value);

	void			extractLumen(vtkImageData *lumenImage, marIsocontour *lumenContour, int point);
	double			avgValue;
	double			stdValue;
	int				startIndex;
	double			maxSignal;

	
	
				//	Contours per slice

	//Eliminados
	//	marIsocontour*	shrinkContour(marIsocontour *cont, double thresh, vtkImageData* imageData, double radio);
  
};

#endif // __MAR__KERNEL__AXISCT__HXX__
