/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marContourVO.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "marContourVO.h"

// ----------------------------------------------------------------------------
marContour* marContourVO::getContour( ) {
	return _contours;
}

// ----------------------------------------------------------------------------
void marContourVO::setContour(marContour* cont) {
	_contours = cont;
}

// ----------------------------------------------------------------------------
vtkPoints* marContourVO::get3DContour( ) {
	return _3Dcontour;
}

// ----------------------------------------------------------------------------
void marContourVO::set3DContour(vtkPoints* cont) {
	_3Dcontour = cont;
}

// ----------------------------------------------------------------------------
vtkPolyData* marContourVO::get2DContour( ) {
	return _2Dcontours;
}

// ----------------------------------------------------------------------------
void marContourVO::set2DContour(vtkPolyData* cont) {
	_2Dcontours = cont;
}

// ----------------------------------------------------------------------------
vtkPoints* marContourVO::get2DDiameterMin( ) {
	return _2DDiameterMin;
}

// ----------------------------------------------------------------------------
void marContourVO::set2DDiameterMin(vtkPoints* diam) {
	_2DDiameterMin = diam;
}

// ----------------------------------------------------------------------------
vtkPoints* marContourVO::get2DDiameterMax( ) {
	return _2DDiameterMax;
}

// ----------------------------------------------------------------------------
void marContourVO::set2DDiameterMax(vtkPoints* diam) {
	_2DDiameterMax = diam;
}

// ----------------------------------------------------------------------------
double marContourVO::getSignal( ) {
	return _signal;
}

// ----------------------------------------------------------------------------
void marContourVO::setSignal(double signal) {
	_signal = signal;

}	  			

// ----------------------------------------------------------------------------
int marContourVO::getType( ) {
	return _contType;
}

// ----------------------------------------------------------------------------
void marContourVO::setType(int cont) {
	_contType = cont;
}

// ----------------------------------------------------------------------------
vtkContourFilter* marContourVO::getIsocontour()
{
	return _isocontour;
}

// ----------------------------------------------------------------------------
void marContourVO::setIsocontour(vtkContourFilter* iso)
{
	_isocontour = iso;
}

// ----------------------------------------------------------------------------
vtkCleanPolyData* marContourVO::getIsocontourCpd()
{
	return _isocontour_cpd;
}

// ----------------------------------------------------------------------------
void marContourVO::setIsocontourCpd(vtkCleanPolyData* isocpd)
{
	_isocontour_cpd = isocpd;
}

// ----------------------------------------------------------------------------
vtkCleanPolyData* marContourVO::getIsocontourCpd2()
{
	return _isocontour_cpd2;
}


// ----------------------------------------------------------------------------
void marContourVO::setIsocontourCpd2(vtkCleanPolyData* isocpd)
{
	_isocontour_cpd2 = isocpd;
}

// ----------------------------------------------------------------------------
vtkPolyDataConnectivityFilter* marContourVO::getIsocontourDcf()
{
	return _isocontour_dcf;
}

// ----------------------------------------------------------------------------
void marContourVO::setIsocontourDcf(vtkPolyDataConnectivityFilter*	isodcf)
{
	_isocontour_dcf = isodcf;
}

// ----------------------------------------------------------------------------
vtkStripper* marContourVO::getIsocontourStripped()
{
	return _isocontour_stripped;
}

// ----------------------------------------------------------------------------
void marContourVO::setIsocontourStripped(vtkStripper* isoStripped)
{
	_isocontour_stripped = isoStripped;
}

// ----------------------------------------------------------------------------
marContourVO::~marContourVO()
{
	if (_contours != NULL) { delete _contours; }
	if (_3Dcontour != NULL) { _3Dcontour->Delete(); }
	if (_2Dcontours != NULL) { _2Dcontours->Delete(); }
	if (_2DDiameterMin != NULL) { _2DDiameterMin->Delete(); }
	if (_2DDiameterMax != NULL) { _2DDiameterMax->Delete(); }
	_signal = 0.0;
	_contType = -1;
	if (_isocontour != NULL) { _isocontour->Delete(); }
	if (_isocontour_cpd != NULL) { _isocontour_cpd->Delete(); }
	if (_isocontour_dcf != NULL) { _isocontour_dcf->Delete(); }
	if (_isocontour_cpd2 != NULL) { _isocontour_cpd2->Delete(); }
}

// ----------------------------------------------------------------------------
bool marContourVO::isReplaced()
{
	return _replaced;
}

// ----------------------------------------------------------------------------
void marContourVO::setReplaced(bool rep)
{
	_replaced = rep;
}

marContourVO::marContourVO()
{
	_replaced = false;
}
