/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marContourVO.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__CONTOURVO__HXX__
#define __MAR__KERNEL__CONTOURVO__HXX__

#include "marContour.h"
#include <vtkPolyData.h>
#include <vtkProbeFilter.h>
#include <vtkContourFilter.h>
#include <vtkCleanPolyData.h>
#include <vtkPolyDataConnectivityFilter.h>
#include <vtkStripper.h>

class vtkPoints;
class vtkCellArray;


class MAR_KERNEL_EXPORT  marContourVO 
{

   public:

	   
	   marContour* getContour( );
	   void setContour(marContour* cont);

	   vtkPoints* get3DContour( );
	   void set3DContour(vtkPoints* cont);

	   vtkPolyData* get2DContour( );
	   void set2DContour(vtkPolyData* cont);

	   vtkPoints* get2DDiameterMin( );
	   void set2DDiameterMin(vtkPoints* diam);

	   vtkPoints* get2DDiameterMax( );
	   void set2DDiameterMax(vtkPoints* diam);

	   double getSignal( );
	   void setSignal(double cont);

	   int getType( );
	   void setType(int cont);

	   vtkContourFilter* getIsocontour();
	   void setIsocontour(vtkContourFilter* iso);

	   vtkCleanPolyData* getIsocontourCpd();
	   void setIsocontourCpd(vtkCleanPolyData* isocpd);

	   vtkCleanPolyData* getIsocontourCpd2();
	   void setIsocontourCpd2(vtkCleanPolyData* isocpd);

	   vtkPolyDataConnectivityFilter* getIsocontourDcf();
	   void setIsocontourDcf(vtkPolyDataConnectivityFilter*	isodcf);

	   vtkStripper* getIsocontourStripped();
	   void setIsocontourStripped(vtkStripper* isoStripped);

	   bool isReplaced();
	   void setReplaced(bool rep);

	   ~marContourVO();
		marContourVO();

   private:

	    
	marContour* 		_contours;					//  DATA-MODEL-2D			Axis Contours
	vtkPoints* 			_3Dcontour;					//  VISUALISATION_VTK 3D	Axis perpendicular Contour
	vtkPolyData*		_2Dcontours;				//  VISUALISATION_VTK 2D	Axis perpendicular Contour
	vtkPoints* 			_2DDiameterMin;				//  VISUALISATION_VTK 2D	Line diameter Minimum
	vtkPoints*			_2DDiameterMax;				//  VISUALISATION_VTK 2D	Line diameter Maximum
	double				_signal;					//  Axis intensity signal
	int					_contType;					//  ContourType
	vtkContourFilter*	_isocontour;
	vtkCleanPolyData*	_isocontour_cpd;
	vtkPolyDataConnectivityFilter*	_isocontour_dcf;
	vtkCleanPolyData*	_isocontour_cpd2;
	vtkStripper*		_isocontour_stripped;
	bool				_replaced;

 
}; 
#endif // __MAR__KERNEL__CONTOUR_VO__HXX__

