/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marExperiment.cpp,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

//#include "matrix.h"
#include "marExperiment.h"
#include "FonctionsGrales.h"
#include "ExtractionAxe.h"

// ----------------------------------------------------------------------------
marExperiment::marExperiment( marParameters* p ) : marObject( p ),
                              _dynData( NULL ), _description( _T("NO DESCRIPTION") )
{
  _voi[ 0 ] = _voi[ 1 ] = _voi[ 2 ] = 0;
  _voi[ 3 ] = _voi[ 4 ] = _voi[ 5 ] = 0;
  _startPoint[ 0 ] = _startPoint[ 1 ] = _startPoint[ 2 ] = 0;
  _axes.push_back( NULL );

}

marExperiment::~marExperiment( ) { 
	reset( ); 
}

// ----------------------------------------------------------------------------
void marExperiment::initExperiment( kVolume* volume )
{
  {
    reset( );
    _dynData = new marDynData( getParameters( ) );

     _dynData->loadData( volume, _voi );

/* EED Borrame
#ifndef DXMM
     _dynData->loadData( volume, _voi );
#else
    _dynData->loadDataDXMM( volume, _voi );
#endif
*/
  }
}

// ----------------------------------------------------------------------------
void marExperiment::setStartPoint( int sx, int sy, int sz )
{
// EED 22 sep 2006
//  _startPoint[ 0 ] = ( int )( ( double )sx * getParameters( )->getVoxelSize( ) );
//  _startPoint[ 1 ] = ( int )( ( double )sy * getParameters( )->getVoxelSize( ) );
//  _startPoint[ 2 ] = ( int )( ( double )sz * getParameters( )->getVoxelSize( ) );

  _startPoint[ 0 ] = sx;
  _startPoint[ 1 ] = sy;
  _startPoint[ 2 ] = sz;

}

// ----------------------------------------------------------------------------
void marExperiment::extractVascularTree( int sens , double *vit, int cleanLevel)
{

  marAxis* tmpAxis;
  marAxis* tmpAxis2;

#ifdef __LFV__GET__VASCULAR__TREE__
    PPPOINTAXE pts = NULL;
    PARBREVASCULAIRE res = NULL;
#else
    PPPOINTAXE res = NULL;
    double pt[ marAxis::INDX_count ];
#endif
    int n, i;
    res = ExtraireArbre(
      _startPoint[ 0 ],
      _startPoint[ 1 ],
      _startPoint[ 2 ],
      ( PPPVOLUME_USHORT )( _dynData->getVolume( )->castIdo( ) ),
      1, 1, 1,
      _dynData->getVolume( )->getXdim( ) - 1,
      _dynData->getVolume( )->getYdim( ) - 1,
      _dynData->getVolume( )->getZdim( ) - 1,
      ( double )( getParameters( )->getIntParam( marParameters::e_roi_dimension ) ),
      ( double )( getParameters( )->getIntParam( marParameters::e_step ) ),
      getParameters( )->getDoubleParam( marParameters::e_gravity_distance ),
      getParameters( )->getDoubleParam( marParameters::e_distance_to_maximum_intensity ),
      getParameters( )->getDoubleParam( marParameters::e_flexion_coeficient ),
      getParameters( )->getDoubleParam( marParameters::e_tension_coeficient ),
      getParameters( )->getIntParam( marParameters::e_mass_power ),
#ifdef __LFV__GET__VASCULAR__TREE__
      pts,
#else
      res,
#endif
      &n , sens , vit);

    // Data treatment
#ifdef __LFV__GET__VASCULAR__TREE__
    for( n = 0; n < res->nomAxes; n++ ) {
      tmp = new marAxis( getParameters( ) );
      tmp->set_points_disc( res->lstAxes[ n ] );
      for( i = 0; i < res->lstAxes[ n ]->nomPoints; i++ )
        tmp->AddAxisPoint( *( res->lstAxes[ n ]->lstPoints[ i ] ) );
      tmp->doSpline( );
      tmp->calculateSignal( _dynData->getVolume( ) );
      _axes.push_back( tmp );
    } // rof
#else
	if (n>2){
		//
		double voxSize = this->getParameters( )->getVoxelSize( );
		tmpAxis = new marAxis( this->getParameters( ) );
		std::string desc = "Axis N.";
		desc += _axes.size( );
		tmpAxis->setDescription( desc );
		tmpAxis->set_points_disc( res );
		for( i = 0; i < n; i++ ) {
			memcpy( pt, res[ i ], sizeof( POINTAXE ) );
			pt[ 0 ] *= voxSize;
			pt[ 1 ] *= voxSize;
			pt[ 2 ] *= voxSize;
			tmpAxis->addAxisPoint( pt );
		}	 // rof
		tmpAxis->doSpline( );
		tmpAxis->calculateSignal( _dynData->getVolume( ) );

		//
		int jCount=0;
		tmpAxis2 = new marAxis( this->getParameters( ) );
		tmpAxis2->setDescription( desc );
		tmpAxis2->set_points_disc( res );	
		for( i = 0; i < n; i++ ) {
			if (tmpAxis->getSignal(i)>=cleanLevel ){
				jCount++;
				memcpy( pt, res[ i ], sizeof( POINTAXE ) );
				pt[ 0 ] *= voxSize;
				pt[ 1 ] *= voxSize;
				pt[ 2 ] *= voxSize;
				tmpAxis2->addAxisPoint( pt );
			} else {
				i=n;
			}
		} // for 
		delete tmpAxis;

		if (jCount>2){
			tmpAxis2->doSpline( );
			tmpAxis2->calculateSignal( _dynData->getVolume( ) );
			_axes.push_back( tmpAxis2 );
			_axes[ 0 ] = tmpAxis2;
		} else {
			delete tmpAxis2;
		}
    }
#endif // __LFV__GET__VASCULAR__TREE__

}


//marContour* marExperiment::generateContour( int slice, int x, int y, std::vector< double* >* points) 
vtkPolyData* marExperiment::generateContour( int slice, int x, int y, std::vector< double* >* points)
{
/*  vtkImageData* imagedata;

  imagedata = getSliceImage( slice );
  vtkKitwareContourFilter* cntVTK = vtkKitwareContourFilter::New( );
  cntVTK->SetInput( imagedata );
  cntVTK->SetNumberOfContours( 1 );
  //cntVTK->SetValue( 0, vmin );
  cntVTK->SetValue( 0, 20 );
  //cntVTK->SetValue( 1, vmax );
  cntVTK->Update( );

    return cntVTK;*/

//  return(_axes[ 0 ]->setContour( slice, x, y, points));

	return NULL;
	
  //return( _axes[ 0 ]->getContour( slice ) );
}


// ----------------------------------------------------------------------------
void marExperiment::applyChangeResolution( )
{
  int i;

  for( i = 1; i < _axes.size( ); i++ )
    _axes[ i ]->changeAxisResolution( );
}

// ----------------------------------------------------------------------------
void marExperiment::prepareQuantification( )
{

// EED borrame
//  _axes[0]->sliceVolumeAxis( _dynData->getVolume( ), true);

  if( _axes[ 0 ] )
    _axes[ 0 ]->createEmptyVectors();

}

// ----------------------------------------------------------------------------
void marExperiment::backQuant( )
{
//Cette m�thode n'existe plus: dommage 
//    if ( _axes[0]->getQuantOn() )
  {
    _axes[0]->setFinishQuant( _axes[0]->getFinishQuant() - 1);
    if ( _axes[0]->getFinishQuant() < 0 )
      _axes[0]->setFinishQuant(0);
  }
}


// ----------------------------------------------------------------------------
void marExperiment::reset( )
{
  int i;

  _description = _T("");
  if( _dynData != NULL ) delete _dynData;
    
 
  _dynData = NULL;

  for( i = 1; i < _axes.size( ); i++ ){
    if (_axes[ i ]!=NULL) delete _axes[ i ];
  }

  _axes.clear( );
  _axes.push_back( NULL );
// PS ->   // PS Et les images ???? _quantificationImages
}

// ----------------------------------------------------------------------------
void marExperiment::calculateAxesSignal( )
{
  int i;
  for( i = 1; i < _axes.size( ); i++ )
    _axes[ i ]->calculateSignal( _dynData->getVolume( ) );
}

// ----------------------------------------------------------------------------
void marExperiment::prepareContourImages( )
{
  if( _axes[ 0 ] )
    _axes[ 0 ]->sliceVolumeAxis( _dynData->getVolume( ) );
}

// ----------------------------------------------------------------------------
void marExperiment::copyFrom( const marObject& from )
{ // TODO
}

// ----------------------------------------------------------------------------
bool marExperiment::save( std::ofstream& os )
{
  int i;
  size_t st;

  st = _description.length( );
  os.write( ( const char* )&st, sizeof( size_t ) );
  os.write( ( const char* )_description.c_str( ), sizeof( char ) * st );
  os.write( ( const char* )_startPoint, 3 * sizeof( int ) );
  os.write( ( const char* )_voi, 6 * sizeof( int ) );
  _dynData->save( os );
  i = _axes.size( ) - 1;
  os.write( ( const char* )&i, sizeof( int ) );
  for( i = 1; i < _axes.size( ); i++ )
    _axes[ i ]->save( os );
  return( true );
}

// ----------------------------------------------------------------------------
bool marExperiment::load(  std::ifstream& is )
{

  int i, n;
  char ttmp[ 5000 ];
  size_t st;
  marAxis* ax;

  reset( );

  is.read( ( char* )&st, sizeof( size_t ) );
  is.read( ( char* )ttmp, sizeof( char ) * st );
  ttmp[ st ] = '\0';

// EED 05 join 2007
// _description  = ttmp;
  _description   = wxString(ttmp, wxConvUTF8);

  is.read( ( char* )_startPoint, 3 * sizeof( int ) );
  is.read( ( char* )_voi, 6 * sizeof( int ) );

  _dynData = new marDynData( getParameters( ) );
  _dynData->load( is );

  is.read( ( char* )&n, sizeof( int ) );
  for( i = 1; i <= n; i++ ) {
    ax = new marAxis( getParameters( ) );
    ax->load( is );
    _axes.push_back( ax );
    _axes[ 0 ] = ax;
  } // rof
  return( true );
}

// ----------------------------------------------------------------------------
void marExperiment::DeleteAxis( unsigned int index )
{
	/* Very naughty bug, when doing a - 1, where a is uint32_t result is still
	uint32_t, imaging when a=0 :) need to cast to int*/
  
  int axesize=_axes.size( )-1;
  index=index+1;
  delete _axes[ index ];
  for( int i = index; i < axesize; i++ ) 
     _axes[ i ] = _axes[ i + 1 ];
  _axes.pop_back( );

  if (index<axesize) {
	_axes[ 0 ]=_axes[ index ];
  } else {
	_axes[ 0 ]=NULL;
  }

/*  
  _axes[index]->Delete();
  if(_axes[ 0 ]) 
	  _axes[ 0 ]->Delete( );
  _axes.erase(_axes.begin() + index);
*/

// PS ->   // PS : traitement identique � la methode std::vector::erase(iterator)
/*
  if(_axes[ 0 ]) 
	  _axes[ 0 ]->Delete( );
  delete _axes[ index ];
*/
}
// ----------------------------------------------------------------------------
void marExperiment::RegenerateSignal(){
	marAxis *maraxis = getAxis(); 
	if (maraxis!=NULL) {
		maraxis->calculateSignal( _dynData->getVolume( ) );
		maraxis->eraseContourVectorsContent();			 
	}
}
// ----------------------------------------------------------------------------
void marExperiment::ClearContours(){
	marAxis *maraxis = getAxis(); 
	if (maraxis!=NULL) maraxis->eraseContourVectorsContent();			 
}
// ----------------------------------------------------------------------------
void marExperiment::RegenerateAxis(){
	if (getAxis()!=NULL){
		int actualquant=getAxis()->getActualQuant();
		DeleteAxis(0);			
		extractVascularTree();
		setAxis(0);	
		getAxis()->setActualQuant(actualquant);
		getAxis()->createEmptyVectors();			 
	}
}
// ----------------------------------------------------------------------------
void marExperiment::RecalculateAxis(){
	marAxis *maraxis = getAxis(); 
	if (maraxis!=NULL){
		maraxis->doSpline();	 
		int nCnts = ( int ) maraxis->getNumberOfSplinePoints( );
		getAxis()->setActualQuant(nCnts/2);
		getAxis()->createEmptyVectors();			 
	}
}

// eof - experiment.cxx
