/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marExperiment.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__EXPERIMENT__HXX__
#define __MAR__KERNEL__EXPERIMENT__HXX__

#include <vector>
#include "volume.hxx"
#include "marAxis.h"
#include "marDynData.h"
#include "GestionBifurcations.h"

class MAR_KERNEL_EXPORT marExperiment : public marObject
{

public:

  marExperiment( marParameters* p = NULL );
  ~marExperiment( );

  wxString& getDescription( ) { return( _description ); };
  void setDescription( wxString& d )	{ _description = d; };

  marDynData* getDynData( )	{ return( _dynData ); };

  void getVOI( int* voi ) { memcpy( voi, _voi, sizeof( int ) * 6 ); };
  void setVOI( int* voi ) { memcpy( _voi, voi, sizeof( int ) * 6 ); };

  void initExperiment( kVolume* volume );

  void setStartPoint( int* sp )
  {
    setStartPoint( sp[ 0 ], sp[ 1 ], sp[ 2 ] );
  }

  void setStartPoint( int sx, int sy, int sz );
  void extractVascularTree( int sens = 1, double *vit=NULL, int cleanLevel=0 );
  void DeleteAxis ( unsigned int index );

//  marContour* generateContour( int slice, int x, int y, std::vector< double* >* points);
  vtkPolyData* generateContour( int slice, int x, int y, std::vector< double* >* points);

  void applyChangeResolution( );

  int getNumberOfAxes( )
  {
    return( _axes.size( ) - 1 );
  };

  marAxis* getAxis( int i = -1 ) 
  { 
    return( _axes[ i + 1 ] ); 
  };

  void appendAxis( marAxis* ax )
  {
    _axes.push_back( ax );
    _axes[ 0 ] = ax;
  }

  void setAxis( int i )
  {
    _axes[ 0 ] = _axes[ i + 1 ];
  }

  int   getQuantStart( )  { return _axes[0]->getStartQuant( );};
  int   getQuantFinish( ) { return _axes[0]->getFinishQuant( );};
  void  backQuant( );

  void prepareQuantification( );

  marContour*		getContour( int i )			{ return(_axes[0]->getContour		( i ,  _dynData->getVolume( )  ));	};
  vtkImageData*		getSliceImage( int i )		{ return(_axes[0]->getSliceImage	( i ,  _dynData->getVolume( )  ));	};
  vtkProbeFilter*	get3DSlice( int i )			{ return(_axes[0]->get3DSlice		( i ,  _dynData->getVolume( )  ));	};
  vtkPoints*		get3Dcontour( int i )		{ return(_axes[0]->get3Dcontour		( i ,  _dynData->getVolume( )  ));	};
  vtkPolyData*		get2Dcontour( int i )		{ return(_axes[0]->get2Dcontour		( i ,  _dynData->getVolume( )  ));	};
  vtkPoints*		get2DDiameterMin( int i )	{ return(_axes[0]->get2DDiameterMin	( i ,  _dynData->getVolume( )  ));	};
  vtkPoints*		get2DDiameterMax( int i )	{ return(_axes[0]->get2DDiameterMax	( i ,  _dynData->getVolume( )  ));	};
  double			getTotalLength()			{ return _axes[0]->getTotalLength() * _dynData->getActualVoxel() ;		};
  double			getSubAxisLength()			{ return _axes[0]->getSubAxisLength() * _dynData->getActualVoxel();		};
  double			getReferenceArea()			{ return _axes[0]->getReferenceArea( _dynData->getVolume( )); 			};
  double			getReferenceAverDiam()		{ return _axes[0]->getReferenceAverDiam( _dynData->getVolume( ));		};

  double			getAverageArea(int pIni, int pEnd) {return _axes[0]->getAverageArea(pIni,pEnd, _dynData->getVolume( ) );		};
  int				getNumberOfSlices( )		{ return _axes[0]->getNumberOfContours();								};

  void calculateAxesSignal( );
  void prepareContourImages( );

  void ClearContours();
  void RegenerateAxis();
  void RegenerateSignal();
  void RecalculateAxis();

  //General methods.
  void reset( );
  void copyFrom( const marObject& from );

  //Persistence methods.
  bool save( std::ofstream& os );
  bool load( std::ifstream& is );

private:

  wxString _description;
  marDynData* _dynData;
  int _voi[ 6 ];
  int _startPoint[ 3 ];

  std::vector< marAxis* > _axes;
};

#endif // __MAR__KERNEL__EXPERIMENT__HXX__
