/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marExperimentCT.cpp,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include "marExperimentCT.h"


// ----------------------------------------------------------------------------
marExperimentCT::marExperimentCT( marParameters* p ) : marExperiment( p )
                              
{
  
}

// ----------------------------------------------------------------------------
marContour* marExperimentCT::getContour( int point, int contour ) {
	return ((marAxisCT *)getAxis())->getContour(point,getDynData()->getVolume(),contour);
}

// ----------------------------------------------------------------------------
vtkPoints*	marExperimentCT::get3Dcontour( int point, int contour ) {
	return ((marAxisCT *)getAxis())->get3Dcontour(point,getDynData()->getVolume(),contour);
}

// ----------------------------------------------------------------------------
vtkPolyData* marExperimentCT::get2Dcontour( int point, int contour ) {
	return ((marAxisCT *)getAxis())->get2Dcontour(point,getDynData()->getVolume(),contour);
}

// ----------------------------------------------------------------------------
vtkPoints* marExperimentCT::get2DDiameterMin( int point, int contour ) {
	return ((marAxisCT *)getAxis())->get2DDiameterMin(point,getDynData()->getVolume(),contour);
}

// ----------------------------------------------------------------------------
vtkPoints* marExperimentCT::get2DDiameterMax( int point, int contour ) {
	return ((marAxisCT *)getAxis())->get2DDiameterMax(point,getDynData()->getVolume(),contour);;
}

// ----------------------------------------------------------------------------
int marExperimentCT::getNumberOfContours(int point) {
	return ((marAxisCT *)getAxis())->getNumberOfContours(point,getDynData()->getVolume( )) ;
}

// ----------------------------------------------------------------------------
void marExperimentCT::prepareQuantification( ) {

	if(getAxis())
	{
		((marAxisCT *)getAxis())->eraseContours();
		((marAxisCT *)getAxis())->createEmptyContours();
		marExperiment::prepareQuantification();
	}
	
}

// ----------------------------------------------------------------------------
void marExperimentCT::RegenerateAxis() {

	if (getAxis()!=NULL){
		((marAxisCT *)getAxis())->eraseContours();
		((marAxisCT *)getAxis())->createEmptyContours();
	//	marExperiment::RegenerateAxis();
	}

	
}

// ----------------------------------------------------------------------------
void marExperimentCT::RecalculateAxis() {

	if (getAxis()!=NULL){
		((marAxisCT *)getAxis())->eraseContours();
		((marAxisCT *)getAxis())->createEmptyContours();
		marExperiment::RecalculateAxis();
	}
	
}

// ----------------------------------------------------------------------------
void marExperimentCT::updateLumenPercentage(int percentage)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	((marAxisCT *)getAxis())->getParameters()->setLumenPercentage(percentage);
	((marAxisCT *)getAxis())->updateLumenPercentage(point,getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::updateCalcPercentage(int percentage) 
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	((marAxisCT *)getAxis())->getParameters()->setCalcPercentage(percentage);
	((marAxisCT *)getAxis())->updateCalcPercentage(point,getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::updateDiscontinuityThreshold(int percentage)
{
	((marAxisCT *)getAxis())->getParameters()->setContourThresh(percentage);
	((marAxisCT *)getAxis())->eraseContours();
	((marAxisCT *)getAxis())->createEmptyContours();
	((marAxisCT *)getAxis())->setCalibration(false);

}



// ----------------------------------------------------------------------------
int	marExperimentCT::getContourType(int point, int index) {
	return ((marAxisCT *)getAxis())->getContourType(point, index, getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::histogram(int point) {
	
	((marAxisCT *)getAxis())->histogram(point, getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::setCalibration(bool calib)
{
	((marAxisCT *)getAxis())->setCalibration(calib);
}

// ----------------------------------------------------------------------------
bool marExperimentCT::getCalibration()
{
	return ((marAxisCT *)getAxis())->getCalibration();
}

// ----------------------------------------------------------------------------
void marExperimentCT::ClearContoursPartial(int start)
{
	((marAxisCT *)getAxis())->eraseContoursPartial(start);
}

// ----------------------------------------------------------------------------
void marExperimentCT::setStartIndex(int start)
{
	((marAxisCT *)getAxis())->setStartIndex(start);
}

// ----------------------------------------------------------------------------
int	marExperimentCT::getPointSize()
{
	return ((marAxisCT *)getAxis())->getPointSize();
}

// ----------------------------------------------------------------------------
marPoint* marExperimentCT::getPoint(int i)
{
	return ((marAxisCT *)getAxis())->getPoint(i);
}

// ----------------------------------------------------------------------------
void marExperimentCT::markUpLumen(int point)
{
	((marAxisCT *)getAxis())->markUpLumen(point, getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::generateFile()
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	((marAxisCT *)getAxis())->generateFile(point, getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
void marExperimentCT::replaceContour2D(int size,double *vx,double *vy, int type)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	((marAxisCT *)getAxis())->replaceContour2D(point,size,vx,vy,type);
}

// ----------------------------------------------------------------------------
void marExperimentCT::cleanContours(int type)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	((marAxisCT *)getAxis())->cleanContours(type,point);
}

// ----------------------------------------------------------------------------
marIsocontour* marExperimentCT::loadMarIsocontour(int size, double *vx, double *vy)
{
	return ((marAxisCT *)getAxis())->loadMarIsocontour(size,vx,vy);
}

// ----------------------------------------------------------------------------
double marExperimentCT::performXOR(int type, std::vector<marIsocontour*> manual)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();

	return ((marAxisCT *)getAxis())->performXOR(type,point,manual, getDynData()->getVolume());
}

// ----------------------------------------------------------------------------
double marExperimentCT::performAND(int type, std::vector<marIsocontour*> manual)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	 
	return ((marAxisCT *)getAxis())->performAND(type,point,manual, getDynData()->getVolume());
	

}

// ----------------------------------------------------------------------------
double marExperimentCT::performUnion(int type, std::vector<marIsocontour*> manual)
{
	int point = ((marAxisCT *)getAxis())->getActualQuant();
	 
	return ((marAxisCT *)getAxis())->performUnion(type,point,manual, getDynData()->getVolume());
}
