/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marExperimentCT.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__EXPERIMENTCT__HXX__
#define __MAR__KERNEL__EXPERIMENTCT__HXX__

#include <vector>
#include "volume.hxx"
#include "marExperiment.h"
#include "marDynData.h"
#include "GestionBifurcations.h"
#include "marAxisCT.h"
#include "marPoint.h"

class MAR_KERNEL_EXPORT marExperimentCT : public marExperiment
{

public:
  
  marExperimentCT( marParameters* p = NULL );
  
  marContour*		getContour( int point, int contour );
  vtkPoints*		get3Dcontour( int point, int contour );
  vtkPolyData*		get2Dcontour( int point, int contour );
  vtkPoints*		get2DDiameterMin( int point, int contour );
  vtkPoints*		get2DDiameterMax( int point, int contour );
  int				getNumberOfContours(int point);
  void				prepareQuantification( );
  void				RegenerateAxis();
  void				RecalculateAxis();
  void				updateLumenPercentage(int percentage);
  void				updateCalcPercentage(int percentage);
  void				updateDiscontinuityThreshold(int percentage);
  int				getContourType(int point, int index);
  void				histogram(int point);
  void				setCalibration(bool calib);
  bool				getCalibration();
  void				ClearContoursPartial(int start);
  void				setStartIndex(int start);
  int				getPointSize();
  marPoint*			getPoint(int i);
  void				markUpLumen(int point);
  void				generateFile();
  void				replaceContour2D(int size,double *vx,double *vy, int type);
  void				cleanContours(int type);
  marIsocontour*	loadMarIsocontour(int size, double *vx, double *vy);
  double			performXOR(int type, std::vector<marIsocontour*> manual);
  double			performAND(int type, std::vector<marIsocontour*> manual);
  double			performUnion(int type, std::vector<marIsocontour*> manual);

};

#endif // __MAR__KERNEL__EXPERIMENTCT__HXX__
