/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marInterface.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/
#ifdef _MSC_VER
#pragma warning ( disable : 4786 )
#pragma warning ( disable : 4251 )
#endif //_MSC_VER

#include "marInterface.h"
#include <wx/file.h>
#include <wx/log.h>




// ----------------------------------------------------------------------------
marInterface::marInterface( )
: _parameters( NULL ), _dicom( NULL ),
_experiment( NULL )
{
	m_paramFileName=MAR_DEFAULT_FILE_PARAMETERS;
    _parameters = new marParameters( );
//EED    _dicom = new marGdcmDicom( _parameters );
    _experiment = new marExperiment( _parameters );
	
    // loadParameters( ); //PS !!! dangereux de faire des op�rations d'E/S 
	// dans des constructeurs
}

// ----------------------------------------------------------------------------
marInterface::~marInterface( ){
    reset( );
}

// ----------------------------------------------------------------------------
bool marInterface::loadParameters( std::string pFile )
{
	std::ifstream is( pFile.c_str( ),std::ios::binary|std::ios::in);

//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Loading parameters from file ") 
//		+ wxString(pFile.c_str()));
	
	if( is==NULL )
	{
		wxString errorMsg;
		errorMsg= wxString(_T("Error : Cannot open file "))
				+ wxString( pFile.c_str(), wxConvUTF8 )
				+ wxString(_T(" to load parameters"));
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return (false);
	}
	_parameters->reset( );
	if (_parameters->load( is ))
	{
		is.close( );
		return( true );
	}
	else
	{
		is.close();
//EEDxx2.4 DEBuG
//		wxLogDebug(wxString("Error : Cannot load parameters from file ")
//				+ wxString(pFile.c_str())
//				+ wxString(": file may be corrupted"));
		return (false);
	}
}

// ----------------------------------------------------------------------------
bool marInterface::saveParameters( std::string pFile )
{
	std::ofstream os(pFile.c_str( ),std::ios::binary | std::ios::out);
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Saving parameters to file ") 
//			+ wxString(pFile.c_str()));
	
	
	if( os==NULL )
	{
		wxString errorMsg;
		errorMsg= wxString(_T("Error : Cannot open file "))
				+ wxString(pFile.c_str(), wxConvUTF8)
				+ wxString(_T(" to save parameters"));
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return( false );
	}
	if(_parameters->save( os ))
	{
		os.close( );
		return( true );
	}
	else
	{
		os.close();
//EEDxx2.4 DEBuG
//		wxLogDebug(wxString("Error : Cannot save parameters to file ")
//				+ wxString(pFile.c_str()));
		return (false);
	}

}

// ----------------------------------------------------------------------------
bool marInterface::initExperiment( )
{
    _experiment->reset( );
    _experiment->initExperiment( _dicom->getVolume( ) );
    return( true );
	
}
// ----------------------------------------------------------------------------
bool marInterface::saveExperiment( std::string nFile )
{
	std::ofstream os( nFile.c_str( ),std::ios::binary | std::ios::out );
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Saving experiment to file ") 
//			+ wxString(nFile.c_str()));
	
	wxString errorMsg;
	errorMsg= wxString(_T("Cannot open file "))
			+ wxString(nFile.c_str(), wxConvUTF8)
			+ wxString(_T(" to save experiment"));

	
    if( os !=NULL ) {
		
        _parameters->save( os );
        _dicom->save( os );
        _experiment->save( os );
		os.close( );
		return( true );
		
    } // fi
//EEDxx2.4 DEBuG
//	wxLogDebug(errorMsg);
    return( false );
}

// ----------------------------------------------------------------------------
bool marInterface::loadExperiment( std::string nFile )
{
	std::ifstream is( nFile.c_str( ) ,std::ios::binary|std::ios::in );
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Loading experiment from file ") 
//			+ wxString(nFile.c_str()));
	
	wxString errorMsg;
	errorMsg= wxString(_T("Cannot open file "))
			+ wxString(nFile.c_str(), wxConvUTF8)
			+ wxString(_T(" to load experiment"));
	
    if( is !=NULL) {
		
        _parameters->reset( );
        _dicom->reset( );
        _experiment->reset( );
		
        _parameters->load( is );
        _dicom->load( is );
        _experiment->load( is );
		is.close( );
		return( true );
		
    } // fi
//EEDxx2.4 DEBuG
//	wxLogDebug(errorMsg);
    return( false );
}

// ----------------------------------------------------------------------------
void marInterface::reset( )
{
    if( _dicom		!= NULL ) delete _dicom;
    if( _experiment != NULL ) delete _experiment;
    if( _parameters != NULL ) delete _parameters;

    _dicom		= NULL;
    _experiment = NULL;
    _parameters = NULL;
}
// ----------------------------------------------------------------------------
void marInterface::SetParamFileName(std::string pFileName) 
{ 
	m_paramFileName=pFileName; 
}
// ----------------------------------------------------------------------------
std::string  marInterface::GetParamFileName() 
{ 
	return m_paramFileName;	 
}
// ----------------------------------------------------------------------------
void marInterface::SetDicom(marFilesBase *dicom) 
{
	_dicom=dicom;				 
}


// eof - interface.cxx


/* EED
void marInterface::SetVolumeData(int dimX,int dimY,int dimZ, float spacingX, float spacingY, float spacingZ, unsigned short * pixels)
{
	if (_dicom!=NULL)
		_dicom->SetVolumeData(dimX,dimY,dimZ,spacingX,spacingY,spacingZ,pixels);
}
*/

