/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marInterface.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__INTERFACE__HXX__
#define __MAR__KERNEL__INTERFACE__HXX__

//#include "marDicom.h"
#include "marDicomBase.h"
#include "marKVolume.h"
#include "marExperiment.h"

class MAR_KERNEL_EXPORT marInterface
{
  public:

    marInterface( );
    ~marInterface( );

    bool loadParameters( std::string pFile );
    bool saveParameters( std::string pFile );

    bool loadParameters( ) {return loadParameters(m_paramFileName);}
    bool saveParameters( ) {return saveParameters(m_paramFileName);}

    bool initExperiment( );

    bool saveExperiment( std::string nFile );
//    bool loadExperiment( wxString nFile );
    bool loadExperiment( std::string nFile );

    void reset( );

	void		SetParamFileName(std::string pFileName); 
	std::string GetParamFileName();
	void		SetDicom(marFilesBase *dicom);

//EED    void SetVolumeData(int dimX,int dimY,int dimZ, float spacingX, float spacingY, float spacingZ, unsigned short * pixels);
//		marDicom*		_dicom;
//EED   marGdcmDicom*	_dicom;

    marFilesBase*		_dicom;

    marExperiment*	_experiment;
    marParameters*	_parameters;

protected:
	std::string m_paramFileName;
};

#endif // __MAR__KERNEL__INTERFACE__HXX__
