/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marInterfaceCT.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
=========================================================================*/
#ifdef _MSC_VER
#pragma warning ( disable : 4786 )
#pragma warning ( disable : 4251 )
#endif //_MSC_VER

#include "marInterfaceCT.h"
#include <wx/file.h>
#include <wx/log.h>




// ----------------------------------------------------------------------------
marInterfaceCT::marInterfaceCT( )
: _parameters( NULL ), _dicom( NULL ),
_experiment( NULL )
{
	m_paramFileName=MAR_DEFAULT_FILE_PARAMETERS;
    _parameters = new marParameters( );

    _experiment = new marExperimentCT( _parameters );
	
    
}

// ----------------------------------------------------------------------------
marInterfaceCT::~marInterfaceCT( ){
    reset( );
}

// ----------------------------------------------------------------------------
bool marInterfaceCT::loadParameters( std::string pFile )
{
	std::ifstream is( pFile.c_str( ),std::ios::binary|std::ios::in);

//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Loading parameters from file ") 
//		+ wxString(pFile.c_str()));
	
	if( is==NULL )
	{
		wxString errorMsg;
		errorMsg= wxString(_T("Error : Cannot open file "))
				+ wxString((wxChar*)pFile.c_str(), wxConvUTF8)
				+ wxString(_T(" to load parameters"));
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return (false);
	}
	_parameters->reset( );
	if (_parameters->load( is ))
	{
		is.close( );
		return( true );
	}
	else
	{
		is.close();
//EEDxx2.4 DEBuG
//		wxLogDebug(wxString("Error : Cannot load parameters from file ")
//				+ wxString(pFile.c_str())
//				+ wxString(": file may be corrupted"));
		return (false);
	}
}

// ----------------------------------------------------------------------------
bool marInterfaceCT::saveParameters( std::string pFile )
{
	std::ofstream os(pFile.c_str( ),std::ios::binary | std::ios::out);
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Saving parameters to file ") 
//			+ wxString(pFile.c_str()));
	
	
	if( os==NULL )
	{
		wxString errorMsg;
		errorMsg= wxString(_T("Error : Cannot open file "))
				+ wxString( (wxChar*)pFile.c_str(), wxConvUTF8)
				+ wxString(_T(" to save parameters"));
//EEDxx2.4 DEBuG
//		wxLogDebug(errorMsg);
		return( false );
	}
	if(_parameters->save( os ))
	{
		os.close( );
		return( true );
	}
	else
	{
		os.close();
//EEDxx2.4 DEBuG
//		wxLogDebug(wxString("Error : Cannot save parameters to file ")
//				+ wxString(pFile.c_str()));
		return (false);
	}

}

// ----------------------------------------------------------------------------
bool marInterfaceCT::initExperiment( )
{
    _experiment->reset( );
    _experiment->initExperiment( _dicom->getVolume( ) );
    return( true );
	
}
// ----------------------------------------------------------------------------
bool marInterfaceCT::saveExperiment( std::string nFile )
{
	std::ofstream os( nFile.c_str( ),std::ios::binary | std::ios::out );
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Saving experiment to file ") 
//			+ wxString(nFile.c_str()));
	
	wxString errorMsg;
	errorMsg= wxString(_T("Cannot open file "))
			+ wxString((wxChar*)nFile.c_str(), wxConvUTF8)
			+ wxString(_T(" to save experiment"));

	
    if( os !=NULL ) {
		
        _parameters->save( os );
        _dicom->save( os );
        _experiment->save( os );
		os.close( );
		return( true );
		
    } // fi
//EEDxx2.4 DEBuG
//	wxLogDebug(errorMsg);
    return( false );
}

// ----------------------------------------------------------------------------
bool marInterfaceCT::loadExperiment( std::string nFile )
{
	std::ifstream is( nFile.c_str( ) ,std::ios::binary|std::ios::in );
	
//EEDxx2.4 DEBuG
//	wxLogDebug(wxString("Loading experiment from file ") 
//			+ wxString(nFile.c_str()));
	
	wxString errorMsg;
	errorMsg= wxString(_T("Cannot open file "))
			+ wxString((wxChar*)nFile.c_str(), wxConvUTF8)
			+ wxString(_T(" to load experiment"));
	
    if( is !=NULL) {
		
        _parameters->reset( );
        _dicom->reset( );
        _experiment->reset( );
		
        _parameters->load( is );
        _dicom->load( is );
        _experiment->load( is );
		is.close( );
		return( true );
		
    } // fi
//EEDxx2.4 DEBuG
//	wxLogDebug(errorMsg);
    return( false );
}

// ----------------------------------------------------------------------------
void marInterfaceCT::reset( ){
    if( _experiment != NULL ) delete _experiment;
    if( _dicom != NULL ) delete _dicom;
    if( _parameters != NULL ) delete _parameters;
    _experiment = NULL;
    _dicom = NULL;
    _parameters = NULL;
}
// ----------------------------------------------------------------------------
void marInterfaceCT::SetParamFileName(std::string pFileName) { 
	m_paramFileName=pFileName; 
}
// ----------------------------------------------------------------------------
std::string  marInterfaceCT::GetParamFileName() { 
	return m_paramFileName;	 
}
// ----------------------------------------------------------------------------
void marInterfaceCT::SetDicom(marFilesBase *dicom) {
	_dicom=dicom;				 
}

// ----------------------------------------------------------------------------
void marInterfaceCT::appendAxis( marAxis* ax )
{
    _experiment->appendAxis(ax);
}


// ----------------------------------------------------------------------------
marAxisCT* marInterfaceCT::getAxis( int i ) {
	return (marAxisCT *) _experiment->getAxis(i);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::setAxis( int i )
{
   _experiment->setAxis(i);
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getQuantStart( ) {
	return _experiment->getQuantStart( );
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getQuantFinish( ) {
	return _experiment->getQuantFinish( );
}
 
// ----------------------------------------------------------------------------
void marInterfaceCT::prepareQuantification( ) {
	_experiment->prepareQuantification( );
}


// ----------------------------------------------------------------------------
vtkImageData* marInterfaceCT::getSliceImage( int i ) {
	return _experiment->getSliceImage( i );
}

// ----------------------------------------------------------------------------
vtkProbeFilter*	marInterfaceCT::get3DSlice( int i ) {
	return _experiment->get3DSlice( i );
}

// ----------------------------------------------------------------------------
double marInterfaceCT::getTotalLength( ) {
	return _experiment->getTotalLength( );
}

// ----------------------------------------------------------------------------
double marInterfaceCT::getSubAxisLength( ) {
	return _experiment->getSubAxisLength( );
}

// ----------------------------------------------------------------------------
double marInterfaceCT::getReferenceArea( ) {
		return _experiment->getReferenceArea( );
}

// ----------------------------------------------------------------------------
double	marInterfaceCT::getReferenceAverDiam() {
	return _experiment->getReferenceAverDiam( );
}

// ----------------------------------------------------------------------------
double marInterfaceCT::getAverageArea(int pIni, int pEnd) {
	return _experiment->getAverageArea(pIni,pEnd);
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getNumberOfSlices( ) {
	return _experiment->getNumberOfSlices( );
}

// ----------------------------------------------------------------------------	
int marInterfaceCT::getActualQuant( ) {
	return _experiment->getAxis()->getActualQuant();
}

// ----------------------------------------------------------------------------
marExperimentCT* marInterfaceCT::GetExperiment()
{
	return _experiment;
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getHealthySlice( ) {
	return _experiment->getAxis( )->getHealthySlice( );
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getHealthySliceStart( ) {
	return _experiment->getAxis()->getHealthySliceStart( );
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getHealthySliceEnd( ) {
	return _experiment->getAxis()->getHealthySliceEnd( );
}

// ----------------------------------------------------------------------------
void marInterfaceCT::setHealthySlice( int hsS, int hs, int hsE ) {
	_experiment->getAxis()->setHealthySlice(hsS,hs,hsE);
	
}
// ----------------------------------------------------------------------------
void marInterfaceCT::setActualQuant(int act) {
	_experiment->getAxis()->setActualQuant( act ) ;
}

// ----------------------------------------------------------------------------
void marInterfaceCT::replaceContour2D(int i,int size,double *vx,double *vy) {
	_experiment->getAxis()->replaceContour2D(i,size,vx,vy);
}

void marInterfaceCT::replaceContour2D(int size,double *vx,double *vy, int type)
{
	_experiment->replaceContour2D(size,vx,vy,type);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::EraseContour( int i ) {
	_experiment->getAxis()->EraseContour( i );
}

// ----------------------------------------------------------------------------
void marInterfaceCT::ClearContours() {
	_experiment->ClearContours();
}

// ----------------------------------------------------------------------------
void marInterfaceCT::RegenerateAxis() {
	_experiment->RegenerateAxis();
}

// ----------------------------------------------------------------------------
void marInterfaceCT::RegenerateSignal() {
	_experiment->RegenerateSignal();
}

// ----------------------------------------------------------------------------
void marInterfaceCT::RecalculateAxis() {
	_experiment->RegenerateAxis();
}

// ----------------------------------------------------------------------------	
void marInterfaceCT::getMinMax( double& min, double& max ) {
	_experiment->getDynData( )->getVolume( )->getMinMax( min, max );
}

// ----------------------------------------------------------------------------	
marContour* marInterfaceCT::getContour( int point, int contour ) {
	return _experiment->getContour(point,contour);
}

// ----------------------------------------------------------------------------	
vtkPoints*	marInterfaceCT::get3Dcontour( int point, int contour ) {
	return _experiment->get3Dcontour(point,contour);
}

// ----------------------------------------------------------------------------	
vtkPolyData* marInterfaceCT::get2Dcontour( int point, int contour ) {
	return _experiment->get2Dcontour(point,contour);
}

// ----------------------------------------------------------------------------	
vtkPoints* marInterfaceCT::get2DDiameterMin( int point, int contour ) {
	return _experiment->get2DDiameterMin(point,contour);
}

// ----------------------------------------------------------------------------	
vtkPoints* marInterfaceCT::get2DDiameterMax( int point, int contour ) {
	return _experiment->get2DDiameterMax(point,contour);
}

// ----------------------------------------------------------------------------	
marParameters* marInterfaceCT::getParameters(){
	return _parameters;
}
// ----------------------------------------------------------------------------	
marDynData* marInterfaceCT::getDynData(){
	return  _experiment->getDynData();
}

// ----------------------------------------------------------------------------	
int marInterfaceCT::getNumberOfContours(int point) {
	return _experiment->getNumberOfContours(point);
}


// ----------------------------------------------------------------------------
void marInterfaceCT::updateLumenPercentage(int percentage) {
	_experiment->updateLumenPercentage(percentage);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::updateCalcPercentage(int percentage) {
	_experiment->updateCalcPercentage(percentage);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::updateDiscontinuityThreshold(int percentage) {
	_experiment->updateDiscontinuityThreshold(percentage);
	//TODO HACER RESET DEL CONTORNO
}

// ----------------------------------------------------------------------------
int marInterfaceCT::getContourType(int point, int index)
{
	return _experiment->getContourType(point,index);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::histogram(int point)
{
	_experiment->histogram(point);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::setCalibration(bool calib)
{
	_experiment->setCalibration(calib);
}

// ----------------------------------------------------------------------------
bool marInterfaceCT::getCalibration()
{
	return _experiment->getCalibration();
}

// ----------------------------------------------------------------------------
void marInterfaceCT::ClearContoursPartial(int start)
{
	_experiment->ClearContoursPartial(start);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::setStartIndex(int start)
{
	_experiment->setStartIndex(start);
}

// ----------------------------------------------------------------------------
int	marInterfaceCT::getPointSize()
{
	return _experiment->getPointSize();
}

// ----------------------------------------------------------------------------
marPoint* marInterfaceCT::getPoint(int i)
{
	return _experiment->getPoint(i);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::markUpLumen(int point)
{
	_experiment->markUpLumen(point);
}

// ----------------------------------------------------------------------------
void marInterfaceCT::generateFile()
{
	_experiment->generateFile();
}

// ----------------------------------------------------------------------------
void marInterfaceCT::cleanContours(int type)
{
	_experiment->cleanContours(type);
}

// ----------------------------------------------------------------------------
marIsocontour* marInterfaceCT::loadMarIsocontour(int size, double *vx, double *vy)
{
	return _experiment->loadMarIsocontour(size,vx,vy);
}

// ----------------------------------------------------------------------------
double marInterfaceCT::performXOR(int type, std::vector<marIsocontour*> manual)
{
	return _experiment->performXOR(type, manual);
}

// ----------------------------------------------------------------------------
double marInterfaceCT::performAND(int type, std::vector<marIsocontour*> manual)
{
	return _experiment->performAND(type, manual);
}


double marInterfaceCT::performUnion(int type, std::vector<marIsocontour*> manual)
{
	return _experiment->performUnion(type, manual);
}
// eof - marInterfaceCT.cxx


