/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: marInterfaceCT.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:31 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __MAR__KERNEL__INTERFACECT__HXX__
#define __MAR__KERNEL__INTERFACECT__HXX__

//#include "marDicom.h"
#include "marDicomBase.h"
#include "marKVolume.h"
#include "marExperimentCT.h"
#include "marAxisCT.h"
#include "marDynData.h"




class MAR_KERNEL_EXPORT marInterfaceCT
{
  public:

    marInterfaceCT( );
    ~marInterfaceCT( );

    bool loadParameters( std::string pFile );
    bool saveParameters( std::string pFile );

    bool loadParameters( ) {return loadParameters(m_paramFileName);}
    bool saveParameters( ) {return saveParameters(m_paramFileName);}

    bool initExperiment( );

    bool saveExperiment( std::string nFile );
//    bool loadExperiment( wxString nFile );
    bool loadExperiment( std::string nFile );

    void reset( );

	void		SetParamFileName(std::string pFileName); 
	std::string GetParamFileName();
	void		SetDicom(marFilesBase *dicom);
	
	void appendAxis( marAxis* ax );
	marAxisCT* getAxis( int i = -1 ) ;
	void setAxis( int i );

	int   getQuantStart( );
	int   getQuantFinish( );
 

	void prepareQuantification( );


	vtkImageData*		getSliceImage( int i );
	vtkProbeFilter*	get3DSlice( int i );
	double			getTotalLength();
	double			getSubAxisLength();
	double			getReferenceArea();
	double			getReferenceAverDiam();
	double			getAverageArea(int pIni, int pEnd);
	int				getNumberOfSlices( );

	marContour*		getContour( int point, int contour );
    vtkPoints*		get3Dcontour( int point, int contour );
    vtkPolyData*	get2Dcontour( int point, int contour );
    vtkPoints*		get2DDiameterMin( int point, int contour );
    vtkPoints*		get2DDiameterMax( int point, int contour );

	marParameters*  getParameters();
	marDynData*		getDynData();

	void getVOI( int* voi ) { _experiment->getVOI(voi); };
	void setVOI( int* voi ) { _experiment->setVOI(voi); };
	int getActualQuant( );
	int getHealthySlice( );
	int getHealthySliceStart( );
	int getHealthySliceEnd( );
	void setHealthySlice( int hsS, int hs, int hsE );
	void setActualQuant(int act);

	void replaceContour2D(int i,int size,double *vx,double *vy);
	void replaceContour2D(int size,double *vx,double *vy, int type);
	void cleanContours(int type);
	void EraseContour(int i);

	void ClearContours();
    void RegenerateAxis();
    void RegenerateSignal();
    void RecalculateAxis();
	void ClearContoursPartial(int start);
	
	void getMinMax( double& min, double& max );

	int getNumberOfContours(int point);

	void updateLumenPercentage(int percentage);
	void updateCalcPercentage(int percentage);
	void updateDiscontinuityThreshold(int percentage);
 
	marIsocontour* loadMarIsocontour(int size, double *vx, double *vy);
	double performXOR(int type, std::vector<marIsocontour*> manual);
	double performAND(int type, std::vector<marIsocontour*> manual);
	double performUnion(int type, std::vector<marIsocontour*> manual);

	void histogram(int point) ;
	



	int	getContourType(int point, int index);
	void				setCalibration(bool calib);
	bool				getCalibration();
	void				setStartIndex(int start);

	int					getPointSize();
	marPoint*			getPoint(int i);
	void				markUpLumen(int point);
	void				generateFile();

	marExperimentCT* GetExperiment();

    marFilesBase*		_dicom;
	marParameters*		_parameters;
	

protected:
	std::string m_paramFileName;

private:
	marExperimentCT*	_experiment;
};

#endif // __MAR__KERNEL__INTERFACECT__HXX__
