/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marIsocontour.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/


#include "marIsocontour.h"

// ----------------------------------------------------------------------------
marIsocontour::marIsocontour() {
	intmax = -1;
}

// ----------------------------------------------------------------------------
marIsocontour::~marIsocontour() {
	
	//TODO - SACAR A UTILS
	for (int ind = 0; ind < listContour.size(); ind++)
	{
		marPoint* p = listContour[ind];
		listContour[ind] = NULL;
		delete p;
		
	}
	listContour.clear();

}

// ----------------------------------------------------------------------------
marIsocontour::marIsocontour(double intmax) {
	this->intmax = intmax;
}
	
// ----------------------------------------------------------------------------
void marIsocontour::getCG(double *x, double *y) {
   double sumax = 0;
   double sumay = 0;

	for (int i = 0; i < listContour.size(); i++){
		double x, y;
		getPoint(i, &x, &y);
		sumax +=x;
		sumay +=y;
	}

	sumax /= listContour.size();
	sumay /= listContour.size();

	*x = (double) sumax;
	*y = (double) sumay;
}

// ----------------------------------------------------------------------------
void marIsocontour::insertPoint(double x, double y) {
	marPoint* p = new marPoint(x, y);
	listContour.push_back(p);
}

// ----------------------------------------------------------------------------
void marIsocontour::getPoint(int i, double *x, double *y) {
	marPoint* p = listContour[i];
	*x = p->getX();
	*y = p->getY();

}

// ----------------------------------------------------------------------------
void marIsocontour::setPoint(int i, double x, double y) {
	marPoint *p = listContour[i];
	p->setPoint(x, y);
}

// ----------------------------------------------------------------------------
int marIsocontour::getSize() {
	return listContour.size();
}

// ----------------------------------------------------------------------------
double marIsocontour::getMaxIntensity() {
	return intmax;
}

// ----------------------------------------------------------------------------
int marIsocontour::getType() {
	return type;
}

// ----------------------------------------------------------------------------
void marIsocontour::setType(int type) {
	this->type = type;
}

// ----------------------------------------------------------------------------
int marIsocontour::getDir(int i) {
	marPoint* p = listContour[i];
	return p->getDirection();
}

// ----------------------------------------------------------------------------
void marIsocontour::setDir(int i, int direction) {
	marPoint *p = listContour[i];
	p->setDirection(direction);
}

// ----------------------------------------------------------------------------
void marIsocontour::setInside(int i, bool ins) {
	marPoint *p = listContour[i];
	p->setInside(ins);
}

// ----------------------------------------------------------------------------
bool marIsocontour::getInside(int i) {
	marPoint* p = listContour[i];
	return p->getInside();
}

// ----------------------------------------------------------------------------
void marIsocontour::setMaxIntensity(double intmax) {
	this->intmax = intmax;
}

// ----------------------------------------------------------------------------
void marIsocontour::removeLastPoint() {
	listContour.pop_back();
}

