/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "marLine.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
marLine::marLine(){
	this->a = 1;
	this->b = 1;
	this->c = 0;
}

// ----------------------------------------------------------------------------
marLine::marLine(double x1, double y1, double x2, double y2){
	this->a = y2 - y1;			//REVISAR SIGNO
	this->b = (x1 - x2);
	this->c = (y1 - y2) * x1 + (x2 - x1)*y1;
}

// ----------------------------------------------------------------------------
marLine::marLine(double a, double b){
	this->a = a;
	this->b = b;
	this->c = 0;
}

// ----------------------------------------------------------------------------
void marLine::getNormal(double *a, double *b){
	*a = (this->b);
	*b = this->a;
}

// ----------------------------------------------------------------------------
void marLine::getIntersect(double a, double b, double c, double *x, double *y){

	if (this->a == a){
		*x = -1;
		*y = -1;
		return;
	}

	if (this->b == b){
		*x = -1;
		*y = -1;
		return;
	}

	*x = (c*this->b - this->c*b) / (this->a*b - a*this->b);

	if (this->b == 0){
		*y = -c/b;
	} else if (b == 0){
		*y = -this->c/this->b;
	} else {
		*y = (-this->a*(*x) - this->c) / this->b;
	}
	

	if (*x < 0 || *y < 0){
		*x = -1;
		*y = -1;
	}
	
}
// ----------------------------------------------------------------------------
double marLine::getA(){
	return a;
}

// ----------------------------------------------------------------------------
double marLine::getB(){
	return b;
}

// ----------------------------------------------------------------------------
double marLine::getC(){
	return c;
}

// ----------------------------------------------------------------------------
marLine::~marLine(){
}

