/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

// marLine.h: interface for the marLine class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __marLine_h
#define __marLine_h

class marLine  
{
public:
	marLine();
	marLine(double x1, double y1, double x2, double y2);
	marLine(double a, double b);
	void getNormal(double *a, double *b);
	void getIntersect(double a, double b, double c, double *x, double *y);
	double getA();
	double getB();
	double getC();
	virtual ~marLine();

private:
	double a;
	double b;
	double c;
};

#endif // !defined(AFX_MARLINE_H__28F8F1C4_E5F2_48C7_94E0_3C8BEA226D06__INCLUDED_)
