/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

// marMatrix.h: interface for the marMatrix class.
//
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <stddef.h>
#include "marVector.h"

class marMatrix  
{
public:
/*==Constructeurs========================================*/
	marMatrix(const marMatrix &m);
	marMatrix(double * data,size_t size1=3,size_t size2=3);
	marMatrix(size_t size1,size_t size2);
/*==Constructeurs========================================*/
	virtual ~marMatrix();

/*==op�rateurss========================================*/
    friend std::ostream& operator<<(std::ostream& os, const marMatrix& m);
 
	marMatrix& operator=( const marMatrix& o );
    marMatrix& operator=( double o );
    marMatrix& operator=( double* o );

    operator double*( ) const;

    double& operator()( size_t i, size_t j );
    const double& operator()( size_t i, size_t j ) const;

    marMatrix operator+( const marMatrix& o );
    marMatrix operator+( double o );
    marMatrix operator+( double* o );

	marMatrix operator-( const marMatrix& o );
    marMatrix operator-( double o );
    marMatrix operator-( double* o );

	marMatrix operator*( const marMatrix& o );
    marVector operator*( const marVector& o );
    marMatrix operator*( double o );

    bool operator==( const marMatrix& o ) const;
    bool operator!=( const marMatrix& o ) const;

/*==M�thodes========================================*/
	size_t columns() const;
	size_t rows() const;

/*==Attributs========================================*/
private:
	bool shallowCopy; // true if _data is a shallow copy of original data (pointer copy)
	size_t _size1;
	size_t _size2;
	double* _data;
};

