/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marSimpleDicom.cpp,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifdef _MSC_VER
#pragma warning ( disable : 4786 )
#pragma warning ( disable : 4251 )
#endif //_MSC_VER

// PS -> #include "gdcm.h"
#include "marSimpleDicom.h"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <vector>
#include <string>
// PS -> #include "vtkGdcmReader.h"
#include <vtkImageChangeInformation.h>
#include <vtkImageCast.h>
#include <vtkImageResample.h>
#include <vtkImageShiftScale.h>
// PS -> #include <gdcmHeaderHelper.h>
#include <vtkCommand.h>
#include <vtkUnsignedShortArray.h>
#include <vtkPointData.h>

#include <wx/gauge.h>
#include <wx/app.h>



//----------------------------------------------------------------------------
// Callback for the interaction
class marProgressObserver : public vtkCommand
{
public:
	static marProgressObserver *New()
    { return new marProgressObserver; }
    marProgressObserver()
    {
		this->FrameGauge = NULL;
    }
	virtual void Execute(vtkObject *wdg, unsigned long event, void* calldata)
    {
		if ( this->FrameGauge )
        {
			int val = this->FrameGauge->GetValue();
			this->FrameGauge->SetValue( val + 1);
			//wxYield();
			//wxSafeYield();
			//wxYieldIfNeeded();
			//wxWakeUpIdle();
			//wxSafeYield( this->FrameGauge, FALSE);
        }
    }
	wxGauge *FrameGauge;
};
//----------------------------------------------------------------------------


static char* DicomTagsNames[] = {
    "ID_File_Name",
		"ID_SOP_Class_UID",                     //!0008 0016 UI ID SOP Class UID
		"ID_SOP_Instance_UID",                  //!0008 0018 UI ID SOP Instance UID
		"ID_Study_Date",                        //!0008 0020 DA ID Study Date
		"ID_Series_Date",                       //!0008 0021 DA ID Series Date
		"ID_Acquisition_Date",                  //!0008 0022 DA ID Acquisition Date
		"ID_Image_Date",                        //!0008 0023 DA ID Image Date
		"ID_Study_Time",                        //!0008 0030 TM ID Study Time
		"ID_Series_Time",                       //!0008 0031 TM ID Series Time
		"ID_Acquisition_Time",                  //!0008 0032 TM ID Acquisition Time
		"ID_Image_Time",                        //!0008 0033 TM ID Image Time
		"ID_Modality",                          //!0008 0060 CS ID Modality
		"ID_Manufacturer",                      //!0008 0070 LO ID Manufacturer
		"ID_Institution_Name",                  //!0008 0080 LO ID Institution Name
		"ID_Study_Description",                 //!0008 1030 LO ID Study Description
		"ID_Series_Description",                //!0008 103e LO ID Series Description
		"ID_Admitting_Diagnoses_Description",   //!0008 1080 LO ID Admitting Diagnoses Description
		"ID_Patient_Name",                      //!0010 0010 PN PAT Patient Name
		"ID_Patient_ID",                        //!0010 0020 LO PAT Patient ID
		"ID_Body_Part_Examined",                //!0018 0015 CS ACQ Body Part Examined
		"ID_Scanning_Sequence",                 //!0018 0020 CS ACQ Scanning Sequence
		"ID_Sequence_Variant",                  //!0018 0021 CS ACQ Sequence Variant
		"ID_Scan_Options",                      //!0018 0022 CS ACQ Scan Options
		"ID_MR_Acquisition_Type",               //!0018 0023 CS ACQ MR Acquisition Type
		"ID_Sequence_Name",                     //!0018 0024 SH ACQ Sequence Name
		"ID_Slice_Thickness",                   //!0018 0050 DS ACQ Slice Thickness
		"ID_Repetition_Time",                   //!0018 0080 DS ACQ Repetition Time
		"ID_Echo_Time",                         //!0018 0081 DS ACQ Echo Time
		"ID_Inversion_Time",                    //!0018 0082 DS ACQ Inversion Time
		"ID_Number_of_Averages",                //!0018 0083 DS ACQ Number of Averages
		"ID_Imaging_Frequency",                 //!0018 0084 DS ACQ Imaging Frequency
		"ID_Imaged_Nucleus",                    //!0018 0085 SH ACQ Imaged Nucleus
		"ID_Echo_Number",                       //!0018 0086 IS ACQ Echo Number
		"ID_Magnetic_Field_Strength",           //!0018 0087 DS ACQ Magnetic Field Strength
		"ID_Spacing_Between_Slices",            //!0018 0088 DS ACQ Spacing Between Slices
		"ID_Echo_Train_Length",                 //!0018 0091 IS ACQ Echo Train Length
		"ID_Percent_Sampling",                  //!0018 0093 DS ACQ Percent Sampling
		"ID_Percent_Phase_Field_of_View",       //!0018 0094 DS ACQ Percent Phase Field of View
		"ID_Receiving_Coil",                    //!0018 1250 SH ACQ Receiving Coil
		"ID_Patient_Position",                  //!0018 5100 CS ACQ Patient Position
		"ID_Study_Instance_UID",                //!0020 000d UI REL Study Instance UID
		"ID_Series_Instance_UID",               //!0020 000e UI REL Series Instance UID
		"ID_Study_ID",                          //!0020 0010 SH REL Study ID
		"ID_Series_Number",                     //!0020 0011 IS REL Series Number
		"ID_Acquisition_Number",                //!0020 0012 IS REL Acquisition Number
		"ID_Image_Number",                      //!0020 0013 IS REL Image Number
		"ID_Patient_Orientation",               //!0020 0020 CS REL Patient Orientation
		"ID_Image_Position",                    //!0020 0030 RET REL Image Position
		"ID_Image_Position_Patient",            //!0020 0032 DS REL Image Position Patient
		"ID_Image_Orientation",                 //!0020 0035 RET REL Image Orientation
		"ID_Image_Orientation_Patient",         //!0020 0037 DS REL Image Orientation (Patient)
		"ID_Location",                          //!0020 0050 RET REL Location
		"ID_Frame_of_Reference_UID",            //!0020 0052 UI REL Frame of Reference UID
		"ID_Slice_Location",                    //!0020 1041 DS REL Slice Location
		"ID_Image_Comments",                    //!0020 4000 LT REL Image Comments
		"ID_Pixel_Spacing",                     //!0028 0030 DS IMG Pixel Spacing
		"ID_Window_Center",                     //!0028 1050 DS IMG Window Center
		"ID_Window_Width",                      //!0028 1051 DS IMG Window Width
};

// -------------------------------------------------------------------------
marSimpleDicom::marSimpleDicom( marParameters* p )
: marFilesBase( p ), m_pSlicesPixels(NULL),
m_ActualStudy(0), m_ActualSerie(0)
// PS -> ,helper(NULL)
{
	// FillDicomInfo( );
}

// -------------------------------------------------------------------------
marSimpleDicom::~marSimpleDicom(){
	reset( );
}



/** Conversion de wxString en string. */
//#define ws2s(as) (string(as.GetData()))
/** Conversion de string en wxString. */
#define s2ws(s) (wxString((s).c_str()))
/** Conversion de C-string en wxString. */
//#define cs2ws(s) (wxString(s))

// -------------------------------------------------------------------------
// PS -> wxArrayString marGdcmDicom::gdcmGetExamInfo( wxString directoryname )
// PS -> {
// PS -> 	wxArrayString temparray;
// PS -> 	temparray.Alloc( 58 );
// PS ->
// PS -> 	wxDir dir(directoryname);
// PS -> 	wxString filename;
// PS -> 	bool cont = dir.GetFirst( &filename, "*", wxDIR_FILES );
// PS -> 	filename = directoryname + "/" + filename;
// PS ->
// PS -> 	std::string val;
// PS ->
// PS -> 	gdcmHeader GdcmHeader( filename.c_str() );
// PS -> 	temparray.Add( filename );                                             //    "ID_File_Name",
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0016).c_str() );//    "ID_SOP_Class_UID",         //0008 0016 UI ID SOP Class UID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0018).c_str() );//    "ID_SOP_Instance_UID",      //0008 0018 UI ID SOP Instance UID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0020).c_str() );//    "ID_Study_Date",            //0008 0020 DA ID Study Date
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0021).c_str() );//    "ID_Series_Date",           //0008 0021 DA ID Series Date
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0022).c_str() );//    "ID_Acquisition_Date",      //0008 0022 DA ID Acquisition Date
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0023).c_str() );//    "ID_Image_Date",            //0008 0023 DA ID Image Date
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0030).c_str() );//    "ID_Study_Time",            //0008 0030 TM ID Study Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0031).c_str() );//    "ID_Series_Time",           //0008 0031 TM ID Series Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0032).c_str() );//    "ID_Acquisition_Time",      //0008 0032 TM ID Acquisition Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0033).c_str() );//    "ID_Image_Time",            //0008 0033 TM ID Image Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0060).c_str() );//    "ID_Modality",              //0008 0060 CS ID Modality
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0070).c_str() );//    "ID_Manufacturer",          //0008 0070 LO ID Manufacturer
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x0080).c_str() );//    "ID_Institution_Name",      //0008 0080 LO ID Institution Name
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x1030).c_str() );//    "ID_Study_Description",     //0008 1030 LO ID Study Description
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x103e).c_str() );//    "ID_Series_Description",    //0008 103e LO ID Series Description
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0008,0x1080).c_str() );//    "ID_Admitting_Diagnoses_Description", //0008 1080 LO ID Admitting Diagnoses Description
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0010,0x0010).c_str() );//    "ID_Patient_Name",          //0010 0010 PN PAT Patient Name
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0010,0x0020).c_str() );//    "ID_Patient_ID",            //0010 0020 LO PAT Patient ID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0015).c_str() );//    "ID_Body_Part_Examined",    //0018 0015 CS ACQ Body Part Examined
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0020).c_str() );//    "ID_Scanning_Sequence",     //0018 0020 CS ACQ Scanning Sequence
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0021).c_str() );//    "ID_Sequence_Variant",      //0018 0021 CS ACQ Sequence Variant
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0022).c_str() );//    "ID_Scan_Options",          //0018 0022 CS ACQ Scan Options
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0023).c_str() );//    "ID_MR_Acquisition_Type",   //0018 0023 CS ACQ MR Acquisition Type
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0024).c_str() );//    "ID_Sequence_Name",         //0018 0024 SH ACQ Sequence Name
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0050).c_str() );//    "ID_Slice_Thickness",       //0018 0050 DS ACQ Slice Thickness
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0080).c_str() );//    "ID_Repetition_Time",       //0018 0080 DS ACQ Repetition Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0081).c_str() );//    "ID_Echo_Time",             //0018 0081 DS ACQ Echo Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0082).c_str() );//    "ID_Inversion_Time",        //0018 0082 DS ACQ Inversion Time
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0083).c_str() );//    "ID_Number_of_Averages",    //0018 0083 DS ACQ Number of Averages
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0084).c_str() );//    "ID_Imaging_Frequency",     //0018 0084 DS ACQ Imaging Frequency
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0085).c_str() );//    "ID_Imaged_Nucleus",        //0018 0085 SH ACQ Imaged Nucleus
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0086).c_str() );//    "ID_Echo_Number",           //0018 0086 IS ACQ Echo Number
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0087).c_str() );//    "ID_Magnetic_Field_Strength", //0018 0087 DS ACQ Magnetic Field Strength
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0088).c_str() );//    "ID_Spacing_Between_Slices",  //0018 0088 DS ACQ Spacing Between Slices
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0091).c_str() );//    "ID_Echo_Train_Length",     //0018 0091 IS ACQ Echo Train Length
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0093).c_str() );//    "ID_Percent_Sampling",      //0018 0093 DS ACQ Percent Sampling
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x0094).c_str() );//    "ID_Percent_Phase_Field_of_View", //0018 0094 DS ACQ Percent Phase Field of View
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x1250).c_str() );//    "ID_Receiving_Coil",        //0018 1250 SH ACQ Receiving Coil
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0018,0x5100).c_str() );//    "ID_Patient_Position",      //0018 5100 CS ACQ Patient Position
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x000d).c_str() );//    "ID_Study_Instance_UID",    //0020 000d UI REL Study Instance UID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x000e).c_str() );//    "ID_Series_Instance_UID",   //0020 000e UI REL Series Instance UID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0010).c_str() );//    "ID_Study_ID",              //0020 0010 SH REL Study ID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0011).c_str() );//    "ID_Series_Number",         //0020 0011 IS REL Series Number
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0012).c_str() );//    "ID_Acquisition_Number",    //0020 0012 IS REL Acquisition Number
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0013).c_str() );//    "ID_Image_Number",          //0020 0013 IS REL Image Number
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0020).c_str() );//    "ID_Patient_Orientation",   //0020 0020 CS REL Patient Orientation
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0030).c_str() );//    "ID_Image_Position",        //0020 0030 RET REL Image Position
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0032).c_str() );//    "ID_Image_Position_Patient",  //0020 0032 DS REL Image Position Patient
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0035).c_str() );//    "ID_Image_Orientation",     //0020 0035 RET REL Image Orientation
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0037).c_str() );//    "ID_Image_Orientation_Patient", //0020 0037 DS REL Image Orientation (Patient)
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0050).c_str() );//    "ID_Location",              //0020 0050 RET REL Location
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x0052).c_str() );//    "ID_Frame_of_Reference_UID",  //0020 0052 UI REL Frame of Reference UID
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x1041).c_str() );//    "ID_Slice_Location",        //0020 1041 DS REL Slice Location
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0020,0x4000).c_str() );//    "ID_Image_Comments",        //0020 4000 LT REL Image Comments
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0028,0x0030).c_str() );//    "ID_Pixel_Spacing",         //0028 0030 DS IMG Pixel Spacing
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0028,0x1050).c_str() );//    "ID_Window_Center",         //0028 1050 DS IMG Window Center
// PS -> 	temparray.Add( GdcmHeader.GetPubElValByNumber(0x0028,0x1051).c_str() );//    "ID_Window_Width",          //0028 1051 DS IMG Window Width
// PS ->
// PS -> 	return temparray;
// PS ->
// PS -> }
#undef s2ws
// ----------------------------------------------------------------------------
// PS -> void marGdcmDicom::FillDicomInfo()
// PS -> {
// PS -> 	reset();
// PS ->
// PS -> 	//!\todo FIXME : m_DicomInfo.size() == 0
// PS -> 	//if( m_DicomInfo.size() == 0 )
// PS -> 	{
// PS -> 		wxString file,subsubdir, subdir, rootdir = getParameters( )->getStringParam( marParameters::e_dicom_images_directory );
// PS -> 		wxDir dir(rootdir);
// PS -> 		bool cont = dir.GetFirst( &subdir, "*", wxDIR_DIRS );
// PS -> 		while ( cont )
// PS -> 		{
// PS -> 			subdir = rootdir + "/" + subdir;
// PS ->
// PS -> 			SerieInfo tempserie;
// PS -> 			wxDir dir2( subdir );
// PS -> 			bool cont2 = dir2.GetFirst( &subsubdir, "*", wxDIR_DIRS );
// PS -> 			while ( cont2 )
// PS -> 			{
// PS -> 				subsubdir = subdir + "/" + subsubdir;
// PS -> 				wxArrayString temptemp(gdcmGetExamInfo(subsubdir));
// PS -> 				tempserie.push_back(temptemp);
// PS -> 				cont2 = dir2.GetNext(&subsubdir);
// PS -> 			}
// PS ->
// PS -> 			m_DicomInfo.push_back( tempserie );
// PS -> 			cont = dir.GetNext(&subdir);
// PS -> 		}
// PS -> 	}
// PS -> }
//-------------------------------------------------------------------------
void marSimpleDicom::loadActualSerie( wxGauge* gauge)
{
	// PS ->   #ifdef DXMM
	loadVolumeDXMM( true , gauge);
	// PS ->   #else
	// PS ->   loadVolume( true , gauge);
	// PS ->   #endif
}

// -------------------------------------------------------------------------
// PS -> void marGdcmDicom::loadVolume( bool force , wxGauge *gauge)
// PS -> {
// PS ->   float spacing[3];
// PS ->   vtkGdcmReader *gdcmReader = NULL;
// PS ->
// PS ->   if( force || !_volume )
// PS ->   {
// PS ->     freeVolume( );
// PS ->
// PS ->     wxFileName temp(m_DicomInfo[m_ActualStudy][m_ActualSerie][ID_File_Name]);
// PS ->
// PS ->     helper = new gdcmSerieHeaderHelper();
// PS ->     helper->SetDirectory( temp.GetPath(wxPATH_GET_VOLUME | wxPATH_GET_SEPARATOR ).c_str() );
// PS ->     helper->OrderGdcmFileList();
// PS ->
// PS ->     std::list<gdcmHeaderHelper*> flist = helper->GetGdcmFileList();
// PS ->     if( flist.size() > 0)
// PS ->     {
// PS ->       gdcmReader = vtkGdcmReader::New();
// PS ->       for(std::list<gdcmHeaderHelper*>::iterator it = flist.begin(); it != flist.end(); it++ )
// PS ->       {
// PS ->         gdcmReader->AddFileName( (*it)->GetFileName().c_str() );
// PS ->       }
// PS ->     } // fi
// PS ->   } // fi
// PS ->
// PS ->   marProgressObserver *progressEvent = marProgressObserver::New();
// PS ->   progressEvent->FrameGauge = gauge;
// PS ->   //gdcmReader->AddObserver( vtkCommand::ProgressEvent, progressEvent);
// PS ->   progressEvent->Delete();
// PS ->
// PS ->   //To simplyfy calculation later I turn Origin to (0, 0, 0)
// PS ->   //this shouldn't be 'trop grave'
// PS ->   vtkImageChangeInformation *change = vtkImageChangeInformation::New();
// PS ->   change->SetInput( gdcmReader->GetOutput() );
// PS ->   change->SetOutputOrigin( 0, 0, 0);
// PS ->   change->Update();
// PS ->
// PS ->   float *range = change->GetOutput()->GetScalarRange();
// PS ->
// PS ->   //Our algorithm are made based on unsigned short pixel/voxel:
// PS ->   //We need to cast our imagedata
// PS ->   vtkImageCast *cast = vtkImageCast::New();
// PS ->   cast->SetInput( change->GetOutput() );
// PS ->   cast->SetOutputScalarTypeToUnsignedShort();
// PS ->   cast->Update(); //important
// PS ->
// PS ->   //As I need to shift & scale I don't need anymore vtkImageCast:
// PS -> /*  vtkImageShiftScale *shift = vtkImageShiftScale::New();
// PS ->   shift->SetInput( change->GetOutput() );
// PS ->   shift->SetShift( -range[0] );
// PS ->   shift->SetScale( VTK_UNSIGNED_SHORT_MAX / (range[1] - range[0]) );
// PS ->   shift->SetOutputScalarTypeToUnsignedShort();
// PS ->   shift->Update();*/
// PS ->
// PS ->   cast->GetOutput()->GetSpacing( spacing );
// PS ->   getParameters( )->setDoubleParam( marParameters::e_voxel_x_dimension, spacing[0] );
// PS ->   getParameters( )->setDoubleParam( marParameters::e_voxel_y_dimension, spacing[1] );
// PS ->   getParameters( )->setDoubleParam( marParameters::e_voxel_z_dimension, spacing[2] );
// PS ->
// PS ->   //FIXME: kVolume doesn't need to be -again- matrix rotated (done in vtkGdcmReader)!!
// PS ->   _volume = new kVolume( cast->GetOutput() );
// PS ->
// PS ->   //!\todo thanks
// PS ->   if(gdcmReader) gdcmReader->Delete();
// PS ->   cast->Delete();
// PS ->   change->Delete();
// PS -> }

void marSimpleDicom::loadVolumeDXMM( bool force , wxGauge *gauge)
{
// PS ->
// PS ->  FILE *stream;
// PS ->  char string[20];
// PS ->  wxString prefix, fileParam, fileVol, rootdir;
// PS ->  rootdir=wxString("c:/temp");
// PS ->  wxDir dir(rootdir);
// PS ->  int dimX, dimY, dimZ;
// PS ->  float spacing[3];
// PS ->  vtkImageReader *volVTK = NULL;
// PS ->
// PS ->  fileParam = rootdir + "/" + "paramDxMM.txt";
// PS ->  stream = fopen(fileParam.c_str(),"r");
// PS ->
// PS ->  wxString errorMsg;
// PS ->  errorMsg= "Cannot open file "+fileParam;
// PS ->  wxASSERT_MSG(stream!=NULL,errorMsg);
// PS ->
// PS ->  fscanf(stream,"%s", string);
// PS ->  dimX = atoi(string);
// PS ->  fscanf(stream,"%s", string);
// PS ->  dimY = atoi(string);
// PS ->  fscanf(stream,"%s", string);
// PS ->  dimZ = atoi(string);
// PS ->  fscanf(stream,"%s", string);
// PS ->  spacing[0] = atof(string);
// PS ->  fscanf(stream,"%s", string);
// PS ->  spacing[1] = atof(string);
// PS ->  fscanf(stream,"%s", string);
// PS ->  spacing[2] = atof(string);
// PS ->  fclose(stream);
// PS ->
// PS ->  getParameters( )->setDoubleParam( marParameters::e_voxel_x_dimension, spacing[0] );
// PS ->  getParameters( )->setDoubleParam( marParameters::e_voxel_y_dimension, spacing[1] );
// PS ->  getParameters( )->setDoubleParam( marParameters::e_voxel_z_dimension, spacing[2] );
// PS ->
// PS ->  if( force || !_volume )
// PS ->  {
// PS ->  	freeVolume( );
// PS ->  } // fi
// PS ->
// PS ->  marProgressObserver *progressEvent = marProgressObserver::New();
// PS ->  progressEvent->FrameGauge = gauge;
// PS ->  progressEvent->Delete();
// PS ->
// PS ->  prefix = rootdir + "/" + "imaDxMM";
// PS ->  volVTK = vtkImageReader::New();
// PS ->  volVTK->SetDataByteOrderToLittleEndian();
// PS ->  volVTK->SetDataScalarTypeToUnsignedShort();
// PS ->  volVTK->SetDataExtent(0, dimX-1, 0, dimY-1, 0, dimZ-1);
// PS ->  volVTK->SetFilePrefix( prefix.c_str() );
// PS ->  volVTK->SetFilePattern( "%s%d.raw");
// PS ->  volVTK->SetDataSpacing(spacing[0],spacing[1],spacing[2]);
// PS ->  volVTK->Update();
// PS ->  vtkImageResample* ir = vtkImageResample::New( );
// PS ->  ir->SetInput(volVTK->GetOutput());
// PS ->  ir->SetDimensionality( 3 );
// PS ->  ir->SetAxisOutputSpacing( 0, getParameters( )->getVoxelSize( ) );
// PS ->  ir->SetAxisOutputSpacing( 1, getParameters( )->getVoxelSize( ) );
// PS ->  ir->SetAxisOutputSpacing( 2, getParameters( )->getVoxelSize( ) );
// PS ->  ir->InterpolateOn( );
// PS ->  ir->Update( );    //important
// PS ->
// PS ->  _volume = new kVolume( ir->GetOutput( ) );
// PS ->
// PS ->  //!\todo thanks
// PS ->  if (ir) ir->Delete( );
// PS ->  if(volVTK) volVTK->Delete();

	if (m_pSlicesPixels!=NULL)
	{
		vtkUnsignedShortArray * dataArray=vtkUnsignedShortArray::New();

		int iRow,iColumn,iSlice,iPixel;

		int iiSlice;
		for (iiSlice=0;iiSlice<m_nSlices;iiSlice++)
		{
			if (_investSliceOrder==false) {
				iSlice=iiSlice;
			} else {
				iSlice=(iiSlice*(-1)) + m_nSlices - 1;
			}

			for (iRow=0;iRow<m_nY;iRow++)
			{
				for (iColumn=0;iColumn<m_nX;iColumn++)
				{
					iPixel=(m_nSlices-1-iSlice)*m_nX*m_nY + (m_nY-1-iRow)*m_nX + iColumn;
					dataArray->InsertNextValue(m_pSlicesPixels[iPixel]);
				}				
			}
		}
		vtkImageData*imgData=vtkImageData::New();
		imgData->SetDimensions(m_nX,m_nY,m_nSlices);
		imgData->SetSpacing(m_PixelSpacingRow,m_PixelSpacingColumn,m_PixelSpacingSlice);
		imgData->SetOrigin(0,0,0);
		imgData->SetScalarTypeToUnsignedShort();
		imgData->GetPointData()->SetScalars(dataArray);


		// TO DO : remplir le vtkImageResample
		vtkImageResample* ir = vtkImageResample::New();
		ir->SetInput(imgData);
		ir->SetDimensionality( 3 );
		ir->SetAxisOutputSpacing( 0, getParameters()->getVoxelSize() );
		ir->SetAxisOutputSpacing( 1, getParameters()->getVoxelSize() );
		ir->SetAxisOutputSpacing( 2, getParameters()->getVoxelSize() );
		ir->InterpolateOn( );
		ir->Update( );    //important

// EED
//		_volume = new kVolume( ir->GetOutput( ) );
		SetVolume( new kVolume( ir->GetOutput()  )  );

		//!\todo thanks
		if (ir) ir->Delete();
		if(imgData) imgData->Delete();
		if(dataArray) dataArray->Delete();
        getParameters( )->setDoubleParam( marParameters::e_RescaleSlope    , m_RescaleSlope     );
        getParameters( )->setDoubleParam( marParameters::e_RescaleIntercept, m_RescaleIntercept );
	}

}


// -------------------------------------------------------------------------
void marSimpleDicom::copyFrom( const marObject& from )
{ //!\todo TODO
}

// -------------------------------------------------------------------------
bool marSimpleDicom::save( std::ofstream& os )
{
/*  int s = _actualStudy.length( );

 os.write( ( const char* )&s, sizeof( int ) );
 os.write( ( char* )_actualStudy.c_str( ), s * sizeof( char ) );

  s = _actualSerie.length( );

   os.write( ( const char* )&s, sizeof( int ) );
	os.write( ( char* )_actualSerie.c_str( ), s * sizeof( char ) );*/

	for(std::vector<SerieInfo>::iterator it1 = m_DicomInfo.begin();
	it1 != m_DicomInfo.end(); it1++ )
    {
		for(std::vector<wxArrayString>::iterator it2 = it1->begin();
		it2 != it1->end(); it2++ )
        {
            for(int i=0; i<it2->GetCount(); i++)
			{
                //wxString temp( it2->Item(i) );
                os << it2->Item(i); //temp;
			}
        }
    }



	return( true );
}

// -------------------------------------------------------------------------
bool marSimpleDicom::load( std::ifstream& is )
{
/*  int s;

 reset( );

  is.read( ( char* )&s, sizeof( int ) );
  _actualStudy.resize( s );
  is.read( ( char* )_actualStudy.c_str( ), s * sizeof( char ) );
  is.read( ( char* )&s, sizeof( int ) );
  _actualSerie.resize( s );
	is.read( ( char* )_actualSerie.c_str( ), s * sizeof( char ) );*/

	for(std::vector<SerieInfo>::iterator it1 = m_DicomInfo.begin();
	it1 != m_DicomInfo.end(); it1++ )
    {
		for(std::vector<wxArrayString>::iterator it2 = it1->begin();
		it2 != it1->end(); it2++ )
        {
            for(int i=0; i<it2->GetCount(); i++)
			{
                std::string temp;
                is >> temp ;
                it2->Add( temp.c_str() );
			}
        }
    }


	return( true );
}

// -------------------------------------------------------------------------
void marSimpleDicom::SetVolumeData( int dimX, 
								    int dimY, 
									int dimZ, 
									float spacingX, 
									float spacingY, 
									float spacingZ,
									float rescaleSlope,
									float rescaleIntercept,
									unsigned short *pixels)
{
	m_pSlicesPixels		= pixels;
	m_nX				= dimX;
	m_nY				= dimY;
	m_nSlices			= dimZ;
	m_PixelSpacingColumn= spacingX;
	m_PixelSpacingRow	= spacingY;
	m_PixelSpacingSlice	= spacingZ;
	m_RescaleSlope		= rescaleSlope;
	m_RescaleIntercept	= rescaleIntercept;
}

// -------------------------------------------------------------------------
void marSimpleDicom::reset( ){
//		freeVolume( );
		//_imageFileNames.Clear( );
		
		int n = m_DicomInfo.size();
		///\todo does this clear evrythg ?
		for(int i=0; i<n; i++) {
			m_DicomInfo[i].clear();
		}
		m_DicomInfo.clear();
		
// PS -> 		if(helper)
// PS -> 			delete helper;
// PS -> 		helper = NULL;
		m_pSlicesPixels		=	NULL;
		m_nX				=	0;
		m_nY				=	0;
		m_nSlices			=	0;
		m_PixelSpacingColumn=	0;
		m_PixelSpacingRow	=	0;
		m_PixelSpacingSlice	=	0;
		m_RescaleSlope		=	1;
		m_RescaleIntercept	=	0;
    }

// -------------------------------------------------------------------------
void marSimpleDicom::SetInvestSliceOrder(bool investSliceOrder){
	_investSliceOrder=investSliceOrder;
}
// -------------------------------------------------------------------------

