/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: marSimpleDicom.h,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:31 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#ifndef __MAR__KERNEL__MARSIMPLEDICOM__HXX__
#define __MAR__KERNEL__MARSIMPLEDICOM__HXX__

#include "marDicomBase.h"

#include "volume.hxx"
#include <wx/string.h>
#include <wx/gauge.h>
// PS -> #include <gdcm.h>
// PS -> #include <gdcmHeaderHelper.h>
#include <vector>
// PS -> #include <gdcmElValSet.h>

typedef std::vector<wxArrayString> SerieInfo;  //DICOM info for each serie
											   /**
* Shouldn't we break the dependencies to wx ???
* 
* We use vector instead of list for efficiency: for access time
* futhermore the number of patient is not changing a lot, so we 
* might add the number of patient to params.dat, to allocate the right 
* number of vector
*
*/

// EED Borrame 
//class MAR_KERNEL_EXPORT marGdcmDicom : public marObject

class marSimpleDicom : public marFilesBase
{
public:
	
    enum DicomTags
    {
		ID_File_Name = 0                   ,
			ID_SOP_Class_UID                   ,//!0008 0016 UI ID SOP Class UID
			ID_SOP_Instance_UID                ,//!0008 0018 UI ID SOP Instance UID
			ID_Study_Date                      ,//!0008 0020 DA ID Study Date
			ID_Series_Date                     ,//!0008 0021 DA ID Series Date
			ID_Acquisition_Date                ,//!0008 0022 DA ID Acquisition Date
			ID_Image_Date                      ,//!0008 0023 DA ID Image Date
			ID_Study_Time                      ,//!0008 0030 TM ID Study Time
			ID_Series_Time                     ,//!0008 0031 TM ID Series Time
			ID_Acquisition_Time                ,//!0008 0032 TM ID Acquisition Time
			ID_Image_Time                      ,//!0008 0033 TM ID Image Time
			ID_Modality                        ,//!0008 0060 CS ID Modality
			ID_Manufacturer                    ,//!0008 0070 LO ID Manufacturer
			ID_Institution_Name                ,//!0008 0080 LO ID Institution Name
			ID_Study_Description               ,//!0008 1030 LO ID Study Description
			ID_Series_Description              ,//!0008 103e LO ID Series Description
			ID_Admitting_Diagnoses_Description ,//!0008 1080 LO ID Admitting Diagnoses Description
			ID_Patient_Name                    ,//!0010 0010 PN PAT Patient Name
			ID_Patient_ID                      ,//!0010 0020 LO PAT Patient ID
			ID_Body_Part_Examined              ,//!0018 0015 CS ACQ Body Part Examined
			ID_Scanning_Sequence               ,//!0018 0020 CS ACQ Scanning Sequence
			ID_Sequence_Variant                ,//!0018 0021 CS ACQ Sequence Variant
			ID_Scan_Options                    ,//!0018 0022 CS ACQ Scan Options
			ID_MR_Acquisition_Type             ,//!0018 0023 CS ACQ MR Acquisition Type
			ID_Sequence_Name                   ,//!0018 0024 SH ACQ Sequence Name
			ID_Slice_Thickness                 ,//!0018 0050 DS ACQ Slice Thickness
			ID_Repetition_Time                 ,//!0018 0080 DS ACQ Repetition Time
			ID_Echo_Time                       ,//!0018 0081 DS ACQ Echo Time
			ID_Inversion_Time                  ,//!0018 0082 DS ACQ Inversion Time
			ID_Number_of_Averages              ,//!0018 0083 DS ACQ Number of Averages
			ID_Imaging_Frequency               ,//!0018 0084 DS ACQ Imaging Frequency
			ID_Imaged_Nucleus                  ,//!0018 0085 SH ACQ Imaged Nucleus
			ID_Echo_Number                     ,//!0018 0086 IS ACQ Echo Number
			ID_Magnetic_Field_Strength         ,//!0018 0087 DS ACQ Magnetic Field Strength
			ID_Spacing_Between_Slices          ,//!0018 0088 DS ACQ Spacing Between Slices
			ID_Echo_Train_Length               ,//!0018 0091 IS ACQ Echo Train Length
			ID_Percent_Sampling                ,//!0018 0093 DS ACQ Percent Sampling
			ID_Percent_Phase_Field_of_View     ,//!0018 0094 DS ACQ Percent Phase Field of View
			ID_Receiving_Coil                  ,//!0018 1250 SH ACQ Receiving Coil
			ID_Patient_Position                ,//!0018 5100 CS ACQ Patient Position
			ID_Study_Instance_UID              ,//!0020 000d UI REL Study Instance UID
			ID_Series_Instance_UID             ,//!0020 000e UI REL Series Instance UID
			ID_Study_ID                        ,//!0020 0010 SH REL Study ID
			ID_Series_Number                   ,//!0020 0011 IS REL Series Number
			ID_Acquisition_Number              ,//!0020 0012 IS REL Acquisition Number
			ID_Image_Number                    ,//!0020 0013 IS REL Image Number
			ID_Patient_Orientation             ,//!0020 0020 CS REL Patient Orientation
			ID_Image_Position                  ,//!0020 0030 RET REL Image Position
			ID_Image_Position_Patient          ,//!0020 0032 DS REL Image Position Patient
			ID_Image_Orientation               ,//!0020 0035 RET REL Image Orientation
			ID_Image_Orientation_Patient       ,//!0020 0037 DS REL Image Orientation (Patient)
			ID_Location                        ,//!0020 0050 RET REL Location
			ID_Frame_of_Reference_UID          ,//!0020 0052 UI REL Frame of Reference UID
			ID_Slice_Location                  ,//!0020 1041 DS REL Slice Location
			ID_Image_Comments                  ,//!0020 4000 LT REL Image Comments
			ID_Pixel_Spacing                   ,//!0028 0030 DS IMG Pixel Spacing
			ID_Window_Center                   ,//!0028 1050 DS IMG Window Center
			ID_Window_Width                    ,//!0028 1051 DS IMG Window Width
			ID_dicom_tags_count
    };
	
public:
	void SetVolumeData( int dimX,
						int dimY,
						int dimZ, 
		                float spacingX, 
						float spacingY, 
						float spacingZ, 
						float rescaleSlope,
						float rescaleIntercept,
						unsigned short * pixels);
	
    marSimpleDicom( marParameters* p = NULL );
	
    virtual ~marSimpleDicom( );
	
    /**
	Function which return an *ordered* array string
	The string is ordered so that filename are in the right order
    */
// PS ->     wxArrayString getStudyInfo( ) { return( m_DicomInfo[m_ActualStudy][0] ); }
// PS ->     int getNumberOfStudies( ) { return m_DicomInfo.size(); }
// PS ->     wxArrayString getSerieInfo( ) { return( m_DicomInfo[m_ActualStudy][m_ActualSerie] ); }
// PS ->     int getNumberOfSeries( ) { return m_DicomInfo[m_ActualStudy].size(); }
	
	
// PS ->     int getNumberOfFiles( )
// PS ->     {
// PS -> 		return m_DicomInfo[m_ActualStudy][m_ActualSerie].GetCount();
// PS ->     }
	
	void SetInvestSliceOrder(bool investSliceOrder);

    void loadActualSerie(wxGauge* gauge );
	
// PS ->     wxArrayString getImageNumbers( )
// PS ->     {
// PS -> 		wxArrayString imageNumbers;
// PS -> 		std::list<gdcmHeaderHelper*> flist = helper->GetGdcmFileList();
// PS -> 		for(std::list<gdcmHeaderHelper*>::iterator it = flist.begin(); 
// PS -> 		it != flist.end(); it++ )
// PS -> 		{
// PS -> 			imageNumbers.Add( wxString::Format("%d", (*it)->GetImageNumber()) );
// PS -> 		}
// PS -> 		return( imageNumbers );
// PS ->     }

	// PS ->     void loadVolume( bool force = false, wxGauge* gauge = NULL);
    void loadVolumeDXMM( bool force = false, wxGauge* gauge = NULL);
	
// PS -> 	
// PS ->     bool setActualStudy( unsigned int studynumber )
// PS ->     {
// PS -> 		m_ActualStudy = studynumber;
// PS -> 		return true;
// PS ->     }
// PS ->     bool setActualSerie( unsigned int serienumber )
// PS ->     {
// PS -> 		m_ActualSerie = serienumber;
// PS -> 		return true;
// PS ->     }
// PS -> 	
    /** 
	* General methods
	*/
    void reset( );
    void copyFrom( const marObject& from );
	
    /**
	* Persistence methods
	*/
    bool save( std::ofstream& os );
    bool load( std::ifstream& is );
	
// PS ->     void FillDicomInfo();
    
// PS ->     wxString GetPatientName()
// PS -> 	{
// PS -> 		return wxString( helper->GetGdcmHeader()->GetPubElValByNumber(0x0010,0x0010).c_str()).Trim();//0010 0010 PN PAT Patient Name
// PS -> 	}
	
  private:
	  
// PS -> 	  wxArrayString gdcmGetExamInfo( wxString directoryname );
	  
	  std::vector< SerieInfo > m_DicomInfo;
	  unsigned int m_ActualStudy;
	  unsigned int m_ActualSerie;
	  
// PS -> 	  gdcmSerieHeaderHelper *helper;
	  unsigned short * m_pSlicesPixels;
	  int   m_nX, m_nY, m_nSlices;
	  float m_PixelSpacingColumn,m_PixelSpacingRow,m_PixelSpacingSlice;
	  float m_RescaleSlope, m_RescaleIntercept;
	  bool  _investSliceOrder;
};

#endif // __MAR__KERNEL__MARSIMPLEDICOM__HXX__
