/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

// marVector.h: interface for the marVector class.
//
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <stddef.h>
class marVector  
{
public:
/*
Remarque : les (double*) sont organis�s ligne par ligne
*/
/*==Constructeurs========================================*/
	marVector(size_t s=3);
	marVector(double* v,size_t s);
	marVector(const marVector & v);
/*==Destructeur========================================*/
	virtual ~marVector();

/*==Op�rateurs========================================*/
	/* Affectation */
	marVector& operator=(const marVector& o);
    marVector& operator=(double o);
    marVector& operator=(double* o);

	/* Affichage */
    friend std::ostream& operator<<(std::ostream& os, const marVector& v);

	/* Casting */
    operator double*() const ;

	/* Indexation */
	double& operator()(size_t i);
    const double& operator()(size_t i) const;

	/* Comparaison */
    bool operator==(const marVector& o) const;
    bool operator!=(const marVector& o) const;

	/* Addition */
    marVector operator+(const marVector& o);
    marVector operator+(double o);
    marVector operator+(double* o);
	/* Addition + Affectation */
    marVector& operator+=(const marVector& o);
    marVector& operator+=(double o);
    marVector& operator+=(double* o);

	/* Soustraction */
    marVector operator-(const marVector& o);
    marVector operator-(double o);
    marVector operator-(double* o);
	/* Soustraction + Affectation */
    marVector& operator-=(const marVector& o);
    marVector& operator-=(double o);
    marVector& operator-=(double* o);

	/* Multiplication (produit scalaire) */
    marVector operator*(double o);
	/* Multiplication (produit scalaire) + Affectation */
    marVector& operator*=(double o);

	/* Division (division scalaire) */
    marVector operator/(double o);
	/* Division (division scalaire) + Affectation */
    marVector& operator/=(double o);

/*==Op�rations========================================*/
	/* produit scalaire */
    double dot( const marVector& o );
    double dot( double* o );
	
	/* produit vectoriel (3D uniquement): le resultat est renvoye */
    marVector cross( const marVector& o );
    marVector cross( double* o );
	/* produit vectoriel (3D uniquement): le resultat est stock� dans this*/
    int scross( const marVector& o ); // renvoie 0 si OK, 1 sinon
    int scross( double* o ); // renvoie 0 si OK, 1 sinon

	/* norme euclidienne */
    double norm2( );

	/* normalisation */
    marVector normalize( ); // resultat renvoy�
    int snormalize( ); // resultat stock� dans this, renvoie 0 si OK, 1 sinon

/*==M�thodes========================================*/
	size_t size() const;

/*==Attributs========================================*/
private:
	bool shallowCopy; // true if _data is a shallow copy of original data (pointer copy)
	size_t _size;
	double* _data;
};


