/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


 
 
 #ifndef __VTK__VTK__DIJKSTRA__IMAGE__DATA__H
 #define __VTK__VTK__DIJKSTRA__IMAGE__DATA__H
 
 #include "vtkPolyDataSource.h"
 #include "vtkImageData.h"
 #include "vtkPoints.h"
 #include "vtkCellArray.h"
 #include "vtkPolyData.h"

 
 class vtkIntArray;
 class vtkDataArray;
 class vtkPriorityQueue;
 class vtkIdList;
 class vtkDijkstraImageData : public vtkPolyDataSource
 {
   public:
   static vtkDijkstraImageData *New();
   vtkTypeMacro(vtkDijkstraImageData,vtkPolyDataSource);
   void PrintSelf(ostream& os, vtkIndent indent);
   
   vtkSetMacro(SourceID,int);
   vtkGetMacro(SourceID,int);
 
 
   vtkSetMacro(SinkID,int);
   vtkGetMacro(SinkID,int);
 
   vtkGetObjectMacro(Parent,vtkIntArray);
 
   
   
   virtual void SetBoundaryScalars(vtkDataArray*);
   vtkGetObjectMacro(BoundaryScalars,vtkDataArray);
 
   
   vtkSetMacro(NumberOfInputPoints,int);
   vtkGetMacro(NumberOfInputPoints,int);
   
   
   vtkSetMacro(NumberOfGraphNodes,int);
   vtkGetMacro(NumberOfGraphNodes,int);
   
   
   vtkIdList* GetShortestPathIdList();
   
   
   vtkSetMacro(UseInverseDistance,int);
   vtkGetMacro(UseInverseDistance,int);
   
  
   vtkSetMacro(UseInverseSquaredDistance,int);
   vtkGetMacro(UseInverseSquaredDistance,int);
 
  
   vtkSetMacro(UseInverseExponentialDistance,int);
   vtkGetMacro(UseInverseExponentialDistance,int);
 
   vtkSetMacro(UseSquaredDistance,int);
   vtkGetMacro(UseSquaredDistance,int);
 
       
   // Description:
   unsigned long GetMTime();
   
   // path operations
   void InitTraversePath();
   int GetNextPathNode();
   int GetNumberOfPathNodes();
   
 
   void SetInput(vtkImageData*);
   vtkImageData* GetInput();
   
   
   void CreateGraph(vtkImageData *inData);
   void DeleteGraph();
   void FindNeighbors(vtkIdList *list,int id, vtkDataArray *scalars); 
   
   int findClosestPointInGraph(vtkDataArray *scalars,int id,int dim0,int dim1, int dim2); 
   
 
  
   
   void InitSingleSource(int startv);
  
   void RunDijkstra(vtkDataArray *scalars,int source, int sink);
   
   float EdgeCost(vtkDataArray *scalars, int u, int v);
   void BuildShortestPath(int start,int end);
  
         
   
   
   int SourceID;
   
   
   int SinkID;  
   
   
   vtkDataArray *BoundaryScalars;
 
  
   int NumberOfInputPoints;
   int NumberOfGraphNodes;
 
   int UseInverseDistance;
   int UseInverseSquaredDistance;
   int UseInverseExponentialDistance;
   int UseSquaredDistance;
 
  
   
   vtkPriorityQueue *PQ;
 
   
   vtkIdList *ShortestPathIdList;
   
   vtkIntArray *Parent;
   
   vtkIntArray *Visited;  
  
  
   int PathPointer;
  
   int StopWhenEndReached;


   vtkPoints *puntos; 
   vtkCellArray *lineas;
   vtkImageData *input;



  	void init(vtkImageData *inData);

	void printPointData(int pointID);

	float fuerzaAtraccion(int u, float w);
	
 
 protected:
   vtkDijkstraImageData();
   ~vtkDijkstraImageData();
    void Execute();

   
   FILE *logger;
 
 private:
//   vtkDijstraImageData(const vtkDijkstraImageData&);
   void operator=(const vtkDijkstraImageData&);
 };
 
 #endif //__VTK__VTK__DIJKSTRA__IMAGE__DATA__H
 
 
 
 
