/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "vtkJoiner.h"

vtkJoiner::vtkJoiner(){
}

vtkJoiner::~vtkJoiner(){
}


vtkImageData* vtkJoiner::join(vtkImageData *a, vtkImageData *b){
	
	int extent[6];
	vtkImageData *c = vtkImageData::New();
	c->DeepCopy(a);
	
	unsigned char *ptrA = NULL;
	unsigned char *ptrB = NULL;
	unsigned char *ptrC = NULL;

	a->GetExtent(extent);
	int i, j, k;
	for(i=extent[0];i<=extent[1];i++){
		for(j=extent[2];j<=extent[3];j++){
			for(k=extent[4];k<=extent[5];k++){
				ptrA = (unsigned char *) a->GetScalarPointer(i,j,k);
				ptrB = (unsigned char *) b->GetScalarPointer(i,j,k);
				ptrC = (unsigned char *) c->GetScalarPointer(i,j,k);
				if ((*ptrA != 0) || (*ptrB != 0)){
					*ptrC=255;
				}
				else{
					*ptrC = 0;
				}
			}
		}
	}

	return c;
}
